/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.sm;

import com.iplanet.services.util.AMEncryption;
import com.iplanet.sso.SSOException;
import com.iplanet.sso.SSOToken;
import com.sun.identity.shared.debug.Debug;
import com.sun.identity.sm.AttributeValidator;
import com.sun.identity.sm.CachedSMSEntry;
import com.sun.identity.sm.CachedSubEntries;
import com.sun.identity.sm.DNMapper;
import com.sun.identity.sm.OrganizationConfigManager;
import com.sun.identity.sm.SMSEntry;
import com.sun.identity.sm.SMSException;
import com.sun.identity.sm.SMSSchema;
import com.sun.identity.sm.SMSUtils;
import com.sun.identity.sm.ServiceConfigManagerImpl;
import com.sun.identity.sm.ServiceListener;
import com.sun.identity.sm.ServiceSchemaImpl;
import com.sun.identity.sm.ServiceSchemaManagerImpl;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

class ServiceConfigImpl
implements ServiceListener {
    private ServiceConfigManagerImpl scm;
    ServiceSchemaManagerImpl ssmi;
    private ServiceSchemaImpl ss;
    private boolean globalConfig;
    private String serviceComponentName;
    private String orgName;
    private String groupName;
    private String compName;
    private String configID;
    private int priority;
    private Map attributes;
    private Map attributesWithoutDefaults;
    private CachedSMSEntry smsEntry;
    private CachedSubEntries subEntries;
    private String labeledUri;
    private String serviceSchemaManagerListernerID;
    private static Map configImpls = Collections.synchronizedMap(new HashMap());
    private static Map userPrincipals = Collections.synchronizedMap(new HashMap());
    private static Debug debug = SMSEntry.debug;

    private ServiceConfigImpl(ServiceConfigManagerImpl scm, ServiceSchemaImpl ss, CachedSMSEntry entry, String orgName, String groupName, String compName, boolean globalConfig, SSOToken token) throws SMSException, SSOException {
        this.scm = scm;
        this.ss = ss;
        this.smsEntry = entry;
        this.smsEntry.addServiceListener(this);
        this.ssmi = scm.getServiceSchemaManagerImpl(token);
        this.serviceSchemaManagerListernerID = this.ssmi.addListener(this);
        this.orgName = orgName == null ? SMSEntry.baseDN : orgName;
        this.groupName = groupName;
        if (compName == null || compName.equals("")) {
            this.compName = "";
            this.serviceComponentName = "/";
        } else {
            this.compName = compName.substring(compName.lastIndexOf(47) + 1);
            this.serviceComponentName = compName;
        }
        this.globalConfig = globalConfig;
        if (this.smsEntry.isDirty()) {
            this.smsEntry.refresh();
        } else {
            this.update();
        }
    }

    String getComponentName() {
        return this.serviceComponentName;
    }

    String getSchemaID() {
        return this.configID;
    }

    String getGroupName() {
        return this.groupName;
    }

    String getOrganizationName() {
        return this.orgName;
    }

    int getPriority() {
        return this.priority;
    }

    String getLabeledUri() {
        return this.labeledUri;
    }

    Set getSubConfigNames(SSOToken t) throws SMSException, SSOException {
        if (this.subEntries == null) {
            this.subEntries = CachedSubEntries.getInstance(t, this.smsEntry.getDN());
        }
        return this.subEntries.getSubEntries(t);
    }

    Set getSubConfigNames(SSOToken t, String pattern) throws SMSException, SSOException {
        if (this.subEntries == null) {
            this.subEntries = CachedSubEntries.getInstance(t, this.smsEntry.getDN());
        }
        if (pattern.equals("*")) {
            return this.getSubConfigNames(t);
        }
        return this.subEntries.getSubEntries(t, pattern);
    }

    Set getSubConfigNames(SSOToken t, String pattern, String serviceidPattern) throws SMSException, SSOException {
        if (this.subEntries == null) {
            this.subEntries = CachedSubEntries.getInstance(t, this.smsEntry.getDN());
        }
        return this.subEntries.getSchemaSubEntries(t, pattern, serviceidPattern);
    }

    ServiceConfigImpl getSubConfig(SSOToken token, String subConfigName) throws SSOException, SMSException {
        subConfigName = SMSSchema.unescapeName(subConfigName);
        String sdn = "ou=" + subConfigName + "," + this.smsEntry.getDN();
        return ServiceConfigImpl.getInstance(token, this.scm, null, sdn, this.orgName, this.groupName, this.serviceComponentName + "/" + SMSSchema.escapeSpecialCharacters(subConfigName), this.globalConfig, this.ss);
    }

    Map getAttributes() {
        if (!SMSEntry.cacheSMSEntries) {
            this.smsEntry.refresh();
        }
        return SMSUtils.copyAttributes(this.attributes);
    }

    Map getAttributesForRead() {
        if (!SMSEntry.cacheSMSEntries) {
            this.smsEntry.refresh();
        }
        return this.attributes;
    }

    Map getAttributesWithoutDefaults() {
        if (!SMSEntry.cacheSMSEntries) {
            this.smsEntry.refresh();
        }
        return SMSUtils.copyAttributes(this.attributesWithoutDefaults);
    }

    Map getAttributesWithoutDefaultsForRead() {
        if (!SMSEntry.cacheSMSEntries) {
            this.smsEntry.refresh();
        }
        return this.attributesWithoutDefaults;
    }

    String getDN() {
        return this.smsEntry.getDN();
    }

    SMSEntry getSMSEntry() {
        return this.smsEntry.getClonedSMSEntry();
    }

    void refresh(SMSEntry e) throws SMSException {
        this.smsEntry.refresh(e);
    }

    ServiceSchemaImpl getServiceSchemaImpl() {
        return this.ss;
    }

    boolean isNewEntry() {
        return this.smsEntry.isNewEntry();
    }

    boolean isValid() {
        if (this.smsEntry.isValid() && this.smsEntry.isDirty()) {
            this.smsEntry.refresh();
        }
        return this.smsEntry.isValid();
    }

    void clear() {
        this.smsEntry.removeServiceListener(this);
        if (this.smsEntry.isValid()) {
            this.smsEntry.clear();
        }
        try {
            if (this.ssmi != null && this.serviceSchemaManagerListernerID != null) {
                this.ssmi.removeListener(this.serviceSchemaManagerListernerID);
            }
        }
        catch (Exception ex) {
            debug.error("ServiceConfigImpl.clear Unable to remove notification handler for dn: " + this.getDN(), (Throwable)ex);
        }
    }

    public int hashCode() {
        int hash = 5;
        hash = 41 * hash + (this.scm != null ? this.scm.hashCode() : 0);
        hash = 41 * hash + (this.globalConfig ? 1 : 0);
        hash = 41 * hash + (this.orgName != null ? this.orgName.hashCode() : 0);
        hash = 41 * hash + (this.groupName != null ? this.groupName.hashCode() : 0);
        hash = 41 * hash + (this.compName != null ? this.compName.hashCode() : 0);
        hash = 41 * hash + (this.configID != null ? this.configID.hashCode() : 0);
        return hash;
    }

    public boolean equals(Object scio) {
        if (scio instanceof ServiceConfigImpl) {
            ServiceConfigImpl s = (ServiceConfigImpl)scio;
            if (s.globalConfig == this.globalConfig && s.orgName.equalsIgnoreCase(this.orgName) && s.groupName.equalsIgnoreCase(this.groupName) && s.compName.equalsIgnoreCase(this.compName) && s.configID.equalsIgnoreCase(this.configID) && s.scm.getName().equalsIgnoreCase(this.scm.getName())) {
                return true;
            }
        }
        return false;
    }

    synchronized void update() {
        String[] ids;
        if (!this.smsEntry.isValid()) {
            this.clear();
            return;
        }
        SMSEntry entry = this.smsEntry.getSMSEntry();
        Map origAttributes = SMSUtils.getAttrsFromEntry(entry);
        Map origAttributesWithoutDefaults = SMSUtils.getAttrsFromEntry(entry);
        String validate = this.ss.getValidate();
        if (validate == null || validate.equalsIgnoreCase("yes")) {
            Set asNames = this.ss.getAttributeSchemaNames();
            Set oldSet = origAttributes.keySet();
            HashSet<String> removeAttrs = new HashSet<String>();
            for (String tName : oldSet) {
                if (asNames.contains(tName)) continue;
                removeAttrs.add(tName);
            }
            for (String t : removeAttrs) {
                origAttributes.remove(t);
                origAttributesWithoutDefaults.remove(t);
            }
            Iterator ass = asNames.iterator();
            while (ass.hasNext()) {
                AttributeValidator av = this.ss.getAttributeValidator((String)ass.next());
                origAttributes = av.inheritDefaults(origAttributes);
                origAttributesWithoutDefaults = av.decodeEncodedAttrs(origAttributesWithoutDefaults);
            }
        }
        this.priority = 0;
        String[] priorities = entry.getAttributeValues("sunsmspriority");
        if (priorities != null) {
            try {
                this.priority = Integer.parseInt(priorities[0]);
            }
            catch (NumberFormatException nfe) {
                SMSEntry.debug.error("ServiceConfig::getPriority() " + nfe);
            }
        }
        this.configID = (ids = entry.getAttributeValues("sunserviceID")) != null ? ids[0] : this.compName;
        String[] lUri = entry.getAttributeValues("labeledURI");
        if (lUri != null) {
            this.labeledUri = lUri[0];
        }
        this.attributes = Collections.unmodifiableMap(origAttributes);
        this.attributesWithoutDefaults = Collections.unmodifiableMap(origAttributesWithoutDefaults);
    }

    static ServiceConfigImpl getInstance(SSOToken token, ServiceConfigManagerImpl scm, ServiceSchemaImpl ss, String dn, String oName, String groupName, String compName, boolean globalConfig) throws SSOException, SMSException {
        return ServiceConfigImpl.getInstance(token, scm, ss, dn, oName, groupName, compName, globalConfig, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static ServiceConfigImpl getInstance(SSOToken token, ServiceConfigManagerImpl scm, ServiceSchemaImpl ss, String dn, String oName, String groupName, String compName, boolean globalConfig, ServiceSchemaImpl parentSS) throws SSOException, SMSException {
        if (debug.messageEnabled()) {
            debug.message("ServiceConfigImpl::getInstance: called: " + dn);
        }
        String orgName = DNMapper.orgNameToDN(oName);
        String cacheName = ServiceConfigImpl.getCacheName(scm.getName(), scm.getVersion(), orgName, groupName, compName, globalConfig);
        ServiceConfigImpl answer = ServiceConfigImpl.getFromCache(cacheName, token);
        if (answer != null) {
            if (!SMSEntry.cacheSMSEntries) {
                answer.smsEntry.refresh();
            }
            return answer;
        }
        if (!SMSEntry.checkIfEntryExists(orgName, token)) {
            if (debug.warningEnabled()) {
                debug.warning("ServiceConfigImpl::getInstance called with non existant organization name: " + orgName);
            }
            return null;
        }
        CachedSMSEntry entry = ServiceConfigImpl.checkAndUpdatePermission(cacheName, dn, token);
        if (!entry.isValid()) {
            entry = ServiceConfigImpl.checkAndUpdatePermission(cacheName, dn, token);
        }
        if (ss == null) {
            String subConfigId = null;
            SMSEntry sentry = entry.getSMSEntry();
            String[] ids = sentry.getAttributeValues("sunserviceID");
            if (ids != null) {
                subConfigId = ids[0];
            } else {
                int index = compName.lastIndexOf(47);
                subConfigId = compName.substring(index + 1);
            }
            if (parentSS != null) {
                ss = parentSS.getSubSchema(subConfigId);
            }
            if (ss == null) {
                return null;
            }
        }
        Map map = configImpls;
        synchronized (map) {
            ServiceConfigImpl tmp = ServiceConfigImpl.getFromCache(cacheName, null);
            if (tmp == null) {
                answer = new ServiceConfigImpl(scm, ss, entry, orgName, groupName, compName, globalConfig, token);
                configImpls.put(cacheName, answer);
            } else {
                answer = tmp;
            }
        }
        if (debug.messageEnabled()) {
            debug.message("ServiceConfigImpl::getInstance: return: " + dn);
        }
        return answer;
    }

    static void deleteInstance(SSOToken token, ServiceConfigManagerImpl scm, ServiceSchemaImpl ss, String dn, String oName, String groupName, String compName, boolean globalConfig, ServiceSchemaImpl parentSS) throws SSOException, SMSException {
        if (debug.messageEnabled()) {
            debug.message("ServiceConfigImpl::deleteInstance: called: dn: " + dn + " Org Name: " + oName + " Group Name: " + groupName + " Component Name: " + compName);
        }
        String orgName = DNMapper.orgNameToDN(oName);
        String cacheName = ServiceConfigImpl.getCacheName(scm.getName(), scm.getVersion(), orgName, groupName, compName, globalConfig);
        if (debug.messageEnabled()) {
            debug.message("ServiceConfigImpl::deleteInstance: cacheName: " + cacheName);
        }
        configImpls.remove(cacheName);
        if (debug.messageEnabled()) {
            debug.message("ServiceConfigImpl::deleteInstance: deleted: " + dn);
        }
    }

    static ServiceConfigImpl getFromCache(String cn, SSOToken t) throws SMSException, SSOException {
        Set principals;
        ServiceConfigImpl answer = (ServiceConfigImpl)configImpls.get(cn);
        if (answer != null) {
            if (!answer.isValid()) {
                configImpls.remove(cn);
                answer.clear();
                answer = null;
            } else if (answer.smsEntry.isNewEntry()) {
                answer = null;
            }
        }
        if (!(answer == null || t == null || (principals = (Set)userPrincipals.get(cn)) != null && principals.contains(t.getPrincipal().getName()))) {
            ServiceConfigImpl.checkAndUpdatePermission(cn, answer.getDN(), t);
        }
        return answer;
    }

    static CachedSMSEntry checkAndUpdatePermission(String cacheName, String dn, SSOToken t) throws SMSException, SSOException {
        CachedSMSEntry answer = CachedSMSEntry.getInstance(t, dn);
        Set<String> sudoPrincipals = (Set<String>)userPrincipals.get(cacheName);
        if (sudoPrincipals == null) {
            sudoPrincipals = Collections.synchronizedSet(new HashSet(2));
            userPrincipals.put(cacheName, sudoPrincipals);
        }
        sudoPrincipals.add(t.getPrincipal().getName());
        return answer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void clearCache() {
        Map map = configImpls;
        synchronized (map) {
            for (ServiceConfigImpl sc : configImpls.values()) {
                sc.clear();
            }
            configImpls.clear();
        }
        userPrincipals.clear();
    }

    static String getCacheName(String sName, String version, String oName, String gName, String cName, boolean global) {
        StringBuffer sb = new StringBuffer(100);
        sb.append(sName).append(version).append(oName).append(gName).append(cName).append(global);
        return sb.toString().toLowerCase();
    }

    public void globalConfigChanged(String serviceName, String version, String groupName, String serviceComponent, int type) {
    }

    public void organizationConfigChanged(String serviceName, String version, String orgName, String groupName, String serviceComponent, int type) {
    }

    public void schemaChanged(String serviceName, String version) {
        if (serviceName.equalsIgnoreCase(this.scm.getName())) {
            this.update();
        }
    }

    public String toXML(SSOToken token, String nodeName, AMEncryption encryptObj) throws SMSException, SSOException {
        return this.toXML(token, nodeName, encryptObj, null);
    }

    public String toXML(SSOToken token, String nodeName, AMEncryption encryptObj, String organizationName) throws SMSException, SSOException {
        Set serviceConfigNames = this.getSubConfigNames(token);
        Map orgAttributes = null;
        if (nodeName.equals("OrganizationConfiguration")) {
            OrganizationConfigManager ocm = new OrganizationConfigManager(token, organizationName);
            orgAttributes = ocm.getAttributes(this.scm.getName());
        }
        if (!(this.attributesWithoutDefaults != null && !this.attributesWithoutDefaults.isEmpty() || serviceConfigNames != null && !serviceConfigNames.isEmpty() || orgAttributes != null && !orgAttributes.isEmpty())) {
            return "";
        }
        StringBuffer buff = new StringBuffer();
        buff.append("<").append(nodeName);
        if ((nodeName.equals("GlobalConfiguration") || nodeName.equals("OrganizationConfiguration") || nodeName.equals("Instance")) && this.groupName != null && this.groupName.length() > 0) {
            buff.append(" ").append("group").append("=\"").append(this.groupName).append("\"");
        }
        if ((nodeName.equals("OrganizationConfiguration") || nodeName.equals("Instance")) && organizationName != null && organizationName.length() > 0) {
            String oName = organizationName.indexOf(47) == -1 ? DNMapper.orgNameToRealmName(organizationName) : organizationName;
            buff.append(" ").append("name").append("=\"").append(oName).append("\"");
        }
        if (nodeName.equals("SubConfiguration")) {
            if (this.compName != null && this.compName.length() > 0) {
                buff.append(" ").append("name").append("=\"").append(this.compName).append("\"");
            }
            if (this.configID != null && this.configID.length() > 0) {
                buff.append(" ").append("id").append("=\"").append(this.configID).append("\"");
            }
            if (this.priority > 0) {
                buff.append(" ").append("priority").append("=\"").append(Integer.toString(this.priority)).append("\"");
            }
        }
        buff.append(">");
        Map deepCopied = SMSUtils.copyAttributes(this.attributesWithoutDefaults);
        Set asNames = this.ss.getAttributeSchemaNames();
        Iterator i = asNames.iterator();
        while (i.hasNext()) {
            AttributeValidator av = this.ss.getAttributeValidator((String)i.next());
            av.encodedAttrs(deepCopied, encryptObj);
        }
        buff.append(SMSUtils.toAttributeValuePairXML(deepCopied));
        for (String scName : serviceConfigNames) {
            ServiceConfigImpl sci = this.getSubConfig(token, scName);
            buff.append(sci.toXML(token, "SubConfiguration", encryptObj));
        }
        if (orgAttributes != null && !orgAttributes.isEmpty()) {
            buff.append("<").append("OrganizationAttributeValuePair").append(">\n");
            buff.append(SMSUtils.toAttributeValuePairXML(orgAttributes));
            buff.append("</").append("OrganizationAttributeValuePair").append(">\n");
        }
        buff.append("</").append(nodeName).append(">");
        return buff.toString();
    }
}

