/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.sm;

import com.iplanet.services.util.AMEncryption;
import com.iplanet.sso.SSOException;
import com.iplanet.sso.SSOToken;
import com.sun.identity.shared.debug.Debug;
import com.sun.identity.shared.xml.XMLUtils;
import com.sun.identity.sm.CachedSMSEntry;
import com.sun.identity.sm.CachedSubEntries;
import com.sun.identity.sm.DNMapper;
import com.sun.identity.sm.PluginInterface;
import com.sun.identity.sm.PluginSchema;
import com.sun.identity.sm.SMSEntry;
import com.sun.identity.sm.SMSException;
import com.sun.identity.sm.SMSSchema;
import com.sun.identity.sm.SchemaType;
import com.sun.identity.sm.ServiceListener;
import com.sun.identity.sm.ServiceManager;
import com.sun.identity.sm.ServiceSchema;
import com.sun.identity.sm.ServiceSchemaImpl;
import com.sun.identity.sm.ServiceSchemaManagerImpl;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class ServiceSchemaManager {
    private SSOToken token;
    private String serviceName;
    private String version;
    private ServiceSchemaManagerImpl ssm;
    private static Debug debug = Debug.getInstance((String)"amSMS");

    public ServiceSchemaManager(String serviceName, SSOToken token) throws SMSException, SSOException {
        this(token, serviceName, ServiceManager.isCoexistenceMode() ? ServiceManager.serviceDefaultVersion(token, serviceName) : ServiceManager.getVersion(serviceName));
    }

    public ServiceSchemaManager(SSOToken token, String serviceName, String version) throws SMSException, SSOException {
        if (token == null || serviceName == null || version == null) {
            throw new IllegalArgumentException(SMSEntry.bundle.getString("sms-INVALID_PARAMETERS"));
        }
        SMSEntry.validateToken(token);
        this.token = token;
        this.serviceName = serviceName;
        this.version = version;
        this.ssm = ServiceSchemaManagerImpl.getInstance(token, serviceName, version);
    }

    public String getName() {
        return this.serviceName;
    }

    public String getVersion() {
        return this.version;
    }

    public String getI18NFileName() {
        this.validate();
        return this.ssm.getI18NFileName();
    }

    public void setI18NFileName(String url) throws SMSException, SSOException {
        SMSEntry.validateToken(this.token);
        this.validateServiceSchemaManagerImpl();
        String tmpS = this.ssm.getI18NFileName();
        this.ssm.setI18NFileName(url);
        try {
            this.replaceSchema(this.ssm.getDocument());
        }
        catch (SMSException se) {
            this.ssm.setI18NFileName(tmpS);
            throw se;
        }
    }

    public String getI18NJarURL() {
        this.validate();
        return this.ssm.getI18NJarURL();
    }

    public void setI18NJarURL(String url) throws SMSException, SSOException {
        SMSEntry.validateToken(this.token);
        this.validateServiceSchemaManagerImpl();
        String tmpS = this.ssm.getI18NJarURL();
        this.ssm.setI18NJarURL(url);
        try {
            this.replaceSchema(this.ssm.getDocument());
        }
        catch (SMSException se) {
            this.ssm.setI18NJarURL(tmpS);
            throw se;
        }
    }

    public String getServiceHierarchy() {
        this.validate();
        return this.ssm.getServiceHierarchy();
    }

    public void setServiceHierarchy(String newhierarchy) throws SMSException, SSOException {
        SMSEntry.validateToken(this.token);
        this.validateServiceSchemaManagerImpl();
        String tmpS = this.getServiceHierarchy();
        this.ssm.setServiceHierarchy(newhierarchy);
        try {
            this.replaceSchema(this.ssm.getDocument());
        }
        catch (SMSException e) {
            this.ssm.setServiceHierarchy(tmpS);
            throw e;
        }
    }

    public String getI18NKey() {
        this.validate();
        return this.ssm.getI18NKey();
    }

    public void setI18NKey(String i18nKey) throws SMSException, SSOException {
        SMSEntry.validateToken(this.token);
        this.validateServiceSchemaManagerImpl();
        String tmp = this.ssm.getI18NKey();
        this.ssm.setI18NKey(i18nKey);
        try {
            this.replaceSchema(this.ssm.getDocument());
        }
        catch (SMSException e) {
            this.ssm.setI18NKey(tmp);
            throw e;
        }
    }

    public String getPropertiesViewBeanURL() {
        this.validate();
        return this.ssm.getPropertiesViewBeanURL();
    }

    public void setPropertiesViewBeanURL(String url) throws SMSException, SSOException {
        SMSEntry.validateToken(this.token);
        this.validateServiceSchemaManagerImpl();
        String tmpS = this.ssm.getPropertiesViewBeanURL();
        this.ssm.setPropertiesViewBeanURL(url);
        try {
            this.replaceSchema(this.ssm.getDocument());
        }
        catch (SMSException e) {
            this.ssm.setPropertiesViewBeanURL(tmpS);
            throw e;
        }
    }

    public int getRevisionNumber() {
        this.validate();
        return this.ssm.getRevisionNumber();
    }

    public void setRevisionNumber(int revisionNumber) throws SMSException, SSOException {
        SMSEntry.validateToken(this.token);
        this.validateServiceSchemaManagerImpl();
        int tmpS = this.ssm.getRevisionNumber();
        this.ssm.setRevisionNumber(revisionNumber);
        try {
            this.replaceSchema(this.ssm.getDocument());
        }
        catch (SMSException e) {
            this.ssm.setRevisionNumber(tmpS);
            throw e;
        }
    }

    public Set getSchemaTypes() throws SMSException {
        SMSEntry.validateToken(this.token);
        this.validate();
        return this.ssm.getSchemaTypes();
    }

    public ServiceSchema getSchema(String type) throws SMSException {
        this.validate();
        SchemaType t = null;
        t = type.equalsIgnoreCase("role") || type.equalsIgnoreCase("filteredrole") || type.equalsIgnoreCase("realm") ? SchemaType.DYNAMIC : (type.equalsIgnoreCase("user") ? SchemaType.USER : new SchemaType(type));
        return this.getSchema(t);
    }

    public ServiceSchema getSchema(SchemaType type) throws SMSException {
        SMSEntry.validateToken(this.token);
        this.validate();
        ServiceSchemaImpl ss = this.ssm.getSchema(type);
        if (ss == null && type.equals(SchemaType.USER)) {
            type = SchemaType.DYNAMIC;
            ss = this.ssm.getSchema(type);
        }
        if (ss != null) {
            return new ServiceSchema(ss, "", type, this);
        }
        return null;
    }

    public ServiceSchema getOrganizationCreationSchema() throws SMSException {
        ServiceSchemaImpl ssi;
        SMSEntry.validateToken(this.token);
        this.validate();
        ServiceSchemaImpl ss = this.ssm.getSchema(SchemaType.ORGANIZATION);
        if (ss != null && (ssi = ss.getOrgAttrSchema()) != null) {
            return new ServiceSchema(ssi, "", SchemaType.ORGANIZATION, this, true);
        }
        return null;
    }

    public Set getServiceAttributeNames(SchemaType type) throws SMSException {
        SMSEntry.validateToken(this.token);
        this.validate();
        ServiceSchema ss = this.getSchema(type);
        return ss.getServiceAttributeNames();
    }

    public ServiceSchema getGlobalSchema() throws SMSException {
        return this.getSchema(SchemaType.GLOBAL);
    }

    public ServiceSchema getOrganizationSchema() throws SMSException {
        return this.getSchema(SchemaType.ORGANIZATION);
    }

    public ServiceSchema getDynamicSchema() throws SMSException {
        return this.getSchema(SchemaType.DYNAMIC);
    }

    public ServiceSchema getUserSchema() throws SMSException {
        return this.getSchema(SchemaType.USER);
    }

    public ServiceSchema getPolicySchema() throws SMSException {
        return this.getSchema(SchemaType.POLICY);
    }

    public InputStream getSchema() throws SMSException {
        SMSEntry.validateToken(this.token);
        this.validate();
        return this.ssm.getSchema();
    }

    public void replaceSchema(InputStream xmlServiceSchema) throws SSOException, SMSException, IOException {
        SMSEntry.validateToken(this.token);
        this.validateServiceSchemaManagerImpl();
        CachedSMSEntry smsEntry = this.ssm.getCachedSMSEntry();
        smsEntry.writeXMLSchema(this.token, xmlServiceSchema);
    }

    public int hashCode() {
        int hash = 7;
        hash = 67 * hash + (this.serviceName != null ? this.serviceName.hashCode() : 0);
        hash = 67 * hash + (this.version != null ? this.version.hashCode() : 0);
        return hash;
    }

    public boolean equals(Object o) {
        if (o instanceof ServiceSchemaManager) {
            ServiceSchemaManager ossm = (ServiceSchemaManager)o;
            if (this.serviceName.equals(ossm.serviceName) && this.version.equals(ossm.version)) {
                return true;
            }
        }
        return false;
    }

    public String toString() {
        return this.ssm.toString();
    }

    public String addListener(ServiceListener listener) {
        return this.ssm.addListener(listener);
    }

    public void removeListener(String listenerID) {
        this.ssm.removeListener(listenerID);
    }

    public String getLastModifiedTime() throws SMSException, SSOException {
        this.validateServiceSchemaManagerImpl();
        CachedSMSEntry ce = this.ssm.getCachedSMSEntry();
        if (ce.isDirty()) {
            ce.refresh();
        }
        SMSEntry e = ce.getSMSEntry();
        String[] vals = e.getAttributeValues("modifytimestamp", true);
        String mTS = null;
        if (vals != null) {
            mTS = vals[0];
        }
        return mTS;
    }

    public Set getPluginInterfaceNames() {
        this.validate();
        return this.ssm.getPluginInterfaceNames();
    }

    public PluginInterface getPluginInterface(String pluginInterfaceName) {
        this.validate();
        return this.ssm.getPluginInterface(pluginInterfaceName);
    }

    public void addPluginInterface(String interfaceName, String interfaceClass, String i18nKey) throws SMSException, SSOException {
        SMSEntry.validateToken(this.token);
        this.validateServiceSchemaManagerImpl();
        if (interfaceName == null || interfaceClass == null) {
            throw new IllegalArgumentException();
        }
        StringBuffer sb = new StringBuffer(100);
        sb.append("<").append("PluginInterface").append(" ").append("name").append("=\"").append(interfaceName).append("\" ").append("interface").append("=\"").append(interfaceClass).append("\"");
        if (i18nKey != null) {
            sb.append(" ").append("i18nKey").append("=\"").append(i18nKey).append("\"");
        }
        sb.append("></").append("PluginInterface").append(">");
        Document pluginDoc = SMSSchema.getXMLDocument(sb.toString(), false);
        Node node = XMLUtils.getRootNode((Document)pluginDoc, (String)"PluginInterface");
        Document schemaDoc = this.ssm.getDocumentCopy();
        Node pluginNode = schemaDoc.importNode(node, true);
        Node schemaNode = XMLUtils.getRootNode((Document)schemaDoc, (String)"Schema");
        schemaNode.appendChild(pluginNode);
        this.replaceSchema(schemaDoc);
    }

    public void removePluginInterface(String interfacename) throws SMSException, SSOException {
        SMSEntry.validateToken(this.token);
        this.validateServiceSchemaManagerImpl();
        Document schemaDoc = this.ssm.getDocumentCopy();
        Node schemaNode = XMLUtils.getRootNode((Document)schemaDoc, (String)"Schema");
        Node pluginNode = XMLUtils.getNamedChildNode((Node)schemaNode, (String)"PluginInterface", (String)"name", (String)interfacename);
        if (pluginNode != null) {
            schemaNode.removeChild(pluginNode);
            this.replaceSchema(schemaDoc);
        }
    }

    public Set getPluginSchemaNames(String interfaceName, String orgName) throws SMSException {
        SMSEntry.validateToken(this.token);
        this.validate();
        StringBuffer sb = new StringBuffer(100);
        sb.append("ou=").append(interfaceName).append(",").append("ou=PluginConfig,").append("ou=").append(this.version).append(",").append("ou=").append(this.serviceName).append(",").append("ou=services").append(",").append(DNMapper.orgNameToDN(orgName));
        CachedSubEntries cse = CachedSubEntries.getInstance(this.token, sb.toString());
        try {
            return cse.getSubEntries(this.token);
        }
        catch (SSOException s) {
            debug.error("ServiceSchemaManager: Unable to get Plugin Schema Names", (Throwable)((Object)s));
            return Collections.EMPTY_SET;
        }
    }

    public PluginSchema getPluginSchema(String pluginSchemaName, String interfaceName, String orgName) throws SMSException {
        SMSEntry.validateToken(this.token);
        this.validate();
        return new PluginSchema(this.token, this.serviceName, this.version, pluginSchemaName, interfaceName, orgName);
    }

    SSOToken getSSOToken() {
        return this.token;
    }

    protected Document getDocumentCopy() throws SMSException {
        return this.ssm.getDocumentCopy();
    }

    protected synchronized void replaceSchema(Document document) throws SSOException, SMSException {
        CachedSMSEntry smsEntry = this.ssm.getCachedSMSEntry();
        SMSSchema smsSchema = new SMSSchema(document);
        smsEntry.writeXMLSchema(this.token, smsSchema.getSchema());
    }

    private void validate() {
        try {
            this.validateServiceSchemaManagerImpl();
        }
        catch (SSOException e) {
            debug.error("ServiceSchemaManager:validate failed for SN: " + this.serviceName, (Throwable)((Object)e));
            throw new RuntimeException(e.getMessage());
        }
        catch (SMSException sMSException) {
            // empty catch block
        }
    }

    private void validateServiceSchemaManagerImpl() throws SMSException, SSOException {
        if (!this.ssm.isValid()) {
            this.ssm = ServiceSchemaManagerImpl.getInstance(this.token, this.serviceName, this.version);
        }
    }

    static void createService(SSOToken token, SMSSchema smsSchema) throws SMSException, SSOException {
        CachedSMSEntry cEntry;
        SMSEntry smsEntry = new SMSEntry(token, ServiceManager.getServiceNameDN(smsSchema.getServiceName()));
        if (smsEntry.isNewEntry()) {
            smsEntry.addAttribute("objectclass", "top");
            smsEntry.addAttribute("objectclass", "sunService");
            smsEntry.save();
        }
        if ((cEntry = CachedSMSEntry.getInstance(token, ServiceManager.getServiceNameDN(smsSchema.getServiceName(), smsSchema.getServiceVersion()))).isDirty()) {
            cEntry.refresh();
        }
        smsEntry = cEntry.getSMSEntry();
        String[] schema = new String[1];
        if (smsEntry.getAttributeValues("sunServiceSchema") != null && !smsEntry.getAttributeValues("sunServiceSchema")[0].equalsIgnoreCase(SMSSchema.getDummyXML(smsSchema.getServiceName(), smsSchema.getServiceVersion()))) {
            Object[] args = new Object[]{smsSchema.getServiceName(), smsSchema.getServiceVersion()};
            throw new SMSException("amSDK", "sms-service_already_exists", args);
        }
        schema[0] = smsSchema.getSchema();
        smsEntry.setAttribute("sunServiceSchema", schema);
        if (smsEntry.isNewEntry()) {
            smsEntry.addAttribute("objectclass", "top");
            smsEntry.addAttribute("objectclass", "sunService");
        }
        smsEntry.save(token);
        cEntry.refresh(smsEntry);
    }

    public String toXML(AMEncryption encryptObj) throws SMSException {
        String xml = this.ssm.toXML(encryptObj);
        int idx = xml.lastIndexOf("</Service>");
        StringBuffer buff = new StringBuffer();
        buff.append(xml.substring(0, idx));
        HashSet<String> realms = new HashSet<String>();
        realms.add("/");
        for (String iName : this.getPluginInterfaceNames()) {
            this.getPlugSchemaXML(buff, iName, realms);
        }
        buff.append("</Service>");
        return buff.toString();
    }

    private void getPlugSchemaXML(StringBuffer buff, String interfaceName, Set realms) throws SMSException {
        for (String realm : realms) {
            Set schemaNames = this.getPluginSchemaNames(interfaceName, realm);
            for (String pName : schemaNames) {
                PluginSchema pSchema = this.getPluginSchema(pName, interfaceName, realm);
                buff.append(pSchema.toXML());
            }
        }
    }
}

