/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.cli;

import com.iplanet.sso.SSOToken;
import com.sun.identity.cli.AttributeValues;
import com.sun.identity.cli.AuthenticatedCommand;
import com.sun.identity.cli.CLIException;
import com.sun.identity.cli.CLIRequest;
import com.sun.identity.cli.CommandManager;
import com.sun.identity.cli.RequestContext;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class BulkOperations
extends AuthenticatedCommand {
    private static final String BATCH_FILE = "batchfile";
    private static final String STATUS_FILE = "batchstatus";

    public void handleRequest(RequestContext rc) throws CLIException {
        super.handleRequest(rc);
        this.ldapLogin();
        SSOToken ssoToken = this.getAdminSSOToken();
        boolean continueFlag = this.isOptionSet("continue");
        String statusFileName = this.getStringOptionValue(STATUS_FILE);
        String batchfile = this.getStringOptionValue(BATCH_FILE);
        List entries = AttributeValues.parseValues(batchfile);
        if (entries != null && !entries.isEmpty()) {
            this.removeEmptyEntries(entries);
        }
        if (entries == null || entries.isEmpty()) {
            String[] arg = new String[]{batchfile};
            throw new CLIException(MessageFormat.format("bulk-op-empty-datafile", arg), 127);
        }
        CLIRequest req = rc.getCLIRequest();
        CommandManager mgr = this.getCommandManager();
        mgr.setContinueFlag(continueFlag);
        mgr.setStatusFileName(statusFileName);
        for (String argv : entries) {
            mgr.addToRequestQueue(new CLIRequest(req, this.makeStringArray(argv), ssoToken));
        }
    }

    private String[] makeStringArray(String argv) throws CLIException {
        argv = argv.trim();
        argv = argv.replace('\t', ' ');
        ArrayList<String> options = new ArrayList<String>();
        char[] array = argv.toCharArray();
        int len = array.length;
        boolean escape = false;
        int startIdx = 0;
        boolean inDblQuote = false;
        boolean inQuote = false;
        block5: for (int i = 0; i < len; ++i) {
            switch (array[i]) {
                case ' ': {
                    if (inQuote || inDblQuote) continue block5;
                    String tmp = argv.substring(startIdx, i);
                    if ((tmp = tmp.trim()).length() > 0) {
                        options.add(tmp);
                    }
                    startIdx = i + 1;
                    continue block5;
                }
                case '\'': {
                    if (inQuote) {
                        if (i + 1 < len && array[i + 1] != ' ') {
                            throw new CLIException(this.getResourceString("unmatch-quote"), 11);
                        }
                        inQuote = false;
                        options.add(argv.substring(startIdx, i));
                        startIdx = i + 1;
                        continue block5;
                    }
                    if (inDblQuote) continue block5;
                    inDblQuote = true;
                    startIdx = i + 1;
                    continue block5;
                }
                case '\"': {
                    if (inDblQuote) {
                        if (i + 1 < len && array[i + 1] != ' ') {
                            throw new CLIException(this.getResourceString("unmatch-doublequote"), 11);
                        }
                        inDblQuote = false;
                        options.add(argv.substring(startIdx, i));
                        startIdx = i + 1;
                        continue block5;
                    }
                    if (inQuote) continue block5;
                    inDblQuote = true;
                    startIdx = i + 1;
                }
            }
        }
        if (inQuote) {
            throw new CLIException(this.getResourceString("unmatch-quote"), 11);
        }
        if (inDblQuote) {
            throw new CLIException(this.getResourceString("unmatch-doublequote"), 11);
        }
        if (startIdx < len) {
            String tmp = argv.substring(startIdx);
            if ((tmp = tmp.trim()).length() > 0) {
                options.add(tmp);
            }
        }
        String[] optionArray = new String[options.size()];
        int sz = options.size();
        for (int i = 0; i < sz; ++i) {
            optionArray[i] = (String)options.get(i);
        }
        return optionArray;
    }

    private void removeEmptyEntries(List entries) {
        Iterator i = entries.iterator();
        while (i.hasNext()) {
            String argv = ((String)i.next()).trim();
            if (argv.length() != 0 && !argv.startsWith("#")) continue;
            i.remove();
        }
    }
}

