/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.console.authentication.model;

import com.iplanet.sso.SSOException;
import com.sun.identity.console.authentication.model.CoreAttributesModel;
import com.sun.identity.console.base.model.AMConsoleException;
import com.sun.identity.console.base.model.AMServiceProfileModelImpl;
import com.sun.identity.sm.OrganizationConfigManager;
import com.sun.identity.sm.SMSException;
import com.sun.identity.sm.SchemaType;
import com.sun.identity.sm.ServiceConfig;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;

public class CoreAttributesModelImpl
extends AMServiceProfileModelImpl
implements CoreAttributesModel {
    private String currentRealm = null;
    private static Set DISPLAY_SCHEMA_SERVICE_TYPE = new HashSet(4);
    private static final String AUTH_SERVICE_NAME = "iPlanetAMAuthService";

    public CoreAttributesModelImpl(HttpServletRequest req, String serviceName, Map map) throws AMConsoleException {
        super(req, serviceName, map);
        this.currentRealm = (String)map.get("currentRealm");
        if (this.currentRealm == null) {
            debug.warning("resetting realm in CoreAttributeModel");
            this.currentRealm = "/";
        }
    }

    public Set getDisplaySchemaTypes() {
        return DISPLAY_SCHEMA_SERVICE_TYPE;
    }

    public void setAttributeValues(Map map) throws AMConsoleException {
        String[] params = new String[]{this.currentRealm, AUTH_SERVICE_NAME};
        this.logEvent("ATTEMPT_MODIFY_AUTH_INSTANCE", params);
        try {
            OrganizationConfigManager scm = new OrganizationConfigManager(this.getUserSSOToken(), this.currentRealm);
            ServiceConfig config = scm.getServiceConfig(AUTH_SERVICE_NAME);
            config.setAttributes(map);
            this.logEvent("SUCCEED_MODIFY_AUTH_INSTANCE", params);
        }
        catch (SMSException e) {
            String strError = this.getErrorString(e);
            String[] paramsEx = new String[]{this.currentRealm, AUTH_SERVICE_NAME, strError};
            this.logEvent("SMS_EXCEPTION_MODIFY_AUTH_INSTANCE", paramsEx);
            throw new AMConsoleException(strError);
        }
        catch (SSOException e) {
            String strError = this.getErrorString((Throwable)((Object)e));
            String[] paramsEx = new String[]{this.currentRealm, AUTH_SERVICE_NAME, strError};
            this.logEvent("SSO_EXCEPTION_MODIFY_AUTH_INSTANCE", paramsEx);
            throw new AMConsoleException(strError);
        }
    }

    public Map getAttributeValues() {
        Map attrs = null;
        String[] param = new String[]{this.currentRealm};
        this.logEvent("ATTEMPT_GET_AUTH_PROFILE_IN_REALM", param);
        try {
            OrganizationConfigManager scm = new OrganizationConfigManager(this.getUserSSOToken(), this.currentRealm);
            ServiceConfig config = scm.getServiceConfig(AUTH_SERVICE_NAME);
            attrs = config.getAttributes();
            if (attrs == null || attrs.isEmpty()) {
                debug.warning("no attributes were returned for Core Auth ...");
            }
            this.logEvent("SUCCEED_GET_AUTH_PROFILE_IN_REALM", param);
        }
        catch (SMSException e) {
            String strError = this.getErrorString(e);
            String[] paramsEx = new String[]{this.currentRealm, strError};
            this.logEvent("SMS_CONFIGURATION_EXCEPTION_GET_AUTH_PROFILE_IN_REALM", paramsEx);
            debug.error("CoreAttributesModelImpl.getAttributeValues", (Throwable)e);
        }
        return attrs == null ? Collections.EMPTY_MAP : attrs;
    }

    static {
        DISPLAY_SCHEMA_SERVICE_TYPE.add(SchemaType.ORGANIZATION);
        DISPLAY_SCHEMA_SERVICE_TYPE.add(SchemaType.DYNAMIC);
    }
}

