/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.wss.sts;

import com.sun.identity.common.SystemConfigurationUtil;
import com.sun.identity.shared.debug.Debug;
import com.sun.identity.wss.sts.ClientUserToken;
import com.sun.identity.wss.sts.FAMSTSException;
import com.sun.identity.wss.sts.STSClientConfiguration;
import com.sun.identity.wss.sts.STSUtils;
import com.sun.xml.ws.api.security.trust.client.IssuedTokenConfiguration;
import com.sun.xml.ws.api.security.trust.client.IssuedTokenManager;
import com.sun.xml.ws.security.IssuedTokenContext;
import com.sun.xml.ws.security.Token;
import org.w3c.dom.Element;

public class TrustAuthorityClientImpl {
    private static Debug debug = STSUtils.debug;
    private static Class clientTokenClass;

    public Element getSTSTokenElement(String wspEndPoint, String stsEndpoint, String stsMexAddress, Object credential, String keyType, String tokenType, String version) throws FAMSTSException {
        String protocolNS = "http://docs.oasis-open.org/ws-sx/ws-trust/200512";
        if ("1.0".equals(version)) {
            protocolNS = "http://schemas.xmlsoap.org/ws/2005/02/trust";
        }
        STSClientConfiguration config = new STSClientConfiguration(protocolNS, stsEndpoint, stsMexAddress);
        config.setKeyType(keyType);
        if (tokenType != null) {
            config.setTokenType(tokenType);
        }
        if (credential != null) {
            config.setOBOToken(this.getClientUserToken(credential));
        }
        try {
            IssuedTokenManager manager = IssuedTokenManager.getInstance();
            IssuedTokenContext ctx = manager.createIssuedTokenContext((IssuedTokenConfiguration)config, wspEndPoint);
            manager.getIssuedToken(ctx);
            Token issuedToken = ctx.getSecurityToken();
            Element element = (Element)issuedToken.getTokenValue();
            return element;
        }
        catch (Exception ex) {
            debug.error("TrustAuthorityClientImpl.getSTSToken:: Failed inobtainining STS Token Element: ", (Throwable)ex);
            throw new FAMSTSException(STSUtils.bundle.getString("wstrustexception"));
        }
    }

    private Token getClientUserToken(Object credential) throws FAMSTSException {
        if (clientTokenClass == null) {
            String className = SystemConfigurationUtil.getProperty((String)"com.sun.identity.wss.sts.clientusertoken", (String)"com.sun.identity.wss.sts.STSClientUserToken");
            try {
                clientTokenClass = Thread.currentThread().getContextClassLoader().loadClass(className);
            }
            catch (Exception ex) {
                debug.error("TrustAuthorityClientImpl.getClientUserToken:Failed in obtaining class", (Throwable)ex);
                throw new FAMSTSException(STSUtils.bundle.getString("initializationFailed"));
            }
        }
        try {
            ClientUserToken userToken = (ClientUserToken)clientTokenClass.newInstance();
            userToken.init(credential);
            if (debug.messageEnabled()) {
                debug.message("TrustAuthorityClientImpl:getClientUserToken: Client User Token : " + userToken);
            }
            return userToken;
        }
        catch (Exception ex) {
            debug.error("TrustAuthorityClientImpl.getClientUserToken: Failed in initialization", (Throwable)ex);
            throw new FAMSTSException(STSUtils.bundle.getString("usertokeninitfailed"));
        }
    }
}

