/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.dpro.session.service;

import com.iplanet.am.util.SystemProperties;
import com.iplanet.dpro.session.Session;
import com.iplanet.dpro.session.SessionException;
import com.iplanet.dpro.session.SessionID;
import com.iplanet.dpro.session.service.SessionCount;
import com.iplanet.dpro.session.service.SessionService;
import com.iplanet.dpro.session.share.SessionBundle;
import com.iplanet.dpro.session.share.SessionRequest;
import com.iplanet.dpro.session.share.SessionResponse;
import com.iplanet.services.comm.server.RequestHandler;
import com.iplanet.services.comm.share.Request;
import com.iplanet.services.comm.share.Response;
import com.iplanet.services.comm.share.ResponseSet;
import com.iplanet.sso.SSOToken;
import com.iplanet.sso.SSOTokenManager;
import com.sun.identity.session.util.RestrictedTokenAction;
import com.sun.identity.session.util.RestrictedTokenContext;
import com.sun.identity.session.util.SessionUtils;
import com.sun.identity.shared.encode.CookieUtils;
import java.net.URL;
import java.util.Map;
import java.util.Vector;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class SessionRequestHandler
implements RequestHandler {
    private SessionService sessionService = SessionService.getSessionService();
    private static Boolean enableAddListenerOnAllSessions = null;
    private SSOToken clientToken = null;

    public ResponseSet process(Vector requests, HttpServletRequest servletRequest, HttpServletResponse servletResponse, ServletContext servletContext) {
        ResponseSet rset = new ResponseSet("session");
        for (int i = 0; i < requests.size(); ++i) {
            Request req = (Request)requests.elementAt(i);
            Response res = this.processRequest(req, servletRequest, servletResponse);
            rset.addResponse(res);
        }
        return rset;
    }

    private Response processRequest(Request req, HttpServletRequest servletRequest, HttpServletResponse servletResponse) {
        String content = req.getContent();
        SessionRequest sreq = SessionRequest.parseXML(content);
        SessionResponse sres = new SessionResponse(sreq.getRequestID(), sreq.getMethodID());
        try {
            Object context = SessionUtils.getClientAddress(servletRequest);
            this.clientToken = null;
            String requester = sreq.getRequester();
            if (requester != null) {
                try {
                    context = RestrictedTokenContext.unmarshal(requester);
                    if (context instanceof SSOToken) {
                        SSOToken adminToken;
                        SSOTokenManager ssoTokenManager = SSOTokenManager.getInstance();
                        if (!ssoTokenManager.isValidToken(adminToken = (SSOToken)context)) {
                            sres.setException(SessionBundle.getString("appTokenInvalid") + requester);
                            return new Response(sres.toXMLString());
                        }
                        this.clientToken = (SSOToken)context;
                    }
                }
                catch (Exception e) {
                    if (SessionService.sessionDebug.warningEnabled()) {
                        SessionService.sessionDebug.warning("SessionRequestHandler.processRequest:app token invalid, sending Session response with Exception");
                    }
                    sres.setException(SessionBundle.getString("appTokenInvalid") + requester);
                    return new Response(sres.toXMLString());
                }
            }
            final HttpServletRequest httpReq = servletRequest;
            final HttpServletResponse httpResp = servletResponse;
            final SessionRequest fsreq = sreq;
            sres = (SessionResponse)RestrictedTokenContext.doUsing(context, new RestrictedTokenAction(){

                public Object run() throws Exception {
                    return SessionRequestHandler.this.processSessionRequest(fsreq, httpReq, httpResp);
                }
            });
        }
        catch (Exception e) {
            SessionService.sessionDebug.error("SessionRequestHandler encounterd exception", (Throwable)e);
            sres.setException(e.getMessage());
        }
        return new Response(sres.toXMLString());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private SessionResponse processSessionRequest(SessionRequest req, HttpServletRequest servletRequest, HttpServletResponse servletResponse) {
        SessionResponse res = new SessionResponse(req.getRequestID(), req.getMethodID());
        SessionID sid = new SessionID(req.getSessionID());
        Session requesterSession = null;
        try {
            switch (req.getMethodID()) {
                case 1: 
                case 5: 
                case 7: {
                    requesterSession = Session.getSession(sid);
                    if (requesterSession.getProperty("TokenRestriction") == null) break;
                    res.setException(sid + " " + SessionBundle.getString("noPrivilege"));
                    return res;
                }
                case 0: 
                case 2: 
                case 3: 
                case 4: 
                case 6: {
                    if (req.getMethodID() == 2) {
                        requesterSession = Session.getSession(sid);
                        if (requesterSession.getProperty("TokenRestriction") != null) {
                            res.setException(sid + " " + SessionBundle.getString("noPrivilege"));
                            return res;
                        }
                        sid = new SessionID(req.getDestroySessionID());
                    } else if (req.getMethodID() == 6) {
                        try {
                            SessionUtils.checkPermissionToSetProperty(this.clientToken, req.getPropertyName(), req.getPropertyValue());
                        }
                        catch (SessionException se) {
                            if (SessionService.sessionDebug.warningEnabled()) {
                                SessionService.sessionDebug.warning("SessionRequestHandler.processRequest:Client does not have permission to set - property key = " + req.getPropertyName() + " : property value = " + req.getPropertyValue());
                            }
                            res.setException(sid + " " + SessionBundle.getString("noPrivilege"));
                            return res;
                        }
                    }
                    if (!this.sessionService.isSessionFailoverEnabled()) {
                        URL originService = Session.getSessionServiceURL(sid);
                        if (this.sessionService.isLocalSessionService(originService)) break;
                        return this.forward(originService, req);
                    }
                    if (SessionService.getUseInternalRequestRouting()) {
                        String hostServerID = this.sessionService.getCurrentHostServer(sid);
                        if (!this.sessionService.isLocalServer(hostServerID)) {
                            try {
                                return this.forward(Session.getSessionServiceURL(hostServerID), req);
                            }
                            catch (SessionException e) {
                                if (this.sessionService.checkServerUp(hostServerID)) throw e;
                                String retryHostServerID = this.sessionService.getCurrentHostServer(sid);
                                if (retryHostServerID.equals(hostServerID)) {
                                    throw e;
                                }
                                if (!this.sessionService.isLocalServer(retryHostServerID)) {
                                    return this.forward(Session.getSessionServiceURL(retryHostServerID), req);
                                }
                            }
                        }
                    } else {
                        String isSessionCookie = CookieUtils.getCookieValueFromReq((HttpServletRequest)servletRequest, (String)Session.getCookieName());
                        String httpCookie = CookieUtils.getCookieValueFromReq((HttpServletRequest)servletRequest, (String)SessionService.getHttpSessionTrackingCookieName());
                        if (!(this.sessionService.isSessionPresent(sid) || isSessionCookie != null && isSessionCookie.equals(sid.toString()) && httpCookie != null && httpCookie.equals(sid.getTail()))) {
                            return this.forward(Session.getSessionServiceURL(sid), req);
                        }
                    }
                    if (this.sessionService.isSessionPresent(sid) || this.sessionService.recoverSession(sid) != null) break;
                    res.setException(sid + " " + SessionBundle.getString("sessionNotObtained"));
                    return res;
                }
                default: {
                    res.setException(sid + " " + SessionBundle.getString("unknownRequestMethod"));
                    return res;
                }
            }
            switch (req.getMethodID()) {
                case 0: {
                    res.addSessionInfo(this.sessionService.getSessionInfo(sid, req.getResetFlag()));
                    return res;
                }
                case 1: {
                    String pattern = req.getPattern();
                    Vector infos = null;
                    int[] status = new int[]{0};
                    infos = this.sessionService.getValidSessions(requesterSession, pattern, status);
                    res.setStatus(status[0]);
                    res.setSessionInfoVector(infos);
                    return res;
                }
                case 2: {
                    this.sessionService.destroySession(requesterSession, new SessionID(req.getDestroySessionID()));
                    return res;
                }
                case 3: {
                    this.sessionService.logout(sid);
                    return res;
                }
                case 4: {
                    this.sessionService.addSessionListener(sid, req.getNotificationURL());
                    return res;
                }
                case 5: {
                    if (!SessionRequestHandler.getEnableAddListenerOnAllSessions()) return res;
                    this.sessionService.addSessionListenerOnAllSessions(requesterSession, req.getNotificationURL());
                    return res;
                }
                case 6: {
                    this.sessionService.setExternalProperty(this.clientToken, sid, req.getPropertyName(), req.getPropertyValue());
                    return res;
                }
                case 7: {
                    String uuid = req.getUUID();
                    Map sessions = SessionCount.getSessionsFromLocalServer(uuid);
                    if (sessions == null) return res;
                    res.setSessionsForGivenUUID(sessions);
                    return res;
                }
                default: {
                    res.setException(sid + " " + SessionBundle.getString("unknownRequestMethod"));
                    return res;
                }
            }
        }
        catch (SessionException e) {
            res.setException(sid + " " + e.getMessage());
        }
        return res;
    }

    private SessionResponse forward(URL svcurl, SessionRequest sreq) throws SessionException {
        try {
            SessionResponse sres;
            Object context = RestrictedTokenContext.getCurrent();
            if (context != null) {
                sreq.setRequester(RestrictedTokenContext.marshal(context));
            }
            if ((sres = Session.sendPLLRequest(svcurl, sreq)).getException() != null) {
                throw new SessionException(sres.getException());
            }
            return sres;
        }
        catch (SessionException se) {
            throw se;
        }
        catch (Exception e) {
            throw new SessionException(e);
        }
    }

    private static boolean getEnableAddListenerOnAllSessions() {
        if (enableAddListenerOnAllSessions == null) {
            enableAddListenerOnAllSessions = Boolean.valueOf(SystemProperties.get("com.sun.am.session.enableAddListenerOnAllSessions"));
        }
        return enableAddListenerOnAllSessions;
    }
}

