/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.ums;

import com.iplanet.services.ldap.Attr;
import com.iplanet.services.ldap.AttrSet;
import com.iplanet.services.util.I18n;
import com.iplanet.ums.ConfigManagerException;
import com.iplanet.ums.ConfigManagerUMS;
import com.iplanet.ums.CreationTemplate;
import com.iplanet.ums.DefaultClassResolver;
import com.iplanet.ums.GroupResolver;
import com.iplanet.ums.Guid;
import com.iplanet.ums.IClassResolver;
import com.iplanet.ums.PersistentObject;
import com.iplanet.ums.SearchTemplate;
import com.iplanet.ums.UMSException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Set;
import java.util.Vector;

public class TemplateManager
implements Serializable {
    public static final int SCOPE_ORG = 0;
    public static final int SCOPE_ANCESTORS = 1;
    public static final int SCOPE_TOP = 2;
    private static final String TEMPLATE_NAME = "name";
    private static final String TEMPLATE_JAVACLASS = "javaclass";
    private static final String TEMPLATE_OPTIONAL = "optional";
    private static final String TEMPLATE_REQUIRED = "required";
    private static final String TEMPLATE_VALIDATED = "validated";
    private static final String TEMPLATE_NAMINGATTRIBUTE = "namingattribute";
    private static final String TEMPLATE_SEARCH_FILTER = "searchfilter";
    private static final String SCHEMA2_SEARCH_FILTER = "inetDomainSearchFilter";
    private static final String TEMPLATE_ATTRS = "attrs";
    private static I18n i18n = I18n.getInstance("amSDK");
    private Vector m_resolvers = new Vector();
    private ConfigManagerUMS m_configManager = null;
    private static TemplateManager m_mgr;

    protected TemplateManager() throws UMSException {
        this.addClassResolver(new DefaultClassResolver());
        this.addClassResolver(new GroupResolver());
        try {
            this.m_configManager = ConfigManagerUMS.getConfigManager();
        }
        catch (ConfigManagerException e) {
            throw new UMSException(e.getMessage());
        }
    }

    public static synchronized TemplateManager getTemplateManager() throws UMSException {
        if (m_mgr == null) {
            m_mgr = new TemplateManager();
        }
        return m_mgr;
    }

    public void addClassResolver(IClassResolver resolver) {
        this.m_resolvers.addElement(resolver);
    }

    public void removeClassResolver(IClassResolver resolver) {
        this.m_resolvers.remove(resolver);
    }

    public CreationTemplate getCreationTemplate(Class cls, Guid orgGuid) throws UMSException {
        return this.getCreationTemplate(cls, orgGuid, 1);
    }

    public CreationTemplate getCreationTemplate(Class cls, Guid orgGuid, int scope) throws UMSException {
        if (cls == null) {
            String msg = i18n.getString("ums-badclass");
            throw new IllegalArgumentException(msg);
        }
        AttrSet attrSet = null;
        try {
            attrSet = this.m_configManager.getCreationTemplateForClass(orgGuid, cls.getName(), scope);
        }
        catch (ConfigManagerException e) {
            throw new UMSException(e.getMessage());
        }
        if (attrSet == null) {
            return null;
        }
        return this.toCreationTemplate(attrSet);
    }

    public CreationTemplate getCreationTemplate(String name, Guid orgGuid) throws UMSException {
        return this.getCreationTemplate(name, orgGuid, 1);
    }

    public CreationTemplate getCreationTemplate(String name, Guid orgGuid, int scope) throws UMSException {
        if (name == null) {
            String msg = i18n.getString("ums-missingtemplname");
            throw new IllegalArgumentException(msg);
        }
        AttrSet attrSet = null;
        try {
            attrSet = this.m_configManager.getCreationTemplate(orgGuid, name, scope);
        }
        catch (ConfigManagerException e) {
            throw new UMSException(e.getMessage());
        }
        if (attrSet == null) {
            return null;
        }
        return this.toCreationTemplate(attrSet);
    }

    public SearchTemplate getSearchTemplate(String name, Guid orgGuid) throws UMSException {
        return this.getSearchTemplate(name, orgGuid, 1);
    }

    public SearchTemplate getSearchTemplate(String name, Guid orgGuid, int scope) throws UMSException {
        if (name == null) {
            String msg = i18n.getString("ums-missingtemplname");
            throw new IllegalArgumentException(msg);
        }
        AttrSet attrSet = null;
        try {
            attrSet = this.m_configManager.getSearchTemplate(orgGuid, name, scope);
        }
        catch (ConfigManagerException e) {
            throw new UMSException(e.getMessage());
        }
        if (attrSet == null) {
            return null;
        }
        return this.toSearchTemplate(attrSet);
    }

    public Set getCreationTemplateNames(Guid orgGuid) throws UMSException {
        Set names = null;
        try {
            names = this.m_configManager.getCreationTemplateNames(orgGuid);
        }
        catch (ConfigManagerException e) {
            throw new UMSException(e.getMessage());
        }
        return names != null ? names : Collections.EMPTY_SET;
    }

    public Set getSearchTemplateNames(Guid orgGuid) throws UMSException {
        Set names = null;
        try {
            names = this.m_configManager.getSearchTemplateNames(orgGuid);
        }
        catch (ConfigManagerException e) {
            throw new UMSException(e.getMessage());
        }
        return names != null ? names : Collections.EMPTY_SET;
    }

    public void replaceCreationTemplate(CreationTemplate template, Guid orgGuid) throws UMSException {
        if (template == null) {
            return;
        }
        String templateName = template.getName();
        if (templateName == null) {
            String msg = i18n.getString("ums-missingtemplname");
            throw new IllegalArgumentException(msg);
        }
        AttrSet attrSet = this.toAttrSet(template);
        try {
            this.m_configManager.replaceCreationTemplate(orgGuid, templateName, attrSet);
        }
        catch (ConfigManagerException e) {
            throw new UMSException(e.getMessage());
        }
    }

    private AttrSet toAttrSet(CreationTemplate t) {
        Attr validated;
        Attr optional;
        AttrSet attrSet = new AttrSet();
        attrSet.add(new Attr(TEMPLATE_NAME, t.getName()));
        attrSet.add(new Attr(TEMPLATE_NAMINGATTRIBUTE, t.getNamingAttribute()));
        ArrayList classes = t.getCreationClasses();
        String[] classNames = new String[classes.size()];
        for (int i = 0; i < classes.size(); ++i) {
            Class cls = (Class)classes.get(i);
            classNames[i] = cls.getName();
        }
        attrSet.add(new Attr(TEMPLATE_JAVACLASS, classNames));
        Attr required = this.encodeAttrSet(TEMPLATE_REQUIRED, t.getRequiredAttributeSet(), "=");
        if (required != null) {
            attrSet.add(required);
        }
        if ((optional = this.encodeAttrSet(TEMPLATE_OPTIONAL, t.getOptionalAttributeSet(), "=")) != null) {
            attrSet.add(optional);
        }
        if ((validated = this.encodeAttrSet(TEMPLATE_VALIDATED, t.getValidation(), "=")) != null) {
            attrSet.add(validated);
        }
        return attrSet;
    }

    Class getJavaClassForEntry(String id, AttrSet attrSet) throws UMSException {
        Class javaClass = null;
        for (int i = this.m_resolvers.size() - 1; javaClass == null && i >= 0; --i) {
            IClassResolver resolver = (IClassResolver)this.m_resolvers.elementAt(i);
            javaClass = resolver.resolve(id, attrSet);
        }
        if (javaClass == null) {
            javaClass = PersistentObject.class;
        }
        return javaClass;
    }

    private CreationTemplate toCreationTemplate(AttrSet t) {
        Attr nameAttr = t.getAttribute(TEMPLATE_NAME);
        String name = null;
        if (nameAttr != null) {
            name = nameAttr.getValue();
        }
        Attr namingAttr = t.getAttribute(TEMPLATE_NAMINGATTRIBUTE);
        String namingAttribute = null;
        if (namingAttr != null) {
            namingAttribute = namingAttr.getValue();
        }
        Attr classAttr = t.getAttribute(TEMPLATE_JAVACLASS);
        String[] classNames = null;
        if (classAttr != null) {
            classNames = classAttr.getStringValues();
        }
        AttrSet required = this.decodeAttr(t.getAttribute(TEMPLATE_REQUIRED), "=");
        AttrSet optional = this.decodeAttr(t.getAttribute(TEMPLATE_OPTIONAL), "=");
        AttrSet validated = this.decodeAttr(t.getAttribute(TEMPLATE_VALIDATED), "=");
        CreationTemplate template = new CreationTemplate();
        ArrayList classes = new ArrayList();
        try {
            if (classNames != null) {
                for (int i = 0; i < classNames.length; ++i) {
                    Class<?> cls = Class.forName(classNames[i]);
                    classes.add(cls);
                }
            }
            template = new CreationTemplate(name, required, optional, classes);
        }
        catch (ClassNotFoundException e) {
            template = new CreationTemplate(name, required, optional);
        }
        if (validated != null) {
            template.setValidation(validated);
        }
        if (namingAttribute != null) {
            template.setNamingAttribute(namingAttribute);
        }
        return template;
    }

    private SearchTemplate toSearchTemplate(AttrSet t) {
        Attr filterAttr;
        Attr nameAttr = t.getAttribute(TEMPLATE_NAME);
        String name = null;
        if (nameAttr != null) {
            name = nameAttr.getValue();
        }
        if ((filterAttr = t.getAttribute(SCHEMA2_SEARCH_FILTER)) == null) {
            filterAttr = t.getAttribute(TEMPLATE_SEARCH_FILTER);
        }
        String filter = null;
        if (filterAttr != null) {
            filter = filterAttr.getValue();
        }
        AttrSet attrSet = this.decodeAttr(t.getAttribute(TEMPLATE_ATTRS), "=");
        SearchTemplate template = new SearchTemplate();
        template = new SearchTemplate(name, attrSet, filter);
        return template;
    }

    private AttrSet decodeAttr(Attr attr, String delimiter) {
        if (attr == null) {
            return null;
        }
        String[] values = attr.getStringValues();
        AttrSet attrSet = new AttrSet();
        int size = attr.size();
        for (int i = 0; i < size; ++i) {
            String value = values[i];
            String attrName = null;
            String attrValue = null;
            int index = value.indexOf(61);
            if (index < 0) {
                attrName = value;
            } else {
                attrName = value.substring(0, index);
                attrValue = value.substring(index + 1, value.length());
            }
            if (attrValue != null && attrValue.length() != 0) {
                attrSet.add(new Attr(attrName, attrValue));
                continue;
            }
            attrSet.add(new Attr(attrName));
        }
        return attrSet;
    }

    private Attr encodeAttrSet(String attrName, AttrSet attrSet, String delimiter) {
        if (attrSet == null || attrSet.size() == 0) {
            return null;
        }
        Enumeration attrEnum = attrSet.getAttributes();
        Attr encodedAttr = new Attr(attrName);
        while (attrEnum.hasMoreElements()) {
            Attr a = (Attr)attrEnum.nextElement();
            String[] values = a.getStringValues();
            String[] encodedValues = new String[values.length];
            if (values.length == 0) {
                encodedAttr.addValue(a.getName());
                continue;
            }
            for (int i = 0; i < values.length; ++i) {
                encodedValues[i] = a.getName() + delimiter + values[i];
            }
            encodedAttr.addValues(encodedValues);
        }
        return encodedAttr;
    }
}

