/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.sm;

import com.iplanet.am.util.SystemProperties;
import com.iplanet.sso.SSOException;
import com.iplanet.sso.SSOToken;
import com.sun.identity.shared.ldap.util.DN;
import com.sun.identity.sm.SMSEntry;
import com.sun.identity.sm.SMSEventListenerManager;
import com.sun.identity.sm.SMSException;
import com.sun.identity.sm.ServiceManager;
import com.sun.identity.sm.ServiceSchemaManagerImpl;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class CachedSMSEntry {
    protected static final String UPDATE_METHOD = "update";
    protected static Map smsEntries = Collections.synchronizedMap(new HashMap(1000));
    protected Set serviceObjects = Collections.synchronizedSet(new HashSet());
    protected String notificationID;
    protected Set principals = Collections.synchronizedSet(new HashSet(10));
    protected SSOToken token;
    protected String dn2Str;
    protected String dnRFCStr;
    protected SMSEntry smsEntry;
    private boolean valid;
    private boolean dirty;
    static boolean ttlEnabled;
    static long lastUpdate;
    static long ttl;
    private static Class CACHED_SMSENTRY;
    private static Method UPDATE_FUNC;

    private CachedSMSEntry(SMSEntry e) {
        this.smsEntry = e;
        DN dn = new DN(e.getDN());
        this.dn2Str = dn.toString();
        this.dnRFCStr = dn.toRFCString().toLowerCase();
        this.token = e.getSSOToken();
        this.addPrincipal(this.token);
        this.valid = true;
        this.smsEntry.setReadOnly();
        this.notificationID = SMSEventListenerManager.notifyChangesToNode(this.token, this.smsEntry.getDN(), UPDATE_FUNC, this, null);
        if (SMSEntry.debug.messageEnabled()) {
            SMSEntry.debug.message("CachedSMSEntry: New instance: " + dn);
        }
    }

    boolean isValid() {
        return this.valid;
    }

    public boolean isDirty() {
        if (ttlEnabled && !this.dirty && System.currentTimeMillis() - lastUpdate > ttl) {
            this.dirty = true;
        }
        return this.dirty;
    }

    void update() {
        if (SMSEntry.debug.messageEnabled()) {
            SMSEntry.debug.message("CachedSMSEntry: update method called: " + this.dn2Str);
        }
        this.dirty = true;
    }

    public void refresh() {
        if (SMSEntry.debug.messageEnabled()) {
            SMSEntry.debug.message("CachedSMSEntry: refresh method called: " + this.dn2Str);
        }
        boolean updated = false;
        this.dirty = true;
        try {
            SSOToken t = this.getValidSSOToken();
            if (t != null) {
                this.smsEntry.read(t);
                lastUpdate = System.currentTimeMillis();
                updated = true;
            } else if (SMSEntry.debug.warningEnabled()) {
                SMSEntry.debug.warning("CachedSMSEntry:update No VALID SSOToken found for dn: " + this.dn2Str);
            }
        }
        catch (SMSException e) {
            SMSEntry.debug.error("Error in reading entry attributes: " + this.dn2Str, (Throwable)e);
        }
        catch (SSOException ssoe) {
            SMSEntry.debug.error("SSOToken problem in reading entry attributes: " + this.dn2Str, (Throwable)((Object)ssoe));
        }
        if (!updated) {
            this.clear();
        }
        this.updateServiceListeners(UPDATE_METHOD);
        this.dirty = false;
    }

    void refresh(SMSEntry e) throws SMSException {
        this.smsEntry.refresh(e);
        this.updateServiceListeners(UPDATE_METHOD);
        this.dirty = false;
    }

    void clear() {
        this.clear(true);
    }

    private void clear(boolean removeFromCache) {
        SMSEventListenerManager.removeNotification(this.notificationID);
        this.notificationID = null;
        this.valid = false;
        this.dirty = true;
        if (removeFromCache) {
            smsEntries.remove(this.dnRFCStr);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SSOToken getValidSSOToken() {
        if (!SMSEntry.tm.isValidToken(this.token)) {
            Set set = this.principals;
            synchronized (set) {
                Iterator items = this.principals.iterator();
                while (items.hasNext()) {
                    String tokenID = (String)items.next();
                    try {
                        this.token = SMSEntry.tm.createSSOToken(tokenID);
                        if (!SMSEntry.tm.isValidToken(this.token)) continue;
                        break;
                    }
                    catch (SSOException ssoe) {
                        items.remove();
                    }
                }
            }
        }
        if (this.principals.isEmpty()) {
            return null;
        }
        return this.token;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateServiceListeners(String method) {
        if (SMSEntry.debug.messageEnabled()) {
            SMSEntry.debug.message("CachedSMSEntry::updateServiceListeners method called: " + this.dn2Str);
        }
        ArrayList tmpServiceObjects = new ArrayList();
        Set set = this.serviceObjects;
        synchronized (set) {
            Iterator objs = this.serviceObjects.iterator();
            while (objs.hasNext()) {
                tmpServiceObjects.add(objs.next());
            }
        }
        Iterator objs = tmpServiceObjects.iterator();
        while (objs.hasNext()) {
            try {
                Object obj = objs.next();
                Method m = obj.getClass().getDeclaredMethod(method, null);
                m.invoke(obj, (Object[])null);
            }
            catch (Throwable e) {
                SMSEntry.debug.error("CachedSMSEntry::unable to deliver notification(" + this.dn2Str + ")", e);
            }
        }
    }

    protected void addServiceListener(Object o) {
        this.serviceObjects.add(o);
    }

    protected void removeServiceListener(Object o) {
        this.serviceObjects.remove(o);
        if (this.serviceObjects.isEmpty()) {
            SMSEventListenerManager.removeNotification(this.notificationID);
            this.notificationID = null;
        }
    }

    synchronized void addPrincipal(SSOToken t) {
        this.principals.add(((Object)t.getTokenID()).toString());
    }

    boolean checkPrincipal(SSOToken t) {
        return this.principals.contains(((Object)t.getTokenID()).toString());
    }

    public SMSEntry getSMSEntry() {
        return this.smsEntry;
    }

    public SMSEntry getClonedSMSEntry() {
        if (this.isDirty()) {
            this.refresh();
        }
        try {
            return (SMSEntry)this.smsEntry.clone();
        }
        catch (CloneNotSupportedException c) {
            SMSEntry.debug.error("Unable to clone SMSEntry: " + this.smsEntry, (Throwable)c);
            return null;
        }
    }

    boolean isNewEntry() {
        if (this.isDirty()) {
            this.refresh();
        }
        return this.smsEntry.isNewEntry();
    }

    String getDN() {
        return this.dn2Str;
    }

    static CachedSMSEntry getInstance(SSOToken t, ServiceSchemaManagerImpl ssm, String serviceName, String version) throws SMSException {
        CachedSMSEntry entry = null;
        String dn = ServiceManager.getServiceNameDN(serviceName, version);
        try {
            entry = CachedSMSEntry.getInstance(t, dn);
            entry.addServiceListener(ssm);
        }
        catch (SSOException ssoe) {
            SMSEntry.debug.error("SMS: Invalid SSOToken: ", (Throwable)((Object)ssoe));
        }
        return entry;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static CachedSMSEntry getInstance(SSOToken t, String dn) throws SMSException, SSOException {
        String cacheEntry;
        CachedSMSEntry answer;
        if (SMSEntry.debug.messageEnabled()) {
            SMSEntry.debug.message("CachedSMSEntry::getInstance: " + dn);
        }
        if ((answer = (CachedSMSEntry)smsEntries.get(cacheEntry = new DN(dn).toRFCString().toLowerCase())) == null || !answer.isValid()) {
            CachedSMSEntry tmp = new CachedSMSEntry(new SMSEntry(t, dn));
            Map map = smsEntries;
            synchronized (map) {
                answer = (CachedSMSEntry)smsEntries.get(cacheEntry);
                if (answer == null || !answer.isValid()) {
                    answer = tmp;
                    smsEntries.put(cacheEntry, answer);
                }
            }
        }
        if (!answer.checkPrincipal(t)) {
            new SMSEntry(t, dn);
            answer.addPrincipal(t);
        }
        if (SMSEntry.debug.messageEnabled()) {
            SMSEntry.debug.message("CachedSMSEntry: obtained instance: " + dn);
        }
        if (answer.isNewEntry()) {
            SMSEntry sEntry = answer.getSMSEntry();
            sEntry.dn = dn;
        }
        return answer;
    }

    static void initializeProperties() {
        String cacheTime;
        String ttlEnabledString = SystemProperties.get("com.sun.identity.sm.cache.ttl.enable", "false");
        ttlEnabled = Boolean.valueOf(ttlEnabledString);
        if (ttlEnabled && (cacheTime = SystemProperties.get("com.sun.identity.sm.cache.ttl")) != null) {
            try {
                ttl = Long.parseLong(cacheTime);
                ttl = ttl * 60L * 1000L;
            }
            catch (NumberFormatException nfe) {
                SMSEntry.debug.error("CachedSMSEntry:init Invalid time for SMS Cache TTL: " + cacheTime);
                ttl = 1800000L;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void clearCache() {
        Map map = smsEntries;
        synchronized (map) {
            for (CachedSMSEntry cEntry : smsEntries.values()) {
                cEntry.clear(false);
            }
            smsEntries.clear();
        }
    }

    String getXMLSchema() {
        String[] schema = this.smsEntry.getAttributeValues("sunServiceSchema");
        if (schema == null) {
            return null;
        }
        return schema[0];
    }

    void writeXMLSchema(SSOToken token, InputStream xmlServiceSchema) throws SSOException, SMSException, IOException {
        int lengthOfStream = xmlServiceSchema.available();
        byte[] byteArray = new byte[lengthOfStream];
        xmlServiceSchema.read(byteArray, 0, lengthOfStream);
        this.writeXMLSchema(token, new String(byteArray));
    }

    void writeXMLSchema(SSOToken token, String xmlSchema) throws SSOException, SMSException {
        SMSEntry.validateToken(token);
        String[] attrValues = new String[]{xmlSchema};
        SMSEntry e = this.getClonedSMSEntry();
        e.setAttribute("sunServiceSchema", attrValues);
        e.save(token);
        this.refresh(e);
        if (SMSEntry.debug.messageEnabled()) {
            SMSEntry.debug.message("CachedSMSEntry::writeXMLSchema: successfully wrote the XML schema for dn: " + e.getDN());
        }
    }

    static {
        ttl = 1800000L;
        try {
            CACHED_SMSENTRY = Class.forName("com.sun.identity.sm.CachedSMSEntry");
            UPDATE_FUNC = CACHED_SMSENTRY.getDeclaredMethod(UPDATE_METHOD, null);
            CachedSMSEntry.initializeProperties();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

