/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.tools.logdoc;

import com.sun.identity.tools.logdoc.LogHtmlTemplate;
import com.sun.identity.tools.logdoc.LogMessages;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LogMessagesFormatter {
    private static FilenameFilter xmlFilter;
    static String htmlDir;
    private List<LogMessages> logMessages = new ArrayList<LogMessages>();

    private LogMessagesFormatter() {
    }

    private LogMessagesFormatter(Set<String> files) throws ParserConfigurationException, SAXException, IOException {
        for (String fileName : files) {
            this.parseXML(fileName);
        }
        this.generateCSSFiles();
        this.generateHTMLFiles();
    }

    private void generateCSSFiles() throws IOException {
        LogMessagesFormatter.writeToFile(LogHtmlTemplate.css_ie5win, "css_ie5win.css");
        LogMessagesFormatter.writeToFile(LogHtmlTemplate.css_ie6up, "css_ie6up.css");
        LogMessagesFormatter.writeToFile(LogHtmlTemplate.css_ns4sol, "css_ns4sol.css");
        LogMessagesFormatter.writeToFile(LogHtmlTemplate.css_ns4win, "css_ns4win.css");
        LogMessagesFormatter.writeToFile(LogHtmlTemplate.css_ns6up, "css_ns6up.css");
        LogMessagesFormatter.writeToFile(LogHtmlTemplate.stylesheetjs, "stylesheet.js");
        LogMessagesFormatter.writeToFile(LogHtmlTemplate.browserjs, "browserVersion.js");
    }

    private void generateHTMLFiles() throws IOException {
        StringBuffer buff = new StringBuffer();
        for (LogMessages lm : this.logMessages) {
            String htmlpage = lm.getName() + ".html";
            String link = LogHtmlTemplate.indexLink.replaceAll("@htmlpage@", htmlpage);
            link = link.replaceAll("@name@", lm.getName());
            buff.append(link);
            lm.generateHTMLFile();
        }
        String indexPage = LogHtmlTemplate.indexPage.replaceAll("@indices@", buff.toString());
        LogMessagesFormatter.writeToFile(indexPage, "index.html");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void writeToFile(String content, String fileName) throws IOException {
        BufferedWriter out = null;
        try {
            out = new BufferedWriter(new FileWriter(htmlDir + "/" + fileName));
            out.write(content);
        }
        finally {
            if (out != null) {
                out.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void parseXML(String fileName) throws ParserConfigurationException, SAXException, IOException {
        String xml = LogMessagesFormatter.stripDocType(fileName);
        ByteArrayInputStream bis = null;
        try {
            bis = new ByteArrayInputStream(xml.getBytes());
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            DocumentBuilder db = dbf.newDocumentBuilder();
            Document dom = db.parse(bis);
            Element rootElm = dom.getDocumentElement();
            this.logMessages.add(new LogMessages(fileName, rootElm));
        }
        finally {
            if (bis != null) {
                bis.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String stripDocType(String fileName) throws IOException {
        BufferedReader reader = null;
        try {
            reader = new BufferedReader(new FileReader(new File(fileName)));
            StringBuffer buff = new StringBuffer();
            String line = reader.readLine();
            while (line != null) {
                buff.append(line);
                line = reader.readLine();
            }
            String string = buff.toString().replaceAll("<!DOCTYPE .*?>", "");
            return string;
        }
        finally {
            if (reader != null) {
                reader.close();
            }
        }
    }

    public static void main(String[] args) {
        try {
            TreeSet<String> files = new TreeSet<String>();
            for (int i = 0; i < args.length; ++i) {
                LogMessagesFormatter.getXMLFiles(args[i], files);
            }
            new LogMessagesFormatter(files);
        }
        catch (ParserConfigurationException e) {
            e.printStackTrace();
        }
        catch (SAXException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private static void getXMLFiles(String dir, Set<String> files) throws IOException {
        File directory = new File(dir);
        String[] children = directory.list(xmlFilter);
        if (children != null) {
            for (int i = 0; i < children.length; ++i) {
                files.add(dir + "/" + children[i]);
            }
        }
    }

    static {
        htmlDir = System.getProperty("opensso.log.html.dir");
        xmlFilter = new FilenameFilter(){

            public boolean accept(File dir, String name) {
                return name.endsWith(".xml");
            }
        };
    }
}

