/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.console.policy;

import com.iplanet.jato.model.ModelControlException;
import com.iplanet.jato.view.ContainerView;
import com.iplanet.jato.view.ContainerViewBase;
import com.iplanet.jato.view.View;
import com.iplanet.jato.view.ViewBean;
import com.iplanet.jato.view.event.ChildDisplayEvent;
import com.iplanet.jato.view.event.DisplayEvent;
import com.iplanet.jato.view.event.RequestInvocationEvent;
import com.iplanet.jato.view.html.OptionList;
import com.sun.identity.console.base.AMPropertySheet;
import com.sun.identity.console.base.model.AMAdminUtils;
import com.sun.identity.console.base.model.AMConsoleException;
import com.sun.identity.console.base.model.AMDisplayType;
import com.sun.identity.console.base.model.AMPropertySheetModel;
import com.sun.identity.console.delegation.model.DelegationConfig;
import com.sun.identity.console.policy.PolicyOpViewBeanBase;
import com.sun.identity.console.policy.ProfileViewBeanBase;
import com.sun.identity.console.policy.SelectReferralTypeViewBean;
import com.sun.identity.console.policy.model.CachedPolicy;
import com.sun.identity.console.policy.model.PolicyCache;
import com.sun.identity.console.policy.model.PolicyModel;
import com.sun.identity.policy.Syntax;
import com.sun.identity.policy.ValidValues;
import com.sun.identity.policy.interfaces.Referral;
import com.sun.web.ui.model.CCPageTitleModel;
import com.sun.web.ui.model.CCPropertySheetModelInterface;
import com.sun.web.ui.view.html.CCSelect;
import com.sun.web.ui.view.html.CCStaticTextField;
import com.sun.web.ui.view.html.CCTextField;
import java.util.Collections;
import java.util.Map;
import java.util.Set;

public abstract class ReferralOpViewBeanBase
extends ProfileViewBeanBase {
    protected static final String PROPERTY_ATTRIBUTE = "propertyAttributes";
    public static final String CALLING_VIEW_BEAN = "ReferralOpViewBeanBaseCallingVB";
    public static final String PG_SESSION_REFERRAL_NAME = "referralName";
    public static final String PG_SESSION_REFERRAL_TYPE = "referralTypType";
    protected static final String SYNTAX = "tfSyntax";
    protected static final String REFERRAL_NAME = "tfReferralName";
    protected static final String REFERRAL_TYPE = "referralTypeName";
    protected static final String REFERRAL_TYPE_NAME = "tfReferralTypeName";
    protected static final String LBL_FILTER = "lblFilter";
    protected static final String FILTER = "tfFilter";
    protected static final String BTN_FILTER = "btnFilter";
    public static final String VALUES_TEXT_VALUE = "valuesTextValue";
    public static final String VALUES_SINGLE_CHOICE_VALUE = "valuesSingleChoiceValue";
    public static final String VALUES_MULTIPLE_CHOICE_VALUE = "valuesMultipleChoiceValue";
    protected CCPageTitleModel ptModel;
    public AMPropertySheetModel propertySheetModel;
    private boolean canModify = true;
    protected boolean submitCycle;

    public ReferralOpViewBeanBase(String name, String defaultDisplayURL) {
        super(name, defaultDisplayURL);
    }

    protected void initialize() {
        String realmName;
        if (!this.initialized && (realmName = (String)this.getPageSessionAttribute("currentRealm")) != null) {
            this.initialized = true;
            super.initialize();
            this.createPageTitleModel();
            this.createPropertyModel(realmName);
            this.registerChildren();
        }
    }

    protected void createPropertyModel(String realmName) {
        DelegationConfig dConfig = DelegationConfig.getInstance();
        this.canModify = dConfig.hasPermission(realmName, null, "MODIFY", this.getModel(), ((Object)((Object)this)).getClass().getName());
        this.propertySheetModel = new AMPropertySheetModel(((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream(this.getPropertyXMLFileName(!this.canModify)));
        this.propertySheetModel.clear();
    }

    protected abstract void createPageTitleModel();

    protected abstract String getPropertyXMLFileName(boolean var1);

    protected void registerChildren() {
        super.registerChildren();
        this.registerChild(PROPERTY_ATTRIBUTE, AMPropertySheet.class);
        this.ptModel.registerChildren((ContainerViewBase)this);
        this.propertySheetModel.registerChildren((ContainerViewBase)this);
    }

    protected View createChild(String name) {
        Object view = null;
        if (this.ptModel.isChildSupported(name)) {
            view = this.ptModel.createChild((View)this, name);
        } else if (name.equals(PROPERTY_ATTRIBUTE)) {
            view = new AMPropertySheet((ContainerView)this, (CCPropertySheetModelInterface)this.propertySheetModel, name);
        } else if (this.propertySheetModel.isChildSupported(name)) {
            view = this.propertySheetModel.createChild((View)this, name, this.getModel());
            if (name.equals(FILTER)) {
                ((CCTextField)view).setValue((Object)"*");
            }
        } else {
            view = super.createChild(name);
        }
        return view;
    }

    public void beginDisplay(DisplayEvent event) throws ModelControlException {
        super.beginDisplay(event);
        if (!this.submitCycle) {
            String realmName = (String)this.getPageSessionAttribute("currentRealm");
            PolicyModel model = (PolicyModel)this.getModel();
            String referralName = (String)this.getPageSessionAttribute(PG_SESSION_REFERRAL_NAME);
            String referralType = (String)this.getPageSessionAttribute(PG_SESSION_REFERRAL_TYPE);
            Syntax syntax = model.getReferralSyntax(realmName, referralType);
            this.propertySheetModel.setValue(SYNTAX, Integer.toString(AMDisplayType.getDisplaySyntax(syntax)));
            this.propertySheetModel.setValue(REFERRAL_NAME, referralName);
            this.propertySheetModel.setValue(REFERRAL_TYPE, referralType);
            Map map = model.getActiveReferralTypes(realmName);
            String i18nName = (String)map.get(referralType);
            this.propertySheetModel.setValue(REFERRAL_TYPE_NAME, i18nName);
        }
    }

    protected Referral createReferral() throws ModelControlException, AMConsoleException {
        Set values;
        Referral referral = null;
        String referralType = (String)this.propertySheetModel.getValue(REFERRAL_TYPE);
        String referralName = this.getReferralName();
        if (referralName != null && (values = this.getValues(referralType)) != null) {
            String realmName = (String)this.getPageSessionAttribute("currentRealm");
            PolicyModel model = (PolicyModel)this.getModel();
            referral = model.createReferral(realmName, referralType, values);
        }
        return referral;
    }

    private String getReferralName() {
        String referralName = (String)this.propertySheetModel.getValue(REFERRAL_NAME);
        if ((referralName = referralName.trim()).length() == 0) {
            this.setInlineAlertMessage("error", "message.error", "policy.missing.referralName");
            referralName = null;
        }
        return referralName;
    }

    private Set getValues(String referralType) throws ModelControlException {
        String realmName;
        PolicyModel model = (PolicyModel)this.getModel();
        Syntax syntax = model.getReferralSyntax(realmName = (String)this.getPageSessionAttribute("currentRealm"), referralType);
        Set values = this.getActionSchemaValues(syntax);
        if (values.isEmpty()) {
            this.setInlineAlertMessage("error", "message.error", "policy.missing.referral.value");
            values = null;
        }
        return values;
    }

    private Set getActionSchemaValues(Syntax syntax) {
        Set values = null;
        int syn = AMDisplayType.getDisplaySyntax(syntax);
        switch (syn) {
            case 0: {
                values = AMAdminUtils.toSet(this.propertySheetModel.getValues(VALUES_TEXT_VALUE));
                break;
            }
            case 10: {
                values = AMAdminUtils.toSet(this.propertySheetModel.getValues(VALUES_SINGLE_CHOICE_VALUE));
                break;
            }
            case 11: {
                values = AMAdminUtils.toSet(this.propertySheetModel.getValues(VALUES_MULTIPLE_CHOICE_VALUE));
            }
        }
        return values == null ? Collections.EMPTY_SET : values;
    }

    protected CachedPolicy getCachedPolicy() throws AMConsoleException {
        CachedPolicy policy = null;
        String cacheID = (String)this.getPageSessionAttribute("policyCacheID");
        if (cacheID != null) {
            PolicyCache cache = PolicyCache.getInstance();
            PolicyModel model = (PolicyModel)this.getModel();
            policy = model.getCachedPolicy(cacheID);
        }
        return policy;
    }

    protected void forwardToPolicyViewBean() {
        try {
            Class<?> clazz = Class.forName((String)this.removePageSessionAttribute(CALLING_VIEW_BEAN));
            PolicyOpViewBeanBase vb = (PolicyOpViewBeanBase)this.getViewBean(clazz);
            this.passPgSessionMap((ViewBean)vb);
            vb.forwardTo(this.getRequestContext());
        }
        catch (ClassNotFoundException e) {
            this.forwardTo();
        }
    }

    public boolean beginChildDisplay(ChildDisplayEvent event) {
        super.endDisplay((DisplayEvent)event);
        boolean display = true;
        String childName = event.getChildName();
        int syntax = Integer.parseInt((String)this.propertySheetModel.getValue(SYNTAX));
        if (childName.indexOf(LBL_FILTER) != -1 || childName.indexOf(BTN_FILTER) != -1 || childName.indexOf(FILTER) != -1) {
            display = syntax == 10 || syntax == 11;
        } else if (childName.indexOf(VALUES_TEXT_VALUE) != -1) {
            display = syntax == 2;
            Set values = this.getDefaultValues();
            if (values != null && !values.isEmpty()) {
                if (this.canModify) {
                    CCTextField tf = (CCTextField)this.getChild(childName);
                    tf.setValue(values.iterator().next());
                } else {
                    CCStaticTextField tf = (CCStaticTextField)this.getChild(childName);
                    tf.setValue(values.iterator().next());
                }
            }
        } else if (childName.indexOf(VALUES_SINGLE_CHOICE_VALUE) != -1) {
            boolean bl = display = syntax == 10;
            if (display) {
                Set values = this.getDefaultValues();
                if (this.canModify) {
                    CCSelect child = (CCSelect)this.getChild(childName);
                    this.setPossibleValues(child);
                    if (values != null && !values.isEmpty()) {
                        child.setValue(values.iterator().next());
                    }
                } else {
                    CCStaticTextField tf = (CCStaticTextField)this.getChild(childName);
                    tf.setValue(values.iterator().next());
                }
            }
        } else if (childName.indexOf(VALUES_MULTIPLE_CHOICE_VALUE) != -1) {
            boolean bl = display = syntax == 11;
            if (display) {
                Set values = this.getDefaultValues();
                if (this.canModify) {
                    CCSelect child = (CCSelect)this.getChild(childName);
                    this.setPossibleValues(child);
                    if (values != null && !values.isEmpty()) {
                        child.setValues(values.toArray());
                    }
                } else {
                    CCStaticTextField tf = (CCStaticTextField)this.getChild(childName);
                    tf.setValue((Object)AMAdminUtils.getString(values, ",", false));
                }
            }
        }
        return display;
    }

    private void setPossibleValues(CCSelect selectView) {
        String filter = (String)this.propertySheetModel.getValue(FILTER);
        String realmName = (String)this.getPageSessionAttribute("currentRealm");
        String referralType = (String)this.propertySheetModel.getValue(REFERRAL_TYPE);
        PolicyModel model = (PolicyModel)this.getModel();
        ValidValues validValues = model.getReferralPossibleValues(realmName, referralType, filter);
        if (validValues != null) {
            int errCode = validValues.getErrorCode();
            if (errCode == 1) {
                this.setInlineAlertMessage("error", "message.error", "policy.referral.sizelimit.exceeded.message");
            } else if (errCode == 1) {
                this.setInlineAlertMessage("error", "message.error", "policy.referral.timelimit.exceeded.message");
            }
            OptionList optList = this.createOptionList(validValues.getSearchResults());
            selectView.setOptions(optList);
        }
    }

    protected OptionList createOptionList(Set values) {
        OptionList optList = new OptionList();
        if (values != null && !values.isEmpty()) {
            PolicyModel model = (PolicyModel)this.getModel();
            String realmName = (String)this.getPageSessionAttribute("currentRealm");
            String referralType = (String)this.propertySheetModel.getValue(REFERRAL_TYPE);
            Map mapLabels = model.getDisplayNameForReferralValues(realmName, referralType, values);
            for (String value : values) {
                optList.add((String)mapLabels.get(value), value);
            }
        }
        return optList;
    }

    public void handleButton3Request(RequestInvocationEvent event) {
        this.backTrail();
        this.forwardToPolicyViewBean();
    }

    public void handleButton1Request(RequestInvocationEvent event) throws ModelControlException {
        SelectReferralTypeViewBean vb = (SelectReferralTypeViewBean)this.getViewBean(SelectReferralTypeViewBean.class);
        this.unlockPageTrailForSwapping();
        this.passPgSessionMap((ViewBean)vb);
        vb.forwardTo(this.getRequestContext());
    }

    public void handleBtnFilterRequest(RequestInvocationEvent event) {
        this.submitCycle = true;
        this.forwardTo();
    }

    protected abstract Set getDefaultValues();
}

