/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.entitlement.opensso.cli;

import com.sun.identity.cli.AttributeValues;
import com.sun.identity.cli.CLIException;
import com.sun.identity.cli.RequestContext;
import com.sun.identity.entitlement.Application;
import com.sun.identity.entitlement.ApplicationManager;
import com.sun.identity.entitlement.ApplicationType;
import com.sun.identity.entitlement.EntitlementException;
import com.sun.identity.entitlement.opensso.cli.ApplicationImpl;
import com.sun.identity.log.Level;
import java.text.MessageFormat;
import java.util.List;
import java.util.Map;

public class CreateApplication
extends ApplicationImpl {
    public void handleRequest(RequestContext rc) throws CLIException {
        super.handleRequest(rc);
        String realm = this.getStringOptionValue("realm");
        String appName = this.getStringOptionValue("name");
        String appTypeName = this.getStringOptionValue("applicationtype");
        String datafile = this.getStringOptionValue("datafile");
        List attrValues = rc.getOption("attributevalues");
        if (datafile == null && attrValues == null) {
            throw new CLIException(this.getResourceString("missing-attributevalues"), 11, rc.getSubCommand().getName());
        }
        Map attributeValues = AttributeValues.parse(this.getCommandManager(), datafile, attrValues);
        ApplicationType applicationType = this.getApplicationType(appTypeName);
        String[] params = new String[]{realm, appName};
        this.writeLog(0, Level.INFO, "ATTEMPT_CREATE_APPLICATION", params);
        Application appl = new Application(realm, appName, applicationType);
        try {
            this.setApplicationAttributes(appl, attributeValues, true);
            ApplicationManager.saveApplication(this.getAdminSubject(), realm, appl);
            String[] param = new String[]{appName};
            this.getOutputWriter().printlnMessage(MessageFormat.format(this.getResourceString("create-application-succeeded"), param));
            this.writeLog(0, Level.INFO, "SUCCEEDED_CREATE_APPLICATION", params);
        }
        catch (EntitlementException e) {
            String[] paramExs = new String[]{realm, appName, e.getMessage()};
            this.writeLog(0, Level.INFO, "FAILED_CREATE_APPLICATION", paramExs);
            throw new CLIException(e, 127);
        }
        catch (CLIException e) {
            String[] paramExs = new String[]{realm, appName, e.getMessage()};
            this.writeLog(0, Level.INFO, "FAILED_CREATE_APPLICATION", paramExs);
            throw e;
        }
    }
}

