/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.am.sdk;

import com.iplanet.am.sdk.AMCommonUtils;
import com.iplanet.am.sdk.AMObjectImpl;
import com.iplanet.sso.SSOException;
import com.iplanet.sso.SSOToken;
import com.iplanet.sso.SSOTokenEvent;
import com.iplanet.sso.SSOTokenListener;
import com.iplanet.sso.SSOTokenManager;
import java.util.Set;

class AMSSOTokenListener
implements SSOTokenListener {
    private String principalName = "";

    public AMSSOTokenListener(String principalName) {
        this.principalName = principalName;
    }

    public void ssoTokenChanged(SSOTokenEvent stEvent) {
        Set dnSet;
        boolean isValid;
        SSOToken ssoToken = stEvent.getToken();
        try {
            isValid = SSOTokenManager.getInstance().isValidToken(ssoToken);
        }
        catch (SSOException se) {
            isValid = false;
        }
        if (AMCommonUtils.debug.messageEnabled()) {
            AMCommonUtils.debug.message("In AMSSOTokenListener.ssoTokenChanged(): Principal: " + this.principalName + " ssoToken: " + isValid);
        }
        if (!isValid && (dnSet = AMObjectImpl.removeFromProfileNameTable(ssoToken)) != null) {
            if (AMCommonUtils.debug.messageEnabled()) {
                AMCommonUtils.debug.message("In AMSSOTokenListener.ssoTokenChanged(): dnSet NOT null!");
            }
            AMObjectImpl.removeObjImplListeners(dnSet, ssoToken.getTokenID());
        }
    }
}

