/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.dpro.session.service;

import com.iplanet.am.util.SystemProperties;
import com.iplanet.dpro.session.Session;
import com.iplanet.dpro.session.SessionException;
import com.iplanet.dpro.session.SessionID;
import com.iplanet.dpro.session.TokenRestriction;
import com.iplanet.dpro.session.service.SessionConstraint;
import com.iplanet.dpro.session.service.SessionCount;
import com.iplanet.dpro.session.service.SessionService;
import com.iplanet.dpro.session.share.SessionEncodeURL;
import com.iplanet.dpro.session.share.SessionInfo;
import com.iplanet.sso.SSOToken;
import com.sun.identity.common.HeadTaskRunnable;
import com.sun.identity.common.SystemTimerPool;
import com.sun.identity.common.TaskRunnable;
import com.sun.identity.common.TimerPool;
import com.sun.identity.session.util.SessionUtils;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.logging.Level;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

public class InternalSession
implements TaskRunnable,
Serializable {
    private String uuid;
    private SessionID sessionID;
    private int sessionType;
    private String clientID;
    private String clientDomain;
    private long maxSessionTime;
    private long maxIdleTime;
    private long maxCachingTime;
    private int sessionState;
    private Properties sessionProperties;
    private boolean willExpireFlag;
    private transient boolean isSessionUpgrade = false;
    private static SessionService ss = SessionService.getSessionService();
    private transient Map internalObjects = new HashMap();
    private long creationTime;
    private long latestAccessTime;
    private transient HttpSession httpSession;
    private boolean isISStored = false;
    Boolean cookieMode = null;
    private String cookieStr;
    private Map restrictedTokensBySid = Collections.synchronizedMap(new HashMap());
    private Map restrictedTokensByRestriction = Collections.synchronizedMap(new HashMap());
    private static String superUserDN;
    private static boolean isEnableHostLookUp;
    private volatile long timedOutAt = 0L;
    private long version = 0L;
    private static long purgeDelay;
    private String sessionHandle = null;
    private static final String LOGIN_URL = "loginURL";
    private static final String SESSION_TIMED_OUT = "SessionTimedOut";
    private static final String HOST = "Host";
    private static final String HOST_NAME = "HostName";
    private static final String AM_MAX_IDLE_TIME = "AMMaxIdleTime";
    private static final String SAML2_IDP_SESSION_INDEX = "SAML2IDPSessionIndex";
    protected static final String UNIVERSAL_IDENTIFIER = "sun.am.UniversalIdentifier";
    private static final String LOG_MSG_SESSION_MAX_LIMIT_REACHED = "SESSION_MAX_LIMIT_REACHED";
    private static int interval;
    private volatile transient TaskRunnable nextTask = null;
    private volatile transient TaskRunnable previousTask = null;
    private volatile transient HeadTaskRunnable headTask = null;
    private transient TimerPool timerPool = null;
    private volatile boolean reschedulePossible;
    private static long maxDefaultIdleTime;
    protected static Set protectedProperties;
    private Map sessionEventURLs = Collections.synchronizedMap(new HashMap());

    private static long getPropValue(String propName, long defaultValue) {
        String defaultPropValue = SystemProperties.get(propName, String.valueOf(defaultValue));
        long propValue = 0L;
        try {
            propValue = Long.parseLong(defaultPropValue);
        }
        catch (Exception le) {
            propValue = defaultValue;
        }
        return propValue;
    }

    InternalSession(SessionID sid) {
        this.maxIdleTime = maxDefaultIdleTime;
        this.maxSessionTime = maxDefaultIdleTime;
        this.reschedulePossible = maxDefaultIdleTime > this.maxIdleTime;
        this.sessionID = sid;
        this.sessionState = 0;
        this.timerPool = SystemTimerPool.getTimerPool();
        this.sessionProperties = new Properties();
        this.willExpireFlag = true;
    }

    public void setHeadTask(HeadTaskRunnable headTask) {
        this.headTask = headTask;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long scheduledExecutionTime() {
        InternalSession internalSession = this;
        synchronized (internalSession) {
            if (this.headTask != null) {
                return this.headTask.scheduledExecutionTime();
            }
        }
        return -1L;
    }

    public HeadTaskRunnable getHeadTask() {
        return this.headTask;
    }

    public TaskRunnable previous() {
        return this.previousTask;
    }

    public TaskRunnable next() {
        return this.nextTask;
    }

    public void setPrevious(TaskRunnable task) {
        this.previousTask = task;
    }

    public void setNext(TaskRunnable task) {
        this.nextTask = task;
    }

    public boolean addElement(Object obj) {
        return false;
    }

    public boolean removeElement(Object obj) {
        return false;
    }

    public boolean isEmpty() {
        return true;
    }

    public long getRunPeriod() {
        return -1L;
    }

    public void run() {
        if (!this.isTimedOut()) {
            if (this.sessionState == 0) {
                this.setState(3);
                ss.removeInternalSession(this.sessionID);
                ss.sendEvent(this, 5);
            } else {
                long timeLeft = this.getTimeLeft();
                if (timeLeft == 0L) {
                    this.changeStateAndNotify(2);
                    if (this.timerPool != null && purgeDelay > 0L) {
                        this.timerPool.schedule((TaskRunnable)this, new Date((this.timedOutAt + purgeDelay * 60L) * 1000L));
                    }
                } else {
                    long idleTimeLeft = this.maxIdleTime * 60L - this.getIdleTime();
                    if (idleTimeLeft <= 0L && this.sessionState != 2) {
                        this.changeStateAndNotify(1);
                        if (this.timerPool != null && purgeDelay > 0L) {
                            this.timerPool.schedule((TaskRunnable)this, new Date((this.timedOutAt + purgeDelay * 60L) * 1000L));
                        }
                    } else {
                        long timeToWait = Math.min(timeLeft, idleTimeLeft);
                        if (this.timerPool != null) {
                            this.timerPool.schedule((TaskRunnable)this, new Date((System.currentTimeMillis() / 1000L + timeToWait) * 1000L));
                        }
                    }
                }
            }
        } else {
            ss.logEvent(this, 5);
            this.setState(3);
            ss.removeInternalSession(this.sessionID);
            ss.sendEvent(this, 5);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancel() {
        HeadTaskRunnable oldHeadTask = null;
        do {
            if ((oldHeadTask = this.headTask) == null || !oldHeadTask.acquireValidLock()) continue;
            try {
                if (oldHeadTask != this.headTask) continue;
                if (oldHeadTask.isTimedOut()) break;
                this.previousTask.setNext(this.nextTask);
                if (this.nextTask != null) {
                    this.nextTask.setPrevious(this.previousTask);
                    this.nextTask = null;
                    break;
                }
                oldHeadTask.setTail(this.previousTask);
                break;
            }
            finally {
                oldHeadTask.releaseLockAndNotify();
            }
        } while (oldHeadTask != this.headTask);
        this.headTask = null;
    }

    protected void reschedule() {
        if (this.timerPool != null) {
            long timeoutTime = Long.MAX_VALUE;
            switch (this.sessionState) {
                case 0: {
                    timeoutTime = (this.creationTime + maxDefaultIdleTime * 60L) * 1000L;
                    break;
                }
                case 1: {
                    timeoutTime = Math.min((this.latestAccessTime + this.maxIdleTime * 60L) * 1000L, (this.creationTime + this.maxSessionTime * 60L) * 1000L);
                }
            }
            if (timeoutTime < this.scheduledExecutionTime()) {
                this.cancel();
            }
            if (this.scheduledExecutionTime() == -1L) {
                Date time = new Date(timeoutTime);
                this.timerPool.schedule((TaskRunnable)this, time);
            }
        }
    }

    public SessionID getID() {
        return this.sessionID;
    }

    public int getType() {
        return this.sessionType;
    }

    public void setType(int type) {
        this.sessionType = type;
        this.updateForFailover();
    }

    public String getClientID() {
        return this.clientID;
    }

    public void setClientID(String id) {
        this.clientID = id;
        this.updateForFailover();
    }

    public String getClientDomain() {
        return this.clientDomain;
    }

    public void setClientDomain(String domain) {
        this.clientDomain = domain;
        this.updateForFailover();
    }

    public long getMaxSessionTime() {
        return this.maxSessionTime;
    }

    public void setMaxSessionTime(long t) {
        boolean mayReschedule = false;
        if (t < this.maxSessionTime) {
            mayReschedule = true;
        }
        this.maxSessionTime = t;
        if (this.scheduledExecutionTime() != -1L && mayReschedule) {
            this.reschedule();
        }
        this.updateForFailover();
    }

    public long getMaxIdleTime() {
        return this.maxIdleTime;
    }

    public void setMaxIdleTime(long t) {
        int httpIdleTime;
        boolean mayReschedule = false;
        if (t < this.maxIdleTime) {
            mayReschedule = true;
        }
        this.maxIdleTime = t;
        boolean bl = this.reschedulePossible = maxDefaultIdleTime > this.maxIdleTime;
        if (this.httpSession != null && this.maxIdleTime > (long)(httpIdleTime = this.httpSession.getMaxInactiveInterval())) {
            this.httpSession.setMaxInactiveInterval((int)this.maxIdleTime * 60);
        }
        if (this.scheduledExecutionTime() != -1L && (mayReschedule || this.reschedulePossible)) {
            this.reschedule();
        }
        this.updateForFailover();
    }

    public long getMaxCachingTime() {
        return this.maxCachingTime;
    }

    public void setMaxCachingTime(long t) {
        this.maxCachingTime = t;
        this.updateForFailover();
    }

    public long getIdleTime() {
        long now = System.currentTimeMillis() / 1000L;
        return now - this.latestAccessTime;
    }

    public long getTimeLeft() {
        long now = System.currentTimeMillis() / 1000L;
        long left = this.creationTime + this.maxSessionTime * 60L - now;
        if (left >= 0L) {
            return left;
        }
        return 0L;
    }

    public long getTimeLeftBeforePurge() {
        if (!this.isTimedOut()) {
            return -1L;
        }
        long now = System.currentTimeMillis() / 1000L;
        long left = this.timedOutAt + purgeDelay * 60L - now;
        return left > 0L ? left : 0L;
    }

    public boolean isTimedOut() {
        return this.timedOutAt != 0L;
    }

    public int getState() {
        return this.sessionState;
    }

    public Object getObject(String key) {
        return this.getInternalObjectMap().get(key);
    }

    public void removeObject(String key) {
        this.getInternalObjectMap().remove(key);
    }

    public void setObject(String key, Object value) {
        this.getInternalObjectMap().put(key, value);
    }

    private Map getInternalObjectMap() {
        if (this.internalObjects == null) {
            this.internalObjects = new HashMap();
        }
        return this.internalObjects;
    }

    public String getProperty(String key) {
        return this.sessionProperties.getProperty(key);
    }

    public Enumeration getPropertyNames() {
        return this.sessionProperties.propertyNames();
    }

    public static boolean isProtectedProperty(String key) {
        return protectedProperties.contains(key) || key.toLowerCase().startsWith("am.protected");
    }

    void putExternalProperty(SSOToken clientToken, String key, String value) throws SessionException {
        try {
            SessionUtils.checkPermissionToSetProperty(clientToken, key, value);
        }
        catch (SessionException se) {
            SessionService.getSessionService().logIt(this, "SESSION_PROTECTED_PROPERTY_ERROR");
            throw se;
        }
        this.internalPutProperty(key, value);
        if (SessionService.sessionDebug.messageEnabled()) {
            SessionService.sessionDebug.message("Updated protected property after validating client identity and permissions");
        }
    }

    public void putProperty(String key, String value) {
        this.internalPutProperty(key, value);
    }

    protected void internalPutProperty(String key, String value) {
        if (key.equals(HOST_NAME) || key.equals(HOST)) {
            if (value == null || value.length() == 0) {
                return;
            }
            if (isEnableHostLookUp) {
                try {
                    InetAddress address = InetAddress.getByName(value);
                    String hostName = address.getHostName();
                    this.sessionProperties.put(HOST_NAME, hostName);
                    this.sessionProperties.put(HOST, value);
                }
                catch (UnknownHostException uhe) {
                    SessionService.sessionDebug.error("InternalSession.internalputProperty():Unable to get HostName for:" + value + " SessionException: ", (Throwable)uhe);
                }
            } else {
                this.sessionProperties.put(HOST_NAME, value);
                this.sessionProperties.put(HOST, value);
            }
        } else if (key.equals(AM_MAX_IDLE_TIME)) {
            this.setMaxIdleTime(Long.parseLong(value));
        } else {
            this.sessionProperties.put(key, value);
        }
        if (this.sessionState == 1 && SessionService.isSendPropertyNotification(key)) {
            SessionService.getSessionService().sendEvent(this, 6);
            SessionService.getSessionService().logEvent(this, 6);
        }
        this.updateForFailover();
    }

    public void setIsSessionUpgrade(boolean value) {
        this.isSessionUpgrade = value;
    }

    public boolean getIsSessionUpgrade() {
        return this.isSessionUpgrade;
    }

    public void setIsISStored(boolean value) {
        boolean wasISStored = this.isISStored;
        this.isISStored = value;
        if (this.isISStored && !wasISStored) {
            this.updateForFailover();
        }
    }

    public boolean getIsISstored() {
        return this.isISStored;
    }

    private boolean shouldIgnoreSessionQuotaChecking(String userDN) {
        boolean ignore = false;
        SessionService.getSessionService();
        if (SessionService.getSessionService().isSuperUser(this.getUUID()) || this.isAppSession()) {
            ignore = true;
        } else {
            boolean checkTopLevelAdminRole = SessionService.bypassConstratintForToplevelAdmin();
            if (checkTopLevelAdminRole && SessionService.getSessionService().hasTopLevelAdminRole(this.getUUID())) {
                ignore = true;
            }
        }
        return ignore;
    }

    public boolean activate(String userDN) {
        if (userDN == null) {
            return false;
        }
        if (SessionService.getActiveSessions() >= SessionService.maxSessions && !userDN.equalsIgnoreCase(superUserDN)) {
            SessionService.getSessionService().logSystemMessage(LOG_MSG_SESSION_MAX_LIMIT_REACHED, Level.INFO);
            return false;
        }
        this.setUUID();
        if (SessionService.isSessionConstraintEnabled() && !this.shouldIgnoreSessionQuotaChecking(userDN) && SessionConstraint.checkQuotaAndPerformAction(this)) {
            if (SessionService.sessionDebug.messageEnabled()) {
                SessionService.sessionDebug.message("Session Quota exhausted!");
            }
            SessionService.getSessionService().logEvent(this, 7);
            return false;
        }
        this.setLatestAccessTime();
        this.setState(1);
        if (this.reschedulePossible) {
            this.reschedule();
        }
        SessionService.getSessionService().logEvent(this, 0);
        SessionService.getSessionService().sendEvent(this, 0);
        SessionService.incrementActiveSessions();
        return true;
    }

    public void setUUID() {
        this.uuid = this.getProperty(UNIVERSAL_IDENTIFIER);
    }

    public String getUUID() {
        return this.uuid;
    }

    public void reactivate() {
        this.cancel();
        this.setCreationTime();
        this.setLatestAccessTime();
        this.setState(1);
        this.reschedule();
        SessionService.getSessionService().logEvent(this, 4);
        SessionService.getSessionService().sendEvent(this, 4);
    }

    public void setExpire(boolean expire) {
        if (!expire) {
            this.maxSessionTime = 0x222222222222222L;
            this.maxIdleTime = 0x222222222222222L;
            this.maxCachingTime = SessionService.applicationMaxCachingTime;
            this.cancel();
            this.timerPool = null;
        }
        this.willExpireFlag = expire;
    }

    private boolean checkInvalidSessionDefaultIdleTime() {
        long now = System.currentTimeMillis() / 1000L;
        long left = this.creationTime + maxDefaultIdleTime * 60L - now;
        return left < 0L;
    }

    boolean shouldDestroy() {
        if (!this.willExpireFlag) {
            return false;
        }
        if (!this.isTimedOut()) {
            if (this.sessionState == 0) {
                if (this.checkInvalidSessionDefaultIdleTime()) {
                    this.setState(3);
                    ss.sendEvent(this, 5);
                    return true;
                }
                return false;
            }
            if (this.getTimeLeft() == 0L) {
                this.changeStateAndNotify(2);
                return false;
            }
            if (this.getIdleTime() >= this.maxIdleTime * 60L && this.sessionState != 2) {
                this.changeStateAndNotify(1);
                return false;
            }
            return false;
        }
        if (this.getTimeLeftBeforePurge() <= 0L) {
            SessionService.getSessionService().logEvent(this, 5);
            this.setState(3);
            SessionService.getSessionService().sendEvent(this, 5);
            return true;
        }
        return false;
    }

    private void changeStateAndNotify(int eventType) {
        SessionService.getSessionService().logEvent(this, eventType);
        this.timedOutAt = System.currentTimeMillis() / 1000L;
        this.putProperty(SESSION_TIMED_OUT, String.valueOf(this.timedOutAt));
        if (purgeDelay == 0L) {
            ss.destroyInternalSession(this.sessionID);
            return;
        }
        SessionService.decrementActiveSessions();
        SessionCount.decrementSessionCount(this);
        this.setState(0);
        SessionService.getSessionService();
        if (SessionService.isSessionTrimmingEnabled()) {
            this.trimSession();
        }
        SessionService.getSessionService().sendEvent(this, eventType);
    }

    public SessionInfo toSessionInfo() {
        SessionInfo info = new SessionInfo();
        info.sid = this.sessionID.toString();
        if (this.sessionType == 0) {
            info.stype = "user";
        } else if (this.sessionType == 1) {
            info.stype = "application";
        }
        info.cid = this.clientID;
        info.cdomain = this.clientDomain;
        info.maxtime = Long.toString(this.maxSessionTime);
        info.maxidle = Long.toString(this.maxIdleTime);
        info.maxcaching = Long.toString(this.maxCachingTime);
        if (this.willExpireFlag) {
            info.timeidle = Long.toString(this.getIdleTime());
            info.timeleft = Long.toString(this.getTimeLeft());
        } else {
            info.timeidle = Long.toString(0L);
            info.timeleft = Long.toString(0x222222222222222L);
        }
        if (this.sessionState == 0) {
            info.state = "invalid";
        } else if (this.sessionState == 1) {
            info.state = "valid";
        } else if (this.sessionState == 2) {
            info.state = "inactive";
        } else if (this.sessionState == 3) {
            info.state = "destroyed";
        }
        info.properties = (Properties)this.sessionProperties.clone();
        return info;
    }

    void setLatestAccessTime() {
        long oldLatestAccessTime = this.latestAccessTime;
        this.latestAccessTime = System.currentTimeMillis() / 1000L;
        if (this.latestAccessTime - oldLatestAccessTime > (long)interval) {
            this.updateForFailover();
        }
    }

    void setState(int state) {
        this.sessionState = state;
        this.updateForFailover();
    }

    Map getSessionEventURLs() {
        return this.sessionEventURLs;
    }

    boolean willExpire() {
        return this.willExpireFlag;
    }

    boolean isAppSession() {
        return this.sessionType == 1 || !this.willExpireFlag;
    }

    public void setCreationTime() {
        this.creationTime = this.httpSession != null ? this.httpSession.getCreationTime() / 1000L : System.currentTimeMillis() / 1000L;
    }

    void addRestrictedToken(SessionID sid, TokenRestriction restriction) {
        this.restrictedTokensBySid.put(sid, restriction);
        this.restrictedTokensByRestriction.put(restriction, sid);
        this.updateForFailover();
    }

    TokenRestriction getRestrictionForToken(SessionID sid) {
        return (TokenRestriction)this.restrictedTokensBySid.get(sid);
    }

    SessionID getRestrictedTokenForRestriction(TokenRestriction restriction) {
        return (SessionID)this.restrictedTokensByRestriction.get(restriction);
    }

    Object[] getRestrictedTokens() {
        return this.restrictedTokensBySid.keySet().toArray();
    }

    public String encodeURL(HttpServletResponse res, String url) {
        return this.encodeURL(res, url, Session.getCookieName());
    }

    public String encodeURL(HttpServletResponse res, String url, String cookieName) {
        return this.encodeURL(url, (short)0, true, cookieName);
    }

    public String encodeURL(String url, short encodingScheme, boolean escape) {
        return this.encodeURL(url, encodingScheme, escape, Session.getCookieName());
    }

    public String encodeURL(String url, short encodingScheme, boolean escape, String cookieName) {
        if (SessionService.sessionDebug.messageEnabled()) {
            SessionService.sessionDebug.message("Session: url: " + url);
        }
        String encodedURL = url;
        if (url != null && url.length() > 0 && !this.getCookieSupport()) {
            if (this.cookieStr != null && this.cookieStr.length() != 0 && Session.foundCookieName(this.cookieStr, cookieName)) {
                encodedURL = SessionEncodeURL.buildCookieString(url, this.cookieStr, encodingScheme, escape);
            } else if (this.sessionID != null) {
                this.cookieStr = SessionEncodeURL.createCookieString(cookieName, this.sessionID.toString());
                encodedURL = SessionEncodeURL.encodeURL(this.cookieStr, url, encodingScheme, escape);
            }
        }
        if (SessionService.sessionDebug.messageEnabled()) {
            SessionService.sessionDebug.message("Returning encoded Session: url: " + encodedURL);
        }
        return encodedURL;
    }

    private boolean getCookieSupport() {
        boolean cookieSupport = false;
        try {
            if (this.sessionID.getCookieMode() != null) {
                cookieSupport = this.sessionID.getCookieMode();
            } else if (this.cookieMode != null) {
                cookieSupport = this.cookieMode;
            }
        }
        catch (Exception ex) {
            SessionService.sessionDebug.error("Error getting cookieSupport value: ", (Throwable)ex);
            cookieSupport = true;
        }
        if (SessionService.sessionDebug.messageEnabled()) {
            SessionService.sessionDebug.message("InternalSession: getCookieSupport: " + cookieSupport);
        }
        return cookieSupport;
    }

    void setHttpSession(HttpSession hSession) {
        this.httpSession = hSession;
    }

    HttpSession getHttpSession() {
        return this.httpSession;
    }

    protected void updateForFailover() {
        if (SessionService.getSessionService().isSessionFailoverEnabled() && this.isISStored) {
            if (this.sessionState != 1) {
                SessionService.getSessionService().deleteFromRepository(this.sessionID);
                this.isISStored = false;
            } else {
                SessionService.getSessionService().saveForFailover(this);
            }
        }
    }

    private void trimSession() {
        String ctxID;
        this.clientDomain = null;
        this.cookieStr = null;
        Properties newProperties = new Properties();
        String loginURL = this.getProperty(LOGIN_URL);
        String sessionTimedOut = this.getProperty(SESSION_TIMED_OUT);
        String idpSessionIndex = this.getProperty(SAML2_IDP_SESSION_INDEX);
        if (loginURL != null) {
            newProperties.put(LOGIN_URL, loginURL);
        }
        if (sessionTimedOut != null) {
            newProperties.put(SESSION_TIMED_OUT, sessionTimedOut);
        }
        if ((ctxID = this.getProperty("AMCtxId")) != null) {
            newProperties.put("AMCtxId", ctxID);
        }
        if (idpSessionIndex != null) {
            newProperties.put(SAML2_IDP_SESSION_INDEX, idpSessionIndex);
        }
        this.sessionProperties = newProperties;
    }

    public void setCookieMode(Boolean cookieMode) {
        SessionService.sessionDebug.message("CookieMode is:" + cookieMode);
        if (cookieMode != null) {
            this.cookieMode = cookieMode;
        }
    }

    void setSessionHandle(String sessionHandle) {
        this.sessionHandle = sessionHandle;
        this.putProperty("SessionHandle", sessionHandle);
        this.updateForFailover();
    }

    String getSessionHandle() {
        return this.sessionHandle;
    }

    public void setVersion(long version) {
        this.version = version;
    }

    public long getVersion() {
        return this.version;
    }

    public long getExpirationTime() {
        long timeLeft = Math.max(0L, this.getMaxIdleTime() * 60L - this.getIdleTime());
        if (timeLeft == 0L) {
            timeLeft = this.getTimeLeftBeforePurge();
        }
        return System.currentTimeMillis() / 1000L + Math.min(this.getTimeLeft(), timeLeft);
    }

    private void readObject(ObjectInputStream oin) throws IOException, ClassNotFoundException {
        oin.defaultReadObject();
        if (this.willExpireFlag) {
            this.timerPool = SystemTimerPool.getTimerPool();
            if (!this.isTimedOut()) {
                if (this.sessionState == 0) {
                    long expectedTime = this.creationTime + maxDefaultIdleTime * 60L;
                    if (expectedTime > System.currentTimeMillis() / 1000L) {
                        if (this.timerPool != null) {
                            this.timerPool.schedule((TaskRunnable)this, new Date(expectedTime * 1000L));
                        }
                    } else {
                        this.setState(3);
                        ss.removeInternalSession(this.sessionID);
                        ss.sendEvent(this, 5);
                    }
                } else {
                    long timeLeft = this.getTimeLeft();
                    if (timeLeft == 0L) {
                        this.changeStateAndNotify(2);
                        if (this.timerPool != null) {
                            this.timerPool.schedule((TaskRunnable)this, new Date((this.timedOutAt + purgeDelay * 60L) * 1000L));
                        }
                    } else {
                        long idleTimeLeft = this.maxIdleTime * 60L - this.getIdleTime();
                        if (idleTimeLeft <= 0L && this.sessionState != 2) {
                            this.changeStateAndNotify(1);
                            if (this.timerPool != null) {
                                this.timerPool.schedule((TaskRunnable)this, new Date((this.timedOutAt + purgeDelay * 60L) * 1000L));
                            }
                        } else {
                            long timeToWait = Math.min(timeLeft, idleTimeLeft);
                            if (this.timerPool != null) {
                                this.timerPool.schedule((TaskRunnable)this, new Date((System.currentTimeMillis() / 1000L + timeToWait) * 1000L));
                            }
                        }
                    }
                }
            } else {
                long expectedTime = this.timedOutAt + purgeDelay * 60L;
                if (expectedTime > System.currentTimeMillis() / 1000L) {
                    if (this.timerPool != null) {
                        this.timerPool.schedule((TaskRunnable)this, new Date(expectedTime * 1000L));
                    }
                } else {
                    ss.logEvent(this, 5);
                    this.setState(3);
                    ss.removeInternalSession(this.sessionID);
                    ss.sendEvent(this, 5);
                }
            }
        }
    }

    static {
        isEnableHostLookUp = Boolean.valueOf(SystemProperties.get("com.sun.am.session.enableHostLookUp"));
        interval = Integer.parseInt(SystemProperties.get("com.sun.identity.session.interval", "10"));
        maxDefaultIdleTime = InternalSession.getPropValue("com.iplanet.am.session.invalidsessionmaxtime", 3L);
        purgeDelay = InternalSession.getPropValue("com.iplanet.am.session.purgedelay", 120L);
        superUserDN = SystemProperties.get("com.sun.identity.authentication.super.user");
        protectedProperties = new HashSet();
        protectedProperties.add(HOST);
        protectedProperties.add(HOST_NAME);
        protectedProperties.add("AuthLevel");
        protectedProperties.add("AuthType");
        protectedProperties.add("Principal");
        protectedProperties.add("UserId");
        protectedProperties.add("UserToken");
        protectedProperties.add("Organization");
        protectedProperties.add("cookieSupport");
        protectedProperties.add("authInstant");
        protectedProperties.add("Principals");
        protectedProperties.add(LOGIN_URL);
        protectedProperties.add("FullLoginURL");
        protectedProperties.add("Role");
        protectedProperties.add("Service");
        protectedProperties.add(SESSION_TIMED_OUT);
        protectedProperties.add("SessionHandle");
        protectedProperties.add("TokenRestriction");
        protectedProperties.add(AM_MAX_IDLE_TIME);
        protectedProperties.add("AMCtxId");
        protectedProperties.add(UNIVERSAL_IDENTIFIER);
        String protectedPropertiesConfig = SystemProperties.get("com.iplanet.am.session.protectedPropertiesList", "");
        if (protectedPropertiesConfig != null) {
            StringTokenizer st = new StringTokenizer(protectedPropertiesConfig, ",");
            while (st.hasMoreTokens()) {
                String prop = st.nextToken().trim();
                protectedProperties.add(prop);
                if (!SessionService.sessionDebug.messageEnabled()) continue;
                SessionService.sessionDebug.message("Added protected property [" + prop + "]");
            }
        }
    }
}

