/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.authentication.UI;

import com.iplanet.am.util.SystemProperties;
import com.iplanet.dpro.session.Session;
import com.iplanet.dpro.session.SessionID;
import com.iplanet.jato.CompleteRequestException;
import com.iplanet.jato.RequestContext;
import com.iplanet.jato.RequestContextImpl;
import com.iplanet.jato.ViewBeanManager;
import com.sun.identity.authentication.UI.AuthExceptionViewBean;
import com.sun.identity.authentication.UI.AuthenticationServletBase;
import com.sun.identity.authentication.service.AuthUtils;
import com.sun.identity.common.ISLocaleContext;
import com.sun.identity.common.RequestUtils;
import com.sun.identity.shared.debug.Debug;
import com.sun.identity.shared.locale.L10NMessageImpl;
import java.io.PrintWriter;
import java.net.URL;
import java.util.HashMap;
import java.util.Locale;
import java.util.Set;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class LoginServlet
extends AuthenticationServletBase {
    private final String amCookieCheck = SystemProperties.get("com.sun.identity.am.cookie.check", "false");
    public static final String DEFAULT_MODULE_URL = "../UI";
    public static String PACKAGE_NAME = LoginServlet.getPackageName((String)LoginServlet.class.getName());
    private static final String REDIRECT_JSP = "Redirect.jsp";
    private Debug debug;
    private static String serviceURI = SystemProperties.get("com.iplanet.am.services.deploymentDescriptor") + "/UI/Login";

    protected void initializeRequestContext(RequestContext requestContext) {
        String hostName;
        super.initializeRequestContext(requestContext);
        Debug debug = Debug.getInstance((String)"amLoginServlet");
        ViewBeanManager viewBeanManager = new ViewBeanManager(requestContext, PACKAGE_NAME);
        ((RequestContextImpl)requestContext).setViewBeanManager(viewBeanManager);
        HttpServletRequest request = requestContext.getRequest();
        HttpServletResponse response = requestContext.getResponse();
        if (this.checkForCookiesInBrowser(request, response, debug)) {
            throw new CompleteRequestException();
        }
        try {
            RequestUtils.checkContentLength(request);
        }
        catch (L10NMessageImpl e) {
            if (debug.messageEnabled()) {
                ISLocaleContext localeContext = new ISLocaleContext();
                localeContext.setLocale(request);
                Locale locale = localeContext.getLocale();
                debug.message("LoginServlet: " + e.getL10NMessage(locale));
            }
            AuthExceptionViewBean vb = (AuthExceptionViewBean)viewBeanManager.getViewBean(AuthExceptionViewBean.class);
            vb.forwardTo(requestContext);
            throw new CompleteRequestException();
        }
        String client_type = AuthUtils.getClientType(request);
        if (debug.messageEnabled()) {
            debug.message("Client Type = " + client_type);
        }
        if (!AuthUtils.isValidFQDNRequest(hostName = AuthUtils.getHostName(request))) {
            try {
                String newHN = AuthUtils.getValidFQDNResource(hostName, request);
                if (debug.messageEnabled()) {
                    debug.message("FQDN = " + newHN);
                }
                if (AuthUtils.isGenericHTMLClient(client_type)) {
                    debug.message("This is HTML");
                    response.sendRedirect(newHN);
                } else {
                    String fileName = AuthUtils.getDefaultFileName(request, REDIRECT_JSP);
                    if (debug.messageEnabled()) {
                        debug.message("Forward to : " + fileName);
                    }
                    RequestDispatcher dispatcher = request.getRequestDispatcher(fileName);
                    dispatcher.forward((ServletRequest)request, (ServletResponse)response);
                }
            }
            catch (Exception e) {
                // empty catch block
            }
            throw new CompleteRequestException();
        }
        String authCookieValue = AuthUtils.getAuthCookieValue(request);
        if (authCookieValue != null && authCookieValue.length() != 0 && !authCookieValue.equalsIgnoreCase("LOGOUT")) {
            String cookieURL;
            block36: {
                cookieURL = null;
                try {
                    SessionID sessionID = new SessionID(authCookieValue);
                    URL sessionServerURL = Session.getSessionServiceURL(sessionID);
                    cookieURL = sessionServerURL.getProtocol() + "://" + sessionServerURL.getHost() + ":" + Integer.toString(sessionServerURL.getPort()) + serviceURI;
                }
                catch (Exception e) {
                    if (!debug.messageEnabled()) break block36;
                    debug.message("LoginServlet error in Session : " + e.toString());
                }
            }
            if (debug.messageEnabled()) {
                debug.message("cookieURL : " + cookieURL);
            }
            if (cookieURL != null && cookieURL.length() != 0 && !AuthUtils.isLocalServer(cookieURL, true)) {
                block37: {
                    debug.message("Routing the request to Original Auth server");
                    try {
                        HashMap origRequestData = AuthUtils.sendAuthRequestToOrigServer(request, response, cookieURL);
                        String redirect_url = null;
                        String clientType = null;
                        String output_data = null;
                        if (origRequestData != null && !origRequestData.isEmpty()) {
                            redirect_url = (String)origRequestData.get("AM_REDIRECT_URL");
                            output_data = (String)origRequestData.get("OUTPUT_DATA");
                            clientType = (String)origRequestData.get("AM_CLIENT_TYPE");
                        }
                        if (debug.messageEnabled()) {
                            debug.message("redirect_url : " + redirect_url);
                            debug.message("clientType : " + clientType);
                        }
                        if (redirect_url != null && !redirect_url.equals("") && AuthUtils.isGenericHTMLClient(clientType)) {
                            debug.message("Redirecting the response");
                            response.sendRedirect(redirect_url);
                        }
                        if (output_data != null && !output_data.equals("")) {
                            debug.message("Printing the forwarded response");
                            response.setContentType("text/html; charset=UTF-8");
                            PrintWriter outP = response.getWriter();
                            outP.println(output_data);
                        }
                        if (redirect_url != null && redirect_url.length() != 0 || output_data != null && output_data.length() != 0) break block37;
                        if (debug.messageEnabled()) {
                            debug.message("LoginServlet:initializeRequestContext No Response from original Auth server");
                        }
                        String refererURL = request.getHeader("Referer");
                        String refererDomain = null;
                        if (refererURL != null && refererURL.length() != 0) {
                            URL u = new URL(refererURL);
                            int pos = u.getHost().indexOf(".");
                            if (pos != -1) {
                                refererDomain = u.getHost().substring(pos);
                            }
                        } else {
                            refererURL = request.getRequestURL().toString();
                            if (request.getQueryString() != null) {
                                refererURL = refererURL + "?" + request.getQueryString();
                            }
                        }
                        if (debug.messageEnabled()) {
                            debug.message("LoginServlet:initializeRequestContext referer domain is " + refererDomain);
                        }
                        Cookie[] cookies = request.getCookies();
                        Set domains = AuthUtils.getCookieDomains();
                        if (cookies != null && cookies.length > 0) {
                            for (int i = 0; i < cookies.length; ++i) {
                                if (!cookies[i].getName().equalsIgnoreCase(AuthUtils.getAuthCookieName()) && !cookies[i].getName().equalsIgnoreCase(AuthUtils.getlbCookieName())) continue;
                                if (debug.messageEnabled()) {
                                    debug.message("LoginServlet:initializeRequestContext removingcookie " + cookies[i].getName());
                                }
                                cookies[i].setValue("");
                                cookies[i].setMaxAge(0);
                                response.addCookie(cookies[i]);
                                if (!domains.isEmpty()) {
                                    for (String domain : domains) {
                                        if (debug.messageEnabled()) {
                                            debug.message("LoginServlet:initializeRequestContext removing cookie " + domain);
                                        }
                                        Cookie cookie = AuthUtils.createCookie(cookies[i].getName(), "", domain);
                                        cookie.setMaxAge(0);
                                        response.addCookie(cookie);
                                    }
                                    continue;
                                }
                                if (refererDomain == null) continue;
                                Cookie cookie = AuthUtils.createCookie(cookies[i].getName(), "", refererDomain);
                                cookie.setMaxAge(0);
                                response.addCookie(cookie);
                            }
                        }
                        if (debug.messageEnabled()) {
                            debug.message("LoginServlet:initializeRequestContextredirecting to: " + refererURL);
                        }
                        response.sendRedirect(refererURL);
                    }
                    catch (Exception e) {
                        if (!debug.messageEnabled()) break block37;
                        debug.message("LoginServlet error in Request Routing : " + e.toString());
                    }
                }
                throw new CompleteRequestException();
            }
        }
    }

    private boolean checkForCookiesInBrowser(HttpServletRequest request, HttpServletResponse response, Debug debug) {
        String agentOrder = null;
        if (this.amCookieCheck != null && this.amCookieCheck.equalsIgnoreCase("false")) {
            agentOrder = request.getParameter("amagentcookiecheck");
        }
        if (debug.messageEnabled()) {
            debug.message("LoginServlet:checkForCookiesInBrowser  amCookieCheck: " + this.amCookieCheck + " agentOrder: " + agentOrder);
        }
        if (this.amCookieCheck != null && this.amCookieCheck.equalsIgnoreCase("true") || agentOrder != null && agentOrder.equalsIgnoreCase("true")) {
            String redirectFlag = request.getParameter("AMTESTCOOKIE");
            String requestURL = request.getRequestURL().toString();
            Cookie[] allCookies = request.getCookies();
            int numCookies = 0;
            if (allCookies != null) {
                numCookies = allCookies.length;
            }
            if (numCookies == 0 && redirectFlag == null) {
                Cookie dummyCookie = new Cookie("AMTESTCOOKIE", "amtestcookie");
                response.addCookie(dummyCookie);
                String queryStr = request.getQueryString();
                try {
                    if (queryStr == null || queryStr.length() == 0) {
                        response.sendRedirect(requestURL + "?AMTESTCOOKIE=amtestcookie");
                    } else {
                        response.sendRedirect(requestURL + "?" + queryStr + "&AMTESTCOOKIE=amtestcookie");
                    }
                }
                catch (Exception e) {
                    debug.message("LoginServlet:checkForCookiesInBrowser  error in Request Routing : " + e.toString());
                }
                return true;
            }
            if (redirectFlag != null && numCookies == 0) {
                debug.message("LoginServlet:checkForCookiesInBrowser This browser does not support cookie");
                request.setAttribute("displayCookieError", (Object)"true");
            }
        }
        return false;
    }

    public String getModuleURL() {
        String result = super.getModuleURL();
        if (result != null) {
            return result;
        }
        return DEFAULT_MODULE_URL;
    }

    protected void onSessionTimeout(RequestContext requestContext) throws ServletException {
    }
}

