/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.authentication.modules.ad;

import com.sun.identity.authentication.config.AMAuthConfigUtils;
import com.sun.identity.authentication.modules.ad.ADPrincipal;
import com.sun.identity.authentication.modules.ldap.LDAP;
import com.sun.identity.authentication.spi.AuthLoginException;
import com.sun.identity.shared.datastruct.CollectionHelper;
import com.sun.identity.shared.debug.Debug;
import java.security.Principal;
import java.util.Map;

public class AD
extends LDAP {
    private ADPrincipal userPrincipal;

    public AD() {
        this.amAuthLDAP = "amAuthAD";
        this.debug = Debug.getInstance((String)this.amAuthLDAP);
    }

    public Principal getPrincipal() {
        if (this.userPrincipal != null) {
            return this.userPrincipal;
        }
        if (this.validatedUserID != null) {
            this.userPrincipal = new ADPrincipal(this.validatedUserID);
            return this.userPrincipal;
        }
        return null;
    }

    public void destroyModuleState() {
        super.destroyModuleState();
        this.userPrincipal = null;
    }

    public boolean initializeLDAP() throws AuthLoginException {
        boolean returnValue = super.initializeLDAP();
        String authLevel = CollectionHelper.getMapAttr((Map)this.currentConfig, (String)AMAuthConfigUtils.getAuthLevelAttribute(this.currentConfig, "AD"));
        if (authLevel != null) {
            try {
                this.setAuthLevel(Integer.parseInt(authLevel));
            }
            catch (Exception e) {
                this.debug.error("Unable to set auth level " + authLevel);
            }
        }
        return returnValue;
    }
}

