/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.common;

import com.sun.identity.common.CaseInsensitiveHashSet;
import com.sun.identity.common.CaseInsensitiveKey;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class CaseInsensitiveHashMap
extends HashMap {
    public CaseInsensitiveHashMap() {
    }

    public CaseInsensitiveHashMap(int initialCapacity) {
        super(initialCapacity);
    }

    public CaseInsensitiveHashMap(int initialCapacity, float loadFactor) {
        super(initialCapacity, loadFactor);
    }

    public CaseInsensitiveHashMap(Map t) {
        this.putAll(t);
    }

    public boolean containsKey(Object key) {
        boolean retval;
        if (key instanceof String) {
            CaseInsensitiveKey ciKey = new CaseInsensitiveKey((String)key);
            retval = super.containsKey(ciKey);
        } else {
            retval = super.containsKey(key);
        }
        return retval;
    }

    public Object get(Object key) {
        Object retval;
        if (key instanceof String) {
            CaseInsensitiveKey ciKey = new CaseInsensitiveKey((String)key);
            retval = super.get(ciKey);
        } else {
            retval = super.get(key);
        }
        return retval;
    }

    public Set keySet() {
        Set keys = super.keySet();
        CaseInsensitiveHashSet set = new CaseInsensitiveHashSet();
        set.addAll(keys);
        return set;
    }

    public Set entrySet() {
        Set entries = super.entrySet();
        HashSet<Entry> set = new HashSet<Entry>();
        for (Map.Entry entry : entries) {
            set.add(new Entry(entry));
        }
        return set;
    }

    public Object put(Object key, Object value) {
        Object retval;
        if (key instanceof String) {
            CaseInsensitiveKey ciKey = new CaseInsensitiveKey((String)key);
            retval = super.put(ciKey, value);
        } else {
            retval = super.put(key, value);
        }
        return retval;
    }

    public void putAll(Map map) {
        if (map == null || map.size() == 0) {
            return;
        }
        for (Map.Entry entry : map.entrySet()) {
            this.put(entry.getKey(), entry.getValue());
        }
    }

    public Object remove(Object key) {
        Object retval;
        if (key instanceof String) {
            CaseInsensitiveKey ciKey = new CaseInsensitiveKey((String)key);
            retval = super.remove(ciKey);
        } else {
            retval = super.remove(key);
        }
        return retval;
    }

    private static class Entry
    implements Map.Entry {
        Map.Entry entry;

        Entry(Map.Entry entry) {
            this.entry = entry;
        }

        public Object getKey() {
            return this.entry.getKey().toString();
        }

        public Object getValue() {
            return this.entry.getValue();
        }

        public boolean equals(Object o) {
            return ((Object)this.entry).equals(o);
        }

        public Object setValue(Object o) {
            return this.entry.setValue(o);
        }

        public int hashCode() {
            return ((Object)this.entry).hashCode();
        }
    }
}

