/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.common.configuration;

import com.sun.identity.sm.ServiceAttributeValidator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ListValueValidator
implements ServiceAttributeValidator {
    private static final Pattern pattern = Pattern.compile("(\\s*\\[\\s*\\d++\\s*\\]\\s*=.*)");

    public boolean validate(Set values) {
        boolean valid = true;
        if (values != null && !values.isEmpty()) {
            Iterator i = values.iterator();
            while (i.hasNext() && valid) {
                String str = ((String)i.next()).trim();
                if (str.length() <= 0) continue;
                Matcher m = pattern.matcher(str);
                valid = m.matches();
            }
        }
        if (valid) {
            valid = this.checkForValidIntegerKeyInValue(values);
        }
        return valid;
    }

    private boolean checkForValidIntegerKeyInValue(Set values) {
        boolean valid = true;
        HashSet<String> keySet = new HashSet<String>();
        int indexNumber = -1;
        if (values != null && !values.isEmpty()) {
            Iterator i = values.iterator();
            while (i.hasNext() && valid) {
                String str = ((String)i.next()).trim();
                if (str.length() <= 0) continue;
                int startIndex = str.indexOf("[");
                int endIndex = str.indexOf("]");
                str = str.substring(startIndex + 1, endIndex).trim();
                try {
                    indexNumber = Integer.parseInt(str);
                }
                catch (NumberFormatException nfe) {
                    valid = false;
                }
                if (indexNumber < 0) {
                    valid = false;
                }
                if (keySet.add(str)) continue;
                valid = false;
            }
        }
        return valid;
    }
}

