/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.entitlement;

import com.sun.identity.entitlement.ApplicationType;
import com.sun.identity.entitlement.EntitlementConfiguration;
import com.sun.identity.entitlement.EntitlementException;
import com.sun.identity.entitlement.PrivilegeManager;
import com.sun.identity.entitlement.interfaces.ISaveIndex;
import com.sun.identity.entitlement.interfaces.ISearchIndex;
import com.sun.identity.entitlement.interfaces.ResourceName;
import java.util.HashSet;
import java.util.Set;
import javax.security.auth.Subject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ApplicationTypeManager {
    public static final String URL_APPLICATION_TYPE_NAME = "iPlanetAMWebAgentService";
    public static final String DELEGATION_APPLICATION_TYPE_NAME = "sunAMDelegationService";

    public static Set<String> getApplicationTypeNames(Subject adminSubject) {
        HashSet<String> names = new HashSet<String>();
        EntitlementConfiguration ec = EntitlementConfiguration.getInstance(adminSubject, "/");
        Set<ApplicationType> applications = ec.getApplicationTypes();
        for (ApplicationType a : applications) {
            names.add(a.getName());
        }
        return names;
    }

    public static ApplicationType getAppplicationType(Subject adminSubject, String name) {
        EntitlementConfiguration ec = EntitlementConfiguration.getInstance(adminSubject, "/");
        Set<ApplicationType> applications = ec.getApplicationTypes();
        for (ApplicationType a : applications) {
            if (!a.getName().equals(name)) continue;
            return a;
        }
        return null;
    }

    public static void removeApplicationType(Subject adminSubject, String name) throws EntitlementException {
        EntitlementConfiguration ec = EntitlementConfiguration.getInstance(adminSubject, "/");
        ec.removeApplicationType(name);
    }

    public static void saveApplicationType(Subject adminSubject, ApplicationType appType) throws EntitlementException {
        EntitlementConfiguration ec = EntitlementConfiguration.getInstance(adminSubject, "/");
        ec.storeApplicationType(appType);
    }

    public static Class getSearchIndex(String className) {
        if (className == null) {
            return null;
        }
        try {
            Class<?> clazz = Class.forName(className);
            Object o = clazz.newInstance();
            if (o instanceof ISearchIndex) {
                return clazz;
            }
        }
        catch (InstantiationException ex) {
            PrivilegeManager.debug.error("ApplicationTypeManager.getSearchIndex", (Throwable)ex);
        }
        catch (IllegalAccessException ex) {
            PrivilegeManager.debug.error("ApplicationTypeManager.getSearchIndex", (Throwable)ex);
        }
        catch (ClassNotFoundException ex) {
            PrivilegeManager.debug.error("ApplicationTypeManager.getSearchIndex", (Throwable)ex);
        }
        return null;
    }

    public static Class getSaveIndex(String className) {
        if (className == null) {
            return null;
        }
        try {
            Class<?> clazz = Class.forName(className);
            Object o = clazz.newInstance();
            if (o instanceof ISaveIndex) {
                return clazz;
            }
        }
        catch (InstantiationException ex) {
            PrivilegeManager.debug.error("ApplicationTypeManager.getSaveIndex", (Throwable)ex);
        }
        catch (IllegalAccessException ex) {
            PrivilegeManager.debug.error("ApplicationTypeManager.getSaveIndex", (Throwable)ex);
        }
        catch (ClassNotFoundException ex) {
            PrivilegeManager.debug.error("ApplicationTypeManager.getSaveIndex", (Throwable)ex);
        }
        return null;
    }

    public static Class getResourceComparator(String className) {
        if (className == null) {
            return null;
        }
        try {
            Class<?> clazz = Class.forName(className);
            Object o = clazz.newInstance();
            if (o instanceof ResourceName) {
                return clazz;
            }
        }
        catch (InstantiationException ex) {
            PrivilegeManager.debug.error("ApplicationTypeManager.getResourceComparator", (Throwable)ex);
        }
        catch (IllegalAccessException ex) {
            PrivilegeManager.debug.error("ApplicationTypeManager.getResourceComparator", (Throwable)ex);
        }
        catch (ClassNotFoundException ex) {
            PrivilegeManager.debug.error("ApplicationTypeManager.getResourceComparator", (Throwable)ex);
        }
        return null;
    }
}

