/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.entitlement.util;

import com.sun.identity.entitlement.ResourceSaveIndexes;
import com.sun.identity.entitlement.interfaces.ISaveIndex;
import com.sun.identity.entitlement.util.RelaxedURL;
import com.sun.identity.entitlement.util.ResourceNameSplitter;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.StringTokenizer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResourceNameIndexGenerator
implements ISaveIndex {
    @Override
    public ResourceSaveIndexes getIndexes(String resName) {
        try {
            RelaxedURL url = new RelaxedURL(resName);
            HashSet<String> hostIndexes = new HashSet<String>();
            hostIndexes.add(ResourceNameIndexGenerator.getHostIndex(url));
            HashSet<String> pathIndexes = new HashSet<String>();
            String pathIndex = ResourceNameIndexGenerator.getPathIndex(url);
            pathIndexes.add(pathIndex);
            Set<String> pathParentIndexes = ResourceNameIndexGenerator.getPathParentIndexes(pathIndex);
            return new ResourceSaveIndexes(hostIndexes, pathIndexes, pathParentIndexes);
        }
        catch (MalformedURLException e) {
            HashSet<String> hostIndexes = new HashSet<String>();
            hostIndexes.add(".");
            HashSet<String> pathIndexes = new HashSet<String>();
            String path = ResourceNameIndexGenerator.getPathIndex(resName, null);
            pathIndexes.add(path);
            Set<String> pathParentIndexes = ResourceNameIndexGenerator.getPathParentIndexes(path);
            return new ResourceSaveIndexes(hostIndexes, pathIndexes, pathParentIndexes);
        }
    }

    private static String getHostIndex(RelaxedURL url) {
        String host = url.getHostname().toLowerCase();
        int idx = host.lastIndexOf("*");
        if (idx != -1) {
            int dotIdx = host.indexOf(46, idx);
            host = dotIdx != -1 ? host.substring(dotIdx) : "";
        }
        return "://" + host;
    }

    private static String getPathIndex(RelaxedURL url) {
        return ResourceNameIndexGenerator.getPathIndex(url.getPath(), url.getQuery());
    }

    private static String getPathIndex(String path, String query) {
        path = path.toLowerCase();
        query = query == null ? "" : query.toLowerCase();
        int idx = path.indexOf("-*-");
        if (idx == -1) {
            idx = path.indexOf("*");
        }
        if (idx != -1) {
            int slashIdx = path.lastIndexOf(47, idx);
            path = path.substring(0, slashIdx + 1);
            query = "";
            if (!path.equals("/") && path.endsWith("/")) {
                path = path.substring(0, path.length() - 1);
            }
        }
        if (query.length() > 0) {
            HashMap<String, HashSet<String>> map = new HashMap<String, HashSet<String>>();
            StringTokenizer st = new StringTokenizer(query, "&");
            while (st.hasMoreTokens()) {
                String tok = st.nextToken();
                int i = tok.indexOf("=");
                String key = i != -1 ? tok.substring(0, i) : tok;
                String val = i != -1 ? tok.substring(i + 1) : "";
                HashSet<String> set = (HashSet<String>)map.get(key);
                if (set == null) {
                    set = new HashSet<String>();
                    map.put(key, set);
                }
                set.add(val);
            }
            boolean queryHasWildCard = false;
            Iterator i = map.keySet().iterator();
            while (i.hasNext() && !queryHasWildCard) {
                String s = (String)i.next();
                queryHasWildCard = s.indexOf(42) != -1;
            }
            if (queryHasWildCard) {
                query = "";
            } else {
                ArrayList<String> list = new ArrayList<String>();
                for (String key : map.keySet()) {
                    Set val = (Set)map.get(key);
                    boolean wildcard = false;
                    Iterator i2 = val.iterator();
                    while (i2.hasNext() && !wildcard) {
                        String s = (String)i2.next();
                        wildcard = s.indexOf(42) != -1;
                    }
                    if (wildcard) {
                        list.add(key + "=");
                        continue;
                    }
                    for (String s : val) {
                        list.add(key + "=" + s);
                    }
                }
                query = ResourceNameSplitter.queryToString(list);
            }
        }
        path = query.length() > 0 ? path + "?" + query : path;
        int idxMacro = path.indexOf("$");
        if (idxMacro != -1 && (path = path.substring(0, idxMacro)).endsWith("/")) {
            path = path.substring(0, path.length() - 1);
        }
        return path;
    }

    private static Set<String> getPathParentIndexes(String pathIndex) {
        HashSet<String> parents = new HashSet<String>();
        int idx = pathIndex.indexOf("?");
        String str = idx != -1 ? pathIndex.substring(0, idx) + "/dummy" : pathIndex;
        StringTokenizer st = new StringTokenizer(str, "/");
        StringBuffer tracker = new StringBuffer();
        tracker.append("/");
        while (st.hasMoreElements()) {
            String s = st.nextToken();
            if (!st.hasMoreElements()) continue;
            tracker.append(s);
            parents.add(tracker.toString());
            tracker.append("/");
        }
        parents.add("/");
        parents.add(str);
        return parents;
    }
}

