/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.log.secure;

import com.sun.identity.log.Logger;
import com.sun.identity.log.handlers.SecureFileHandler;
import com.sun.identity.log.secure.SecureLogHelper;
import com.sun.identity.log.spi.Debug;
import java.util.Vector;
import java.util.logging.Handler;

public class LogSign {
    private String name;
    private Logger logger;

    public LogSign(String log) {
        this.name = log;
    }

    public void readHeader(String[] recordListHeader) {
        Vector<String> header = new Vector<String>(recordListHeader.length);
        for (int i = 0; i < recordListHeader.length; ++i) {
            header.add(recordListHeader[i]);
        }
        String signFieldName = "Signature";
        for (int j = 0; j < header.size() && !((String)header.get(j)).equalsIgnoreCase(signFieldName); ++j) {
        }
    }

    public synchronized String sign() throws Exception {
        byte[] newMAC;
        byte[] prevSign;
        this.logger = (Logger)Logger.getLogger(this.name);
        Handler[] handlers = this.logger.getHandlers();
        SecureLogHelper helper = ((SecureFileHandler)handlers[0]).getSecureLogHelper();
        byte[] prevMAC = new byte[1];
        prevMAC = helper.getLastMAC();
        if (prevMAC == null) {
            if (Debug.warningEnabled()) {
                Debug.warning(this.name + "Prev MAC = null");
            }
            return null;
        }
        if (Debug.messageEnabled()) {
            Debug.message(this.name + "prevMAC = " + helper.toHexString(prevMAC));
        }
        if ((prevSign = helper.getLastSignatureBytes()) == null || prevSign.length == 0) {
            newMAC = new byte[prevMAC.length];
            System.arraycopy(prevMAC, 0, newMAC, 0, prevMAC.length);
        } else {
            newMAC = new byte[prevMAC.length + prevSign.length];
            System.arraycopy(prevMAC, 0, newMAC, 0, prevMAC.length);
            System.arraycopy(prevSign, 0, newMAC, prevMAC.length, prevSign.length);
        }
        byte[] curSign = helper.signMAC(newMAC);
        String sign = helper.toHexString(curSign);
        return sign;
    }
}

