/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.servicetag.registration;

import com.sun.identity.servicetag.registration.RegistrationException;
import com.sun.identity.servicetag.registration.RepositoryManager;
import com.sun.identity.servicetag.registration.ServiceTag;
import com.sun.identity.servicetag.registration.StringManager;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SysnetTransferManager {
    private RepositoryManager rm;
    private static final List<STClientCommandInfo> osToSTClientCommand = SysnetTransferManager.prepareSTClientLocationMap();
    private static final String OS_NAME = System.getProperty("os.name");
    private static final String LINE_SEP = System.getProperty("line.separator");

    public SysnetTransferManager(File repositoryFile) throws RegistrationException {
        this.rm = new RepositoryManager(repositoryFile);
    }

    public int transferServiceTags() throws RegistrationException {
        int result = -1;
        try {
            if (!this.isSTClientInstalled()) {
                return result;
            }
            this.rm.updateRuntimeValues();
            List<ServiceTag> unTransferredTags = this.getUntransferredServiceTags(this.rm);
            for (ServiceTag tag : unTransferredTags) {
                this.addTagToSysNet(tag);
                this.rm.setStatus(tag, ServiceTag.Status.TRANSFERRED);
            }
            result = unTransferredTags.size();
            return result;
        }
        catch (Exception e) {
            throw new RegistrationException(StringManager.getString("xfmgr.errTransTags", new Object[0]), e);
        }
    }

    private boolean isSTClientInstalled() {
        return this.chooseSTClientCommandForPlatform() != null;
    }

    private List<ServiceTag> getUntransferredServiceTags(RepositoryManager rm) {
        List<ServiceTag> candidateTags = rm.getServiceTags();
        Iterator<ServiceTag> it = candidateTags.iterator();
        while (it.hasNext()) {
            ServiceTag tag = it.next();
            if (!ServiceTag.Status.valueOf(tag.getSvcTag().getStatus()).equals((Object)ServiceTag.Status.TRANSFERRED)) continue;
            it.remove();
        }
        return candidateTags;
    }

    private void addTagToSysNet(ServiceTag tag) throws RegistrationException, IOException, InterruptedException {
        STClientCommand stClientCommand = new STClientCommand(tag);
        stClientCommand.run();
    }

    private static List<STClientCommandInfo> prepareSTClientLocationMap() {
        ArrayList<STClientCommandInfo> result = new ArrayList<STClientCommandInfo>();
        result.add(new STClientCommandInfo("Windows", "C:\\Program Files\\Sun\\servicetag\\stclient.exe"));
        result.add(new STClientCommandInfo("Sun", "/usr/bin/stclient"));
        result.add(new STClientCommandInfo("Linux", "/opt/sun/servicetag/bin/stclient"));
        return result;
    }

    private STClientCommandInfo chooseSTClientCommandForPlatform() {
        String stClientPath = null;
        for (STClientCommandInfo info : osToSTClientCommand) {
            if (!info.handles(SysnetTransferManager.OS_NAME)) continue;
            stClientPath = info.getToolPath();
            File stClientFile = new File(stClientPath);
            if (stClientFile.exists()) {
                return info;
            }
            return null;
        }
        return null;
    }

    private class STClientCommand {
        private static final long STCLIENT_COMMAND_TIMEOUT_MS = 25000L;
        private static final int INPUT_BUFFER_SIZE = 1024;
        private static final int PROCESS_IO_FLUSH_DELAY_MS = 500;
        private ServiceTag tag;
        private List<String> command;
        private InputStreamReader outputFromProcess;
        private InputStreamReader errorFromProcess;
        private StringBuilder outputTextFromProcess = new StringBuilder();
        private StringBuilder errorTextFromProcess = new StringBuilder();

        public STClientCommand(ServiceTag tag) throws RegistrationException {
            this.tag = tag;
            this.constructCommand();
        }

        public void run() throws IOException, InterruptedException, RegistrationException {
            ProcessBuilder pb = new ProcessBuilder(this.command);
            StringBuilder sb = new StringBuilder("Preparing to run the following command:\n");
            for (String s : this.command) {
                sb.append(s).append(" ");
            }
            final Process commandProcess = pb.start();
            this.outputFromProcess = new InputStreamReader(new BufferedInputStream(commandProcess.getInputStream()));
            this.errorFromProcess = new InputStreamReader(new BufferedInputStream(commandProcess.getErrorStream()));
            final AtomicInteger processExitStatus = new AtomicInteger();
            final AtomicBoolean processExitDetected = new AtomicBoolean(false);
            Thread processMonitorThread = new Thread(new Runnable(){

                public void run() {
                    try {
                        int status = commandProcess.waitFor();
                        processExitStatus.set(status);
                        processExitDetected.set(true);
                    }
                    catch (InterruptedException e) {
                        commandProcess.destroy();
                    }
                }
            });
            processMonitorThread.start();
            boolean isProcessDestroyRequested = false;
            long processWaitDeadline = System.currentTimeMillis() + 25000L;
            while (processMonitorThread.isAlive()) {
                if (System.currentTimeMillis() > processWaitDeadline && !isProcessDestroyRequested) {
                    commandProcess.destroy();
                    isProcessDestroyRequested = true;
                }
                this.flushProcessIO();
                Thread.sleep(500L);
            }
            this.flushProcessIO();
            if (!processExitDetected.get()) {
                throw new RegistrationException(StringManager.getString("xfmgr.unknownCmdProcResult", new Object[0]));
            }
            if (processExitStatus.get() != 0) {
                RegistrationException e = new RegistrationException(StringManager.getString("xfmgr.cmdProcFailed", this.errorTextFromProcess.toString()));
                throw e;
            }
        }

        private void flushProcessIO() throws IOException {
            this.copyFromReader(this.outputFromProcess, this.outputTextFromProcess);
            this.copyFromReader(this.errorFromProcess, this.errorTextFromProcess);
        }

        private void copyFromReader(InputStreamReader reader, StringBuilder sb) throws IOException {
            char[] buffer = new char[1024];
            boolean eoStream = false;
            while (reader.ready() && !eoStream) {
                int charsRead = reader.read(buffer);
                if (charsRead == -1) {
                    eoStream = true;
                    continue;
                }
                sb.append(buffer, 0, charsRead);
            }
        }

        private void constructCommand() throws RegistrationException {
            this.command = new ArrayList<String>();
            STClientCommandInfo commandInfo = SysnetTransferManager.this.chooseSTClientCommandForPlatform();
            this.command.add(this.formatValue(commandInfo.getToolPath()));
            this.command.add("-a");
            this.addRequired("-p", this.tag.getProductName());
            this.addRequired("-e", this.tag.getProductVersion());
            this.addRequired("-t", this.tag.getProductURN());
            this.addOptional("-F", this.tag.getProductParentURN());
            this.addRequired("-P", this.tag.getProductParentURN());
            this.addOptional("-I", this.tag.getProductDefinedInstID());
            this.addRequired("-m", this.tag.getProductVendor());
            this.addRequired("-A", this.tag.getPlatformArch());
            this.addRequired("-z", this.tag.getContainer());
            this.addRequired("-S", this.tag.getSource());
        }

        private void addRequired(String option, String value) throws RegistrationException {
            if (value == null) {
                throw new RegistrationException(StringManager.getString("xfmgr.reqdValueNull", option));
            }
            this.command.add(option);
            this.command.add(this.formatValue(value));
        }

        private void addOptional(String option, String value) {
            if (value != null && value.length() > 0) {
                this.command.add(option);
                this.command.add(this.formatValue(value));
            }
        }

        private String formatValue(String value) {
            if (value.indexOf(32) == -1 && value.length() > 0) {
                return value;
            }
            return "\"" + value + "\"";
        }
    }

    private static class STClientCommandInfo {
        private String osNamePrefix;
        private String toolPath;

        private STClientCommandInfo(String osNamePrefix, String toolPath) {
            this.osNamePrefix = osNamePrefix;
            this.toolPath = toolPath;
        }

        private String getToolPath() {
            return this.toolPath;
        }

        private boolean handles(String osName) {
            return osName.startsWith(this.osNamePrefix);
        }
    }
}

