/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.sm;

import com.sun.identity.shared.debug.Debug;
import com.sun.identity.shared.ldap.LDAPDN;
import com.sun.identity.shared.ldap.util.DN;
import com.sun.identity.sm.OrgConfigViaAMSDK;
import com.sun.identity.sm.SMSEntry;
import com.sun.identity.sm.SMSSchema;
import com.sun.identity.sm.ServiceManager;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import java.util.StringTokenizer;

public class DNMapper {
    private static Debug debug = SMSEntry.debug;
    private static HashMap cache = new HashMap(2);
    protected static boolean realmEnabled = ServiceManager.isRealmEnabled();
    protected static String serviceDN = new DN("ou=services," + SMSEntry.baseDN).toRFCString().toLowerCase();
    static boolean migration = false;

    public static String orgNameToDN(String orgName) {
        if (orgName == null || orgName.trim().length() == 0 || orgName.equals("/")) {
            return SMSEntry.baseDN;
        }
        String orgdn = (String)cache.get(orgName);
        if (orgdn != null) {
            return orgdn;
        }
        if (DN.isDN((String)orgName)) {
            orgdn = new DN(orgName).toRFCString();
            String orgdnlc = orgdn.toLowerCase();
            if (orgdnlc.startsWith("o=sunamhiddenrealm")) {
                orgdn = LDAPDN.explodeDN((String)orgdn, (boolean)false)[0] + "," + serviceDN;
                DNMapper.updateCache(orgName, orgdn);
                return orgdn;
            }
            if (orgdnlc.equals(SMSEntry.baseDN) || orgdnlc.equals(serviceDN) || orgdnlc.equals(SMSEntry.amsdkbaseDN)) {
                DNMapper.updateCache(orgName, SMSEntry.baseDN);
                return SMSEntry.baseDN;
            }
            if (realmEnabled) {
                int indx;
                int ndx = orgdn.indexOf(serviceDN);
                if (ndx == -1) {
                    ndx = orgdn.lastIndexOf(SMSEntry.baseDN);
                }
                if (ndx > 0) {
                    orgdn = orgdn.substring(0, ndx - 1);
                }
                if ((indx = orgdn.lastIndexOf(",")) >= 0 && orgdn.substring(indx).equals(",")) {
                    orgdn = orgdn.substring(0, indx);
                }
                if (debug.messageEnabled()) {
                    debug.message("DNMapper.orgNameToDN():orgdn " + orgdn);
                }
                String answer = DNMapper.normalizeDN(orgdn) + serviceDN;
                if (debug.messageEnabled()) {
                    debug.message("DNMapper.orgNameToDN(" + orgName + ")=" + answer);
                }
                DNMapper.updateCache(orgName, answer);
                return answer;
            }
            if (!migration) {
                orgdn = DNMapper.replaceString(orgdn, ",ou=services,", ",");
                DNMapper.updateCache(orgName, orgdn);
                return orgdn;
            }
            return orgdn;
        }
        StringBuffer buf = DNMapper.convertToDN(orgName);
        if (realmEnabled || buf.toString().toLowerCase().indexOf("sunamhiddenrealm") != -1) {
            buf.append(",").append(serviceDN);
        } else if (SMSEntry.baseDN.length() > 0) {
            buf.append(",").append(SMSEntry.baseDN);
        }
        if (debug.messageEnabled()) {
            debug.message("DNMapper.orgNameToDN(" + orgName + ")=" + buf.toString());
        }
        String answer = buf.toString();
        DNMapper.updateCache(orgName, answer);
        return answer;
    }

    private static void updateCache(String orgName, String realmName) {
        HashMap<String, String> ncache = new HashMap<String, String>(cache);
        ncache.put(orgName, realmName);
        cache = ncache;
    }

    public static String realmNameToAMSDKName(String realmName) {
        String dn = DNMapper.orgNameToDN(realmName);
        String dnlc = dn.toLowerCase();
        if (debug.messageEnabled()) {
            debug.message("DNMapper.realmNameToAMSDKName realmName =" + realmName);
            debug.message("DNMapper.realmNameToAMSDKName orgDN =" + dn);
        }
        if (dnlc.equals(SMSEntry.baseDN) && !dnlc.equals(SMSEntry.amsdkbaseDN)) {
            return SMSEntry.amsdkbaseDN;
        }
        if (dnlc.equals(SMSEntry.baseDN) || dnlc.startsWith("o=sunamhiddenrealm")) {
            return SMSEntry.baseDN;
        }
        StringBuffer buf = new StringBuffer(dn.length());
        String orgAttr = OrgConfigViaAMSDK.getNamingAttrForOrg();
        if (orgAttr == null || orgAttr.equalsIgnoreCase("o")) {
            String answer = DNMapper.replaceString(dn, ",ou=services,", ",");
            if (debug.messageEnabled()) {
                debug.message("DNMapper.realmNameToAMSDKName sdkName =" + answer);
            }
            return answer;
        }
        int index = dnlc.indexOf(serviceDN);
        if (index == -1) {
            index = dnlc.indexOf(SMSEntry.baseDN);
        }
        String answer = index == -1 ? dn : dn.substring(0, index - 1);
        String[] rdns = LDAPDN.explodeDN((String)answer, (boolean)true);
        int size = rdns.length;
        for (int i = 0; i < size; ++i) {
            buf.append(orgAttr).append("=").append(rdns[i]);
            buf.append(',');
        }
        buf.append(SMSEntry.baseDN);
        if (debug.messageEnabled()) {
            debug.message("DNMapper.realmNameToAMSDKName sdkName =" + buf.toString());
        }
        return buf.toString();
    }

    public static String orgNameToRealmName(String orgName) {
        StringBuffer answer = new StringBuffer(100);
        answer.append("/");
        if (orgName != null && orgName.length() != 0 && !orgName.equalsIgnoreCase(SMSEntry.baseDN) && !orgName.equalsIgnoreCase(serviceDN) && DN.isDN((String)orgName)) {
            HashSet<String> resultSet = new HashSet<String>(2);
            resultSet.add(orgName);
            String orgdn = new DN(orgName).toRFCString();
            String orgdnlc = orgdn.toLowerCase();
            Set returnSet = null;
            if (orgdnlc.endsWith(serviceDN)) {
                returnSet = SMSEntry.parseResult(resultSet, serviceDN, true);
            } else if (orgdnlc.endsWith(SMSEntry.baseDN)) {
                returnSet = SMSEntry.parseResult(resultSet, serviceDN, true);
            }
            if (returnSet != null && !returnSet.isEmpty()) {
                answer.append(returnSet.iterator().next().toString());
            }
        }
        return answer.toString();
    }

    static String[] splitString(String str) {
        String[] strArray = new String[2];
        int idx = str.indexOf(61);
        if (idx != -1) {
            strArray[0] = str.substring(0, idx).trim();
            strArray[1] = str.substring(idx + 1).trim();
        }
        return strArray;
    }

    static String replaceString(String originalString, String token, String newString) {
        int lenToken = token.length();
        int idx = originalString.indexOf(token);
        if (!originalString.startsWith("/") && idx >= 0) {
            int slashndx = originalString.substring(idx).indexOf("/");
            while (slashndx != -1) {
                originalString = originalString.substring(0, slashndx) + "&#47;" + originalString.substring(slashndx + 1);
                slashndx = originalString.indexOf("/", slashndx + 5);
            }
        }
        while (idx != -1) {
            originalString = originalString.substring(0, idx) + newString + originalString.substring(idx + lenToken);
            idx = originalString.indexOf(token, idx + lenToken);
        }
        if (debug.messageEnabled()) {
            debug.message("DNMapper.replaceString() " + originalString);
        }
        return originalString;
    }

    static String normalizeDN(String orgName) {
        String orgAttr = "";
        String placeHold = "";
        StringBuffer buf = new StringBuffer(orgName.length());
        String[] rdns = LDAPDN.explodeDN((String)orgName, (boolean)false);
        int size = rdns.length;
        if (debug.messageEnabled()) {
            debug.message("DNMapper.normalizeDN():orgName " + orgName);
        }
        if (!realmEnabled) {
            orgAttr = OrgConfigViaAMSDK.getNamingAttrForOrg();
        }
        placeHold = realmEnabled ? "o" : orgAttr;
        for (int i = 0; i < size; ++i) {
            String[] strArr = DNMapper.splitString(rdns[i]);
            if (orgName.toLowerCase().startsWith("o=sunamhiddenrealm")) {
                buf.append("o");
            } else {
                buf.append(placeHold);
            }
            buf.append("=").append(strArr[1]).append(",");
        }
        if (debug.messageEnabled()) {
            debug.message("DNMapper.normalizeDN():finalorgdn " + buf.toString());
        }
        return buf.toString();
    }

    static StringBuffer convertToDN(String orgName) {
        StringBuffer buf = new StringBuffer();
        String placeHold = realmEnabled ? "o" : OrgConfigViaAMSDK.getNamingAttrForOrg();
        ArrayList<String> arr = new ArrayList<String>();
        StringTokenizer strtok = new StringTokenizer(orgName, "/");
        while (strtok.hasMoreElements()) {
            String token = strtok.nextToken().trim();
            if (token == null || token.length() == 0) continue;
            arr.add(token);
        }
        int size = arr.size();
        for (int i = 0; i < size; ++i) {
            String theOrg = (String)arr.get(size - i - 1);
            if (theOrg.toLowerCase().startsWith("sunamhiddenrealm")) {
                placeHold = "o";
            }
            buf.append(placeHold);
            buf.append('=').append(theOrg);
            if (i == size - 1) continue;
            buf.append(',');
        }
        if (debug.messageEnabled()) {
            debug.message("DNMapper.convertToDN():finalorgdn " + buf.toString());
        }
        if (buf.toString().indexOf("&#47;") >= 0) {
            String realmName = SMSSchema.unescapeName(buf.toString());
            if (debug.messageEnabled()) {
                debug.message("DNMapper.convertToDN():realmName " + realmName);
            }
            StringBuffer newBuf = new StringBuffer();
            newBuf.append(realmName);
            buf = newBuf;
            if (debug.messageEnabled()) {
                debug.message("DNMapper.convertToDN():newRealmName " + buf.toString());
            }
        }
        return buf;
    }

    static void clearCache() {
        cache = new HashMap();
        realmEnabled = ServiceManager.isRealmEnabled();
    }
}

