/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.sm.jaxrpc;

import com.iplanet.am.util.SystemProperties;
import com.iplanet.services.comm.server.PLLServer;
import com.iplanet.services.comm.server.SendNotificationException;
import com.iplanet.services.comm.share.Notification;
import com.iplanet.services.comm.share.NotificationSet;
import com.iplanet.sso.SSOException;
import com.iplanet.sso.SSOToken;
import com.iplanet.sso.SSOTokenManager;
import com.sun.identity.common.CaseInsensitiveHashMap;
import com.sun.identity.shared.debug.Debug;
import com.sun.identity.shared.xml.XMLUtils;
import com.sun.identity.sm.CachedSMSEntry;
import com.sun.identity.sm.CachedSubEntries;
import com.sun.identity.sm.SMSEntry;
import com.sun.identity.sm.SMSException;
import com.sun.identity.sm.SMSNotificationManager;
import com.sun.identity.sm.SMSObjectListener;
import com.sun.identity.sm.SMSUtils;
import com.sun.identity.sm.ServiceAttributeValidator;
import com.sun.identity.sm.jaxrpc.SMSJAXRPCObject;
import com.sun.identity.sm.jaxrpc.SMSObjectIF;
import java.net.MalformedURLException;
import java.net.URL;
import java.rmi.RemoteException;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import javax.naming.directory.BasicAttribute;
import javax.naming.directory.ModificationItem;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class SMSJAXRPCObjectImpl
implements SMSObjectIF,
SMSObjectListener {
    static Debug debug = Debug.getInstance((String)"amSMSServerImpl");
    static Map notificationURLs = new HashMap();
    static SSOTokenManager tokenMgr;
    static SSOException initializationError;
    static String baseDN;
    static String amsdkbaseDN;
    static boolean initialized;
    static String serverURL;
    static int cacheSize;
    static LinkedList cacheIndices;
    static HashMap cache;

    private void initialize() {
        if (!initialized) {
            String namingURL;
            try {
                tokenMgr = SSOTokenManager.getInstance();
            }
            catch (SSOException ssoe) {
                debug.error("SMSJAXRPCObject: Unable to get SSO Token Manager");
                initializationError = ssoe;
            }
            if (SMSNotificationManager.isCacheEnabled()) {
                SMSNotificationManager.getInstance().registerCallbackHandler(this);
                if (debug.messageEnabled()) {
                    debug.message("SMSJAXRPCObjectImpl.init Registered for notifications");
                }
                String cacheSizeStr = SystemProperties.get("com.sun.am.event.notification.expire.time");
                try {
                    cacheSize = Integer.parseInt(cacheSizeStr);
                    if (cacheSize < 0) {
                        cacheSize = 30;
                    }
                }
                catch (NumberFormatException e) {
                    // empty catch block
                }
                if (debug.messageEnabled()) {
                    debug.message("SMSJAXRPCObjectImpl.init  EventNotification cache size is set to " + cacheSize);
                }
            }
            if ((namingURL = SystemProperties.get("com.iplanet.am.naming.url")) != null) {
                int index = namingURL.toLowerCase().indexOf("/namingservice");
                serverURL = index != -1 ? namingURL.substring(0, index) : "";
            } else {
                serverURL = SystemProperties.getServerInstanceName();
                if (serverURL == null) {
                    serverURL = "";
                }
            }
            if (serverURL == null || serverURL.length() == 0) {
                debug.error("SMSJAXRPCObjectImpl.init Server URL IS NULL");
            } else if (debug.messageEnabled()) {
                debug.message("SMSJAXRPCObjectImpl.init ServerURL: " + serverURL);
            }
            initialized = true;
        }
    }

    public void checkForLocal() {
        SMSJAXRPCObject.isLocal = true;
    }

    public Map read(String tokenID, String objName) throws SMSException, SSOException, RemoteException {
        this.initialize();
        if (debug.messageEnabled()) {
            debug.message("SMSJAXRPCObjectImpl::read dn: " + objName);
        }
        Map returnAttributes = null;
        if (objName.equals("o=AM_JAXRPC_VERSION")) {
            returnAttributes = new HashMap<String, String>();
            returnAttributes.put("AM_JAXRPC_VERSION", "11");
        } else {
            Map attrs;
            CachedSMSEntry ce = CachedSMSEntry.getInstance(SMSJAXRPCObjectImpl.getToken(tokenID), objName);
            if (ce.isDirty()) {
                ce.refresh();
            }
            if ((attrs = ce.getSMSEntry().getAttributes()) != null && attrs instanceof CaseInsensitiveHashMap) {
                returnAttributes = new HashMap();
                Iterator items = attrs.keySet().iterator();
                while (items.hasNext()) {
                    String attrName = items.next().toString();
                    Object o = attrs.get(attrName);
                    returnAttributes.put(attrName, o);
                }
            } else {
                returnAttributes = attrs;
            }
        }
        return returnAttributes;
    }

    public void create(String tokenID, String objName, Map attributes) throws SMSException, SSOException, RemoteException {
        this.initialize();
        if (debug.messageEnabled()) {
            debug.message("SMSJAXRPCObjectImpl::create dn: " + objName);
        }
        SMSEntry entry = new SMSEntry(SMSJAXRPCObjectImpl.getToken(tokenID), objName);
        entry.setAttributes(attributes);
        entry.save();
    }

    public void modify(String tokenID, String objName, String mods) throws SMSException, SSOException, RemoteException {
        this.initialize();
        if (debug.messageEnabled()) {
            debug.message("SMSJAXRPCObjectImpl::modify dn: " + objName);
        }
        SMSEntry entry = new SMSEntry(SMSJAXRPCObjectImpl.getToken(tokenID), objName);
        entry.modifyAttributes(SMSJAXRPCObjectImpl.getModItems(mods));
        entry.save();
    }

    public void delete(String tokenID, String objName) throws SMSException, SSOException, RemoteException {
        this.initialize();
        if (debug.messageEnabled()) {
            debug.message("SMSJAXRPCObjectImpl::delete dn: " + objName);
        }
        SMSEntry entry = new SMSEntry(SMSJAXRPCObjectImpl.getToken(tokenID), objName);
        entry.delete();
    }

    public Set searchSubOrgNames(String tokenID, String dn, String filter, int numOfEntries, boolean sortResults, boolean ascendingOrder, boolean recursive) throws SMSException, SSOException {
        this.initialize();
        if (debug.messageEnabled()) {
            debug.message("SMSJAXRPCObjectImpl::searchSubOrgNames dn: " + dn);
        }
        CachedSubEntries ce = CachedSubEntries.getInstance(SMSJAXRPCObjectImpl.getToken(tokenID), dn);
        return ce.searchSubOrgNames(SMSJAXRPCObjectImpl.getToken(tokenID), filter, recursive);
    }

    public Set searchOrganizationNames(String tokenID, String dn, int numOfEntries, boolean sortResults, boolean ascendingOrder, String serviceName, String attrName, Set values) throws SMSException, SSOException {
        this.initialize();
        if (debug.messageEnabled()) {
            debug.message("SMSJAXRPCObjectImpl::searchOrganizationNames dn: " + dn);
        }
        CachedSubEntries ce = CachedSubEntries.getInstance(SMSJAXRPCObjectImpl.getToken(tokenID), dn);
        return ce.searchOrgNames(SMSJAXRPCObjectImpl.getToken(tokenID), serviceName, attrName, values);
    }

    public Set subEntries(String tokenID, String dn, String filter, int numOfEntries, boolean sortResults, boolean ascendingOrder) throws SMSException, SSOException {
        this.initialize();
        if (debug.messageEnabled()) {
            debug.message("SMSJAXRPCObjectImpl::subentries dn: " + dn);
        }
        CachedSubEntries ce = CachedSubEntries.getInstance(SMSJAXRPCObjectImpl.getToken(tokenID), dn);
        return ce.getSubEntries(SMSJAXRPCObjectImpl.getToken(tokenID), filter);
    }

    public Set schemaSubEntries(String tokenID, String dn, String filter, String sidFilter, int numOfEntries, boolean sortResults, boolean ao) throws SMSException, SSOException {
        this.initialize();
        if (debug.messageEnabled()) {
            debug.message("SMSJAXRPCObjectImpl::subentries dn: " + dn);
        }
        CachedSubEntries ce = CachedSubEntries.getInstance(SMSJAXRPCObjectImpl.getToken(tokenID), dn);
        return ce.getSchemaSubEntries(SMSJAXRPCObjectImpl.getToken(tokenID), filter, sidFilter);
    }

    public Set search(String tokenID, String startDN, String filter) throws SMSException, SSOException, RemoteException {
        this.initialize();
        if (debug.messageEnabled()) {
            debug.message("SMSJAXRPCObjectImpl::search dn: " + startDN + " filter: " + filter);
        }
        return SMSEntry.search(SMSJAXRPCObjectImpl.getToken(tokenID), startDN, filter);
    }

    public boolean entryExists(String tokenID, String objName) throws SSOException, RemoteException {
        this.initialize();
        if (debug.messageEnabled()) {
            debug.message("SMSJAXRPCObjectImpl::exists dn: " + objName);
        }
        boolean entryExists = false;
        try {
            CachedSMSEntry ce = CachedSMSEntry.getInstance(SMSJAXRPCObjectImpl.getToken(tokenID), objName);
            if (ce.isDirty()) {
                ce.refresh();
            }
            entryExists = !ce.getSMSEntry().isNewEntry();
        }
        catch (SMSException smse) {
            // empty catch block
        }
        return entryExists;
    }

    public String getRootSuffix() throws RemoteException {
        if (baseDN == null) {
            baseDN = SMSEntry.getRootSuffix();
        }
        return baseDN;
    }

    public String getAMSdkBaseDN() throws RemoteException {
        if (amsdkbaseDN == null) {
            amsdkbaseDN = SMSEntry.getAMSdkBaseDN();
        }
        return amsdkbaseDN;
    }

    public boolean validateServiceAttributes(String token, String validatorClass, Set values) throws SMSException, SSOException, RemoteException {
        this.initialize();
        if (debug.messageEnabled()) {
            debug.message("SMSJAXRPCObjectImpl::validateServiceAttributes: " + validatorClass + " Values: " + values);
        }
        try {
            Class<?> clazz = Class.forName(validatorClass);
            ServiceAttributeValidator v = (ServiceAttributeValidator)clazz.newInstance();
            return v.validate(values);
        }
        catch (InstantiationException ex) {
            throw new SMSException("sms-validator_cannot_instantiate_class");
        }
        catch (IllegalAccessException ex) {
            throw new SMSException("sms-validator_cannot_instantiate_class");
        }
        catch (ClassNotFoundException ex) {
            throw new SMSException("sms-validator_cannot_instantiate_class");
        }
    }

    public synchronized Set objectsChanged(int time) throws RemoteException {
        if (debug.messageEnabled()) {
            debug.message("SMSJAXRPCObjectImpl::objectsChanged: " + time);
        }
        HashSet answer = new HashSet();
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(new Date());
        calendar.add(12, 1);
        for (int i = 0; i < time + 3; ++i) {
            calendar.add(12, -1);
            String cacheIndex = SMSJAXRPCObjectImpl.calendarToString(calendar);
            Set modDNs = (Set)cache.get(cacheIndex);
            if (modDNs == null) continue;
            answer.addAll(modDNs);
        }
        return answer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void objectChanged(String name, int type) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(new Date());
        String cacheIndex = SMSJAXRPCObjectImpl.calendarToString(calendar);
        HashSet<String> modDNs = (HashSet<String>)cache.get(cacheIndex);
        if (modDNs == null) {
            modDNs = new HashSet<String>();
            cache.put(cacheIndex, modDNs);
            cacheIndices.addFirst(cacheIndex);
            if (cacheIndices.size() > cacheSize) {
                String index = (String)cacheIndices.removeLast();
                cache.remove(index);
            }
        }
        String modItem = null;
        switch (type) {
            case 0: {
                modItem = "ADD:" + name;
                break;
            }
            case 1: {
                modItem = "DEL:" + name;
                break;
            }
            default: {
                modItem = "MOD:" + name;
            }
        }
        modDNs.add(modItem);
        Map map = notificationURLs;
        synchronized (map) {
            HashMap notifications = new HashMap(notificationURLs);
            for (Map.Entry entry : notifications.entrySet()) {
                URL url = (URL)entry.getValue();
                Notification notification = new Notification(modItem);
                NotificationSet ns = new NotificationSet("SMSObjectIF");
                ns.addNotification(notification);
                try {
                    PLLServer.send(url, ns);
                    if (!debug.messageEnabled()) continue;
                    debug.message("SMSJAXRPCObjectImpl:sentNotification URL: " + url + " Data: " + ns);
                }
                catch (SendNotificationException ne) {
                    if (debug.warningEnabled()) {
                        debug.warning("SMSJAXRPCObject: failed sending notification to: " + url + "\nRemoving " + "URL from notification list.", (Throwable)ne);
                    }
                    notificationURLs.remove((String)entry.getKey());
                }
            }
        }
    }

    public void allObjectsChanged() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String registerNotificationURL(String url) throws RemoteException {
        String id;
        block8: {
            this.initialize();
            id = SMSUtils.getUniqueID();
            try {
                if (!url.toLowerCase().startsWith(serverURL)) {
                    Map map = notificationURLs;
                    synchronized (map) {
                        notificationURLs.put(id, new URL(url));
                    }
                    if (debug.messageEnabled()) {
                        debug.message("SMSJAXRPCObjectImpl:register for notification URL: " + url);
                    }
                    break block8;
                }
                if (debug.warningEnabled()) {
                    debug.warning("SMSJAXRPCObjectImpl:registerURL cannot add local server: " + url);
                }
                id = "0";
            }
            catch (MalformedURLException e) {
                if (!debug.warningEnabled()) break block8;
                debug.warning("SMSJAXRPCObjectImpl:registerNotificationURL  invalid URL: " + url, (Throwable)e);
            }
        }
        return id;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deRegisterNotificationURL(String id) throws RemoteException {
        Map map = notificationURLs;
        synchronized (map) {
            notificationURLs.remove(id);
        }
    }

    public void notifyObjectChanged(String name, int type) throws RemoteException {
        SMSNotificationManager.getInstance().objectChanged(name, type);
    }

    private static String calendarToString(Calendar calendar) {
        int year = calendar.get(1);
        int month = calendar.get(2);
        int date = calendar.get(5);
        int hour = calendar.get(10);
        int minute = calendar.get(12);
        StringBuffer sb = new StringBuffer(200);
        sb.append(serverURL);
        sb.append(":").append(year).append(month).append(date);
        sb.append(hour).append(minute);
        return sb.toString();
    }

    private static SSOToken getToken(String tokenID) throws SSOException {
        if (initializationError != null) {
            throw initializationError;
        }
        return tokenMgr.createSSOToken(tokenID);
    }

    static ModificationItem[] getModItems(String mods) throws SMSException {
        if (debug.messageEnabled()) {
            debug.message("SMSJAXRPCObject::StringToMods: " + mods);
        }
        ModificationItem[] answer = null;
        try {
            if (mods != null) {
                mods = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n" + mods;
                Document doc = XMLUtils.toDOMDocument((String)mods, (Debug)debug);
                Node root = XMLUtils.getRootNode((Document)doc, (String)"Modifications");
                int modsSize = Integer.parseInt(XMLUtils.getNodeAttributeValue((Node)root, (String)"size"));
                answer = new ModificationItem[modsSize];
                NodeList nl = root.getChildNodes();
                for (int i = 0; i < modsSize; ++i) {
                    Node node = nl.item(i);
                    if (!node.getNodeName().equals("AttributeValuePair")) continue;
                    String eventS = XMLUtils.getNodeAttributeValue((Node)node, (String)"event");
                    int event = 1;
                    if (eventS.equals("REPLACE")) {
                        event = 2;
                    } else if (eventS.equals("DELETE")) {
                        event = 3;
                    }
                    Node attrNode = XMLUtils.getChildNode((Node)node, (String)"Attribute");
                    String attrName = XMLUtils.getNodeAttributeValue((Node)attrNode, (String)"name");
                    Set vals = XMLUtils.getAttributeValuePair((Node)node, (boolean)false);
                    BasicAttribute attr = new BasicAttribute(attrName);
                    Iterator it = vals.iterator();
                    while (it.hasNext()) {
                        attr.add(it.next());
                    }
                    answer[i] = new ModificationItem(event, attr);
                }
            }
        }
        catch (Exception e) {
            throw new SMSException(e, "sms-JAXRPC-cannot-copy-fromModStringToModItem");
        }
        return answer;
    }

    static {
        cacheSize = 30;
        cacheIndices = new LinkedList();
        cache = new HashMap(cacheSize);
    }
}

