/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.common.configuration;

import com.iplanet.am.util.SystemProperties;
import com.iplanet.sso.SSOException;
import com.iplanet.sso.SSOToken;
import com.sun.identity.common.configuration.ConfigurationException;
import com.sun.identity.common.configuration.ConfigurationListener;
import com.sun.identity.common.configuration.ConfigurationObserver;
import com.sun.identity.common.configuration.ServerConfiguration;
import com.sun.identity.security.AdminTokenAction;
import com.sun.identity.setup.BootstrapCreator;
import com.sun.identity.shared.debug.Debug;
import com.sun.identity.sm.SMSException;
import java.security.AccessController;

public class ServerConfigXMLObserver
implements ConfigurationListener {
    private static ServerConfigXMLObserver instance;
    private static Debug debug;
    private static String currentXML;

    private ServerConfigXMLObserver() {
    }

    public static ServerConfigXMLObserver getInstance() {
        return instance;
    }

    public void notifyChanges() {
        this.update(false);
    }

    public void update(boolean bForce) {
        SSOToken adminToken = (SSOToken)AccessController.doPrivileged(AdminTokenAction.getInstance());
        try {
            String xml = ServerConfiguration.getServerConfigXML(adminToken, SystemProperties.getServerInstanceName());
            if (bForce) {
                currentXML = null;
            }
            if (currentXML == null || !currentXML.equals(xml)) {
                BootstrapCreator.updateBootstrap();
                currentXML = xml;
            }
        }
        catch (ConfigurationException e) {
            debug.error("ServerConfigXMLObserver.notifyChanges", (Throwable)e);
        }
        catch (SMSException e) {
            debug.error("ServerConfigXMLObserver.notifyChanges", (Throwable)e);
        }
        catch (SSOException e) {
            debug.error("ServerConfigXMLObserver.notifyChanges", (Throwable)((Object)e));
        }
    }

    static {
        debug = Debug.getInstance((String)"amSetupServlet");
        instance = new ServerConfigXMLObserver();
        ConfigurationObserver.getInstance().addListener(instance);
        SSOToken adminToken = (SSOToken)AccessController.doPrivileged(AdminTokenAction.getInstance());
        try {
            currentXML = ServerConfiguration.getServerConfigXML(adminToken, SystemProperties.getServerInstanceName());
        }
        catch (SMSException e) {
            debug.error("ServerConfigXMLObserver.init", (Throwable)e);
        }
        catch (SSOException e) {
            debug.error("ServerConfigXMLObserver.init", (Throwable)((Object)e));
        }
    }
}

