/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.sm.util;

import com.sun.identity.shared.ldap.LDAPAttribute;
import com.sun.identity.shared.ldap.LDAPAttributeSet;
import com.sun.identity.shared.ldap.LDAPConnection;
import com.sun.identity.shared.ldap.LDAPEntry;
import com.sun.identity.shared.ldap.LDAPException;
import com.sun.identity.shared.ldap.LDAPReferralException;
import com.sun.identity.shared.ldap.LDAPSearchResults;
import com.sun.identity.sm.ServiceAlreadyExistsException;
import com.sun.identity.sm.flatfile.SMSFlatFileObject;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;

public class SMSRepositoryMig {
    private static void createSMSEntry(SMSFlatFileObject smsFlatFileObject, String dn, LDAPAttributeSet attrs) throws Exception {
        HashMap attrsMap = new HashMap();
        Enumeration attrsEnum = attrs.getAttributes();
        while (attrsEnum.hasMoreElements()) {
            LDAPAttribute attr = (LDAPAttribute)attrsEnum.nextElement();
            String attrName = attr.getName();
            HashSet<String> attrVals = new HashSet<String>();
            Enumeration valsEnum = attr.getStringValues();
            while (valsEnum.hasMoreElements()) {
                String val = (String)valsEnum.nextElement();
                attrVals.add(val);
            }
            attrsMap.put(attrName, attrVals);
        }
        try {
            smsFlatFileObject.create(null, dn, attrsMap);
        }
        catch (ServiceAlreadyExistsException e) {
            System.out.println("Warning: '" + dn + "' already exists.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void migrate(String host, int port, String binddn, String pw, String basedn, String flatfiledir) throws Exception {
        if (port < 0 || binddn == null || binddn.length() == 0 || pw == null || pw.length() == 0 || basedn == null || basedn.length() == 0 || flatfiledir == null || flatfiledir.length() == 0) {
            throw new IllegalArgumentException("SMSRepositoryMig: One or more invalid arguments in constructor");
        }
        SMSFlatFileObject smsFlatFileObject = new SMSFlatFileObject();
        LDAPConnection conn = null;
        try {
            conn = new LDAPConnection();
            conn.connect(host, port, binddn, pw);
            String[] attrs = new String[]{"*"};
            LDAPSearchResults res = conn.search("ou=services," + basedn, 2, "(objectclass=*)", attrs, false);
            System.out.println("Migrating " + res.getCount() + " results.");
            while (res.hasMoreElements()) {
                LDAPEntry entry = null;
                try {
                    entry = res.next();
                    LDAPAttributeSet attrSet = entry.getAttributeSet();
                    System.out.println(entry.getDN() + ": " + attrSet.size() + " Attributes found.");
                    SMSRepositoryMig.createSMSEntry(smsFlatFileObject, entry.getDN(), attrSet);
                }
                catch (LDAPReferralException e) {
                    System.out.println("ERROR: LDAP Referral not supported.");
                    System.out.println("LDAPReferralException received: " + e.toString());
                    e.printStackTrace();
                }
                catch (LDAPException e) {
                    System.out.println("ERROR: LDAP Exception encountered: " + e.toString());
                    e.printStackTrace();
                }
            }
        }
        finally {
            if (conn != null && conn.isConnected()) {
                try {
                    conn.disconnect();
                }
                catch (LDAPException ex) {}
            }
        }
    }

    private static void usage() {
        System.out.println("Usage: " + SMSRepositoryMig.class.getName() + " <host> <port> <binddn> <password> " + "<orgdn> <flat-file directory>");
    }

    public static void main(String[] args) throws Exception {
        if (args.length < 6) {
            SMSRepositoryMig.usage();
            System.exit(0);
        }
        String host = args[0];
        int port = Integer.parseInt(args[1]);
        String binddn = args[2];
        String pw = args[3];
        String basedn = args[4];
        String flatfiledir = args[5];
        SMSRepositoryMig.migrate(host, port, binddn, pw, basedn, flatfiledir);
    }
}

