/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.tools.patch;

import com.sun.identity.tools.bundles.CopyUtils;
import com.sun.identity.tools.manifest.Manifest;
import com.sun.identity.tools.patch.PatchGeneratorConstants;
import com.sun.identity.tools.patch.PatchGeneratorUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.text.MessageFormat;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.jar.JarFile;

public class Patch
implements PatchGeneratorConstants {
    private String srcFilePath;
    private String destFilePath;
    private String src2FilePath;
    private String stagingFilePath;
    private Manifest firstMan;
    private Manifest origMan;
    private Manifest secondMan;
    private boolean createMode = false;
    private boolean compareMode = false;
    private boolean mergeMode = false;
    private boolean overwriteMode = false;
    private boolean overrideMode = false;
    private File stagingArea;
    private Properties srcManifest;
    private Properties src2Manifest;
    private char wildCard;
    private static Locale locale;
    private static ResourceBundle rbMessages;
    private static Map options;
    private static Map longShortNameMapping;
    private static Set unary;

    private static Locale getLocale(String strLocale) {
        StringTokenizer st = new StringTokenizer(strLocale, "_");
        String lang = st.hasMoreTokens() ? st.nextToken() : "";
        String country = st.hasMoreTokens() ? st.nextToken() : "";
        String variant = st.hasMoreTokens() ? st.nextToken() : "";
        return new Locale(lang, country, variant);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void getProperties() {
        File propFile;
        String propFilePath = System.getProperty("file.properties");
        Properties sysProp = new Properties();
        if (propFilePath != null && (propFile = new File(propFilePath)).exists() && propFile.isFile()) {
            FileInputStream fin = null;
            try {
                fin = new FileInputStream(propFile);
                sysProp.load(fin);
            }
            catch (IOException ex) {
                System.out.println("Error occured when reading file " + propFilePath);
                System.exit(1);
            }
            finally {
                try {
                    if (fin != null) {
                        fin.close();
                    }
                }
                catch (IOException ex) {}
            }
        }
        this.srcFilePath = (String)options.get("--war-file");
        this.destFilePath = (String)options.get("--manifest");
        this.src2FilePath = (String)options.get("--war-file-compare");
        this.stagingFilePath = (String)options.get("--staging");
        this.wildCard = System.getProperty("pattern.wildcard", sysProp.getProperty("pattern.wildcard", "*")).charAt(0);
        if (this.srcFilePath == null) {
            System.out.println(rbMessages.getString("exception-no-src"));
            Patch.printUsage();
            System.exit(1);
        }
        if (this.destFilePath != null && this.src2FilePath != null) {
            System.out.println(rbMessages.getString("exception-bad-args"));
            Patch.printUsage();
            System.exit(1);
        }
        if (this.destFilePath != null) {
            this.createMode = true;
        }
        if (this.src2FilePath != null) {
            this.compareMode = true;
        } else {
            this.src2FilePath = this.srcFilePath;
        }
        if (this.stagingFilePath != null) {
            this.mergeMode = true;
        }
        this.overwriteMode = Patch.isOptionSet("--overwrite");
        this.overrideMode = Patch.isOptionSet("--override");
        this.firstMan = new Manifest();
        this.firstMan.setDefaultProperties();
        this.origMan = new Manifest();
        this.origMan.setDefaultProperties();
        this.secondMan = new Manifest();
        this.secondMan.setDefaultProperties();
    }

    private void compareManifest(Manifest man1, Manifest man2, Manifest orig, String stagingPath) {
        int diffCount = 0;
        int customCount = 0;
        try {
            String key;
            String idSrc = man1.getProperty("identifier");
            String idSrc2 = man2.getProperty("identifier");
            if (stagingPath != null) {
                this.stagingArea = new File(this.stagingFilePath);
                if (this.stagingArea.exists() && !this.overwriteMode) {
                    System.out.println(rbMessages.getString("exception-path-exists"));
                    System.exit(1);
                } else {
                    this.stagingArea.mkdirs();
                }
            }
            if (idSrc != null && idSrc2 != null) {
                System.out.print(rbMessages.getString("patch-compare"));
                if (man1.srcFile == null) {
                    System.out.print("Internal");
                } else {
                    System.out.print(man1.srcFile.getPath());
                }
                System.out.print(" (");
                System.out.print(idSrc);
                System.out.print(") ");
                System.out.print(rbMessages.getString("patch-against"));
                if (man2.srcFile == null) {
                    System.out.print("Internal");
                } else {
                    System.out.print(man2.srcFile.getPath());
                }
                System.out.print(" (");
                System.out.print(idSrc2);
                System.out.print(")\n");
            }
            Enumeration keysEnum = man2.getPropertyNames();
            while (keysEnum.hasMoreElements()) {
                InputStream fileIn;
                JarFile src2War;
                File destFile;
                key = (String)keysEnum.nextElement();
                String hashValue = man2.getProperty(key);
                String srcValue = man1.getProperty(key);
                String origValue = man1.getProperty(key);
                if (orig != null) {
                    origValue = orig.getProperty(key);
                }
                if (key.equals("identifier") || key.equals("META-INF/MANIFEST.MF")) {
                    man1.removeProperty(key);
                    continue;
                }
                if (key.equals("META-INF/OpenSSO.manifest")) {
                    if (this.mergeMode) {
                        destFile = new File(this.stagingArea, key);
                        src2War = new JarFile(man2.srcFile);
                        fileIn = src2War.getInputStream(src2War.getEntry(key));
                        CopyUtils.copyFileFromJar(fileIn, destFile, this.overwriteMode);
                    }
                    man1.removeProperty(key);
                    continue;
                }
                if (srcValue == null && origValue == null) {
                    if (this.mergeMode) {
                        destFile = new File(this.stagingArea, key);
                        src2War = new JarFile(man2.srcFile);
                        fileIn = src2War.getInputStream(src2War.getEntry(key));
                        CopyUtils.copyFileFromJar(fileIn, destFile, this.overwriteMode);
                        continue;
                    }
                    ++diffCount;
                    System.out.print(rbMessages.getString("patch-new"));
                    System.out.print("(");
                    System.out.print(key);
                    System.out.print(")\n");
                    continue;
                }
                if (srcValue == null && origValue != null) {
                    ++diffCount;
                    System.out.print(rbMessages.getString("patch-missing"));
                    System.out.print("(");
                    System.out.print(key);
                    System.out.print(")\n");
                    continue;
                }
                if (srcValue != null && origValue == null) {
                    ++diffCount;
                    System.out.print(rbMessages.getString("patch-not-in-manifest"));
                    man1.removeProperty(key);
                    if (this.mergeMode) {
                        destFile = new File(this.stagingArea, key);
                        src2War = new JarFile(man2.srcFile);
                        fileIn = src2War.getInputStream(src2War.getEntry(key));
                        CopyUtils.copyFileFromJar(fileIn, destFile, this.overwriteMode);
                        System.out.print(rbMessages.getString("patch-from-new"));
                    }
                    System.out.print("(");
                    System.out.print(key);
                    System.out.print(")\n");
                    continue;
                }
                if (srcValue.equals(origValue)) {
                    man1.removeProperty(key);
                    if (this.mergeMode) {
                        destFile = new File(this.stagingArea, key);
                        src2War = new JarFile(man2.srcFile);
                        fileIn = src2War.getInputStream(src2War.getEntry(key));
                        CopyUtils.copyFileFromJar(fileIn, destFile, this.overwriteMode);
                    }
                    if (hashValue.equals(srcValue)) continue;
                    ++diffCount;
                    if (this.mergeMode) continue;
                    System.out.print(rbMessages.getString("patch-modified"));
                    System.out.print("(");
                    System.out.print(key);
                    System.out.print(")\n");
                    continue;
                }
                if (origValue.equals(hashValue) && !origValue.equals(srcValue)) {
                    ++diffCount;
                    ++customCount;
                    man1.removeProperty(key);
                    System.out.print(rbMessages.getString("patch-customized"));
                    if (this.mergeMode) {
                        System.out.print(rbMessages.getString("patch-from-orig"));
                        destFile = new File(this.stagingArea, key);
                        src2War = new JarFile(man1.srcFile);
                        fileIn = src2War.getInputStream(src2War.getEntry(key));
                        CopyUtils.copyFileFromJar(fileIn, destFile, this.overwriteMode);
                    }
                    System.out.print("(");
                    System.out.print(key);
                    System.out.print(")\n");
                    continue;
                }
                ++diffCount;
                ++customCount;
                man1.removeProperty(key);
                System.out.print(rbMessages.getString("patch-need-custom"));
                if (this.mergeMode) {
                    System.out.print(rbMessages.getString("patch-from-new"));
                    destFile = new File(this.stagingArea, key);
                    src2War = new JarFile(man2.srcFile);
                    fileIn = src2War.getInputStream(src2War.getEntry(key));
                    CopyUtils.copyFileFromJar(fileIn, destFile, this.overwriteMode);
                }
                System.out.print("(");
                System.out.print(key);
                System.out.print(")\n");
            }
            if (orig != null) {
                keysEnum = man1.getPropertyNames();
                while (keysEnum.hasMoreElements()) {
                    key = (String)keysEnum.nextElement();
                    String srcValue = man1.getProperty(key);
                    String origValue = orig.getProperty(key);
                    if (key == null || key.equals("META-INF/OpenSSO.manifest") || origValue != null && key.equals(origValue)) continue;
                    if (origValue == null) {
                        System.out.print(rbMessages.getString("patch-added"));
                    } else {
                        System.out.print(rbMessages.getString("patch-custom-rm"));
                    }
                    if (this.mergeMode) {
                        System.out.print(rbMessages.getString("patch-from-orig"));
                        File destFile = new File(this.stagingArea, key);
                        JarFile src2War = new JarFile(man1.srcFile);
                        InputStream fileIn = src2War.getInputStream(src2War.getEntry(key));
                        CopyUtils.copyFileFromJar(fileIn, destFile, this.overwriteMode);
                    }
                    System.out.print("(");
                    System.out.print(key);
                    System.out.print(")\n");
                    ++diffCount;
                }
            }
            if (diffCount == 0) {
                System.out.println(rbMessages.getString("patch-identical"));
            } else {
                System.out.print(rbMessages.getString("patch-diff"));
                System.out.println(diffCount);
                System.out.print(rbMessages.getString("patch-custom"));
                System.out.println(customCount);
            }
        }
        catch (Exception ex) {
            System.out.println(rbMessages.getString("exception-read-error"));
            System.exit(1);
        }
    }

    private boolean createManifest(Manifest man, String srcFilePath, String destFilePath) {
        return man.createManifest(srcFilePath, destFilePath, null, true, true);
    }

    public void processPatch() {
        try {
            if (this.stagingFilePath != null) {
                this.stagingArea = new File(this.stagingFilePath);
                if (this.stagingArea.exists() && !this.overwriteMode) {
                    System.out.println(rbMessages.getString("exception-path-exists"));
                    System.exit(1);
                }
            }
            System.out.print(rbMessages.getString("patch-generating"));
            System.out.print(this.srcFilePath);
            System.out.print("\n");
            if (!this.createManifest(this.firstMan, this.srcFilePath, null)) {
                System.out.println(rbMessages.getString("exception-no-create"));
                System.exit(1);
            }
            File srcFile = new File(this.srcFilePath);
            JarFile srcWar = new JarFile(srcFile);
            this.origMan.setProperties(PatchGeneratorUtils.getManifest(srcWar, "META-INF/OpenSSO.manifest", this.wildCard));
            String id = this.origMan.getProperty("identifier");
            if (id == null) {
                System.out.println(rbMessages.getString("exception-no-manifest"));
                System.exit(1);
            }
            if (this.compareMode) {
                String[] express_bld;
                File src2File = new File(this.src2FilePath);
                JarFile src2War = new JarFile(src2File);
                this.secondMan.setProperties(PatchGeneratorUtils.getManifest(src2War, "META-INF/OpenSSO.manifest", this.wildCard));
                String id2 = this.secondMan.getProperty("identifier");
                if (id2 == null) {
                    System.out.println(rbMessages.getString("exception-no-manifest"));
                    System.exit(1);
                }
                System.out.print(rbMessages.getString("patch-original"));
                System.out.print(id);
                System.out.print("\n");
                System.out.print(rbMessages.getString("patch-new"));
                System.out.print(id2);
                System.out.print("\n");
                String[] result = id.split("\\s|\\(|\\)|\\.");
                String[] result2 = id2.split("\\s|\\(|\\)|\\.");
                boolean is_compatible = false;
                int vers = 0;
                int rev = 0;
                int build = 0;
                int update = 0;
                long date = 0L;
                int vers2 = 0;
                int rev2 = 0;
                int build2 = 0;
                int update2 = 0;
                long date2 = 0L;
                date = Long.parseLong(result[result.length - 1]);
                if (result[0].equals("Enterprise")) {
                    if (result.length > 5) {
                        vers = Integer.parseInt(result[1]);
                        rev = Integer.parseInt(result[2]);
                        if (result[3].equals("Build")) {
                            build = Integer.parseInt(result[4]);
                        } else if (result[3].equals("Update")) {
                            update = Integer.parseInt(result[4]);
                        }
                    }
                } else if (result[0].equals("Express") && result.length >= 3 && result[1].equals("Build")) {
                    if (!result[2].matches("[0-9]*[a-z]")) {
                        build = Integer.parseInt(result[2]);
                    } else {
                        express_bld = result[2].split("[a-z]");
                        build = Integer.parseInt(express_bld[0]);
                    }
                }
                date2 = Long.parseLong(result2[result2.length - 1]);
                if (result2[0].equals("Enterprise")) {
                    if (result2.length > 5) {
                        vers2 = Integer.parseInt(result2[1]);
                        rev2 = Integer.parseInt(result2[2]);
                        if (result2[3].equals("Build")) {
                            build2 = Integer.parseInt(result2[4]);
                        } else if (result2[3].equals("Update")) {
                            update2 = Integer.parseInt(result2[4]);
                        }
                    }
                } else if (result2[0].equals("Express") && result2.length >= 3 && result2[1].equals("Build")) {
                    if (!result2[2].matches("[0-9]*[a-z]")) {
                        build2 = Integer.parseInt(result2[2]);
                    } else {
                        express_bld = result2[2].split("[a-z]");
                        build2 = Integer.parseInt(express_bld[0]);
                    }
                }
                if (result[0].equals(result2[0]) && vers == vers2 && rev == rev2 && date <= date2 && (build <= build2 || update <= update2)) {
                    is_compatible = true;
                }
                if (is_compatible) {
                    System.out.println(rbMessages.getString("patch-supported"));
                } else {
                    System.out.println(rbMessages.getString("patch-not-supported"));
                    if (!this.overrideMode) {
                        System.out.println(rbMessages.getString("patch-override"));
                        System.exit(1);
                    }
                }
                System.out.print(rbMessages.getString("patch-generating"));
                System.out.print(this.src2FilePath);
                System.out.print("\n");
                if (!this.createManifest(this.secondMan, this.src2FilePath, null)) {
                    System.out.println(rbMessages.getString("exception-no-create"));
                    System.exit(1);
                }
                this.compareManifest(this.firstMan, this.secondMan, this.origMan, this.stagingFilePath);
            } else {
                this.compareManifest(this.origMan, this.firstMan, null, null);
            }
        }
        catch (Exception ex) {
            System.out.println(rbMessages.getString("exception-read-error"));
            System.exit(1);
        }
    }

    public static void main(String[] args) {
        Patch patch = new Patch();
        Patch.getOptions(args);
        patch.getProperties();
        if (patch.createMode) {
            patch.createManifest(patch.firstMan, patch.srcFilePath, patch.destFilePath);
        } else {
            patch.processPatch();
        }
    }

    private static void printUsage() {
        System.out.println(rbMessages.getString("usage"));
    }

    private static void getOptions(String[] args) {
        String strLocale;
        String currentOpt = null;
        String invalidOpt = null;
        boolean incorrectFormat = false;
        for (int i = 0; i < args.length; ++i) {
            String s = args[i];
            if (s.startsWith("--")) {
                if (!longShortNameMapping.keySet().contains(s)) {
                    invalidOpt = s;
                }
                if (currentOpt != null) {
                    options.put(currentOpt, "");
                }
                currentOpt = s;
                continue;
            }
            if (s.startsWith("-")) {
                String longName = Patch.getLongName(s);
                if (longName == null) {
                    invalidOpt = s;
                }
                if (currentOpt != null) {
                    options.put(currentOpt, "");
                }
                currentOpt = longName;
                continue;
            }
            if (currentOpt == null || unary.contains(currentOpt)) {
                incorrectFormat = true;
                continue;
            }
            options.put(currentOpt, s);
            currentOpt = null;
        }
        if (currentOpt != null) {
            if (unary.contains(currentOpt)) {
                options.put(currentOpt, "");
            } else {
                incorrectFormat = true;
            }
        }
        if ((strLocale = (String)options.remove("--locale")) != null && strLocale.length() > 0) {
            locale = Patch.getLocale(strLocale);
        }
        if (locale == null) {
            locale = Locale.getDefault();
        }
        try {
            rbMessages = ResourceBundle.getBundle("ssoPatch", locale);
        }
        catch (MissingResourceException e) {
            System.out.print("Resource file not found.\n");
            System.exit(1);
        }
        boolean bHelp = Patch.isOptionSet("--help");
        if (invalidOpt != null) {
            Object[] a = new Object[]{invalidOpt};
            System.out.print(MessageFormat.format(rbMessages.getString("invalid-option"), a));
            System.out.println();
            Patch.printUsage();
            System.exit(1);
        }
        if (incorrectFormat || bHelp && options.size() > 1) {
            System.out.print(rbMessages.getString("incorrect-format"));
            System.out.println();
            Patch.printUsage();
            System.exit(1);
        }
        if (bHelp) {
            System.out.println();
            Patch.printUsage();
            System.exit(0);
        }
    }

    private static boolean isOptionSet(String optName) {
        String str = (String)options.get(optName);
        return str != null;
    }

    private static String getLongName(String s) {
        for (String longName : longShortNameMapping.keySet()) {
            String shortName = (String)longShortNameMapping.get(longName);
            if (!s.equals(shortName)) continue;
            return longName;
        }
        return null;
    }

    static {
        options = new HashMap();
        longShortNameMapping = new HashMap();
        unary = new HashSet();
        longShortNameMapping.put("--help", "-?");
        longShortNameMapping.put("--war-file", "-o");
        longShortNameMapping.put("--manifest", "-m");
        longShortNameMapping.put("--war-file-compare", "-c");
        longShortNameMapping.put("--staging", "-s");
        longShortNameMapping.put("--locale", "-l");
        longShortNameMapping.put("--override", "-r");
        longShortNameMapping.put("--overwrite", "-w");
        unary.add("--help");
        unary.add("--override");
        unary.add("--overwrite");
    }
}

