/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.cli;

import com.iplanet.sso.SSOException;
import com.iplanet.sso.SSOToken;
import com.sun.identity.cli.AuthenticatedCommand;
import com.sun.identity.cli.CLIException;
import com.sun.identity.cli.CommandManager;
import com.sun.identity.cli.RequestContext;
import com.sun.identity.common.ISResourceBundle;
import com.sun.identity.sm.SMSException;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.logging.Level;

public class AddResourceBundle
extends AuthenticatedCommand {
    static final String ARGUMENT_RESOURCE_BUNDLE_FILE_NAME = "bundlefilename";

    public void handleRequest(RequestContext rc) throws CLIException {
        super.handleRequest(rc);
        this.ldapLogin();
        SSOToken adminSSOToken = this.getAdminSSOToken();
        String bundleName = this.getStringOptionValue("bundlename");
        String fileName = this.getStringOptionValue(ARGUMENT_RESOURCE_BUNDLE_FILE_NAME);
        String localeName = this.getStringOptionValue("bundlelocale");
        try {
            String[] params = new String[]{bundleName, fileName, localeName};
            this.writeLog(0, Level.INFO, "ATTEMPT_ADD_RESOURCE_BUNDLE", params);
            CommandManager mgr = this.getCommandManager();
            String url = mgr.getWebEnabledURL();
            if (url != null) {
                params[1] = "web-input";
            }
            Map mapStrings = url != null ? this.getResourceStringsMap(new StringReader(fileName)) : this.getResourceStringsMap(new FileReader(fileName));
            ISResourceBundle.storeResourceBundle(adminSSOToken, bundleName, localeName, mapStrings);
            this.getOutputWriter().printlnMessage(this.getResourceString("resourcebundle-added"));
            this.writeLog(0, Level.INFO, "SUCCEED_ADD_RESOURCE_BUNDLE", params);
        }
        catch (SSOException e) {
            String[] args = new String[]{bundleName, fileName, localeName, e.getMessage()};
            this.writeLog(0, Level.INFO, "FAILED_ADD_RESOURCE_BUNDLE", args);
            throw new CLIException((Throwable)((Object)e), 127);
        }
        catch (IOException e) {
            String[] args = new String[]{bundleName, fileName, localeName, e.getMessage()};
            this.writeLog(0, Level.INFO, "FAILED_ADD_RESOURCE_BUNDLE", args);
            throw new CLIException(e, 127);
        }
        catch (SMSException e) {
            String[] args = new String[]{bundleName, fileName, localeName, e.getMessage()};
            this.writeLog(0, Level.INFO, "FAILED_ADD_RESOURCE_BUNDLE", args);
            throw new CLIException(e, 127);
        }
    }

    private Map getResourceStringsMap(Reader reader) throws CLIException {
        BufferedReader in = null;
        HashMap resourceStrings = new HashMap();
        try {
            boolean commented = false;
            in = new BufferedReader(reader);
            String line = in.readLine();
            while (line != null) {
                String key;
                int idx;
                if ((line = line.trim()).startsWith("/*")) {
                    commented = true;
                } else if (line.endsWith("*/")) {
                    commented = false;
                } else if (!line.startsWith("#") && !commented && (idx = line.indexOf(61)) != -1 && (key = line.substring(0, idx).trim()).length() > 0) {
                    HashSet<String> tmp = new HashSet<String>(2);
                    String value = line.substring(idx + 1).trim();
                    tmp.add(value);
                    resourceStrings.put(key, tmp);
                }
                line = in.readLine();
            }
        }
        catch (IOException e) {
            throw new CLIException(e, 24);
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException e) {
                    throw new CLIException(e, 24);
                }
            }
        }
        return resourceStrings;
    }
}

