/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.console.service;

import com.iplanet.jato.model.ModelControlException;
import com.iplanet.jato.view.ContainerView;
import com.iplanet.jato.view.ContainerViewBase;
import com.iplanet.jato.view.View;
import com.iplanet.jato.view.ViewBean;
import com.iplanet.jato.view.event.DisplayEvent;
import com.iplanet.jato.view.event.RequestInvocationEvent;
import com.sun.identity.console.base.AMPrimaryMastHeadViewBean;
import com.sun.identity.console.base.AMViewBeanBase;
import com.sun.identity.console.base.AMViewConfig;
import com.sun.identity.console.base.model.AMConsoleException;
import com.sun.identity.console.base.model.AMModel;
import com.sun.identity.console.components.view.html.SerializedField;
import com.sun.identity.console.service.ServerAddViewBean;
import com.sun.identity.console.service.ServerCloneViewBean;
import com.sun.identity.console.service.SiteAddViewBean;
import com.sun.identity.console.service.SiteEditViewBean;
import com.sun.identity.console.service.model.ServerSiteModel;
import com.sun.identity.console.service.model.ServerSiteModelImpl;
import com.sun.web.ui.model.CCActionTableModel;
import com.sun.web.ui.model.CCActionTableModelInterface;
import com.sun.web.ui.model.CCPageTitleModel;
import com.sun.web.ui.model.CCPageTitleModelInterface;
import com.sun.web.ui.view.html.CCButton;
import com.sun.web.ui.view.pagetitle.CCPageTitle;
import com.sun.web.ui.view.table.CCActionTable;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import javax.servlet.http.HttpServletRequest;

public class ServerSiteViewBean
extends AMPrimaryMastHeadViewBean {
    private static final String DEFAULT_DISPLAY_URL = "/console/service/ServerSite.jsp";
    private static final String BTN_DEFAULT_SERVER = "btnDefaultSettings";
    private static final String TBL_SERVERS = "tblServer";
    private static final String TBL_SERVER_BUTTON_ADD = "tblServerButtonAdd";
    private static final String TBL_SERVER_BUTTON_CLONE = "tblServerButtonClone";
    private static final String TBL_SERVER_BUTTON_DELETE = "tblServerButtonDelete";
    private static final String TBL_COL_SERVER_NAME = "tblColServerName";
    private static final String TBL_DATA_SERVER_ACTION_HREF = "tblDataServerActionHref";
    private static final String TBL_DATA_SERVER_NAME = "tblDataServerName";
    private static final String TBL_COL_SITE = "tblColSite";
    private static final String TBL_DATA_SITE = "tblDataSite";
    private static final String TBL_SITES = "tblSite";
    private static final String TBL_SITE_BUTTON_ADD = "tblSiteButtonAdd";
    private static final String TBL_SITE_BUTTON_DELETE = "tblSiteButtonDelete";
    private static final String TBL_COL_SITE_NAME = "tblColSiteName";
    private static final String TBL_DATA_SITE_ACTION_HREF = "tblDataSiteActionHref";
    private static final String TBL_DATA_SITE_NAME = "tblDataSiteName";
    private static final String TBL_COL_SITE_URL = "tblColSiteURL";
    private static final String TBL_DATA_SITE_URL = "tblDataSiteURL";
    private static final String TBL_COL_SITE_SERVERS = "tblColSiteServers";
    private static final String TBL_DATA_SITE_SERVERS = "tblDataSiteServers";
    private static final String SZ_CACHE_1 = "szCache1";
    private static final String SZ_CACHE_SERVER = "szCacheServer";
    private static final String SZ_CACHE_SITE = "szCacheSite";
    private static final String PAGETITLE = "pgtitle";
    private CCActionTableModel tblServerModel;
    private CCActionTableModel tblSiteModel;
    private CCPageTitleModel ptModel;

    public ServerSiteViewBean() {
        super("ServerSite");
        this.setDefaultDisplayURL(DEFAULT_DISPLAY_URL);
        this.createTableModel();
        this.ptModel = new CCPageTitleModel(((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream("com/sun/identity/console/simplePageTitle.xml"));
        this.registerChildren();
    }

    protected void registerChildren() {
        super.registerChildren();
        this.registerChild(SZ_CACHE_1, SerializedField.class);
        this.registerChild(SZ_CACHE_SERVER, SerializedField.class);
        this.registerChild(SZ_CACHE_SITE, SerializedField.class);
        this.registerChild(PAGETITLE, CCPageTitle.class);
        this.registerChild(TBL_SERVERS, CCActionTable.class);
        this.registerChild(TBL_SITES, CCActionTable.class);
        this.registerChild(BTN_DEFAULT_SERVER, CCButton.class);
        this.ptModel.registerChildren((ContainerViewBase)this);
        this.tblServerModel.registerChildren((ContainerViewBase)this);
        this.tblSiteModel.registerChildren((ContainerViewBase)this);
    }

    protected View createChild(String name) {
        Object view = null;
        if (name.equals(TBL_SERVERS)) {
            SerializedField szCache = (SerializedField)this.getChild(SZ_CACHE_SERVER);
            this.populateServerTableModel((Map)szCache.getSerializedObj());
            view = new CCActionTable((ContainerView)this, (CCActionTableModelInterface)this.tblServerModel, name);
        } else if (name.equals(TBL_SITES)) {
            SerializedField szCache = (SerializedField)this.getChild(SZ_CACHE_SITE);
            this.populateSiteTableModel((Map)szCache.getSerializedObj());
            view = new CCActionTable((ContainerView)this, (CCActionTableModelInterface)this.tblSiteModel, name);
        } else {
            view = name.equals(PAGETITLE) ? new CCPageTitle((ContainerView)this, (CCPageTitleModelInterface)this.ptModel, name) : (this.tblSiteModel.isChildSupported(name) ? this.tblSiteModel.createChild((View)this, name) : (this.tblServerModel.isChildSupported(name) ? this.tblServerModel.createChild((View)this, name) : super.createChild(name)));
        }
        return view;
    }

    public void beginDisplay(DisplayEvent event) throws ModelControlException {
        super.beginDisplay(event);
        this.resetButtonState(TBL_SERVER_BUTTON_DELETE);
        this.resetButtonState(TBL_SERVER_BUTTON_CLONE);
        this.resetButtonState(TBL_SITE_BUTTON_DELETE);
        this.getSiteNames();
        this.getServerNames();
    }

    protected AMModel getModelInternal() {
        HttpServletRequest req = this.getRequestContext().getRequest();
        return new ServerSiteModelImpl(req, this.getPageSessionAttributes());
    }

    private void createTableModel() {
        this.tblSiteModel = new CCActionTableModel(((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream("com/sun/identity/console/tblSite.xml"));
        this.tblSiteModel.setTitleLabel("label.items");
        this.tblSiteModel.setActionValue(TBL_SITE_BUTTON_ADD, (Object)"table.site.button.new");
        this.tblSiteModel.setActionValue(TBL_SITE_BUTTON_DELETE, (Object)"table.site.button.delete");
        this.tblSiteModel.setActionValue(TBL_COL_SITE_NAME, (Object)"table.site.name.column.name");
        this.tblSiteModel.setActionValue(TBL_COL_SITE_URL, (Object)"table.site.url.column.name");
        this.tblSiteModel.setActionValue(TBL_COL_SITE_SERVERS, (Object)"table.site.servers.column.name");
        this.tblServerModel = new CCActionTableModel(((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream("com/sun/identity/console/tblServer.xml"));
        this.tblServerModel.setTitleLabel("label.items");
        this.tblServerModel.setActionValue(TBL_SERVER_BUTTON_ADD, (Object)"table.server.button.new");
        this.tblServerModel.setActionValue(TBL_SERVER_BUTTON_DELETE, (Object)"table.server.button.delete");
        this.tblServerModel.setActionValue(TBL_SERVER_BUTTON_CLONE, (Object)"table.server.button.clone");
        this.tblServerModel.setActionValue(TBL_COL_SERVER_NAME, (Object)"table.server.name.column.name");
        this.tblServerModel.setActionValue(TBL_COL_SITE, (Object)"table.server.site.column.name");
    }

    private void getSiteNames() {
        ServerSiteModel model = (ServerSiteModel)this.getModel();
        try {
            Set sites = model.getSiteNames();
            HashMap<String, String[]> map = new HashMap<String, String[]>(sites.size() * 2);
            for (String site : sites) {
                String[] params = new String[2];
                params[0] = model.getSitePrimaryURL(site);
                Set assignedServers = model.getSiteServers(site);
                if (assignedServers != null && !assignedServers.isEmpty()) {
                    TreeSet set = new TreeSet();
                    set.addAll(assignedServers);
                    StringBuffer buff = new StringBuffer();
                    Iterator j = set.iterator();
                    while (j.hasNext()) {
                        buff.append((String)j.next()).append("<br />");
                    }
                    params[1] = buff.toString();
                } else {
                    params[1] = "";
                }
                map.put(site, params);
            }
            this.populateSiteTableModel(map);
        }
        catch (AMConsoleException e) {
            this.setInlineAlertMessage("error", "message.error", e.getMessage());
        }
    }

    private void getServerNames() {
        ServerSiteModel model = (ServerSiteModel)this.getModel();
        try {
            Set servers = model.getServerNames();
            HashMap<String, String> map = new HashMap<String, String>(servers.size() * 2);
            for (String server : servers) {
                map.put(server, model.getServerSite(server));
            }
            this.populateServerTableModel(map);
        }
        catch (AMConsoleException e) {
            this.setInlineAlertMessage("error", "message.error", e.getMessage());
        }
    }

    private void populateSiteTableModel(Map siteToURL) {
        this.tblSiteModel.clearAll();
        SerializedField szCache = (SerializedField)this.getChild(SZ_CACHE_1);
        SerializedField szCacheSite = (SerializedField)this.getChild(SZ_CACHE_SITE);
        ServerSiteModel model = (ServerSiteModel)this.getModel();
        this.tblServerModel.setMaxRows(model.getPageSize());
        HashMap<String, String[]> cacheSite = new HashMap<String, String[]>();
        ArrayList<String> cache = new ArrayList<String>();
        if (siteToURL != null && !siteToURL.isEmpty()) {
            int counter = 0;
            Iterator iter = siteToURL.keySet().iterator();
            while (iter.hasNext()) {
                if (counter > 0) {
                    this.tblSiteModel.appendRow();
                }
                String name = (String)iter.next();
                String[] params = (String[])siteToURL.get(name);
                String url = params[0];
                String assigned = params[1];
                this.tblSiteModel.setValue(TBL_DATA_SITE_ACTION_HREF, (Object)ServerSiteViewBean.stringToHex(name));
                this.tblSiteModel.setValue(TBL_DATA_SITE_NAME, (Object)name);
                this.tblSiteModel.setValue(TBL_DATA_SITE_URL, (Object)url);
                this.tblSiteModel.setValue(TBL_DATA_SITE_SERVERS, (Object)assigned);
                this.tblSiteModel.setSelectionVisible(counter, true);
                cacheSite.put(name, params);
                cache.add(name);
                ++counter;
            }
            szCacheSite.setValue(cacheSite);
            szCache.setValue(cache);
        } else {
            szCache.setValue(null);
            szCacheSite.setValue(null);
        }
    }

    private void populateServerTableModel(Map serverToSite) {
        this.tblServerModel.clearAll();
        SerializedField szCache = (SerializedField)this.getChild("szCache");
        SerializedField szCacheServer = (SerializedField)this.getChild(SZ_CACHE_SERVER);
        ServerSiteModel model = (ServerSiteModel)this.getModel();
        this.tblServerModel.setMaxRows(model.getPageSize());
        int counter = 0;
        HashMap<String, String> cacheServer = new HashMap<String, String>();
        ArrayList<String> cache = new ArrayList<String>();
        if (serverToSite != null && !serverToSite.isEmpty()) {
            Iterator iter = serverToSite.keySet().iterator();
            while (iter.hasNext()) {
                if (counter > 0) {
                    this.tblServerModel.appendRow();
                }
                String name = (String)iter.next();
                String siteName = (String)serverToSite.get(name);
                this.tblServerModel.setValue(TBL_DATA_SERVER_ACTION_HREF, (Object)name);
                this.tblServerModel.setValue(TBL_DATA_SERVER_NAME, (Object)name);
                this.tblServerModel.setValue(TBL_DATA_SITE, (Object)siteName);
                this.tblServerModel.setSelectionVisible(counter, true);
                cacheServer.put(name, siteName);
                cache.add(name);
                ++counter;
            }
            szCache.setValue(cache);
            szCacheServer.setValue(cacheServer);
        } else {
            szCache.setValue(null);
        }
    }

    public void handleTblSiteButtonAddRequest(RequestInvocationEvent event) {
        SiteAddViewBean vb = (SiteAddViewBean)this.getViewBean(SiteAddViewBean.class);
        this.unlockPageTrail();
        this.passPgSessionMap((ViewBean)vb);
        vb.forwardTo(this.getRequestContext());
    }

    public void handleTblServerButtonCloneRequest(RequestInvocationEvent event) throws ModelControlException {
        CCActionTable table = (CCActionTable)this.getChild(TBL_SERVERS);
        table.restoreStateData();
        Integer[] selected = this.tblServerModel.getSelectedRows();
        SerializedField szCache = (SerializedField)this.getChild("szCache");
        List list = (List)szCache.getSerializedObj();
        String serverName = (String)list.get(selected[0]);
        ServerCloneViewBean vb = (ServerCloneViewBean)this.getViewBean(ServerCloneViewBean.class);
        this.unlockPageTrail();
        this.setPageSessionAttribute("pgAttrServerName", (Serializable)((Object)serverName));
        this.passPgSessionMap((ViewBean)vb);
        vb.forwardTo(this.getRequestContext());
    }

    public void handleTblServerButtonAddRequest(RequestInvocationEvent event) {
        ServerAddViewBean vb = (ServerAddViewBean)this.getViewBean(ServerAddViewBean.class);
        this.unlockPageTrail();
        this.passPgSessionMap((ViewBean)vb);
        vb.forwardTo(this.getRequestContext());
    }

    public void handleTblServerButtonDeleteRequest(RequestInvocationEvent event) throws ModelControlException {
        CCActionTable table = (CCActionTable)this.getChild(TBL_SERVERS);
        table.restoreStateData();
        Integer[] selected = this.tblServerModel.getSelectedRows();
        SerializedField szCache = (SerializedField)this.getChild("szCache");
        List list = (List)szCache.getSerializedObj();
        HashSet<String> names = new HashSet<String>(selected.length * 2);
        for (int i = 0; i < selected.length; ++i) {
            String name = (String)list.get(selected[i]);
            names.add(name);
        }
        try {
            ServerSiteModel model = (ServerSiteModel)this.getModel();
            model.deleteServers(names);
            if (selected.length == 1) {
                this.setInlineAlertMessage("info", "message.information", "serverconfig.message.deleted");
            } else {
                this.setInlineAlertMessage("info", "message.information", "serverconfig.message.deleted.pural");
            }
        }
        catch (AMConsoleException e) {
            this.setInlineAlertMessage("error", "message.error", e.getMessage());
        }
        this.forwardTo();
    }

    public void handleTblSiteButtonDeleteRequest(RequestInvocationEvent event) throws ModelControlException {
        CCActionTable table = (CCActionTable)this.getChild(TBL_SITES);
        table.restoreStateData();
        Integer[] selected = this.tblSiteModel.getSelectedRows();
        SerializedField szCache = (SerializedField)this.getChild(SZ_CACHE_1);
        List list = (List)szCache.getSerializedObj();
        HashSet<String> names = new HashSet<String>(selected.length * 2);
        for (int i = 0; i < selected.length; ++i) {
            String name = (String)list.get(selected[i]);
            names.add(name);
        }
        try {
            ServerSiteModel model = (ServerSiteModel)this.getModel();
            model.deleteSites(names);
            if (selected.length == 1) {
                this.setInlineAlertMessage("info", "message.information", "siteconfig.message.deleted");
            } else {
                this.setInlineAlertMessage("info", "message.information", "siteconfig.message.deleted.pural");
            }
        }
        catch (AMConsoleException e) {
            this.setInlineAlertMessage("error", "message.error", e.getMessage());
        }
        this.forwardTo();
    }

    public void handleTblDataSiteActionHrefRequest(RequestInvocationEvent event) throws ModelControlException {
        String siteName = ServerSiteViewBean.hexToString((String)this.getDisplayFieldValue(TBL_DATA_SITE_ACTION_HREF));
        this.setPageSessionAttribute("pgAttrSiteName", (Serializable)((Object)siteName));
        SiteEditViewBean vb = (SiteEditViewBean)this.getViewBean(SiteEditViewBean.class);
        this.unlockPageTrail();
        this.passPgSessionMap((ViewBean)vb);
        vb.forwardTo(this.getRequestContext());
    }

    public void handleTblDataServerActionHrefRequest(RequestInvocationEvent event) throws ModelControlException {
        String serverName = (String)this.getDisplayFieldValue(TBL_DATA_SERVER_ACTION_HREF);
        this.forwardToServerProfilePage(serverName);
    }

    private void forwardToServerProfilePage(String serverName) {
        this.setPageSessionAttribute("pgAttrServerName", (Serializable)((Object)serverName));
        String tabIdx = (String)this.getPageSessionAttribute("CCTabs.serverConfig");
        int idxTab = 421;
        if (tabIdx != null) {
            idxTab = Integer.parseInt(tabIdx);
        }
        AMViewConfig config = AMViewConfig.getInstance();
        try {
            AMViewBeanBase vb = config.getTabViewBean(this, "/", this.getModel(), "cscGeneral", idxTab, -1);
            this.unlockPageTrail();
            this.passPgSessionMap((ViewBean)vb);
            vb.forwardTo(this.getRequestContext());
        }
        catch (AMConsoleException e) {
            this.setInlineAlertMessage("error", "message.error", e.getMessage());
        }
    }

    public void handleBtnDefaultSettingsRequest(RequestInvocationEvent event) {
        this.forwardToServerProfilePage("server-default");
    }

    protected String getBreadCrumbDisplayName() {
        return "breadcrumbs.server.config";
    }
}

