/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.liberty.ws.interaction;

import com.iplanet.services.naming.WebtopNaming;
import com.sun.identity.common.SystemConfigurationUtil;
import com.sun.identity.liberty.ws.interaction.InteractionConfig;
import com.sun.identity.shared.debug.Debug;
import java.util.Set;

public class SiteAwareInteractionConfig
extends InteractionConfig {
    private static Debug debug = Debug.getInstance((String)"libIDWSF");

    public SiteAwareInteractionConfig() {
        if (debug.messageEnabled()) {
            debug.message("SiteAwareInteractionConfig: constructor called");
        }
        this.initialize();
    }

    public void initialize() {
        debug.message("SiteAwareInteractionConfig.initialise(): called");
        super.initialize();
        String protocol = SystemConfigurationUtil.getProperty((String)"com.iplanet.am.server.protocol");
        String host = SystemConfigurationUtil.getProperty((String)"com.iplanet.am.server.host");
        String port = SystemConfigurationUtil.getProperty((String)"com.iplanet.am.server.port");
        String contextPath = SystemConfigurationUtil.getProperty((String)"com.iplanet.am.services.deploymentDescriptor");
        if (debug.messageEnabled()) {
            debug.message("SiteAwareInteractionConfig.initialise():server protocol: " + protocol + ", server host:" + host + ", server port:" + port + ", contextPath:" + contextPath);
        }
        try {
            String serverId2 = WebtopNaming.getServerID((String)protocol, (String)host, (String)port, (String)contextPath);
            String server = WebtopNaming.getServerFromID((String)serverId2);
            this.wspRedirectHandler = server + "/" + "WSPRedirectHandler";
            boolean siteEnabled = WebtopNaming.isSiteEnabled((String)protocol, (String)host, (String)port, (String)contextPath);
            if (debug.messageEnabled()) {
                debug.message("SiteAwareInteractionConfig.initialise():server id:" + serverId2 + ", server:" + server + ",siteEnabled:" + siteEnabled);
            }
            if (siteEnabled) {
                String siteId = WebtopNaming.getSiteID((String)serverId2);
                this.lbWspRedirectHandler = WebtopNaming.getServerFromID((String)siteId) + "/" + "WSPRedirectHandler";
                Set siteNodes = WebtopNaming.getSiteNodes((String)siteId);
                this.trustedWspRedirectHandlers.clear();
                if (siteNodes != null && !siteNodes.isEmpty()) {
                    for (String serverId2 : siteNodes) {
                        this.trustedWspRedirectHandlers.put(serverId2, WebtopNaming.getServerFromID((String)serverId2) + "/" + "WSPRedirectHandler");
                    }
                }
            }
        }
        catch (Exception e) {
            debug.error("SiteAwareInteractionConfig.initialise():error while initializing", (Throwable)e);
        }
        if (debug.messageEnabled()) {
            debug.message("SiteAwareInteractionConfig.initialise():wspRedirectHandler:" + this.wspRedirectHandler + "lbWspRedirectHandler:" + this.lbWspRedirectHandler + "trustedWspRedirectHandlers:" + this.trustedWspRedirectHandlers);
        }
    }
}

