/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.dpro.session;

import com.iplanet.am.util.Debug;
import com.iplanet.am.util.Misc;
import com.iplanet.dpro.session.TokenRestriction;
import com.iplanet.dpro.session.service.SessionService;
import com.iplanet.sso.SSOToken;
import com.sun.identity.security.AdminTokenAction;
import com.sun.identity.shared.datastruct.CollectionHelper;
import com.sun.identity.sm.ServiceSchema;
import com.sun.identity.sm.ServiceSchemaManager;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.security.AccessController;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class DNOrIPAddressListTokenRestriction
implements TokenRestriction {
    static final long serialVersionUID = 8352965917649287133L;
    private String dn;
    private Set addressList = new HashSet();
    private String asString;
    private static boolean dnRestrictionOnly;
    private static final String SESSION_DNRESTRICTIONONLY_ATTR_NAME = "iplanet-am-session-dnrestrictiononly";
    private static final String AM_SESSION_SERVICE = "iPlanetAMSessionService";
    private static SSOToken adminToken;
    private static Comparator addressComparator;

    public DNOrIPAddressListTokenRestriction(String dn, List hostNames) throws Exception {
        String val = "";
        boolean hostmatch = false;
        this.dn = Misc.canonicalize(dn);
        Iterator i = hostNames.iterator();
        while (i.hasNext()) {
            try {
                val = (String)i.next();
                this.addressList.add(InetAddress.getByName(val));
                hostmatch = true;
            }
            catch (UnknownHostException e) {
                if (SessionService.sessionDebug.warningEnabled()) {
                    SessionService.sessionDebug.warning("DNOrIPAddressListTokenRestriction.constructor: failure resolving host " + val);
                }
                if (i.hasNext() || hostmatch) continue;
                throw new UnknownHostException(val);
            }
        }
        StringBuffer buf = new StringBuffer();
        buf.append(dn).append("\n");
        Object[] sortedAddressList = this.addressList.toArray();
        Arrays.sort(sortedAddressList, addressComparator);
        for (int i2 = 0; i2 < sortedAddressList.length; ++i2) {
            buf.append(((InetAddress)sortedAddressList[i2]).getHostAddress());
            buf.append("\n");
        }
        this.asString = buf.toString();
    }

    public String toString() {
        return this.asString;
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public boolean isSatisfied(Object context) throws Exception {
        if (context == null) {
            return false;
        }
        if (context instanceof SSOToken) {
            if (SessionService.sessionDebug.messageEnabled()) {
                SessionService.sessionDebug.message("DNOrIPAddressListTokenRestriction.isSatisfied(): context is instance of SSOToken");
            }
            SSOToken usedBy = (SSOToken)context;
            return Misc.canonicalize(usedBy.getPrincipal().getName()).equals(this.dn);
        }
        if (context instanceof InetAddress) {
            if (dnRestrictionOnly) {
                SessionService.sessionDebug.error("DNOrIPAddressListTokenRestriction.isSatisfied():dnRestrictionOnly is true, hence cannot accept passed IP as restriction");
                return false;
            }
            if (SessionService.sessionDebug.messageEnabled()) {
                SessionService.sessionDebug.message("DNOrIPAddressListTokenRestriction.isSatisfied(): dnRestrictionOnly is false");
                SessionService.sessionDebug.message("DNOrIPAddressListTokenRestriction.isSatisfied(): IP based restriction received and accepted");
            }
            return this.addressList.contains(context);
        }
        if (SessionService.sessionDebug.warningEnabled()) {
            SessionService.sessionDebug.warning("Unknown context type:" + context);
        }
        return false;
    }

    public boolean equals(Object other) {
        return other != null && other instanceof DNOrIPAddressListTokenRestriction && other.toString().equals(this.toString());
    }

    static SSOToken getAdminToken() {
        if (adminToken == null) {
            try {
                adminToken = (SSOToken)AccessController.doPrivileged(AdminTokenAction.getInstance());
            }
            catch (Exception e) {
                SessionService.sessionDebug.error("Failed to get the admin token for dnRestrictionOnly property checking.", (Throwable)e);
            }
        }
        return adminToken;
    }

    static SessionService getSS() {
        SessionService ss = SessionService.getSessionService();
        if (ss == null) {
            SessionService.sessionDebug.error("DNOrIPAddressListTokenRestriction:  Failed to get the session service instance");
        }
        return ss;
    }

    private static boolean getDNRestrictionOnly() {
        boolean dnRestrictionOnly;
        block2: {
            dnRestrictionOnly = false;
            try {
                ServiceSchemaManager ssm = new ServiceSchemaManager(AM_SESSION_SERVICE, DNOrIPAddressListTokenRestriction.getAdminToken());
                ServiceSchema schema = ssm.getGlobalSchema();
                Map attrs = schema.getAttributeDefaults();
                dnRestrictionOnly = Boolean.valueOf(CollectionHelper.getMapAttr((Map)attrs, (String)SESSION_DNRESTRICTIONONLY_ATTR_NAME, (String)"false"));
            }
            catch (Exception e) {
                if (!SessionService.sessionDebug.messageEnabled()) break block2;
                SessionService.sessionDebug.message("Failed to get the default dnRestrictionOnlysetting. => Set  dnRestrictionOnly to false", (Throwable)e);
            }
        }
        return dnRestrictionOnly;
    }

    static {
        adminToken = null;
        Debug debug = Debug.getInstance("amSession");
        dnRestrictionOnly = DNOrIPAddressListTokenRestriction.getDNRestrictionOnly();
        if (debug.messageEnabled()) {
            debug.message("DNOrIPAddressListTokenRestriction: fetching value for dnRestrictionOnly:" + dnRestrictionOnly);
        }
        addressComparator = new Comparator(){

            public int compare(Object o1, Object o2) {
                return ((InetAddress)o1).getHostAddress().compareTo(((InetAddress)o2).getHostAddress());
            }
        };
    }
}

