/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.dpro.session;

import com.iplanet.am.util.SystemProperties;
import com.iplanet.dpro.session.SessionException;
import com.iplanet.dpro.session.share.SessionEncodeURL;
import com.iplanet.services.naming.WebtopNaming;
import com.sun.identity.shared.debug.Debug;
import com.sun.identity.shared.encode.Base64;
import com.sun.identity.shared.encode.CookieUtils;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.Serializable;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;

public class SessionID
implements Serializable {
    private String encryptedString = "";
    private boolean isParsed = false;
    private boolean comingFromAuth = false;
    private String sessionServerProtocol = "";
    private String sessionServer = "";
    private String sessionServerPort = "";
    private String sessionServerURI = "";
    protected String sessionDomain = "";
    private String sessionServerID = "";
    private String tail = null;
    private String extensionPart = null;
    private Map extensions = new HashMap();
    private static String cookieName = null;
    private static Debug debug;
    private Boolean cookieMode = null;
    public static final String PRIMARY_ID = "S1";
    public static final String STORAGE_KEY = "SK";
    public static final String SITE_ID = "SI";

    public SessionID(HttpServletRequest request) {
        String cookieValue = null;
        if (cookieName == null) {
            cookieName = SystemProperties.get("com.iplanet.am.cookie.name");
        }
        if (cookieName != null) {
            cookieValue = CookieUtils.getCookieValueFromReq((HttpServletRequest)request, (String)cookieName);
            if (cookieValue == null) {
                String realReqSid = SessionEncodeURL.getSidFromURL(request);
                if (realReqSid != null) {
                    this.encryptedString = realReqSid;
                }
                this.cookieMode = Boolean.FALSE;
            } else {
                this.cookieMode = Boolean.TRUE;
                this.encryptedString = cookieValue;
            }
        }
    }

    public SessionID(String sid) {
        this.encryptedString = sid;
    }

    public boolean isNull() {
        return SessionID.isNull(this.encryptedString);
    }

    private static boolean isNull(String s) {
        return s == null || s.length() == 0;
    }

    public String getSessionServerURI() {
        if (SessionID.isNull(this.sessionServerURI)) {
            this.parseSessionString();
        }
        return this.sessionServerURI;
    }

    public boolean getComingFromAuth() {
        if (debug.messageEnabled()) {
            debug.message("SessionID.getComingFromAuth():comingFromAuth:" + this.comingFromAuth);
        }
        return this.comingFromAuth;
    }

    public void setComingFromAuth(boolean comingFromAuth) {
        this.comingFromAuth = comingFromAuth;
    }

    public String getSessionServerProtocol() {
        if (SessionID.isNull(this.sessionServerProtocol)) {
            this.parseSessionString();
        }
        return this.sessionServerProtocol;
    }

    public String getSessionServerPort() {
        if (SessionID.isNull(this.sessionServerPort)) {
            this.parseSessionString();
        }
        return this.sessionServerPort;
    }

    public String getSessionServer() {
        if (SessionID.isNull(this.sessionServer)) {
            this.parseSessionString();
        }
        return this.sessionServer;
    }

    public String getSessionDomain() {
        return this.sessionDomain;
    }

    public String getSessionServerID() {
        if (SessionID.isNull(this.sessionServerID)) {
            this.parseSessionString();
        }
        return this.sessionServerID;
    }

    public String toString() {
        return this.encryptedString;
    }

    public boolean equals(Object object) {
        if (object == null || !(object instanceof SessionID)) {
            return false;
        }
        SessionID another = (SessionID)object;
        return this.encryptedString.equals(another.encryptedString);
    }

    public int hashCode() {
        return this.encryptedString.hashCode();
    }

    private void parseSessionString() {
        if (this.isParsed) {
            return;
        }
        if (this.isNull()) {
            throw new IllegalArgumentException("sid value is null or empty");
        }
        try {
            String serverID;
            int outerIndex;
            String sidString = this.encryptedString;
            if (sidString.indexOf("*") != -1) {
                sidString = SessionID.c66DecodeCookieString(this.encryptedString);
            }
            if ((outerIndex = sidString.lastIndexOf("@")) == -1) {
                this.isParsed = true;
                return;
            }
            String outer = sidString.substring(outerIndex + 1);
            int tailIndex = outer.indexOf("#");
            this.tail = outer.substring(tailIndex + 1);
            if (tailIndex != -1) {
                this.extensionPart = outer.substring(0, tailIndex);
                DataInputStream extensionStr = new DataInputStream(new ByteArrayInputStream(Base64.decode((String)this.extensionPart)));
                HashMap<String, String> extMap = new HashMap<String, String>();
                while (true) {
                    String extName;
                    try {
                        extName = extensionStr.readUTF();
                    }
                    catch (EOFException e) {
                        break;
                    }
                    String extValue = extensionStr.readUTF();
                    extMap.put(extName, extValue);
                }
                this.extensions = extMap;
            }
            if ((serverID = (String)this.extensions.get(SITE_ID)) != null) {
                this.setServerID(serverID);
            }
        }
        catch (Exception e) {
            debug.error("Invalid sessionid format", (Throwable)e);
            throw new IllegalArgumentException("Invalid sessionid format" + e);
        }
        this.isParsed = true;
    }

    protected void setServerID(String id) {
        try {
            URL url = new URL(WebtopNaming.getServerFromID(id));
            this.sessionServerID = id;
            this.sessionServerProtocol = url.getProtocol();
            this.sessionServer = url.getHost();
            this.sessionServerPort = String.valueOf(url.getPort());
            this.sessionServerURI = url.getPath();
            int idx = this.sessionServerURI.lastIndexOf(47);
            while (idx > 0) {
                this.sessionServerURI = this.sessionServerURI.substring(0, idx);
                idx = this.sessionServerURI.lastIndexOf(47);
            }
        }
        catch (Exception e) {
            debug.error("Could not get server info from sessionid", (Throwable)e);
            throw new IllegalArgumentException("Invalid server id in session id " + e);
        }
    }

    public String getTail() {
        this.parseSessionString();
        return this.tail;
    }

    public Boolean getCookieMode() {
        return this.cookieMode;
    }

    public String getExtension(String name) {
        this.parseSessionString();
        return (String)this.extensions.get(name);
    }

    public static String makeSessionID(String encryptedID, Map extensions, String tail) throws SessionException {
        try {
            StringBuffer buf = new StringBuffer();
            buf.append(encryptedID);
            if (extensions != null || tail != null) {
                buf.append("@");
            }
            if (extensions != null) {
                ByteArrayOutputStream baOut = new ByteArrayOutputStream();
                DataOutputStream dataOut = new DataOutputStream(baOut);
                for (Map.Entry entry : extensions.entrySet()) {
                    dataOut.writeUTF((String)entry.getKey());
                    dataOut.writeUTF((String)entry.getValue());
                }
                dataOut.close();
                buf.append(Base64.encode((byte[])baOut.toByteArray()));
                buf.append("#");
            }
            if (tail != null) {
                buf.append(tail);
            }
            String returnValue = buf.toString();
            if (SessionID.c66EncodeCookie()) {
                returnValue = SessionID.c66EncodeSidString(returnValue);
            }
            return returnValue;
        }
        catch (Exception e) {
            throw new SessionException(e);
        }
    }

    public static String makeRelatedSessionID(String encryptedID, SessionID prototype) throws SessionException {
        prototype.parseSessionString();
        return SessionID.makeSessionID(encryptedID, prototype.extensions, prototype.tail);
    }

    private static boolean c66EncodeCookie() {
        return Boolean.valueOf(SystemProperties.get("com.iplanet.am.cookie.c66Encode", "false"));
    }

    private static String c66EncodeSidString(String sidString) {
        if (sidString == null || sidString.length() == 0) {
            return sidString;
        }
        int length = sidString.length();
        char[] chars = new char[length];
        for (int i = 0; i < length; ++i) {
            char c = sidString.charAt(i);
            chars[i] = c == '+' ? 45 : (c == '/' ? 95 : (c == '=' ? 46 : (c == '@' ? 42 : (c == '#' ? 42 : c))));
        }
        return new String(chars);
    }

    private static String c66DecodeCookieString(String urlEncodedString) {
        if (urlEncodedString == null || urlEncodedString.length() == 0) {
            return urlEncodedString;
        }
        int length = urlEncodedString.length();
        char[] chars = new char[length];
        boolean firstStar = true;
        for (int i = 0; i < length; ++i) {
            char c = urlEncodedString.charAt(i);
            if (c == '-') {
                chars[i] = 43;
                continue;
            }
            if (c == '_') {
                chars[i] = 47;
                continue;
            }
            if (c == '.') {
                chars[i] = 61;
                continue;
            }
            if (c == '*') {
                if (firstStar) {
                    firstStar = false;
                    chars[i] = 64;
                    continue;
                }
                chars[i] = 35;
                continue;
            }
            chars[i] = c;
        }
        return new String(chars);
    }

    static {
        cookieName = System.getProperty("com.iplanet.am.cookie.name");
        if (cookieName == null) {
            cookieName = SystemProperties.get("com.iplanet.am.cookie.name");
        }
        debug = Debug.getInstance((String)"amSession");
    }
}

