/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.tune.impl;

import com.sun.identity.tune.base.AMTuneDSBase;
import com.sun.identity.tune.common.AMTuneException;
import com.sun.identity.tune.common.FileHandler;
import com.sun.identity.tune.config.AMTuneConfigInfo;
import com.sun.identity.tune.util.AMTuneUtil;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.logging.Level;

public class TuneDS5Impl
extends AMTuneDSBase {
    private String db2BakPath;
    private String stopCmdPath;
    private String startCmdPath;
    private String dbBackUpDir;

    public void initialize(AMTuneConfigInfo confInfo) throws AMTuneException {
        super.initialize(confInfo);
        if (AMTuneUtil.isWindows()) {
            this.db2BakPath = this.instanceDir + "/" + "db2bak.bat ";
            this.stopCmdPath = this.instanceDir + "/" + "stop-slapd.bat";
            this.startCmdPath = this.instanceDir + "/" + "start-slapd.bat";
        } else {
            this.db2BakPath = this.instanceDir + "/" + "db2bak ";
            this.stopCmdPath = this.instanceDir + "/" + "stop-slapd";
            this.startCmdPath = this.instanceDir + "/" + "start-slapd";
        }
        this.validateAdminToolPath();
        this.dbBackUpDir = "amtune-" + AMTuneUtil.getRandomStr();
    }

    protected void validateAdminToolPath() throws AMTuneException {
        File db2bakFile = new File(this.db2BakPath.trim());
        if (!db2bakFile.exists()) {
            this.mWriter.writelnLocaleMsg("pt-error-ds-tool-not-found");
            AMTuneUtil.printErrorMsg("DS_INSTANCE_DIR");
            throw new AMTuneException(AMTuneUtil.getResourceBundle().getString("pt-error-invalid-ds-instance-dir"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startTuning() throws AMTuneException {
        try {
            this.pLogger.log(Level.FINE, "startTuning", "Start tuning.");
            this.mWriter.writeln("#####################################################################");
            this.mWriter.writelnLocaleMsg("pt-fam-ds-tuning");
            this.mWriter.writeln("#####################################################################");
            this.mWriter.writelnLocaleMsg("pt-init");
            this.mWriter.writeln("---------------------------------------------------------------------");
            this.computeTuneValues();
            this.mWriter.writeln("=====================================================================");
            this.modifyLDAP();
            if (!AMTuneUtil.isWindows()) {
                this.tuneUsingDSE();
            }
            this.tuneFuture();
            this.mWriter.writelnLocaleMsg("pt-ds-um-mutliple-msg");
        }
        catch (Exception ex) {
            this.pLogger.log(Level.SEVERE, "startTuning", "Error tuning DS5.2");
            this.mWriter.writelnLocaleMsg("pt-error-tuning-msg");
            this.pLogger.logException("startTuning", ex);
        }
        finally {
            try {
                this.releaseCon();
            }
            catch (Exception exception) {}
            this.deletePasswordFile();
        }
    }

    protected void tuneUsingDSE() throws AMTuneException {
        try {
            super.tuneUsingDSE();
            this.pLogger.log(Level.FINE, "tuneUsingDSE", "");
            if (this.configInfo.isReviewMode()) {
                return;
            }
            this.pLogger.log(Level.FINE, "tuneUsingDSE", "Modify dse.ldif");
            if (this.curDBHomeLocation.equals(this.newDBHomeLocation)) {
                this.pLogger.log(Level.INFO, "tuneUsingDSE", "Current DB Location is same as recommended value.");
                return;
            }
            this.stopDS();
            this.backUpDS();
            FileHandler dseH = new FileHandler(this.dseLdifPath);
            int reqLineNo = dseH.lineContains("nsslapd-db-home-directory:");
            dseH.replaceLine(reqLineNo, "nsslapd-db-home-directory: " + this.newDBHomeLocation);
            dseH.close();
            this.startDS();
        }
        catch (FileNotFoundException fex) {
            throw new AMTuneException(fex.getMessage());
        }
        catch (IOException ioe) {
            throw new AMTuneException(ioe.getMessage());
        }
    }

    private void modifyLDAP() throws AMTuneException {
        this.pLogger.log(Level.FINE, "modifyLDAP", "Modify LDAP attributes.");
        boolean applyRec = false;
        boolean remAci = false;
        this.ldapTuningRecommendations();
        if (this.configInfo.isReviewMode()) {
            return;
        }
        this.stopDS();
        this.backUpDS();
        this.startDS();
        applyRec = this.applyRecommendations();
        if (applyRec || remAci) {
            this.stopDS();
            this.startDS();
        }
    }

    protected void backUpDS() throws AMTuneException {
        try {
            String dbBackUpSuccessFile = this.instanceDir + "/" + "bak" + "/" + this.dbBackUpDir + "/" + "SUCCESS.dontdelete";
            File successFile = new File(dbBackUpSuccessFile);
            if (successFile.isFile()) {
                this.pLogger.log(Level.INFO, "backUpDS", "Backup exists");
                return;
            }
            File bakDir = new File(this.instanceDir + "/" + "bak");
            if (!bakDir.isDirectory()) {
                bakDir.mkdir();
            }
            StringBuffer resultBuffer = new StringBuffer();
            String db2BakCmd = this.db2BakPath + bakDir.getAbsolutePath() + "/" + this.dbBackUpDir;
            this.pLogger.log(Level.FINE, "backUpDS", "Backing up DS.");
            int retVal = AMTuneUtil.executeCommand(db2BakCmd, resultBuffer);
            if (retVal == -1) {
                this.mWriter.writelnLocaleMsg("pt-cannot-backup-db");
                throw new AMTuneException(AMTuneUtil.getResourceBundle().getString("pt-error-ds-db-backup-failed"));
            }
            this.pLogger.log(Level.FINE, "backUpDS", "Backing up Done...");
            try {
                File dseLdif = new File(this.dseLdifPath);
                this.pLogger.log(Level.FINE, "backUpDS", "Backing " + this.dseLdifPath);
                File bakDseFile = new File(this.instanceDir + "/" + "bak" + "/" + this.dbBackUpDir + "/" + "dse.ldif");
                AMTuneUtil.CopyFile(dseLdif, bakDseFile);
                this.pLogger.log(Level.FINE, "backUpDS", "Backing Done..");
            }
            catch (Exception ex) {
                this.pLogger.log(Level.SEVERE, "backupDS", ex.getMessage());
                throw new AMTuneException(AMTuneUtil.getResourceBundle().getString("pt-error-ds-conf-file-backup"));
            }
            successFile.createNewFile();
        }
        catch (Exception ex) {
            throw new AMTuneException(ex.getMessage());
        }
    }

    protected void stopDS() throws AMTuneException {
        this.pLogger.log(Level.FINE, "stopDS", "Stopping DS.");
        StringBuffer resultBuffer = new StringBuffer();
        int retVal = AMTuneUtil.executeCommand(this.stopCmdPath, resultBuffer);
        if (retVal == -1) {
            throw new AMTuneException(AMTuneUtil.getResourceBundle().getString("pt-error-ds-stop"));
        }
        this.pLogger.log(Level.FINE, "stopDS", "DS Successfully stopped.");
    }

    protected void startDS() throws AMTuneException {
        this.pLogger.log(Level.FINE, "startDS", "Starting DS.");
        StringBuffer resultBuffer = new StringBuffer();
        int retVal = AMTuneUtil.executeCommand(this.startCmdPath, resultBuffer);
        if (retVal == -1) {
            throw new AMTuneException(AMTuneUtil.getResourceBundle().getString("pt-error-ds-start"));
        }
        this.pLogger.log(Level.FINE, "startDS", "DS Successfully started.");
    }
}

