/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.classloader;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Vector;
import sun.misc.CompoundEnumeration;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MaskingClassLoader
extends ClassLoader {
    private final ClassLoader parent;
    private final String[] masks;
    private final String[] maskResources;
    private final URL[] urls;
    private final String resource = "META-INF/services/com.sun.xml.ws.api.pipe.TransportPipeFactory";
    private final String resource2 = "META-INF/services/com.sun.xml.ws.policy.spi.PolicyAssertionValidator";
    private final String resourceAuthConfigProvider = "META-INF/services/javax.security.auth.message.config.AuthConfigProvider";
    private final String resourceTransformerFactory = "META-INF/services/javax.xml.transform.TransformerFactory";
    private final String resourceSAXParserFactory = "META-INF/services/javax.xml.parsers.SAXParserFactory";
    private final String resourceDocumentBuilderFactory = "META-INF/services/javax.xml.parsers.DocumentBuilderFactory";
    private final String resourceTubelineAssembler = "META-INF/services/com.sun.xml.ws.api.pipe.TubelineAssemblerFactory";

    public MaskingClassLoader(ClassLoader parent, String[] masks, String[] maskResources, URL[] urls) {
        super(parent);
        this.parent = parent;
        this.masks = masks;
        this.maskResources = maskResources;
        this.urls = urls;
    }

    public MaskingClassLoader(ClassLoader parent, Collection<String> masks, Collection<String> maskResources, URL[] urls) {
        super(parent);
        this.parent = parent;
        this.masks = masks.toArray(new String[masks.size()]);
        this.maskResources = maskResources != null ? maskResources.toArray(new String[maskResources.size()]) : null;
        this.urls = urls;
    }

    @Override
    protected synchronized Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
        for (String mask : this.masks) {
            if (!name.startsWith(mask)) continue;
            throw new ClassNotFoundException();
        }
        return super.loadClass(name, resolve);
    }

    @Override
    public synchronized URL getResource(String name) {
        URL jarURL;
        if (this.maskResources == null) {
            return super.getResource(name);
        }
        if (name.startsWith("META-INF/services/javax.security.auth.message.config.AuthConfigProvider")) {
            try {
                URL jarURL2 = new URL("jar:" + this.urls[6].toString() + "!/" + "META-INF/services/javax.security.auth.message.config.AuthConfigProvider");
                return jarURL2;
            }
            catch (MalformedURLException mue) {
                // empty catch block
            }
        }
        if (name.startsWith("META-INF/services/javax.xml.transform.TransformerFactory")) {
            try {
                URL jarURL3 = new URL("jar:" + this.urls[7].toString() + "!/" + "META-INF/services/javax.xml.transform.TransformerFactory");
                return jarURL3;
            }
            catch (MalformedURLException mue) {
                // empty catch block
            }
        }
        if (name.startsWith("META-INF/services/javax.xml.parsers.SAXParserFactory")) {
            try {
                jarURL = new URL("jar:" + this.urls[8].toString() + "!/" + "META-INF/services/javax.xml.parsers.SAXParserFactory");
                return jarURL;
            }
            catch (MalformedURLException mue) {
                // empty catch block
            }
        }
        if (name.startsWith("META-INF/services/javax.xml.parsers.DocumentBuilderFactory")) {
            try {
                jarURL = new URL("jar:" + this.urls[8].toString() + "!/" + "META-INF/services/javax.xml.parsers.DocumentBuilderFactory");
                return jarURL;
            }
            catch (MalformedURLException mue) {
                // empty catch block
            }
        }
        if (name.startsWith("META-INF/services/com.sun.xml.ws.api.pipe.TubelineAssemblerFactory")) {
            try {
                jarURL = new URL("jar:" + this.urls[1].toString() + "!/" + "META-INF/services/com.sun.xml.ws.api.pipe.TubelineAssemblerFactory");
                return jarURL;
            }
            catch (MalformedURLException mue) {
                // empty catch block
            }
        }
        for (String mask : this.maskResources) {
            if (!name.startsWith(mask)) continue;
            return null;
        }
        return super.getResource(name);
    }

    @Override
    public Enumeration<URL> getResources(String name) throws IOException {
        if (this.maskResources == null) {
            return super.getResources(name);
        }
        Enumeration[] tmp = new Enumeration[1];
        if (name.startsWith("META-INF/services/com.sun.xml.ws.api.pipe.TransportPipeFactory")) {
            Vector<URL> vec = new Vector<URL>(1);
            URL jarURL = new URL("jar:" + this.urls[5].toString() + "!/" + "META-INF/services/com.sun.xml.ws.api.pipe.TransportPipeFactory");
            vec.add(jarURL);
            tmp[0] = vec.elements();
            return new CompoundEnumeration(tmp);
        }
        if (name.startsWith("META-INF/services/com.sun.xml.ws.policy.spi.PolicyAssertionValidator")) {
            Vector<URL> vec = new Vector<URL>(1);
            URL jarURL = new URL("jar:" + this.urls[1].toString() + "!/" + "META-INF/services/com.sun.xml.ws.policy.spi.PolicyAssertionValidator");
            vec.add(jarURL);
            tmp[0] = vec.elements();
            return new CompoundEnumeration(tmp);
        }
        if (name.startsWith("META-INF/services/com.sun.xml.ws.api.pipe.TubelineAssemblerFactory")) {
            Vector<URL> vec = new Vector<URL>(1);
            URL jarURL = new URL("jar:" + this.urls[1].toString() + "!/" + "META-INF/services/com.sun.xml.ws.api.pipe.TubelineAssemblerFactory");
            vec.add(jarURL);
            tmp[0] = vec.elements();
            return new CompoundEnumeration(tmp);
        }
        if (name.startsWith("META-INF/services/javax.xml.transform.TransformerFactory")) {
            Vector<URL> vec = new Vector<URL>(1);
            URL jarURL = new URL("jar:" + this.urls[7].toString() + "!/" + "META-INF/services/javax.xml.transform.TransformerFactory");
            vec.add(jarURL);
            tmp[0] = vec.elements();
            return new CompoundEnumeration(tmp);
        }
        if (name.startsWith("META-INF/services/javax.xml.parsers.SAXParserFactory")) {
            Vector<URL> vec = new Vector<URL>(1);
            URL jarURL = new URL("jar:" + this.urls[8].toString() + "!/" + "META-INF/services/javax.xml.parsers.SAXParserFactory");
            vec.add(jarURL);
            tmp[0] = vec.elements();
            return new CompoundEnumeration(tmp);
        }
        if (name.startsWith("META-INF/services/javax.xml.parsers.DocumentBuilderFactory")) {
            Vector<URL> vec = new Vector<URL>(1);
            URL jarURL = new URL("jar:" + this.urls[8].toString() + "!/" + "META-INF/services/javax.xml.parsers.DocumentBuilderFactory");
            vec.add(jarURL);
            tmp[0] = vec.elements();
            return new CompoundEnumeration(tmp);
        }
        return super.getResources(name);
    }

    public synchronized String toString() {
        return "com.sun.identity.classloader.MaskingClassLoader : Super is : " + super.toString();
    }
}

