/*
 * This file is part of the Meeds project (https://meeds.io/).
 * Copyright (C) 2020 Meeds Association
 * contact@meeds.io
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 3 of the License, or (at your option) any later version.
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 */
package org.gatein.wci.test.deployment;

import java.util.HashSet;

import jakarta.servlet.ServletContextEvent;
import jakarta.servlet.ServletContextListener;

/** @author <a href="mailto:julien.viet@exoplatform.com">Julien Viet</a> */
public class NativeSkipFilter implements ServletContextListener
{

   /** . */
   static final HashSet<String> contextPaths = new HashSet<String>();

   @Override
   public void contextInitialized(ServletContextEvent sce)
   {
      contextPaths.add(sce.getServletContext().getContextPath());
   }

   @Override
   public void contextDestroyed(ServletContextEvent sce)
   {
      contextPaths.remove(sce.getServletContext().getContextPath());
   }
}
