/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.wci.test.jetty8;

import java.security.Principal;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.eclipse.jetty.security.DefaultIdentityService;
import org.eclipse.jetty.security.IdentityService;
import org.eclipse.jetty.security.LoginService;
import org.eclipse.jetty.server.UserIdentity;
import org.gatein.wci.test.jetty8.BasicUserIdentity;

public class BasicLoginService
implements LoginService {
    private final ConcurrentMap<String, UserIdentity> identities = new ConcurrentHashMap<String, UserIdentity>();
    private static final Map<String, String> validUsers = new HashMap<String, String>();
    private final IdentityService identityService = new DefaultIdentityService();

    public String getName() {
        return "basic";
    }

    public UserIdentity login(final String username, Object credentials) {
        UserIdentity identity = (UserIdentity)this.identities.get(username);
        if (identity == null && validUsers.containsKey(username) && validUsers.get(username).equals(credentials)) {
            Principal userPrincipal = new Principal(){

                @Override
                public String getName() {
                    return username;
                }
            };
            identity = new BasicUserIdentity(userPrincipal, new String[]{"myrole"});
            this.identities.putIfAbsent(username, identity);
        }
        return identity;
    }

    public boolean validate(UserIdentity user) {
        return this.identities.containsKey(user.getUserPrincipal().getName());
    }

    public IdentityService getIdentityService() {
        return this.identityService;
    }

    public void setIdentityService(IdentityService service) {
        throw new UnsupportedOperationException();
    }

    public void logout(UserIdentity user) {
        this.identities.remove(user.getUserPrincipal().getName());
    }

    static {
        validUsers.put("foo", "bar");
    }
}

