/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.wci;

import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.gatein.common.logging.Logger;
import org.gatein.common.logging.LoggerFactory;
import org.gatein.wci.RequestDispatchCallback;
import org.gatein.wci.ServletContainerVisitor;
import org.gatein.wci.WebApp;
import org.gatein.wci.WebAppEvent;
import org.gatein.wci.WebAppLifeCycleEvent;
import org.gatein.wci.WebAppListener;
import org.gatein.wci.authentication.AuthenticationEvent;
import org.gatein.wci.authentication.AuthenticationEventType;
import org.gatein.wci.authentication.AuthenticationException;
import org.gatein.wci.authentication.AuthenticationListener;
import org.gatein.wci.command.CommandDispatcher;
import org.gatein.wci.security.Credentials;
import org.gatein.wci.spi.ServletContainerContext;
import org.gatein.wci.spi.WebAppContext;

public final class ServletContainer {
    private static final Logger log = LoggerFactory.getLogger(ServletContainer.class);
    private final Object lock = new Object();
    private final Vector<WebAppListener> webAppListeners = new Vector();
    private final List<AuthenticationListener> authenticationListeners = new CopyOnWriteArrayList<AuthenticationListener>();
    private final Map<String, WebAppImpl> webAppMap = new HashMap<String, WebAppImpl>();
    private RegistrationImpl registration;
    private Map<String, String> manualMonitoredContexts = new HashMap<String, String>();

    public void registerWebApp(WebAppContext webappContext, String dispatchPath) {
        if (ServletContainer.isDisabledNativeRegistration(webappContext.getServletContext())) {
            this.manualMonitoredContexts.put(webappContext.getServletContext().getServletContextName(), dispatchPath);
            this.registration.registerWebApp(webappContext);
        }
    }

    public void unregisterWebApp(ServletContext servletContext) {
        if (ServletContainer.isDisabledNativeRegistration(servletContext)) {
            this.manualMonitoredContexts.remove(servletContext.getServletContextName());
            if (this.registration != null) {
                this.registration.unregisterWebApp(servletContext.getContextPath());
            }
        }
    }

    public static boolean isDisabledNativeRegistration(ServletContext servletContext) {
        if (servletContext != null) {
            String disableWCINativeRegistration = servletContext.getInitParameter("gatein.wci.native.DisableRegistration");
            return disableWCINativeRegistration != null && disableWCINativeRegistration.equalsIgnoreCase("true");
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void register(ServletContainerContext context) {
        if (context == null) {
            throw new IllegalArgumentException("No null context accepted");
        }
        if (this.registration == null) {
            Object object = this.lock;
            synchronized (object) {
                if (this.registration == null) {
                    this.registration = new RegistrationImpl(this, context);
                    context.setCallback(this.registration);
                }
            }
        }
    }

    public void login(HttpServletRequest request, HttpServletResponse response, Credentials credentials) throws ServletException, IOException {
        String remoteUser = request.getRemoteUser();
        if (remoteUser == null) {
            try {
                this.registration.context.login(request, response, credentials);
                this.fireEvent(new AuthenticationEvent(AuthenticationEventType.LOGIN, request, response, credentials.getUsername(), credentials, this.registration.context));
            }
            catch (AuthenticationException ae) {
                this.fireEvent(new AuthenticationEvent(AuthenticationEventType.FAILED, request, response, credentials.getUsername(), credentials, this.registration.context));
                throw ae;
            }
        } else {
            throw new IllegalStateException("User already authenticated");
        }
    }

    public void logout(HttpServletRequest request, HttpServletResponse response) {
        String remoteUser = request.getRemoteUser();
        if (remoteUser != null) {
            try {
                this.registration.context.logout(request, response);
            }
            catch (ServletException servletException) {}
        } else {
            throw new IllegalStateException("User is not authenticated");
        }
    }

    public void addAuthenticationListener(AuthenticationListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException("listener is null");
        }
        this.authenticationListeners.add(listener);
    }

    public void removeAuthenticationlistener(AuthenticationListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException("listener is null");
        }
        this.authenticationListeners.remove(listener);
    }

    public String getContainerInfo() {
        return this.registration.context.getContainerInfo();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addWebAppListener(WebAppListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException();
        }
        if (this.webAppListeners.contains(listener)) {
            return false;
        }
        Iterator<WebAppImpl> iterator = this.lock;
        synchronized (iterator) {
            if (this.webAppListeners.contains(listener)) {
                return false;
            }
            this.webAppListeners.add(listener);
        }
        if (!this.webAppMap.isEmpty()) {
            for (WebAppImpl response : this.webAppMap.values()) {
                WebApp webApp;
                WebApp webApp2 = webApp = (WebApp)response;
                synchronized (webApp2) {
                    WebAppLifeCycleEvent event = new WebAppLifeCycleEvent(webApp, 1);
                    this.safeFireEvent(listener, event);
                }
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeWebAppListener(WebAppListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException();
        }
        if (this.webAppListeners.remove(listener)) {
            Iterator<WebAppImpl> iterator = this.webAppMap.values().iterator();
            while (iterator.hasNext()) {
                WebApp webApp;
                WebApp webApp2 = webApp = (WebApp)iterator.next();
                synchronized (webApp2) {
                    WebAppLifeCycleEvent event = new WebAppLifeCycleEvent(webApp, 0);
                    this.safeFireEvent(listener, event);
                }
            }
            return true;
        }
        return false;
    }

    private void safeFireEvent(WebAppListener listener, WebAppEvent event) {
        try {
            listener.onEvent(event);
        }
        catch (Throwable t) {
            if (t instanceof Error) {
                throw (Error)t;
            }
            t.printStackTrace();
        }
    }

    private void fireEvent(WebAppEvent event) {
        for (WebAppListener listener : this.webAppListeners) {
            this.safeFireEvent(listener, event);
        }
    }

    public void fireEvent(AuthenticationEvent event) {
        for (AuthenticationListener currentListener : this.authenticationListeners) {
            try {
                currentListener.onEvent(event);
            }
            catch (Exception ignore) {
                ignore.printStackTrace();
            }
        }
    }

    public Object include(ServletContext targetServletContext, HttpServletRequest request, HttpServletResponse response, RequestDispatchCallback callback, Object handback) throws ServletException, IOException {
        if (this.manualMonitoredContexts.containsKey(targetServletContext.getServletContextName())) {
            String dispatherPath = this.manualMonitoredContexts.get(targetServletContext.getServletContextName());
            CommandDispatcher dispatcher = new CommandDispatcher(dispatherPath);
            return dispatcher.include(targetServletContext, request, response, callback, handback);
        }
        RegistrationImpl registration = this.registration;
        if (registration == null) {
            throw new IllegalStateException("No SPI installed");
        }
        return registration.context.include(targetServletContext, request, response, callback, handback);
    }

    public void visit(ServletContainerVisitor visitor) {
        if (!this.webAppMap.isEmpty()) {
            for (WebApp webApp : this.webAppMap.values()) {
                visitor.accept(webApp);
            }
        }
    }

    private static class WebAppImpl
    implements WebApp {
        final WebAppContext context;

        public WebAppImpl(WebAppContext context) {
            this.context = context;
        }

        @Override
        public ServletContext getServletContext() {
            return this.context.getServletContext();
        }

        @Override
        public ClassLoader getClassLoader() {
            return this.context.getClassLoader();
        }

        @Override
        public String getContextPath() {
            return this.context.getContextPath();
        }

        @Override
        public boolean importFile(String parentDirRelativePath, String name, InputStream source, boolean overwrite) throws IOException {
            return this.context.importFile(parentDirRelativePath, name, source, overwrite);
        }

        @Override
        public HttpSession getHttpSession(String sessId) {
            return this.context.getHttpSession(sessId);
        }

        @Override
        public void fireRequestInitialized(ServletRequest servletRequest) {
            this.context.fireRequestInitialized(servletRequest);
        }

        @Override
        public void fireRequestDestroyed(ServletRequest servletRequest) {
            this.context.fireRequestDestroyed(servletRequest);
        }
    }

    private static class RegistrationImpl
    implements ServletContainerContext.Registration {
        private boolean disposed = false;
        private ServletContainer container;
        private ServletContainerContext context;

        public RegistrationImpl(ServletContainer container, ServletContainerContext context) {
            this.container = container;
            this.context = context;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean registerWebApp(WebAppContext webAppContext) {
            if (this.disposed) {
                throw new IllegalStateException("Disposed registration");
            }
            Object object = this.container.lock;
            synchronized (object) {
                if (webAppContext == null) {
                    throw new IllegalArgumentException("No null web app context accepted");
                }
                String key = webAppContext.getContextPath();
                if (this.container.webAppMap.containsKey(key)) {
                    log.debug((Object)("Web application " + key + " is already registered"));
                    return false;
                }
                try {
                    log.debug((Object)("Web application " + key + " registration"));
                    webAppContext.start();
                    WebAppImpl webApp = new WebAppImpl(webAppContext);
                    this.container.webAppMap.put(key, webApp);
                    this.container.fireEvent(new WebAppLifeCycleEvent(webApp, 1));
                    return true;
                }
                catch (Exception e) {
                    log.debug((Object)("Was not able to start web app context " + key));
                    e.printStackTrace();
                    return false;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean unregisterWebApp(String webAppId) {
            if (this.disposed) {
                throw new IllegalStateException("Disposed registration");
            }
            if (webAppId == null) {
                throw new IllegalArgumentException("No null web app id accepted");
            }
            WebAppImpl webApp = this.container.webAppMap.get(webAppId);
            if (webApp == null) {
                log.debug((Object)("Web application " + webAppId + " was not registered"));
                return false;
            }
            WebAppContext webAppContext = webApp.context;
            synchronized (webAppContext) {
                Object object = this.container.lock;
                synchronized (object) {
                    webApp = this.container.webAppMap.remove(webAppId);
                    if (webApp != null) {
                        log.debug((Object)("Web application " + webAppId + " cleanup"));
                        this.container.fireEvent(new WebAppLifeCycleEvent(webApp, 0));
                        webApp.context.stop();
                        return true;
                    }
                    log.debug((Object)("Web application " + webAppId + " was not registered"));
                    return false;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void cancel() {
            if (this.disposed) {
                throw new IllegalStateException("Disposed registration");
            }
            Object object = this.container.lock;
            synchronized (object) {
                for (WebApp webApp : this.container.webAppMap.values()) {
                    WebAppLifeCycleEvent event = new WebAppLifeCycleEvent(webApp, 0);
                    this.container.fireEvent(event);
                }
                this.container.webAppMap.clear();
                try {
                    this.context.unsetCallback(this);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                this.context = null;
                this.disposed = true;
                this.container.registration = null;
            }
        }
    }
}

