/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.wci.spi;

import jakarta.servlet.ServletContext;
import jakarta.servlet.ServletRequest;
import java.io.IOException;
import java.io.InputStream;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.gatein.wci.command.CommandServlet;
import org.gatein.wci.spi.WebAppContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class CatalinaWebAppContext
implements WebAppContext {
    protected static final Logger log = LoggerFactory.getLogger(CatalinaWebAppContext.class);
    protected static final String GATEIN_SERVLET_NAME = "TomcatGateInServlet";
    protected static final String GATEIN_SERVLET_PATH = "/tomcatgateinservlet";
    protected static final int GATEIN_SERVLET_LOAD_ON_STARTUP = 0;
    private static final String BEAN_MGR_ATTR = "javax.enterprise.inject.spi.BeanManager";
    protected ServletContext servletContext;
    protected ClassLoader classLoader;
    protected String contextPath;

    public CatalinaWebAppContext(ServletContext servletContext, ClassLoader classLoader, String contextPath) {
        this.servletContext = servletContext;
        this.classLoader = classLoader;
        this.contextPath = contextPath;
    }

    @Override
    public void start() throws Exception {
        this.performStartup();
        try {
            Object beanMgr = new InitialContext().lookup("java:comp/BeanManager");
            if (null != beanMgr) {
                this.servletContext.setAttribute(BEAN_MGR_ATTR, beanMgr);
            }
        }
        catch (NamingException namingException) {
            // empty catch block
        }
    }

    @Override
    public void stop() {
        this.cleanup();
    }

    @Override
    public ServletContext getServletContext() {
        return this.servletContext;
    }

    @Override
    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    @Override
    public String getContextPath() {
        return this.contextPath;
    }

    @Override
    public boolean importFile(String parentDirRelativePath, String name, InputStream source, boolean overwrite) throws IOException {
        return false;
    }

    protected String getCommandServletClassName() {
        String className = null;
        try {
            className = CommandServlet.class.getName();
            this.classLoader.loadClass(className);
        }
        catch (Exception ex) {
            className = null;
            log.debug("WCI integration skipped for context: /" + this.contextPath);
        }
        return className;
    }

    @Override
    public void fireRequestDestroyed(ServletRequest servletRequest) {
    }

    @Override
    public void fireRequestInitialized(ServletRequest servletRequest) {
    }

    protected abstract void performStartup() throws Exception;

    protected abstract void cleanup();
}

