/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.wci.wildfly;

import io.undertow.server.session.Session;
import io.undertow.server.session.SessionManager;
import io.undertow.servlet.api.Deployment;
import io.undertow.servlet.api.DeploymentInfo;
import io.undertow.servlet.api.DeploymentManager;
import io.undertow.servlet.api.ServletContainer;
import io.undertow.servlet.api.ServletInfo;
import io.undertow.servlet.core.ApplicationListeners;
import io.undertow.servlet.handlers.ServletHandler;
import io.undertow.servlet.spec.HttpSessionImpl;
import io.undertow.servlet.spec.ServletContextImpl;
import io.undertow.servlet.spec.ServletRegistrationImpl;
import java.io.IOException;
import java.io.InputStream;
import javax.servlet.ServletContext;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpSession;
import org.gatein.common.logging.Logger;
import org.gatein.common.logging.LoggerFactory;
import org.gatein.wci.command.CommandServlet;
import org.gatein.wci.spi.WebAppContext;

public class Wildfly11WebAppContext
implements WebAppContext {
    public static final String GATEIN_SERVLET_NAME = "CommandServlet";
    public static final String GATEIN_SERVLET_PATH = "/wildfly11gateinservlet";
    private static final Logger log = LoggerFactory.getLogger(Wildfly11WebAppContext.class);
    private Deployment deployment;
    private SessionManager undertowSessionManager;
    private ServletContextImpl servletContext;
    private ClassLoader classLoader;
    private String contextPath;

    public Wildfly11WebAppContext(Deployment deployment) {
        if (deployment == null) {
            throw new IllegalArgumentException("'deployment' parameter is mandatory in WCI WebApp constructor");
        }
        this.deployment = deployment;
        this.undertowSessionManager = deployment.getSessionManager();
        if (this.undertowSessionManager == null) {
            throw new IllegalStateException("'undertowSessionManager' is mandatory in WCI WebApp constructor but couldn't be found in Deployment object");
        }
        this.servletContext = deployment.getServletContext();
        if (this.servletContext == null) {
            throw new IllegalStateException("'servletContext' is mandatory in WCI WebApp constructor but couldn't be found in Deployment object");
        }
        this.classLoader = this.servletContext.getClassLoader();
        if (this.classLoader == null) {
            throw new IllegalStateException("'classLoader' is mandatory in WCI WebApp constructor but couldn't be found in Deployment object");
        }
        this.contextPath = this.servletContext.getContextPath();
        if (this.contextPath == null) {
            throw new IllegalStateException("'contextPath' is mandatory in WCI WebApp constructor but couldn't be found in Deployment object");
        }
    }

    public void start() throws Exception {
        DeploymentInfo deploymentInfo = this.deployment.getDeploymentInfo();
        ServletInfo servlet = new ServletInfo(GATEIN_SERVLET_NAME, CommandServlet.class, deploymentInfo.getClassIntrospecter().createInstanceFactory(CommandServlet.class));
        deploymentInfo.addServlet(servlet);
        ServletHandler handler = this.deployment.getServlets().addServlet(servlet);
        ServletRegistrationImpl servletRegistrationImpl = new ServletRegistrationImpl(servlet, handler.getManagedServlet(), this.deployment);
        servletRegistrationImpl.addMapping(new String[]{GATEIN_SERVLET_PATH});
    }

    public void stop() {
        if (this.deployment.getDeploymentState() != DeploymentManager.State.STARTED) {
            log.debug((Object)("Attempt to stop deployment '" + this.deployment.getDeploymentInfo().getDeploymentName() + "' already stopped."));
            return;
        }
        try {
            this.deployment.getServletPaths().getServletHandlerByName(GATEIN_SERVLET_NAME).getManagedServlet().getServlet().release();
        }
        catch (Exception e) {
            log.error((Object)"Error while removing Servlet CommandServlet", (Throwable)e);
        }
        ServletContainer servletContainer = this.deployment.getServletContainer();
        DeploymentInfo deploymentInfo = this.deployment.getDeploymentInfo();
        String deploymentName = deploymentInfo.getDeploymentName();
        DeploymentManager deploymentManager = servletContainer.getDeployment(deploymentName);
        deploymentManager.undeploy();
    }

    public ServletContext getServletContext() {
        return this.servletContext;
    }

    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    public String getContextPath() {
        return this.contextPath;
    }

    public boolean importFile(String parentDirRelativePath, String name, InputStream source, boolean overwrite) throws IOException {
        return false;
    }

    public HttpSession getHttpSession(String sessionId) {
        Session session = this.undertowSessionManager.getSession(sessionId);
        if (session == null) {
            log.debug((Object)("Couldn't find session with id " + sessionId));
            return null;
        }
        return HttpSessionImpl.forSession((Session)session, (ServletContext)this.getServletContext(), (boolean)false);
    }

    public void fireRequestInitialized(ServletRequest request) {
        ApplicationListeners applicationListeners = this.deployment.getApplicationListeners();
        if (null != applicationListeners) {
            applicationListeners.requestInitialized(request);
        }
    }

    public void fireRequestDestroyed(ServletRequest request) {
        ApplicationListeners applicationListeners = this.deployment.getApplicationListeners();
        if (null != applicationListeners) {
            applicationListeners.requestDestroyed(request);
        }
    }
}

