/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.wci.wildfly;

import io.undertow.servlet.api.ServletContainer;
import java.util.concurrent.atomic.AtomicBoolean;
import org.gatein.common.logging.Logger;
import org.gatein.common.logging.LoggerFactory;
import org.gatein.wci.wildfly.Wildfly11ServletContainerContext;
import org.wildfly.extension.undertow.ServletContainerService;

public class Wildfly11Integration {
    private static final Logger log = LoggerFactory.getLogger(Wildfly11Integration.class);
    private static final String CROSS_CONTEXT_LOGOUT_KEY = "org.gatein.wci.cross_context_logout";
    protected final AtomicBoolean start = new AtomicBoolean(false);
    private Wildfly11ServletContainerContext containerContext = null;
    private ServletContainerService servletContainerService;

    public Wildfly11Integration(ServletContainerService servletContainerService) {
        this.servletContainerService = servletContainerService;
    }

    public void start() {
        if (this.start.compareAndSet(false, true)) {
            ServletContainer servletContainer = this.servletContainerService.getServletContainer();
            this.containerContext = new Wildfly11ServletContainerContext(servletContainer);
            this.containerContext.setCrossContextLogout(this.getCrossContextLogoutConfig());
            this.containerContext.start();
        }
    }

    public void stop() {
        if (this.start.compareAndSet(true, false)) {
            this.containerContext.stop();
        }
    }

    private boolean getCrossContextLogoutConfig() {
        String val = System.getProperty(CROSS_CONTEXT_LOGOUT_KEY);
        if (val == null || Boolean.valueOf(val).booleanValue()) {
            return true;
        }
        if (!"false".equalsIgnoreCase(val)) {
            log.warn((Object)("System property org.gatein.wci.cross_context_logout value is invalid: [" + val + "] - falling back to: [false]"));
        }
        log.debug((Object)"Cross-context session invalidation on logout disabled");
        return false;
    }
}

