/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.injection.helper;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.net.URLDecoder;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.exoplatform.container.RootContainer;
import org.exoplatform.container.configuration.ConfigurationManager;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.social.core.image.ImageUtils;
import org.exoplatform.social.core.model.AvatarAttachment;

public class InjectorUtils {
    private final Log LOG = ExoLogger.getLogger(InjectorUtils.class);
    public static final String DATA_INJECTOR_CONTENT_PATH = "/medias/contents/";
    public static final String DATA_INJECTOR_IMAGE_PATH = "/medias/images/";
    public static final String DATA_INJECTOR_DEFAULT_FOLDER_PATH = "data";

    public static String getConfigPath(String defaultDataPath) throws Exception {
        String injectorDataFolder = null;
        ConfigurationManager confManager = (ConfigurationManager)RootContainer.getInstance().getComponentInstanceOfType(ConfigurationManager.class);
        try {
            if (defaultDataPath != null && defaultDataPath.length() > 0) {
                injectorDataFolder = confManager.getResource(defaultDataPath).getPath();
            }
        }
        catch (Exception ex) {
            injectorDataFolder = confManager.getResource(DATA_INJECTOR_DEFAULT_FOLDER_PATH).getPath();
        }
        try {
            injectorDataFolder = URLDecoder.decode(injectorDataFolder, "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        return injectorDataFolder;
    }

    public static AvatarAttachment getAvatarAttachment(String fileName, String defaultFolder) throws Exception {
        String mimeType = "image/png";
        int WIDTH = 120;
        FileInputStream inputStream = FileUtils.openInputStream((File)new File(InjectorUtils.getConfigPath(defaultFolder) + DATA_INJECTOR_IMAGE_PATH + fileName));
        AvatarAttachment avatarAttachment = ImageUtils.createResizedAvatarAttachment((InputStream)inputStream, (int)WIDTH, (int)0, null, (String)fileName, (String)mimeType, null);
        if (avatarAttachment == null) {
            avatarAttachment = new AvatarAttachment(null, fileName, mimeType, (InputStream)inputStream, null, System.currentTimeMillis());
        }
        return avatarAttachment;
    }

    public static String getWikiPage(String fileName, String defaultFolder) throws IOException {
        StringWriter writer = null;
        try {
            if (fileName.equals("")) {
                return "";
            }
            FileInputStream inputStream = FileUtils.openInputStream((File)new File(InjectorUtils.getConfigPath(defaultFolder) + DATA_INJECTOR_CONTENT_PATH + fileName));
            writer = new StringWriter();
            IOUtils.copy((InputStream)inputStream, (Writer)writer);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return writer.toString();
    }

    public static InputStream getFile(String fileName, String fileType, String defaultFolder) throws IOException, Exception {
        if (fileName.equals("")) {
            return null;
        }
        FileInputStream inputStream = FileUtils.openInputStream((File)new File(InjectorUtils.getConfigPath(defaultFolder) + "/medias/" + fileType + "/" + fileName));
        return inputStream;
    }

    public static int getDayAsInt(String day) {
        if ("monday".equals(day)) {
            return 2;
        }
        if ("tuesday".equals(day)) {
            return 3;
        }
        if ("wednesday".equals(day)) {
            return 4;
        }
        if ("thursday".equals(day)) {
            return 5;
        }
        if ("friday".equals(day)) {
            return 6;
        }
        if ("saturday".equals(day)) {
            return 7;
        }
        if ("sunday".equals(day)) {
            return 1;
        }
        return 2;
    }

    public static int getHourAsInt(String hourString) {
        String[] start = hourString.split(":");
        Integer hour = Integer.parseInt(start[0]);
        return hour;
    }

    public static int getMinuteAsInt(String hourString) {
        String[] start = hourString.split(":");
        Integer minutes = Integer.parseInt(start[1]);
        return minutes;
    }
}

