/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.injection.services.impl;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.container.component.RequestLifeCycle;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.container.xml.ValueParam;
import org.exoplatform.injection.core.module.ActivityModule;
import org.exoplatform.injection.core.module.CalendarModule;
import org.exoplatform.injection.core.module.DocumentModule;
import org.exoplatform.injection.core.module.ForumModule;
import org.exoplatform.injection.core.module.SpaceModule;
import org.exoplatform.injection.core.module.UserModule;
import org.exoplatform.injection.core.module.WikiModule;
import org.exoplatform.injection.helper.InjectorMonitor;
import org.exoplatform.injection.helper.InjectorUtils;
import org.exoplatform.injection.services.DataInjector;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.json.JSONException;
import org.json.JSONObject;

public class DataInjectorImpl
implements DataInjector {
    private static final Log LOG = ExoLogger.getLogger(DataInjectorImpl.class);
    public static final String SCENARIOS_FOLDER = "/scenarios";
    public static final String SCENARIO_NAME_ATTRIBUTE = "scenarioName";
    private static Map<String, JSONObject> scenarios;
    private static final String DATA_INJECTION_FOLDER_PATH = "data-injection-folder-path";
    UserModule userModule_;
    SpaceModule spaceModule_;
    CalendarModule calendarModule_;
    WikiModule wikiModule_;
    ForumModule forumModule_;
    DocumentModule documentModule_;
    ActivityModule activityModule_;
    private String dataFolderPath = "";
    private Map<String, Integer> completion;

    public DataInjectorImpl(InitParams params, UserModule userModule, SpaceModule spaceModule, CalendarModule calendarModule, WikiModule wikiModule, ForumModule forumModule, DocumentModule documentModule, ActivityModule activityModule) {
        this.userModule_ = userModule;
        this.spaceModule_ = spaceModule;
        this.calendarModule_ = calendarModule;
        this.wikiModule_ = wikiModule;
        this.forumModule_ = forumModule;
        this.documentModule_ = documentModule;
        this.activityModule_ = activityModule;
        ValueParam dataFolderPathParam = params.getValueParam(DATA_INJECTION_FOLDER_PATH);
        if (dataFolderPathParam != null) {
            this.dataFolderPath = dataFolderPathParam.getValue();
        }
        this.setup(this.dataFolderPath);
    }

    @Override
    public Map setup(String dataFolderPath) {
        scenarios = new HashMap<String, JSONObject>();
        try {
            File scenariosFolder = new File(InjectorUtils.getConfigPath(dataFolderPath) + SCENARIOS_FOLDER);
            for (String fileName : scenariosFolder.list()) {
                FileInputStream stream = FileUtils.openInputStream((File)new File(InjectorUtils.getConfigPath(dataFolderPath) + SCENARIOS_FOLDER + "/" + fileName));
                String fileContent = DataInjectorImpl.getData(stream);
                try {
                    JSONObject json = new JSONObject(fileContent);
                    String name = json.getString(SCENARIO_NAME_ATTRIBUTE);
                    scenarios.put(name, json);
                }
                catch (JSONException e) {
                    LOG.error((Object)("Syntax error in scenario " + fileName), (Throwable)e);
                }
            }
        }
        catch (URISyntaxException use) {
            LOG.error((Object)"Unable to read scenario file", (Throwable)use);
        }
        catch (Exception e) {
            LOG.error((Object)"Unable to find scenario file", (Throwable)e);
        }
        return scenarios;
    }

    @Override
    public void inject(Map<String, Integer> completion) throws Exception {
        scenarios.forEach((k, v) -> this.inject((String)k, completion));
    }

    @Override
    public void purge(Map<String, Integer> completion) throws Exception {
        for (Map.Entry<String, JSONObject> scenarioEntry : scenarios.entrySet()) {
            this.purge(scenarioEntry.getKey(), completion);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void inject(String scenarioName, Map<String, Integer> completion) {
        PortalContainer portalContainer = PortalContainer.getInstance();
        ExoContainerContext.setCurrentContainer((ExoContainer)portalContainer);
        this.enforceCloseTransaction();
        LOG.info("Start {} .............", new Object[]{this.getClass().getName()});
        InjectorMonitor injectorMonitor = new InjectorMonitor("Data Injection Process");
        String downloadUrl = "";
        try {
            JSONObject scenarioData = scenarios.get(scenarioName).getJSONObject("data");
            if (scenarioData.has("users")) {
                LOG.info((Object)("Create " + scenarioData.getJSONArray("users").length() + " users."));
                completion.put("Users", 0);
                injectorMonitor.start("Processing users data");
                this.userModule_.createUsers(scenarioData.getJSONArray("users"), this.dataFolderPath);
                completion.put("Users", 100);
                injectorMonitor.stop();
            }
            if (scenarioData.has("relations")) {
                LOG.info((Object)("Create " + scenarioData.getJSONArray("relations").length() + " relations."));
                injectorMonitor.start("Processing relations data");
                this.userModule_.createRelations(scenarioData.getJSONArray("relations"));
                injectorMonitor.stop();
            }
            if (scenarioData.has("spaces")) {
                LOG.info((Object)("Create " + scenarioData.getJSONArray("spaces").length() + " spaces."));
                completion.put("Spaces", 0);
                injectorMonitor.start("Processing spaces data");
                this.spaceModule_.createSpaces(scenarioData.getJSONArray("spaces"), this.dataFolderPath);
                completion.put("Spaces", 100);
                injectorMonitor.stop();
            }
            if (scenarioData.has("wikis")) {
                LOG.info((Object)("Create " + scenarioData.getJSONArray("wikis").length() + " wikis."));
                completion.put("Wiki", 0);
                injectorMonitor.start("Processing wikis data");
                this.wikiModule_.createUserWiki(scenarioData.getJSONArray("wikis"), this.dataFolderPath);
                completion.put("Wiki", 100);
                injectorMonitor.stop();
            }
            if (scenarioData.has("activities")) {
                LOG.info((Object)("Create " + scenarioData.getJSONArray("activities").length() + " activities."));
                injectorMonitor.start("Processing activities data");
                this.activityModule_.pushActivities(scenarioData.getJSONArray("activities"));
                injectorMonitor.stop();
            }
            if (scenarioData.has("documents")) {
                LOG.info((Object)("Create " + scenarioData.getJSONArray("documents").length() + " documents."));
                completion.put("Documents", 0);
                injectorMonitor.start("Processing documents data");
                this.documentModule_.uploadDocuments(scenarioData.getJSONArray("documents"), this.dataFolderPath);
                completion.put("Documents", 100);
                injectorMonitor.stop();
            }
            if (scenarioData.has("forums")) {
                LOG.info((Object)("Create " + scenarioData.getJSONArray("forums").length() + " forums."));
                completion.put("Forums", 0);
                injectorMonitor.start("Processing forums data");
                this.forumModule_.createForumContents(scenarioData.getJSONArray("forums"));
                completion.put("Forums", 100);
                injectorMonitor.stop();
            }
            LOG.info((Object)"Data Injection has been done successfully.............");
            LOG.info((Object)injectorMonitor.prettyPrint());
        }
        catch (JSONException e) {
            LOG.error((Object)("Syntax error when reading scenario " + scenarioName), (Throwable)e);
        }
        finally {
            this.enforceCloseTransaction();
            RequestLifeCycle.begin((ExoContainer)portalContainer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void purge(String scenarioName, Map<String, Integer> completion) {
        PortalContainer portalContainer = PortalContainer.getInstance();
        ExoContainerContext.setCurrentContainer((ExoContainer)portalContainer);
        this.enforceCloseTransaction();
        LOG.info("Purge {} .............", new Object[]{this.getClass().getName()});
        InjectorMonitor injectorMonitor = new InjectorMonitor("Data Injection Purge Process");
        String downloadUrl = "";
        try {
            JSONObject scenarioData = scenarios.get(scenarioName).getJSONObject("data");
            if (scenarioData.has("spaces")) {
                LOG.info((Object)("Create " + scenarioData.getJSONArray("spaces").length() + " spaces."));
                injectorMonitor.start("Purging spaces");
                this.spaceModule_.purgeSpaces(scenarioData.getJSONArray("spaces"));
                injectorMonitor.stop();
            }
            if (scenarioData.has("relations")) {
                LOG.info((Object)("Purge " + scenarioData.getJSONArray("relations").length() + " relations."));
                injectorMonitor.start("Purging spaces");
                this.userModule_.purgeRelations(scenarioData.getJSONArray("relations"));
                injectorMonitor.stop();
            }
            LOG.info((Object)"Data purging has been done successfully.............");
            LOG.info((Object)injectorMonitor.prettyPrint());
        }
        catch (JSONException e) {
            LOG.error((Object)("Syntax error when reading scenario " + scenarioName), (Throwable)e);
        }
        finally {
            this.enforceCloseTransaction();
            RequestLifeCycle.begin((ExoContainer)PortalContainer.getInstance());
        }
    }

    public static String getData(InputStream inputStream) {
        String out = "";
        StringWriter writer = new StringWriter();
        try {
            IOUtils.copy((InputStream)inputStream, (Writer)writer);
            out = writer.toString();
        }
        catch (IOException e) {
            LOG.error("Error to load data ", new Object[]{e, e.getMessage()});
        }
        return out;
    }

    private void enforceCloseTransaction() {
        try {
            while (true) {
                RequestLifeCycle.end();
            }
        }
        catch (Exception e) {
            return;
        }
    }
}

