/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.cs.ext.impl;

import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.jcr.PathNotFoundException;
import org.exoplatform.calendar.service.CalendarEvent;
import org.exoplatform.calendar.service.CalendarService;
import org.exoplatform.calendar.service.Utils;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.cs.ext.impl.CalendarSpaceActivityPublisher;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.organization.User;
import org.exoplatform.services.security.ConversationState;
import org.exoplatform.social.core.space.model.Space;
import org.exoplatform.social.core.space.spi.SpaceService;
import org.exoplatform.social.webui.activity.BaseUIActivity;
import org.exoplatform.webui.application.WebuiRequestContext;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.core.lifecycle.UIFormLifecycle;
import org.exoplatform.webui.core.lifecycle.WebuiBindingContext;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.event.EventListener;

@ComponentConfig(lifecycle=UIFormLifecycle.class, template="classpath:groovy/cs/social-integration/plugin/space/CalendarUIActivity.gtmpl", events={@EventConfig(listeners={BaseUIActivity.LoadLikesActionListener.class}), @EventConfig(listeners={BaseUIActivity.ToggleDisplayCommentFormActionListener.class}), @EventConfig(listeners={BaseUIActivity.LikeActivityActionListener.class}), @EventConfig(listeners={BaseUIActivity.SetCommentListStatusActionListener.class}), @EventConfig(listeners={BaseUIActivity.PostCommentActionListener.class}), @EventConfig(listeners={BaseUIActivity.DeleteActivityActionListener.class}), @EventConfig(listeners={BaseUIActivity.DeleteCommentActionListener.class}), @EventConfig(listeners={AcceptEventActionListener.class}), @EventConfig(listeners={AssignTaskActionListener.class}), @EventConfig(listeners={SetTaskStatusActionListener.class})})
public class CalendarUIActivity
extends BaseUIActivity {
    private static final Log LOG = ExoLogger.getLogger(CalendarUIActivity.class);
    private boolean isAnswered = false;
    private boolean isInvited = false;
    private boolean isTaskAssignedToMe = false;
    private boolean isTaskDone = false;
    private boolean eventNotFound = false;
    private String taskStatus;
    private String eventId;
    private String calendarId;
    private CalendarEvent event = null;

    public void init() {
        block14: {
            try {
                String username;
                block13: {
                    this.eventId = (String)this.getActivity().getTemplateParams().get(CalendarSpaceActivityPublisher.EVENT_ID_KEY);
                    this.calendarId = (String)this.getActivity().getTemplateParams().get(CalendarSpaceActivityPublisher.CALENDAR_ID_KEY);
                    username = ConversationState.getCurrent().getIdentity().getUserId();
                    CalendarService calService = (CalendarService)PortalContainer.getInstance().getComponentInstanceOfType(CalendarService.class);
                    try {
                        this.event = calService.getGroupEvent(this.calendarId, this.eventId);
                    }
                    catch (PathNotFoundException pnf) {
                        if (!LOG.isDebugEnabled()) break block13;
                        LOG.debug((Object)("Couldn't find the event: " + this.eventId), (Throwable)pnf);
                    }
                }
                if (this.event == null) {
                    this.eventNotFound = true;
                    return;
                }
                HashMap<String, String> pars = new HashMap<String, String>();
                if (this.event.getEventType().equalsIgnoreCase(CalendarEvent.TYPE_EVENT) && this.event.getParticipantStatus() != null) {
                    for (String part : this.event.getParticipantStatus()) {
                        String[] entry = part.split(":");
                        if (entry.length > 1) {
                            pars.put(entry[0], entry[1]);
                            continue;
                        }
                        pars.put(entry[0], "");
                    }
                    if (pars.containsKey(username)) {
                        this.isInvited = true;
                        if (((String)pars.get(username)).equalsIgnoreCase("yes") || ((String)pars.get(username)).equalsIgnoreCase("no")) {
                            this.isAnswered = true;
                        }
                    }
                } else if (this.event.getEventType().equalsIgnoreCase(CalendarEvent.TYPE_TASK)) {
                    this.taskStatus = this.event.getEventState();
                    String taskDelegator = this.event.getTaskDelegator();
                    if (taskDelegator != null && taskDelegator.indexOf(username) >= 0) {
                        this.isTaskAssignedToMe = true;
                    }
                }
            }
            catch (Exception e) {
                if (!LOG.isErrorEnabled()) break block14;
                LOG.error((Object)("Could not calculate values of Calendar activity with event(task): " + this.eventId), (Throwable)e);
            }
        }
    }

    private String getTitleTemplate() {
        String typeOfEvent = this.getTypeOfEvent();
        String titleKey = "";
        if (CalendarSpaceActivityPublisher.EVENT_ADDED.equals(typeOfEvent)) {
            titleKey = "CalendarUIActivity.msg.event-add";
        } else if (CalendarSpaceActivityPublisher.TASK_ADDED.equals(typeOfEvent)) {
            titleKey = "CalendarUIActivity.msg.task-add";
        } else if (CalendarSpaceActivityPublisher.EVENT_UPDATED.equals(typeOfEvent)) {
            titleKey = "CalendarUIActivity.msg.event-update";
        } else if (CalendarSpaceActivityPublisher.TASK_UPDATED.equals(typeOfEvent)) {
            titleKey = "CalendarUIActivity.msg.task-update";
        }
        return WebuiRequestContext.getCurrentInstance().getApplicationResourceBundle().getString(titleKey);
    }

    private String getSummary() {
        return this.getActivityParamValue(CalendarSpaceActivityPublisher.EVENT_SUMMARY_KEY);
    }

    @Deprecated
    private String getEventLink() {
        String value = null;
        value = this.getActivityParamValue("EventLink");
        return value != null ? value : "";
    }

    public String getTaskStatus() {
        return this.taskStatus;
    }

    public boolean isTaskAssigned() {
        return this.isTaskAssignedToMe;
    }

    public boolean isTaskDone() {
        return this.isTaskDone;
    }

    public String getEventId() {
        return this.eventId;
    }

    public void setEventId(String eventId) {
        this.eventId = eventId;
    }

    public String getCalendarId() {
        return this.calendarId;
    }

    public void setCalendarId(String calendarId) {
        this.calendarId = calendarId;
    }

    public boolean isAnswered() {
        return this.isAnswered;
    }

    public boolean isInvited() {
        return this.isInvited;
    }

    public String getActivityParamValue(String key) {
        String value = null;
        Map params = this.getActivity().getTemplateParams();
        if (params != null) {
            value = (String)params.get(key);
        }
        return value;
    }

    public String getTypeOfEvent() {
        String type = "";
        Map params = this.getActivity().getTemplateParams();
        if (params != null) {
            type = (String)params.get(CalendarSpaceActivityPublisher.EVENT_TYPE_KEY);
        }
        return type;
    }

    public String getEventStartTime(WebuiBindingContext ctx) {
        String timeStr = this.getActivityParamValue(CalendarSpaceActivityPublisher.EVENT_STARTTIME_KEY);
        if (timeStr == null) {
            return "";
        }
        long time = Long.valueOf(timeStr);
        return CalendarSpaceActivityPublisher.getDateTimeString(this.getLocale(ctx), time, this.event, CalendarSpaceActivityPublisher.getUserTimeZone());
    }

    private Locale getLocale(WebuiBindingContext ctx) {
        return ctx.getRequestContext().getLocale();
    }

    public String getDescription() {
        String des = this.getActivityParamValue(CalendarSpaceActivityPublisher.EVENT_DESCRIPTION_KEY);
        return des != null ? CalendarUIActivity.extractWebLinkFromText(des) : "";
    }

    private static String extractWebLinkFromText(String text) {
        block3: {
            Pattern calendarPattern = Pattern.compile("(?i)\\b((?:https?://|www\\d{0,3}[.]|[a-z0-9.\\-]+[.][a-z]{2,4}/)(?:[^\\s()<>]+|\\(([^\\s()<>]+|(\\([^\\s()<>]+\\)))*\\))+(?:\\(([^\\s()<>]+|(\\([^\\s()<>]+\\)))*\\)|[^\\s`!()\\[\\]{};:'\".,<>???\u201c\u201d\u2018\u2019]))");
            try {
                Matcher matcher = calendarPattern.matcher(text);
                if (matcher.find()) {
                    return matcher.replaceAll("<a href=\"$1\" target=\"_blank\">$1</a>");
                }
            }
            catch (Exception e) {
                if (!LOG.isErrorEnabled()) break block3;
                LOG.error((Object)"Exception occurs when matching event description with web link patterns", (Throwable)e);
            }
        }
        return text;
    }

    public String getLocation() {
        String des = this.getActivityParamValue(CalendarSpaceActivityPublisher.EVENT_LOCALE_KEY);
        return des != null ? des : "";
    }

    public String getEventEndTime(WebuiBindingContext ctx) {
        String timeStr = this.getActivityParamValue(CalendarSpaceActivityPublisher.EVENT_ENDTIME_KEY);
        if (timeStr == null) {
            return "";
        }
        long time = Long.valueOf(timeStr);
        return CalendarSpaceActivityPublisher.getDateTimeString(this.getLocale(ctx), time, this.event, CalendarSpaceActivityPublisher.getUserTimeZone());
    }

    private String getEventPreviewLinkInSpace() {
        SpaceService spaceService = (SpaceService)PortalContainer.getInstance().getComponentInstanceOfType(SpaceService.class);
        String spaceGroupId = Utils.getSpaceGroupIdFromCalendarId((String)this.calendarId);
        Space space = spaceService.getSpaceByGroupId(spaceGroupId);
        StringBuffer sb = new StringBuffer("");
        if (space != null) {
            sb.append(org.exoplatform.social.webui.Utils.getSpaceHomeURL((Space)space)).append("/calendar").append("/invitation/detail/").append(ConversationState.getCurrent().getIdentity().getUserId()).append("/").append(this.eventId).append("/").append(this.event.getCalType());
        }
        return sb.toString();
    }

    public static class SetTaskStatusActionListener
    extends EventListener<CalendarUIActivity> {
        public void execute(Event<CalendarUIActivity> event) throws Exception {
            CalendarUIActivity uiComponent = (CalendarUIActivity)((Object)event.getSource());
            WebuiRequestContext requestContext = event.getRequestContext();
            String param = requestContext.getRequestParameter("objectId");
            try {
                CalendarService calService = (CalendarService)PortalContainer.getInstance().getComponentInstanceOfType(CalendarService.class);
                if (param != null && !param.equalsIgnoreCase(uiComponent.getTaskStatus())) {
                    calService.setGroupTaskStatus(uiComponent.getEventId(), uiComponent.getCalendarId(), param);
                }
            }
            catch (Exception e) {
                if (LOG.isWarnEnabled()) {
                    LOG.warn((Object)("Could not set task status for task: " + uiComponent.getEventId()));
                }
                throw e;
            }
            requestContext.addUIComponentToUpdateByAjax((UIComponent)uiComponent);
        }
    }

    public static class AssignTaskActionListener
    extends EventListener<CalendarUIActivity> {
        public void execute(Event<CalendarUIActivity> event) throws Exception {
            CalendarUIActivity uiComponent = (CalendarUIActivity)((Object)event.getSource());
            WebuiRequestContext requestContext = event.getRequestContext();
            if (!uiComponent.isTaskAssigned()) {
                try {
                    CalendarService calService = (CalendarService)PortalContainer.getInstance().getComponentInstanceOfType(CalendarService.class);
                    String remoteUser = requestContext.getRemoteUser();
                    calService.assignGroupTask(uiComponent.getEventId(), uiComponent.getCalendarId(), remoteUser);
                }
                catch (Exception e) {
                    if (LOG.isWarnEnabled()) {
                        LOG.warn((Object)("Could not assign user for task: " + uiComponent.getEventId()));
                    }
                    throw e;
                }
            }
            requestContext.addUIComponentToUpdateByAjax((UIComponent)uiComponent);
        }
    }

    public static class AcceptEventActionListener
    extends EventListener<CalendarUIActivity> {
        public void execute(Event<CalendarUIActivity> event) throws Exception {
            CalendarUIActivity uiComponent = (CalendarUIActivity)((Object)event.getSource());
            WebuiRequestContext requestContext = event.getRequestContext();
            String paramStr = requestContext.getRequestParameter("objectId");
            if (!uiComponent.isAnswered()) {
                boolean isAccepted = false;
                if (paramStr != null) {
                    isAccepted = Boolean.parseBoolean(paramStr);
                }
                try {
                    CalendarService calService = (CalendarService)PortalContainer.getInstance().getComponentInstanceOfType(CalendarService.class);
                    User user = (User)ConversationState.getCurrent().getAttribute("UserProfile");
                    int answer = 0;
                    if (isAccepted) {
                        answer = 1;
                    }
                    calService.confirmInvitation(user.getUserName(), user.getEmail(), user.getUserName(), 2, uiComponent.getCalendarId(), uiComponent.getEventId(), answer);
                }
                catch (Exception e) {
                    if (LOG.isWarnEnabled()) {
                        LOG.warn((Object)("Could not answer the invitation of event: " + uiComponent.getEventId()));
                    }
                    throw e;
                }
            }
            requestContext.addUIComponentToUpdateByAjax((UIComponent)uiComponent);
        }
    }
}

