/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.cs.ext.impl;

import java.text.DateFormat;
import java.text.DateFormatSymbols;
import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.TimeZone;
import org.exoplatform.calendar.service.CalendarEvent;
import org.exoplatform.calendar.service.CalendarService;
import org.exoplatform.calendar.service.CalendarSetting;
import org.exoplatform.calendar.service.Utils;
import org.exoplatform.calendar.service.impl.CalendarEventListener;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.portal.config.UserPortalConfigService;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.resources.ResourceBundleService;
import org.exoplatform.services.security.ConversationState;
import org.exoplatform.social.common.ExoSocialException;
import org.exoplatform.social.core.activity.model.ExoSocialActivity;
import org.exoplatform.social.core.activity.model.ExoSocialActivityImpl;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.core.manager.ActivityManager;
import org.exoplatform.social.core.manager.IdentityManager;
import org.exoplatform.social.core.space.model.Space;
import org.exoplatform.social.core.space.spi.SpaceService;
import org.exoplatform.webui.application.WebuiRequestContext;

public class CalendarSpaceActivityPublisher
extends CalendarEventListener {
    private static final Log LOG = ExoLogger.getLogger(CalendarSpaceActivityPublisher.class);
    public static final String CALENDAR_APP_ID = "cs-calendar:spaces";
    public static final String ACTIVITY_COMMENT_TYPE = "CALENDAR_ACTIVITY";
    public static final String EVENT_ADDED = "EventAdded".intern();
    public static final String EVENT_UPDATED = "EventUpdated".intern();
    public static final String EVENT_ID_KEY = "EventID".intern();
    public static final String CALENDAR_ID_KEY = "CalendarID".intern();
    public static final String TASK_ADDED = "TaskAdded".intern();
    public static final String TASK_UPDATED = "TaskUpdated".intern();
    public static final String EVENT_TYPE_KEY = "EventType".intern();
    public static final String EVENT_SUMMARY_KEY = "EventSummary".intern();
    public static final String EVENT_TITLE_KEY = "EventTitle".intern();
    public static final String EVENT_DESCRIPTION_KEY = "EventDescription".intern();
    public static final String EVENT_LOCALE_KEY = "EventLocale".intern();
    public static final String EVENT_STARTTIME_KEY = "EventStartTime".intern();
    public static final String EVENT_ENDTIME_KEY = "EventEndTime".intern();
    public static final String EVENT_LINK_KEY = "EventLink";
    public static final String INVITATION_DETAIL = "/invitation/detail/";
    public static final String CALENDAR_FIELDS_CHANGED = "CALENDAR_FIELDS_CHANGED";
    public static final String SUMMARY_UPDATED = "summary_updated";
    public static final String DESCRIPTION_UPDATED = "description_updated";
    public static final String DESCRIPTION_REMOVED = "description_removed";
    public static final String FROM_UPDATED = "fromDateTime_updated";
    public static final String TO_UPDATED = "toDateTime_updated";
    public static final String LOCATION_UPDATED = "location_updated";
    public static final String LOCATION_REMOVED = "location_removed";
    public static final String ALLDAY_UPDATED = "allDay_updated";
    public static final String REPEAT_UPDATED = "repeatType_updated";
    public static final String ATTACH_UPDATED = "attachment_updated";
    public static final String CATEGORY_UPDATED = "eventCategoryName_updated";
    public static final String CALENDAR_UPDATED = "calendarId_updated";
    public static final String PRIORITY_UPDATED = "priority_updated";
    private static final String RP_END_BYDATE = "endByDate";
    private static final String RP_END_AFTER = "endAfter";
    private static final String RP_END_NEVER = "neverEnd";
    private static final String RP_MONTHLY_BYDAY = "monthlyByDay";
    private static final String RP_MONTHLY_BYMONTHDAY = "monthlyByMonthDay";
    private static final String REPEAT_EVENT_INSTANCE_REMOVED = "repeatEvent_instance_removed";
    public static final String NAME_UPDATED = "name_updated";
    public static final String NOTE_UPDATED = "note_updated";
    public static final String NOTE_REMOVED = "note_removed";
    public static final String TASK_CATEGORY_UPDATED = "taskCategoryName_updated";
    public static final String TASK_CALENDAR_UPDATED = "task_CalendarId_updated";
    public static final String TASK_ATTACH_UPDATED = "task_attachment_updated";
    public static final String TASK_NEED_ACTION = CalendarEvent.NEEDS_ACTION;
    public static final String TASK_IN_PROCESS_ACTION = CalendarEvent.IN_PROCESS;
    public static final String TASK_COMPLETED_ACTION = CalendarEvent.COMPLETED;
    public static final String TASK_CANCELLED_ACTION = CalendarEvent.CANCELLED;
    public static final String STOP_REPEATING = "stop_repeating";
    public static final String EVENT_CANCELLED = "event_cancelled";
    private static final String LOCALE_US = "en";
    protected static final String CALENDAR_PREFIX_KEY = "CalendarUIActivity.msg.";
    private static final String EVENT_EXCEPTIONAL = "EXCEPTIONAL_EVENT";
    private CalendarService calendarService;
    private IdentityManager identityManager;
    private ActivityManager activityManager;
    private SpaceService spaceService;

    private String makeEventLink(CalendarEvent event) {
        StringBuffer sb = new StringBuffer("");
        PortalContainer instance = PortalContainer.getInstance();
        String portalURI = instance.getName();
        UserPortalConfigService portalConfigService = (UserPortalConfigService)instance.getComponentInstanceOfType(UserPortalConfigService.class);
        sb.append('/').append(portalURI).append('/').append(portalConfigService.getDefaultPortal()).append('/').append("calendar").append(INVITATION_DETAIL).append(ConversationState.getCurrent().getIdentity().getUserId()).append("/").append(event.getId()).append("/").append(event.getCalType());
        return sb.toString();
    }

    private Map<String, String> makeActivityParams(CalendarEvent event, String calendarId, String eventType) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put(EVENT_TYPE_KEY, eventType);
        params.put(EVENT_ID_KEY, event.getId());
        params.put(CALENDAR_ID_KEY, calendarId);
        params.put(EVENT_SUMMARY_KEY, event.getSummary());
        params.put(EVENT_LOCALE_KEY, event.getLocation() != null ? event.getLocation() : "");
        params.put(EVENT_DESCRIPTION_KEY, event.getDescription() != null ? event.getDescription() : "");
        params.put(EVENT_STARTTIME_KEY, String.valueOf(event.getFromDateTime().getTime()));
        params.put(EVENT_ENDTIME_KEY, String.valueOf(event.getToDateTime().getTime()));
        params.put(EVENT_LINK_KEY, this.makeEventLink(event));
        if (event.getIsExceptionOccurrence() != null && event.getIsExceptionOccurrence().booleanValue()) {
            params.put(EVENT_EXCEPTIONAL, Boolean.TRUE.toString());
        }
        return params;
    }

    private void publishActivity(CalendarEvent event) {
        ExoSocialActivity activity = this.getActivityForEvent(event);
        if (activity == null && LOG.isDebugEnabled()) {
            LOG.error((Object)"Can not record Activity for space when event added ");
        }
    }

    private ExoSocialActivity getActivityForEvent(CalendarEvent calendarEvent) {
        String eventType = calendarEvent.getEventType().equalsIgnoreCase(CalendarEvent.TYPE_EVENT) ? EVENT_ADDED : TASK_ADDED;
        String calendarId = calendarEvent.getCalendarId();
        if (calendarId == null || calendarId.indexOf("_space_calendar") < 0) {
            return null;
        }
        this.identityManager = (IdentityManager)PortalContainer.getInstance().getComponentInstanceOfType(IdentityManager.class);
        this.spaceService = (SpaceService)PortalContainer.getInstance().getComponentInstanceOfType(SpaceService.class);
        this.activityManager = (ActivityManager)PortalContainer.getInstance().getComponentInstanceOfType(ActivityManager.class);
        this.calendarService = (CalendarService)PortalContainer.getInstance().getComponentInstance(CalendarService.class);
        String spaceGroupId = Utils.getSpaceGroupIdFromCalendarId((String)calendarId);
        Space space = this.spaceService.getSpaceByGroupId(spaceGroupId);
        if (space == null) {
            return null;
        }
        String userId = ConversationState.getCurrent().getIdentity().getUserId();
        Identity spaceIdentity = this.identityManager.getOrCreateIdentity("space", space.getPrettyName(), false);
        Identity userIdentity = this.identityManager.getOrCreateIdentity("organization", userId, false);
        ExoSocialActivity activity = null;
        if (calendarEvent.getActivityId() != null) {
            activity = this.activityManager.getActivity(calendarEvent.getActivityId());
        }
        if (activity == null || calendarEvent.getIsExceptionOccurrence() != null && activity.getTemplateParams().get(EVENT_EXCEPTIONAL) == null) {
            activity = new ExoSocialActivityImpl();
            activity.setUserId(userIdentity.getId());
            activity.setTitle(calendarEvent.getSummary());
            activity.setBody(calendarEvent.getDescription());
            activity.setType(CALENDAR_APP_ID);
            activity.setTemplateParams(this.makeActivityParams(calendarEvent, calendarId, eventType));
            this.activityManager.saveActivityNoReturn(spaceIdentity, activity);
            calendarEvent.setActivityId(activity.getId());
            try {
                this.calendarService.savePublicEvent(calendarId, calendarEvent, false);
            }
            catch (Exception e) {
                LOG.error("Couldn't attach the Activity ID {} to the event {}", new Object[]{activity.getId(), calendarEvent.getId(), e});
            }
        } else {
            activity.setTitle(calendarEvent.getSummary());
            activity.setBody(calendarEvent.getDescription());
            activity.setTemplateParams(this.makeActivityParams(calendarEvent, calendarId, eventType));
            this.activityManager.updateActivity(activity);
        }
        return activity;
    }

    private void updateToActivity(CalendarEvent event, Map<String, String> messagesParams) {
        ExoSocialActivity activity = this.getActivityForEvent(event);
        if (activity != null) {
            ExoSocialActivity comment = this.createComment(messagesParams, null);
            this.activityManager.saveComment(activity, comment);
        }
    }

    public void updateFollowingOccurrences(CalendarEvent originEvent, Date stopDate) {
        ExoSocialActivity activity = this.getActivityForEvent(originEvent);
        if (activity != null) {
            HashMap<String, String> params = new HashMap<String, String>();
            params.put(STOP_REPEATING, String.valueOf(stopDate.getTime()));
            ExoSocialActivity comment = this.createComment(params, originEvent);
            this.activityManager.saveComment(activity, comment);
        }
    }

    public void removeOneOccurrence(CalendarEvent originEvent, CalendarEvent removedEvent) {
        ExoSocialActivity activity = this.getActivityForEvent(originEvent);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put(EVENT_CANCELLED, String.valueOf(removedEvent.getFromDateTime().getTime()));
        ExoSocialActivity comment = this.createComment(params, null);
        if (comment != null) {
            this.activityManager.saveComment(activity, comment);
        }
    }

    private ExoSocialActivity createComment(Map<String, String> messagesParams, CalendarEvent repeatEvent) {
        String userId = ConversationState.getCurrent().getIdentity().getUserId();
        if (this.identityManager == null) {
            return null;
        }
        Identity userIdentity = this.identityManager.getOrCreateIdentity("organization", userId, false);
        ExoSocialActivityImpl newComment = new ExoSocialActivityImpl();
        newComment.isComment(true);
        newComment.setUserId(userIdentity.getId());
        newComment.setType(ACTIVITY_COMMENT_TYPE);
        StringBuilder fields = new StringBuilder();
        LinkedHashMap<String, String> data = new LinkedHashMap<String, String>();
        for (String field : messagesParams.keySet()) {
            String value = messagesParams.get(field);
            data.put(field, value);
            fields.append("," + field);
        }
        String fieldsChanged = fields.toString().substring(1);
        data.put(CALENDAR_FIELDS_CHANGED, fieldsChanged);
        newComment.setTitleId(fieldsChanged);
        newComment.setTemplateParams(data);
        newComment.setTitle(fieldsChanged);
        return newComment;
    }

    private void deleteActivity(CalendarEvent event, String calendarId) {
        block7: {
            try {
                Class.forName("org.exoplatform.social.core.space.spi.SpaceService");
            }
            catch (ClassNotFoundException e) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)"eXo Social components not found!", (Throwable)e);
                }
                return;
            }
            if (calendarId == null || calendarId.indexOf("_space_calendar") < 0) {
                return;
            }
            try {
                this.activityManager = (ActivityManager)PortalContainer.getInstance().getComponentInstanceOfType(ActivityManager.class);
                this.spaceService = (SpaceService)PortalContainer.getInstance().getComponentInstanceOfType(SpaceService.class);
                String spaceGroupId = Utils.getSpaceGroupIdFromCalendarId((String)calendarId);
                Space space = this.spaceService.getSpaceByGroupId(spaceGroupId);
                if (space != null && event.getActivityId() != null) {
                    this.activityManager.deleteActivity(event.getActivityId());
                }
            }
            catch (ExoSocialException e) {
                if (!LOG.isDebugEnabled()) break block7;
                LOG.error((Object)"Can not delete Activity for space when event deleted ", (Throwable)e);
            }
        }
    }

    private Map<String, String> buildParams(CalendarEvent oldEvent, CalendarEvent newEvent) {
        LinkedHashMap<String, String> messagesParams = new LinkedHashMap<String, String>();
        try {
            if (CalendarEvent.TYPE_EVENT.equals(newEvent.getEventType())) {
                if (!oldEvent.getSummary().equals(newEvent.getSummary())) {
                    messagesParams.put(SUMMARY_UPDATED, newEvent.getSummary());
                }
                if (newEvent.getDescription() != null && !newEvent.getDescription().equals(oldEvent.getDescription())) {
                    messagesParams.put(DESCRIPTION_UPDATED, newEvent.getDescription());
                } else if (newEvent.getDescription() == null && oldEvent.getDescription() != null) {
                    messagesParams.put(DESCRIPTION_REMOVED, "");
                }
                if (newEvent.getLocation() != null && !newEvent.getLocation().equals(oldEvent.getLocation())) {
                    messagesParams.put(LOCATION_UPDATED, newEvent.getLocation());
                } else if (newEvent.getLocation() == null && oldEvent.getLocation() != null) {
                    messagesParams.put(LOCATION_REMOVED, "");
                }
                if (newEvent.getPriority() != null && !newEvent.getPriority().equals(oldEvent.getPriority())) {
                    messagesParams.put(PRIORITY_UPDATED, newEvent.getPriority());
                }
                if (newEvent.getAttachment() != null) {
                    if (oldEvent.getAttachment() == null) {
                        messagesParams.put(ATTACH_UPDATED, "");
                    } else if (newEvent.getAttachment().size() != oldEvent.getAttachment().size()) {
                        messagesParams.put(ATTACH_UPDATED, "");
                    }
                }
                if (CalendarSpaceActivityPublisher.isAllDayEvent(newEvent) && !CalendarSpaceActivityPublisher.isAllDayEvent(oldEvent) && CalendarEvent.TYPE_EVENT.equals(oldEvent.getEventType())) {
                    messagesParams.put(ALLDAY_UPDATED, "");
                } else if (!CalendarSpaceActivityPublisher.isAllDayEvent(newEvent)) {
                    if (newEvent.getFromDateTime().compareTo(oldEvent.getFromDateTime()) != 0) {
                        messagesParams.put(FROM_UPDATED, String.valueOf(newEvent.getFromDateTime().getTime()));
                    }
                    if (newEvent.getToDateTime().compareTo(oldEvent.getToDateTime()) != 0) {
                        messagesParams.put(TO_UPDATED, String.valueOf(newEvent.getToDateTime().getTime()));
                    }
                }
                String repeatSummary = CalendarSpaceActivityPublisher.buildRepeatSummary(newEvent);
                if (!repeatSummary.equals(CalendarSpaceActivityPublisher.buildRepeatSummary(oldEvent))) {
                    messagesParams.put(REPEAT_UPDATED, repeatSummary);
                }
                if (newEvent == null) {
                    messagesParams.put(REPEAT_EVENT_INSTANCE_REMOVED, this.getDateFormattedAfterUserSetting(oldEvent.getRecurrenceId()));
                }
            } else {
                if (!oldEvent.getSummary().equals(newEvent.getSummary())) {
                    messagesParams.put(NAME_UPDATED, newEvent.getSummary());
                }
                if (newEvent.getDescription() != null && !newEvent.getDescription().equals(oldEvent.getDescription())) {
                    messagesParams.put(NOTE_UPDATED, newEvent.getDescription());
                } else if (newEvent.getDescription() == null && oldEvent.getDescription() != null) {
                    messagesParams.put(NOTE_REMOVED, "");
                }
                if (!CalendarSpaceActivityPublisher.isAllDayEvent(newEvent)) {
                    if (newEvent.getFromDateTime().compareTo(oldEvent.getFromDateTime()) != 0) {
                        messagesParams.put(FROM_UPDATED, String.valueOf(newEvent.getFromDateTime().getTime()));
                    }
                    if (newEvent.getToDateTime().compareTo(oldEvent.getToDateTime()) != 0) {
                        messagesParams.put(TO_UPDATED, String.valueOf(newEvent.getToDateTime().getTime()));
                    }
                }
                if (newEvent.getPriority() != null && !newEvent.getPriority().equals(oldEvent.getPriority())) {
                    messagesParams.put(PRIORITY_UPDATED, newEvent.getPriority());
                }
                if (newEvent.getAttachment() != null) {
                    if (oldEvent.getAttachment() == null) {
                        messagesParams.put(TASK_ATTACH_UPDATED, "");
                    } else if (newEvent.getAttachment().size() != oldEvent.getAttachment().size()) {
                        messagesParams.put(TASK_ATTACH_UPDATED, "");
                    }
                }
                if (newEvent.getEventState() != null && !newEvent.getEventState().equals(oldEvent.getEventState())) {
                    if (CalendarEvent.NEEDS_ACTION.equals(newEvent.getEventState())) {
                        messagesParams.put(TASK_NEED_ACTION, newEvent.getEventState());
                    } else if (CalendarEvent.IN_PROCESS.equals(newEvent.getEventState())) {
                        messagesParams.put(TASK_IN_PROCESS_ACTION, newEvent.getEventState());
                    } else if (CalendarEvent.COMPLETED.equals(newEvent.getEventState())) {
                        messagesParams.put(TASK_COMPLETED_ACTION, newEvent.getEventState());
                    } else if (CalendarEvent.CANCELLED.equals(newEvent.getEventState())) {
                        messagesParams.put(TASK_CANCELLED_ACTION, newEvent.getEventState());
                    }
                }
            }
        }
        catch (Exception e) {
            LOG.error((Object)"Can not build message for space when event updated ", (Throwable)e);
        }
        return messagesParams;
    }

    private String getDateFormattedAfterUserSetting(String date) {
        try {
            String userId = ConversationState.getCurrent().getIdentity().getUserId();
            this.calendarService = (CalendarService)PortalContainer.getInstance().getComponentInstance(CalendarService.class);
            CalendarSetting calSetting = this.calendarService.getCalendarSetting(userId);
            WebuiRequestContext requestContext = (WebuiRequestContext)WebuiRequestContext.getCurrentInstance();
            Locale locale = requestContext.getParentAppRequestContext().getLocale();
            SimpleDateFormat format = new SimpleDateFormat(calSetting.getDateFormat(), locale);
            SimpleDateFormat format1 = new SimpleDateFormat("yyyyMMdd'T'HHmmss'Z'");
            Date eventDate = format1.parse(date);
            return format.format(eventDate);
        }
        catch (Exception e) {
            LOG.debug((Object)e.getMessage());
            return null;
        }
    }

    public static String buildRepeatSummary(CalendarEvent repeatEvent) {
        return CalendarSpaceActivityPublisher.buildRepeatSummary(repeatEvent, Locale.ENGLISH);
    }

    public static String buildRepeatSummary(CalendarEvent repeatEvent, Locale locale) {
        if (repeatEvent == null) {
            return "";
        }
        String repeatType = repeatEvent.getRepeatType();
        if (CalendarEvent.RP_NOREPEAT.equals(repeatType) || repeatType == null) {
            return "";
        }
        try {
            String userId = ConversationState.getCurrent().getIdentity().getUserId();
            CalendarService calendarService = (CalendarService)ExoContainerContext.getCurrentContainer().getComponentInstanceOfType(CalendarService.class);
            CalendarSetting calSetting = calendarService.getCalendarSetting(userId);
            SimpleDateFormat format = new SimpleDateFormat(calSetting.getDateFormat(), locale);
            DateFormatSymbols symbols = new DateFormatSymbols(locale);
            String[] dayOfWeeks = symbols.getWeekdays();
            int interval = (int)repeatEvent.getRepeatInterval();
            int count = (int)repeatEvent.getRepeatCount();
            Date until = repeatEvent.getRepeatUntilDate();
            String endType = RP_END_NEVER;
            if (count > 0) {
                endType = RP_END_AFTER;
            }
            if (until != null) {
                endType = RP_END_BYDATE;
            }
            StringBuilder pattern = new StringBuilder("");
            if (repeatType.equals(CalendarEvent.RP_DAILY)) {
                if (interval == 1) {
                    pattern.append(CalendarSpaceActivityPublisher.getUICalendarLabel("daily", locale));
                } else {
                    pattern.append(CalendarSpaceActivityPublisher.getUICalendarLabel("every-day", locale));
                }
                if (endType.equals(RP_END_AFTER)) {
                    pattern.append(", " + CalendarSpaceActivityPublisher.getUICalendarLabel("count-times", locale));
                }
                if (endType.equals(RP_END_BYDATE)) {
                    pattern.append(", " + CalendarSpaceActivityPublisher.getUICalendarLabel("until", locale));
                }
                return new String(pattern).replace("{interval}", String.valueOf(interval)).replace("{count}", String.valueOf(repeatEvent.getRepeatCount())).replace("{until}", repeatEvent.getRepeatUntilDate() == null ? "" : format.format(repeatEvent.getRepeatUntilDate()));
            }
            if (repeatType.equals(CalendarEvent.RP_WEEKLY)) {
                if (interval == 1) {
                    pattern.append(CalendarSpaceActivityPublisher.getUICalendarLabel("weekly", locale));
                } else {
                    pattern.append(CalendarSpaceActivityPublisher.getUICalendarLabel("every-week", locale));
                }
                if (endType.equals(RP_END_AFTER)) {
                    pattern.append(", " + CalendarSpaceActivityPublisher.getUICalendarLabel("count-times", locale));
                }
                if (endType.equals(RP_END_BYDATE)) {
                    pattern.append(", " + CalendarSpaceActivityPublisher.getUICalendarLabel("until", locale));
                }
                String[] weeklyByDays = repeatEvent.getRepeatByDay();
                StringBuffer byDays = new StringBuffer();
                for (int i = 0; i < weeklyByDays.length; ++i) {
                    if (i == 0) {
                        byDays.append(dayOfWeeks[CalendarSpaceActivityPublisher.convertToDayOfWeek(weeklyByDays[0])]);
                        continue;
                    }
                    byDays.append(", ");
                    byDays.append(dayOfWeeks[CalendarSpaceActivityPublisher.convertToDayOfWeek(weeklyByDays[i])]);
                }
                return new String(pattern).replace("{interval}", String.valueOf(interval)).replace("{count}", String.valueOf(repeatEvent.getRepeatCount())).replace("{until}", repeatEvent.getRepeatUntilDate() == null ? "" : format.format(repeatEvent.getRepeatUntilDate())).replace("{byDays}", byDays.toString());
            }
            if (repeatType.equals(CalendarEvent.RP_MONTHLY)) {
                String monthlyType = RP_MONTHLY_BYMONTHDAY;
                if (repeatEvent.getRepeatByDay() != null && repeatEvent.getRepeatByDay().length > 0) {
                    monthlyType = RP_MONTHLY_BYDAY;
                }
                if (interval == 1) {
                    pattern.append(CalendarSpaceActivityPublisher.getUICalendarLabel("monthly", locale));
                } else {
                    pattern.append(CalendarSpaceActivityPublisher.getUICalendarLabel("every-month", locale));
                }
                if (monthlyType.equals(RP_MONTHLY_BYDAY)) {
                    pattern.append(" " + CalendarSpaceActivityPublisher.getUICalendarLabel("monthly-by-day", locale));
                } else {
                    pattern.append(" " + CalendarSpaceActivityPublisher.getUICalendarLabel("monthly-by-month-day", locale));
                }
                if (endType.equals(RP_END_AFTER)) {
                    pattern.append(", " + CalendarSpaceActivityPublisher.getUICalendarLabel("count-times", locale));
                }
                if (endType.equals(RP_END_BYDATE)) {
                    pattern.append(", " + CalendarSpaceActivityPublisher.getUICalendarLabel("until", locale));
                }
                String theNumber = "";
                String theDay = "";
                if (monthlyType.equals(RP_MONTHLY_BYDAY)) {
                    Calendar temp = CalendarSpaceActivityPublisher.getCalendarInstanceBySetting(calSetting);
                    temp.setTime(repeatEvent.getFromDateTime());
                    int weekOfMonth = temp.get(4);
                    Calendar temp2 = CalendarSpaceActivityPublisher.getCalendarInstanceBySetting(calSetting);
                    temp2.setTime(temp.getTime());
                    temp2.add(5, 7);
                    if (temp2.get(2) != temp.get(2)) {
                        weekOfMonth = 5;
                    }
                    int dayOfWeek = temp.get(7);
                    String[] weekOfMonths = new String[]{CalendarSpaceActivityPublisher.getUICalendarLabel("summary-the-first", locale), CalendarSpaceActivityPublisher.getUICalendarLabel("summary-the-second", locale), CalendarSpaceActivityPublisher.getUICalendarLabel("summary-the-third", locale), CalendarSpaceActivityPublisher.getUICalendarLabel("summary-the-fourth", locale), CalendarSpaceActivityPublisher.getUICalendarLabel("summary-the-last", locale)};
                    theNumber = weekOfMonths[weekOfMonth - 1];
                    theDay = dayOfWeeks[dayOfWeek];
                } else {
                    Calendar temp = CalendarSpaceActivityPublisher.getCalendarInstanceBySetting(calSetting);
                    temp.setTime(repeatEvent.getFromDateTime());
                    int dayOfMonth = temp.get(5);
                    theDay = String.valueOf(dayOfMonth);
                }
                return new String(pattern).replace("{interval}", String.valueOf(interval)).replace("{count}", String.valueOf(repeatEvent.getRepeatCount())).replace("{until}", repeatEvent.getRepeatUntilDate() == null ? "" : format.format(repeatEvent.getRepeatUntilDate())).replace("{theDay}", theDay).replace("{theNumber}", theNumber);
            }
            if (repeatType.equals(CalendarEvent.RP_YEARLY)) {
                if (interval == 1) {
                    pattern.append(CalendarSpaceActivityPublisher.getUICalendarLabel("yearly", locale));
                } else {
                    pattern.append(CalendarSpaceActivityPublisher.getUICalendarLabel("every-year", locale));
                }
                if (endType.equals(RP_END_AFTER)) {
                    pattern.append(", " + CalendarSpaceActivityPublisher.getUICalendarLabel("count-times", locale));
                }
                if (endType.equals(RP_END_BYDATE)) {
                    pattern.append(", " + CalendarSpaceActivityPublisher.getUICalendarLabel("until", locale));
                }
                String theDay = format.format(repeatEvent.getFromDateTime());
                return new String(pattern).replace("{interval}", String.valueOf(interval)).replace("{count}", String.valueOf(repeatEvent.getRepeatCount())).replace("{until}", repeatEvent.getRepeatUntilDate() == null ? "" : format.format(repeatEvent.getRepeatUntilDate())).replace("{theDay}", theDay);
            }
        }
        catch (Exception e) {
            LOG.error((Object)"Error while building event repeat summary", (Throwable)e);
        }
        return null;
    }

    public static String buildComment(ExoSocialActivity comment, CalendarEvent repeatEvent, Locale locale) {
        StringBuilder commentMessage = new StringBuilder();
        Map tempParams = comment.getTemplateParams();
        String fieldsChanged = (String)tempParams.get(CALENDAR_FIELDS_CHANGED);
        if (fieldsChanged == null) {
            return comment.getTitle();
        }
        String[] fields = fieldsChanged.split(",");
        for (int i = 0; i < fields.length; ++i) {
            String childMessage;
            long time;
            String label = CalendarSpaceActivityPublisher.getUICalendarLabel(fields[i], locale);
            label = label.replace("'", "''");
            if (fields[i].equals(FROM_UPDATED) || fields[i].equals(TO_UPDATED)) {
                time = Long.valueOf((String)tempParams.get(fields[i]));
                childMessage = MessageFormat.format(label, CalendarSpaceActivityPublisher.getDateTimeString(locale, time, null, CalendarSpaceActivityPublisher.getUserTimeZone()));
            } else if (fields[i].equals(STOP_REPEATING) || fields[i].equals(EVENT_CANCELLED)) {
                time = Long.valueOf((String)tempParams.get(fields[i]));
                Calendar calendar = GregorianCalendar.getInstance(locale);
                calendar.setTimeInMillis(time);
                childMessage = MessageFormat.format(label, CalendarSpaceActivityPublisher.getDateString(locale, calendar, CalendarSpaceActivityPublisher.getUserTimeZone()));
            } else {
                childMessage = fields[i].equals(REPEAT_UPDATED) ? MessageFormat.format(label, CalendarSpaceActivityPublisher.buildRepeatSummary(repeatEvent, locale)) : MessageFormat.format(label, tempParams.get(fields[i]));
            }
            commentMessage.append(childMessage + "<br/>");
        }
        return commentMessage.toString();
    }

    public static String getDateTimeString(Locale locale, long time, CalendarEvent event, TimeZone tz) {
        WebuiRequestContext requestContext = (WebuiRequestContext)WebuiRequestContext.getCurrentInstance();
        ResourceBundle rb = requestContext.getApplicationResourceBundle();
        Calendar calendar = GregorianCalendar.getInstance(locale);
        calendar.setTimeInMillis(time);
        StringBuilder sb = new StringBuilder(CalendarSpaceActivityPublisher.getDateString(locale, calendar, tz));
        sb.append(" ");
        if (event != null && CalendarSpaceActivityPublisher.isAllDayEvent(event)) {
            if (CalendarEvent.TYPE_EVENT.equals(event.getEventType())) {
                sb.append(rb.getString("CalendarUIActivity.label.allday"));
            }
        } else {
            sb.append(CalendarSpaceActivityPublisher.getTimeString(locale, calendar, tz));
        }
        return sb.toString();
    }

    public static String getDateString(Locale locale, Calendar calendar, TimeZone tz) {
        DateFormat dformat = DateFormat.getDateInstance(0, locale);
        dformat.setTimeZone(tz);
        return CalendarSpaceActivityPublisher.capitalizeFirstChar(dformat.format(calendar.getTime()));
    }

    public static String getTimeString(Locale locale, Calendar calendar, TimeZone tz) {
        DateFormat tformat = DateFormat.getTimeInstance(3, locale);
        tformat.setTimeZone(tz);
        String timeStr = tformat.format(calendar.getTime());
        if (LOCALE_US.equals(locale) && timeStr.indexOf(":00") > -1) {
            return timeStr.replace(":00", "");
        }
        return timeStr;
    }

    private static String capitalizeFirstChar(String str) {
        StringBuilder sb = new StringBuilder(str.substring(0, 1).toUpperCase());
        sb.append(str.substring(1));
        return sb.toString();
    }

    public static String getUICalendarLabel(String label, Locale locale) {
        ResourceBundleService resourceBundleService = (ResourceBundleService)ExoContainerContext.getCurrentContainer().getComponentInstanceOfType(ResourceBundleService.class);
        ResourceBundle resourceBundle = resourceBundleService.getResourceBundle("locale.calendar.integration.integration", locale);
        return resourceBundle.getString(CALENDAR_PREFIX_KEY + label);
    }

    public static int convertToDayOfWeek(String day) {
        int dayOfWeek = day.equals("MO") ? 2 : (day.equals("TU") ? 3 : (day.equals("WE") ? 4 : (day.equals("TH") ? 5 : (day.equals("FR") ? 6 : (day.equals("SA") ? 7 : (day.equals("SU") ? 1 : 0))))));
        return dayOfWeek;
    }

    public static Calendar getCalendarInstanceBySetting(CalendarSetting calendarSetting) {
        Calendar calendar = GregorianCalendar.getInstance();
        calendar.setLenient(false);
        calendar.setTimeZone(TimeZone.getTimeZone(calendarSetting.getTimeZone()));
        calendar.setFirstDayOfWeek(Integer.parseInt(calendarSetting.getWeekStartOn()));
        calendar.setMinimalDaysInFirstWeek(4);
        return calendar;
    }

    private static boolean isAllDayEvent(CalendarEvent eventCalendar) {
        try {
            TimeZone tz = CalendarSpaceActivityPublisher.getUserTimeZone();
            GregorianCalendar cal1 = new GregorianCalendar(tz);
            GregorianCalendar cal2 = new GregorianCalendar(tz);
            cal1.setLenient(false);
            cal1.setTime(eventCalendar.getFromDateTime());
            cal2.setLenient(false);
            cal2.setTime(eventCalendar.getToDateTime());
            return cal1.get(11) == 0 && cal1.get(12) == 0 && cal2.get(11) == ((Calendar)cal2).getActualMaximum(11) && cal2.get(12) == ((Calendar)cal2).getActualMaximum(12);
        }
        catch (Exception e) {
            if (LOG.isDebugEnabled()) {
                LOG.error((Object)"Can not check all day event when event updated ", (Throwable)e);
            }
            return false;
        }
    }

    public static TimeZone getUserTimeZone() {
        try {
            String username = ConversationState.getCurrent().getIdentity().getUserId();
            CalendarService calService = (CalendarService)PortalContainer.getInstance().getComponentInstanceOfType(CalendarService.class);
            CalendarSetting setting = calService.getCalendarSetting(username);
            return TimeZone.getTimeZone(setting.getTimeZone());
        }
        catch (Exception e) {
            if (LOG.isDebugEnabled()) {
                LOG.error((Object)"Can not get time zone from user setting ", (Throwable)e);
            }
            return null;
        }
    }

    public void savePublicEvent(CalendarEvent event, String calendarId) {
        this.publishActivity(event);
    }

    public void updatePublicEvent(CalendarEvent oldEvent, CalendarEvent newEvent, String calendarId) {
        Map<String, String> messagesParams = this.buildParams(oldEvent, newEvent);
        if (messagesParams.size() > 0) {
            this.updateToActivity(newEvent, messagesParams);
        }
    }

    public void updatePublicEvent(CalendarEvent newEvent, String calendarId) {
        this.publishActivity(newEvent);
    }

    public void deletePublicEvent(CalendarEvent event, String calendarId) {
        this.deleteActivity(event, calendarId);
    }
}

