/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.wcm.ext.component.activity.listener;

import java.io.InputStream;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Map;
import javax.jcr.Item;
import javax.jcr.Node;
import javax.jcr.PathNotFoundException;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.services.cms.link.LinkManager;
import org.exoplatform.services.context.DocumentContext;
import org.exoplatform.services.jcr.core.ManageableRepository;
import org.exoplatform.services.jcr.ext.common.SessionProvider;
import org.exoplatform.services.jcr.ext.hierarchy.NodeHierarchyCreator;
import org.exoplatform.services.jcr.impl.core.NodeImpl;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.security.ConversationState;
import org.exoplatform.services.wcm.core.NodeLocation;
import org.exoplatform.services.wcm.core.WebSchemaConfigService;
import org.exoplatform.services.wcm.utils.WCMCoreUtils;
import org.exoplatform.services.wcm.webcontent.WebContentSchemaHandler;
import org.exoplatform.social.core.activity.model.ExoSocialActivity;
import org.exoplatform.social.core.activity.model.ExoSocialActivityImpl;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.core.manager.ActivityManager;
import org.exoplatform.social.core.manager.IdentityManager;
import org.exoplatform.social.core.space.spi.SpaceService;

public class Utils {
    private static final Log LOG = ExoLogger.getLogger(Utils.class);
    private static final String CONTENT_SPACES = "contents:spaces";
    private static final String CURRENT_STATE_PROP = "publication:currentState";

    public static Map<String, String> populateActivityData(Node node, String activityOwnerId, String activityMsgBundleKey) throws Exception {
        Node contentNode;
        SimpleDateFormat dateFormatter = null;
        dateFormatter = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss");
        String repository = ((ManageableRepository)node.getSession().getRepository()).getConfiguration().getName();
        String workspace = node.getSession().getWorkspace().getName();
        String state = node.hasProperty(CURRENT_STATE_PROP) ? node.getProperty(CURRENT_STATE_PROP).getValue().getString() : "";
        String illustrationImg = Utils.getIllustrativeImage(node);
        String strDateCreated = "";
        if (node.hasProperty("exo:dateCreated")) {
            Calendar dateCreated = node.getProperty("exo:dateCreated").getDate();
            strDateCreated = dateFormatter.format(dateCreated.getTime());
        }
        String strLastModified = "";
        if (node.hasNode("jcr:content") && (contentNode = node.getNode("jcr:content")).hasProperty("jcr:lastModified")) {
            Calendar lastModified = contentNode.getProperty("jcr:lastModified").getDate();
            strLastModified = dateFormatter.format(lastModified.getTime());
        }
        activityOwnerId = activityOwnerId != null ? activityOwnerId : "";
        HashMap<String, String> activityParams = new HashMap<String, String>();
        activityParams.put("contentName", node.getName());
        activityParams.put("state", state);
        activityParams.put("author", activityOwnerId);
        activityParams.put("dateCreated", strDateCreated);
        activityParams.put("lastModified", strLastModified);
        activityParams.put("contenLink", Utils.getContentLink(node));
        activityParams.put("id", node.isNodeType("mix:referenceable") ? node.getUUID() : "");
        activityParams.put("repository", repository);
        activityParams.put("workspace", workspace);
        activityParams.put("message", activityMsgBundleKey);
        activityParams.put("mimeType", Utils.getMimeType(node));
        activityParams.put("imagePath", illustrationImg);
        activityParams.put("imagePath", illustrationImg);
        return activityParams;
    }

    public static void postActivity(Node node, String activityMsgBundleKey) throws Exception {
        Object isSkipRaiseAct = DocumentContext.getCurrent().getAttributes().get("isSkipRaiseActivity");
        if (isSkipRaiseAct != null && Boolean.valueOf(isSkipRaiseAct.toString()).booleanValue()) {
            return;
        }
        if (!Utils.isSupportedContent(node)) {
            return;
        }
        ExoContainer container = ExoContainerContext.getCurrentContainer();
        ActivityManager activityManager = (ActivityManager)container.getComponentInstanceOfType(ActivityManager.class);
        IdentityManager identityManager = (IdentityManager)container.getComponentInstanceOfType(IdentityManager.class);
        SpaceService spaceService = (SpaceService)WCMCoreUtils.getService(SpaceService.class);
        Utils.refineNode(node);
        String activityOwnerId = Utils.getActivityOwnerId();
        ExoSocialActivity activity = Utils.createActivity(identityManager, activityOwnerId, node, activityMsgBundleKey);
        String spaceName = Utils.getSpaceName(node);
        if (spaceName != null && spaceName.length() > 0 && spaceService.getSpaceByPrettyName(spaceName) != null) {
            Identity spaceIdentity = identityManager.getOrCreateIdentity("space", spaceName, true);
            activityManager.saveActivityNoReturn(spaceIdentity, activity);
        } else if (activityOwnerId != null && activityOwnerId.length() > 0) {
            Identity ownerIdentity = identityManager.getOrCreateIdentity("organization", activityOwnerId, true);
            activityManager.saveActivityNoReturn(ownerIdentity, activity);
        } else {
            return;
        }
    }

    private static boolean isSupportedContent(Node node) throws Exception {
        SessionProvider sessionProvider;
        NodeHierarchyCreator nodeHierarchyCreator;
        Node userNode;
        return Utils.getActivityOwnerId() == null || Utils.getActivityOwnerId().length() <= 0 || (userNode = (nodeHierarchyCreator = (NodeHierarchyCreator)ExoContainerContext.getCurrentContainer().getComponentInstanceOfType(NodeHierarchyCreator.class)).getUserNode(sessionProvider = WCMCoreUtils.getUserSessionProvider(), Utils.getActivityOwnerId())) == null || !node.getPath().startsWith(userNode.getPath() + "/Private/");
    }

    private static void refineNode(Node currentNode) throws Exception {
        Session session = currentNode.getSession();
        String nodePath = currentNode.getPath();
        currentNode.getSession().save();
        if (currentNode instanceof NodeImpl && !((NodeImpl)currentNode).isValid()) {
            currentNode = (Node)session.getItem(nodePath);
            ExoContainer container = ExoContainerContext.getCurrentContainer();
            LinkManager linkManager = (LinkManager)container.getComponentInstanceOfType(LinkManager.class);
            if (linkManager.isLink((Item)currentNode)) {
                try {
                    currentNode = linkManager.getTarget(currentNode, false);
                }
                catch (RepositoryException ex) {
                    currentNode = linkManager.getTarget(currentNode, true);
                }
            }
        }
    }

    private static String getActivityOwnerId() {
        String activityOwnerId = "";
        ConversationState conversationState = ConversationState.getCurrent();
        if (conversationState != null) {
            activityOwnerId = conversationState.getIdentity().getUserId();
        }
        return activityOwnerId;
    }

    private static String getSpaceName(Node node) throws Exception {
        NodeHierarchyCreator nodeHierarchyCreator = (NodeHierarchyCreator)ExoContainerContext.getCurrentContainer().getComponentInstanceOfType(NodeHierarchyCreator.class);
        String groupPath = nodeHierarchyCreator.getJcrPath("groupsPath");
        String spacesFolder = groupPath + "/spaces/";
        String spaceName = "";
        String nodePath = node.getPath();
        if (nodePath.startsWith(spacesFolder)) {
            spaceName = nodePath.substring(spacesFolder.length());
            spaceName = spaceName.substring(0, spaceName.indexOf("/"));
        }
        return spaceName;
    }

    public static String getContentLink(Node node) throws RepositoryException {
        String repository = ((ManageableRepository)node.getSession().getRepository()).getConfiguration().getName();
        String workspace = node.getSession().getWorkspace().getName();
        return repository + '/' + workspace + node.getPath();
    }

    public static ExoSocialActivity createActivity(IdentityManager identityManager, String activityOwnerId, Node node, String activityMsgBundleKey) throws Exception {
        Map<String, String> activityParams = Utils.populateActivityData(node, activityOwnerId, activityMsgBundleKey);
        String title = node.hasProperty("exo:title") ? node.getProperty("exo:title").getString() : "";
        ExoSocialActivityImpl activity = new ExoSocialActivityImpl();
        if (ConversationState.getCurrent() != null) {
            Identity identity = identityManager.getOrCreateIdentity("organization", ConversationState.getCurrent().getIdentity().getUserId(), false);
            activity.setUserId(identity.getId());
        }
        activity.setType(CONTENT_SPACES);
        activity.setUrl(node.getPath());
        activity.setTitle(title);
        activity.setTemplateParams(activityParams);
        return activity;
    }

    public static String getIllustrativeImage(Node node) {
        WebSchemaConfigService schemaConfigService = (WebSchemaConfigService)WCMCoreUtils.getService(WebSchemaConfigService.class);
        WebContentSchemaHandler contentSchemaHandler = (WebContentSchemaHandler)schemaConfigService.getWebSchemaHandlerByType(WebContentSchemaHandler.class);
        Node illustrativeImage = null;
        String uri = "";
        try {
            illustrativeImage = contentSchemaHandler.getIllustrationImage(node);
            uri = Utils.generateThumbnailImageURI(illustrativeImage);
        }
        catch (PathNotFoundException ex) {
            return uri;
        }
        catch (Exception e) {
            LOG.warn((Object)e.getMessage(), (Throwable)e);
        }
        return uri;
    }

    public static String generateThumbnailImageURI(Node file) throws Exception {
        StringBuilder builder = new StringBuilder();
        NodeLocation fielLocation = NodeLocation.getNodeLocationByNode((Node)file);
        String repository = fielLocation.getRepository();
        String workspaceName = fielLocation.getWorkspace();
        String nodeIdentifiler = file.getPath().replaceFirst("/", "");
        String portalName = PortalContainer.getCurrentPortalContainerName();
        String restContextName = PortalContainer.getCurrentRestContextName();
        InputStream stream = file.getNode("jcr:content").getProperty("jcr:data").getStream();
        if (stream.available() == 0) {
            return null;
        }
        stream.close();
        builder.append("/").append(portalName).append("/").append(restContextName).append("/").append("thumbnailImage/medium/").append(repository).append("/").append(workspaceName).append("/").append(nodeIdentifiler);
        return builder.toString();
    }

    public static String getMimeType(Node node) {
        try {
            if (node.getPrimaryNodeType().getName().equals("nt:file") && node.hasNode("jcr:content")) {
                return node.getNode("jcr:content").getProperty("jcr:mimeType").getString();
            }
        }
        catch (RepositoryException e) {
            LOG.error((Object)e.getMessage(), (Throwable)e);
        }
        return "";
    }
}

