/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.wcm.ext.component.activity.listener;

import java.io.InputStream;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Map;
import javax.jcr.Item;
import javax.jcr.Node;
import javax.jcr.PathNotFoundException;
import javax.jcr.RepositoryException;
import org.apache.commons.lang.StringUtils;
import org.exoplatform.commons.utils.ActivityTypeUtils;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.services.cms.jcrext.activity.ActivityCommonService;
import org.exoplatform.services.cms.link.LinkManager;
import org.exoplatform.services.cms.templates.TemplateService;
import org.exoplatform.services.context.DocumentContext;
import org.exoplatform.services.jcr.core.ManageableRepository;
import org.exoplatform.services.jcr.ext.common.SessionProvider;
import org.exoplatform.services.jcr.ext.hierarchy.NodeHierarchyCreator;
import org.exoplatform.services.jcr.impl.core.NodeImpl;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.security.ConversationState;
import org.exoplatform.services.wcm.core.NodeLocation;
import org.exoplatform.services.wcm.core.WebSchemaConfigService;
import org.exoplatform.services.wcm.utils.WCMCoreUtils;
import org.exoplatform.services.wcm.webcontent.WebContentSchemaHandler;
import org.exoplatform.social.core.activity.model.ExoSocialActivity;
import org.exoplatform.social.core.activity.model.ExoSocialActivityImpl;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.core.manager.ActivityManager;
import org.exoplatform.social.core.manager.IdentityManager;
import org.exoplatform.social.core.space.spi.SpaceService;

public class Utils {
    private static final Log LOG = ExoLogger.getLogger(Utils.class);
    private static final String CONTENT_SPACES = "contents:spaces";
    private static final String FILE_SPACES = "files:spaces";
    private static final String CURRENT_STATE_PROP = "publication:currentState";
    private static String MIX_COMMENT = "exo:activityComment";
    private static String MIX_COMMENT_ID = "exo:activityCommentID";
    private static int MAX_SUMMARY_LINES_COUNT = 4;
    private static int MAX_SUMMARY_CHAR_COUNT = 430;

    public static Map<String, String> populateActivityData(Node node, String activityOwnerId, String activityMsgBundleKey) throws Exception {
        return Utils.populateActivityData(node, activityOwnerId, activityMsgBundleKey, false, null);
    }

    public static Map<String, String> populateActivityData(Node node, String activityOwnerId, String activityMsgBundleKey, boolean isSystemComment, String systemComment) throws Exception {
        Node contentNode;
        SimpleDateFormat dateFormatter = null;
        dateFormatter = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss");
        String repository = ((ManageableRepository)node.getSession().getRepository()).getConfiguration().getName();
        String workspace = node.getSession().getWorkspace().getName();
        String illustrationImg = Utils.getIllustrativeImage(node);
        String strDateCreated = "";
        if (node.hasProperty("exo:dateCreated")) {
            Calendar dateCreated = node.getProperty("exo:dateCreated").getDate();
            strDateCreated = dateFormatter.format(dateCreated.getTime());
        }
        String strLastModified = "";
        if (node.hasNode("jcr:content") && (contentNode = node.getNode("jcr:content")).hasProperty("jcr:lastModified")) {
            Calendar lastModified = contentNode.getProperty("jcr:lastModified").getDate();
            strLastModified = dateFormatter.format(lastModified.getTime());
        }
        activityOwnerId = activityOwnerId != null ? activityOwnerId : "";
        HashMap<String, String> activityParams = new HashMap<String, String>();
        activityParams.put("contentName", node.getName());
        activityParams.put("author", activityOwnerId);
        activityParams.put("dateCreated", strDateCreated);
        activityParams.put("lastModified", strLastModified);
        activityParams.put("contenLink", Utils.getContentLink(node));
        activityParams.put("id", node.isNodeType("mix:referenceable") ? node.getUUID() : "");
        activityParams.put("repository", repository);
        activityParams.put("workspace", workspace);
        activityParams.put("message", activityMsgBundleKey);
        activityParams.put("mimeType", Utils.getMimeType(node));
        activityParams.put("imagePath", illustrationImg);
        activityParams.put("imagePath", illustrationImg);
        if (isSystemComment) {
            activityParams.put("isSystemComment", String.valueOf(isSystemComment));
            activityParams.put("systemComment", systemComment);
        }
        return activityParams;
    }

    public static void postActivity(Node node, String activityMsgBundleKey) throws Exception {
        Utils.postActivity(node, activityMsgBundleKey, false, false, null);
    }

    public static void postFileActivity(Node node, String activityMsgBundleKey) throws Exception {
        Utils.postFileActivity(node, activityMsgBundleKey, false, false, null);
    }

    public static ExoSocialActivity postActivity(Node node, String activityMsgBundleKey, boolean needUpdate, boolean isSystemComment, String systemComment) throws Exception {
        String commentID;
        Object isSkipRaiseAct = DocumentContext.getCurrent().getAttributes().get("isSkipRaiseActivity");
        if (isSkipRaiseAct != null && Boolean.valueOf(isSkipRaiseAct.toString()).booleanValue()) {
            return null;
        }
        if (!Utils.isSupportedContent(node)) {
            return null;
        }
        ExoContainer container = ExoContainerContext.getCurrentContainer();
        ActivityManager activityManager = (ActivityManager)container.getComponentInstanceOfType(ActivityManager.class);
        IdentityManager identityManager = (IdentityManager)container.getComponentInstanceOfType(IdentityManager.class);
        SpaceService spaceService = (SpaceService)WCMCoreUtils.getService(SpaceService.class);
        Utils.refineNode(node);
        String activityOwnerId = Utils.getActivityOwnerId();
        String nodeActivityID = "";
        ExoSocialActivity exa = null;
        if (node.isNodeType(ActivityTypeUtils.EXO_ACTIVITY_INFO)) {
            try {
                nodeActivityID = node.getProperty(ActivityTypeUtils.EXO_ACTIVITY_ID).getString();
                exa = activityManager.getActivity(nodeActivityID);
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        ExoSocialActivity activity = null;
        boolean commentFlag = false;
        if (node.isNodeType(MIX_COMMENT) && node.hasProperty(MIX_COMMENT_ID)) {
            commentID = node.getProperty(MIX_COMMENT_ID).getString();
            activity = activityManager.getActivity(commentID);
            boolean bl = commentFlag = activity != null;
        }
        if (activity == null) {
            activity = Utils.createActivity(identityManager, activityOwnerId, node, activityMsgBundleKey, CONTENT_SPACES, isSystemComment, systemComment);
        }
        if (exa != null) {
            if (commentFlag) {
                Map paramsMap = activity.getTemplateParams();
                String paramMessage = (String)paramsMap.get("message");
                String paramContent = (String)paramsMap.get("systemComment");
                if (!StringUtils.isEmpty((String)paramMessage)) {
                    paramMessage = paramMessage + ActivityCommonService.VALUE_SEPERATOR + activityMsgBundleKey;
                    paramContent = StringUtils.isEmpty((String)systemComment) ? paramContent + ActivityCommonService.VALUE_SEPERATOR + " " : paramContent + ActivityCommonService.VALUE_SEPERATOR + systemComment;
                } else {
                    paramMessage = activityMsgBundleKey;
                    paramContent = systemComment;
                }
                paramsMap.put("message", paramMessage);
                paramsMap.put("systemComment", paramContent);
                activity.setTemplateParams(paramsMap);
                activityManager.updateActivity(activity);
            } else {
                activityManager.saveComment(exa, activity);
                if (node.isNodeType(MIX_COMMENT)) {
                    commentID = activity.getId();
                    node.setProperty(MIX_COMMENT_ID, commentID);
                }
            }
            if (needUpdate) {
                Utils.updateMainActivity(activityManager, node, exa);
            }
            return activity;
        }
        String spaceName = Utils.getSpaceName(node);
        if (spaceName != null && spaceName.length() > 0 && spaceService.getSpaceByPrettyName(spaceName) != null) {
            Identity spaceIdentity = identityManager.getOrCreateIdentity("space", spaceName, true);
            activityManager.saveActivityNoReturn(spaceIdentity, activity);
        } else if (activityOwnerId != null && activityOwnerId.length() > 0) {
            Identity ownerIdentity = identityManager.getOrCreateIdentity("organization", activityOwnerId, true);
            activityManager.saveActivityNoReturn(ownerIdentity, activity);
        } else {
            return null;
        }
        String activityId = activity.getId();
        if (!StringUtils.isEmpty((String)activityId)) {
            ActivityTypeUtils.attachActivityId((Node)node, (String)activityId);
        }
        Utils.updateMainActivity(activityManager, node, activity);
        return activity;
    }

    public static ExoSocialActivity postFileActivity(Node node, String activityMsgBundleKey, boolean needUpdate, boolean isSystemComment, String systemComment) throws Exception {
        String commentID;
        Object isSkipRaiseAct = DocumentContext.getCurrent().getAttributes().get("isSkipRaiseActivity");
        if (isSkipRaiseAct != null && Boolean.valueOf(isSkipRaiseAct.toString()).booleanValue()) {
            return null;
        }
        if (!Utils.isSupportedContent(node)) {
            return null;
        }
        ExoContainer container = ExoContainerContext.getCurrentContainer();
        ActivityManager activityManager = (ActivityManager)container.getComponentInstanceOfType(ActivityManager.class);
        IdentityManager identityManager = (IdentityManager)container.getComponentInstanceOfType(IdentityManager.class);
        SpaceService spaceService = (SpaceService)WCMCoreUtils.getService(SpaceService.class);
        Utils.refineNode(node);
        String activityOwnerId = Utils.getActivityOwnerId();
        String nodeActivityID = "";
        ExoSocialActivity exa = null;
        if (node.isNodeType(ActivityTypeUtils.EXO_ACTIVITY_INFO)) {
            try {
                nodeActivityID = node.getProperty(ActivityTypeUtils.EXO_ACTIVITY_ID).getString();
                exa = activityManager.getActivity(nodeActivityID);
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        ExoSocialActivity activity = null;
        boolean commentFlag = false;
        if (node.isNodeType(MIX_COMMENT) && node.hasProperty(MIX_COMMENT_ID)) {
            commentID = node.getProperty(MIX_COMMENT_ID).getString();
            activity = activityManager.getActivity(commentID);
            boolean bl = commentFlag = activity != null;
        }
        if (activity == null) {
            activity = Utils.createActivity(identityManager, activityOwnerId, node, activityMsgBundleKey, FILE_SPACES, isSystemComment, systemComment);
        }
        if (exa != null) {
            if (commentFlag) {
                Map paramsMap = activity.getTemplateParams();
                String paramMessage = (String)paramsMap.get("message");
                String paramContent = (String)paramsMap.get("systemComment");
                if (!StringUtils.isEmpty((String)paramMessage)) {
                    paramMessage = paramMessage + ActivityCommonService.VALUE_SEPERATOR + activityMsgBundleKey;
                    paramContent = StringUtils.isEmpty((String)systemComment) ? paramContent + ActivityCommonService.VALUE_SEPERATOR + " " : paramContent + ActivityCommonService.VALUE_SEPERATOR + systemComment;
                } else {
                    paramMessage = activityMsgBundleKey;
                    paramContent = systemComment;
                }
                paramsMap.put("message", paramMessage);
                paramsMap.put("systemComment", paramContent);
                activity.setTemplateParams(paramsMap);
                activityManager.updateActivity(activity);
            } else {
                activityManager.saveComment(exa, activity);
                if (node.isNodeType(MIX_COMMENT)) {
                    commentID = activity.getId();
                    node.setProperty(MIX_COMMENT_ID, commentID);
                }
            }
            return activity;
        }
        String spaceName = Utils.getSpaceName(node);
        if (spaceName != null && spaceName.length() > 0 && spaceService.getSpaceByPrettyName(spaceName) != null) {
            Identity spaceIdentity = identityManager.getOrCreateIdentity("space", spaceName, true);
            activityManager.saveActivityNoReturn(spaceIdentity, activity);
        } else if (activityOwnerId != null && activityOwnerId.length() > 0) {
            Identity ownerIdentity = identityManager.getOrCreateIdentity("organization", activityOwnerId, true);
            activityManager.saveActivityNoReturn(ownerIdentity, activity);
        } else {
            return null;
        }
        String activityId = activity.getId();
        if (!StringUtils.isEmpty((String)activityId)) {
            ActivityTypeUtils.attachActivityId((Node)node, (String)activityId);
        }
        return activity;
    }

    private static void updateMainActivity(ActivityManager activityManager, Node contentNode, ExoSocialActivity activity) {
        String state;
        String nodeTitle;
        String documentTypeLabel;
        Map activityParams = activity.getTemplateParams();
        String nodeType = null;
        Object nodeIconName = null;
        String currentVersion = null;
        TemplateService templateService = (TemplateService)WCMCoreUtils.getService(TemplateService.class);
        try {
            nodeType = contentNode.getPrimaryNodeType().getName();
            documentTypeLabel = templateService.getTemplateLabel(nodeType);
        }
        catch (Exception e) {
            documentTypeLabel = "";
        }
        try {
            nodeTitle = org.exoplatform.ecm.webui.utils.Utils.getTitle((Node)contentNode);
        }
        catch (Exception e1) {
            nodeTitle = "";
        }
        try {
            state = contentNode.hasProperty(CURRENT_STATE_PROP) ? contentNode.getProperty(CURRENT_STATE_PROP).getValue().getString() : "";
        }
        catch (Exception e) {
            state = "";
        }
        try {
            currentVersion = contentNode.getBaseVersion().getName();
            if (currentVersion.contains("jcr:rootVersion")) {
                currentVersion = "0";
            }
        }
        catch (Exception e) {
            currentVersion = "";
        }
        activityParams.put("state", state);
        activityParams.put("docTypeLabel", documentTypeLabel);
        activityParams.put("docTitle", nodeTitle);
        activityParams.put("docVersion", currentVersion);
        String summary = Utils.getSummary(contentNode);
        summary = Utils.getFirstSummaryLines(summary, MAX_SUMMARY_LINES_COUNT);
        activityParams.put("docSummary", summary);
        activity.setTemplateParams(activityParams);
        activityManager.updateActivity(activity);
    }

    private static boolean isSupportedContent(Node node) throws Exception {
        SessionProvider sessionProvider;
        NodeHierarchyCreator nodeHierarchyCreator;
        Node userNode;
        return Utils.getActivityOwnerId() == null || Utils.getActivityOwnerId().length() <= 0 || (userNode = (nodeHierarchyCreator = (NodeHierarchyCreator)ExoContainerContext.getCurrentContainer().getComponentInstanceOfType(NodeHierarchyCreator.class)).getUserNode(sessionProvider = WCMCoreUtils.getUserSessionProvider(), Utils.getActivityOwnerId())) == null || !node.getPath().startsWith(userNode.getPath() + "/Private/");
    }

    private static void refineNode(Node currentNode) throws Exception {
        ExoContainer container;
        LinkManager linkManager;
        if (currentNode instanceof NodeImpl && !((NodeImpl)currentNode).isValid() && (linkManager = (LinkManager)(container = ExoContainerContext.getCurrentContainer()).getComponentInstanceOfType(LinkManager.class)).isLink((Item)currentNode)) {
            try {
                currentNode = linkManager.getTarget(currentNode, false);
            }
            catch (RepositoryException ex) {
                currentNode = linkManager.getTarget(currentNode, true);
            }
        }
    }

    private static String getActivityOwnerId() {
        String activityOwnerId = "";
        ConversationState conversationState = ConversationState.getCurrent();
        if (conversationState != null) {
            activityOwnerId = conversationState.getIdentity().getUserId();
        }
        return activityOwnerId;
    }

    private static String getSpaceName(Node node) throws Exception {
        NodeHierarchyCreator nodeHierarchyCreator = (NodeHierarchyCreator)ExoContainerContext.getCurrentContainer().getComponentInstanceOfType(NodeHierarchyCreator.class);
        String groupPath = nodeHierarchyCreator.getJcrPath("groupsPath");
        String spacesFolder = groupPath + "/spaces/";
        String spaceName = "";
        String nodePath = node.getPath();
        if (nodePath.startsWith(spacesFolder)) {
            spaceName = nodePath.substring(spacesFolder.length());
            spaceName = spaceName.substring(0, spaceName.indexOf("/"));
        }
        return spaceName;
    }

    public static String getContentLink(Node node) throws RepositoryException {
        String repository = ((ManageableRepository)node.getSession().getRepository()).getConfiguration().getName();
        String workspace = node.getSession().getWorkspace().getName();
        return repository + '/' + workspace + node.getPath();
    }

    public static ExoSocialActivity createActivity(IdentityManager identityManager, String activityOwnerId, Node node, String activityMsgBundleKey, String activityType) throws Exception {
        return Utils.createActivity(identityManager, activityOwnerId, node, activityMsgBundleKey, activityType, false, null);
    }

    public static ExoSocialActivity createActivity(IdentityManager identityManager, String activityOwnerId, Node node, String activityMsgBundleKey, String activityType, boolean isSystemComment, String systemComment) throws Exception {
        Map<String, String> activityParams = Utils.populateActivityData(node, activityOwnerId, activityMsgBundleKey, isSystemComment, systemComment);
        String title = node.hasProperty("exo:title") ? node.getProperty("exo:title").getString() : org.exoplatform.ecm.webui.utils.Utils.getTitle((Node)node);
        ExoSocialActivityImpl activity = new ExoSocialActivityImpl();
        if (ConversationState.getCurrent() != null) {
            Identity identity = identityManager.getOrCreateIdentity("organization", ConversationState.getCurrent().getIdentity().getUserId(), false);
            activity.setUserId(identity.getId());
        }
        activity.setType(activityType);
        activity.setUrl(node.getPath());
        activity.setTitle(title);
        activity.setTemplateParams(activityParams);
        return activity;
    }

    public static void deleteFileActivity(Node node) throws RepositoryException {
        ExoContainer container = ExoContainerContext.getCurrentContainer();
        ActivityManager activityManager = (ActivityManager)container.getComponentInstanceOfType(ActivityManager.class);
        IdentityManager identityManager = (IdentityManager)container.getComponentInstanceOfType(IdentityManager.class);
        String activityOwnerId = Utils.getActivityOwnerId();
        String nodeActivityID = "";
        Object exa = null;
        if (node.isNodeType(ActivityTypeUtils.EXO_ACTIVITY_INFO)) {
            try {
                nodeActivityID = node.getProperty(ActivityTypeUtils.EXO_ACTIVITY_ID).getString();
                activityManager.deleteActivity(nodeActivityID);
            }
            catch (Exception e) {
                // empty catch block
            }
        }
    }

    public static String getIllustrativeImage(Node node) {
        WebSchemaConfigService schemaConfigService = (WebSchemaConfigService)WCMCoreUtils.getService(WebSchemaConfigService.class);
        WebContentSchemaHandler contentSchemaHandler = (WebContentSchemaHandler)schemaConfigService.getWebSchemaHandlerByType(WebContentSchemaHandler.class);
        Node illustrativeImage = null;
        String uri = "";
        try {
            illustrativeImage = contentSchemaHandler.getIllustrationImage(node);
            uri = Utils.generateThumbnailImageURI(illustrativeImage);
        }
        catch (PathNotFoundException ex) {
            return uri;
        }
        catch (Exception e) {
            LOG.warn((Object)e.getMessage(), (Throwable)e);
        }
        return uri;
    }

    public static String generateThumbnailImageURI(Node file) throws Exception {
        StringBuilder builder = new StringBuilder();
        NodeLocation fielLocation = NodeLocation.getNodeLocationByNode((Node)file);
        String repository = fielLocation.getRepository();
        String workspaceName = fielLocation.getWorkspace();
        String nodeIdentifiler = file.getPath().replaceFirst("/", "");
        String portalName = PortalContainer.getCurrentPortalContainerName();
        String restContextName = PortalContainer.getCurrentRestContextName();
        InputStream stream = file.getNode("jcr:content").getProperty("jcr:data").getStream();
        if (stream.available() == 0) {
            return null;
        }
        stream.close();
        builder.append("/").append(portalName).append("/").append(restContextName).append("/").append("thumbnailImage/medium/").append(repository).append("/").append(workspaceName).append("/").append(nodeIdentifiler);
        return builder.toString();
    }

    public static String getMimeType(Node node) {
        try {
            if (node.getPrimaryNodeType().getName().equals("nt:file") && node.hasNode("jcr:content")) {
                return node.getNode("jcr:content").getProperty("jcr:mimeType").getString();
            }
        }
        catch (RepositoryException e) {
            LOG.error((Object)e.getMessage(), (Throwable)e);
        }
        return "";
    }

    public static String getSummary(Node node) {
        String desc;
        block6: {
            desc = "";
            try {
                if (node != null) {
                    Node content;
                    if (node.hasProperty("exo:summary")) {
                        desc = node.getProperty("exo:summary").getValue().getString();
                    } else if (node.hasNode("jcr:content") && (content = node.getNode("jcr:content")).hasProperty("dc:description") && content.getProperty("dc:description").getValues().length > 0) {
                        desc = content.getProperty("dc:description").getValues()[0].getString();
                    }
                }
            }
            catch (RepositoryException re) {
                if (!LOG.isWarnEnabled()) break block6;
                LOG.warn((Object)"RepositoryException: ", (Throwable)re);
            }
        }
        return desc;
    }

    public static String getFirstSummaryLines(String source) {
        return Utils.getFirstSummaryLines(source, MAX_SUMMARY_LINES_COUNT);
    }

    public static String getFirstSummaryLines(String source, int linesCount) {
        String result = source;
        result = result.replaceAll("(?i)<head>.*</head>", "");
        result = result.replaceAll("(?i)<script.*>.*</script>", "");
        result = result.replaceAll("(?i)<style.*>.*</style>", "");
        result = result.replaceAll("<([a-z\"]+) *[^/]*?>", "");
        result = result.replaceAll("</([a-z]+) *[^/]*?>", "<br>");
        result = result.replaceAll("([\n\t])+", "<br>");
        result = result.replaceAll("(<br>[ \t\n]+<br>)", "<br>");
        result = result.replaceAll("(<br>)+", "<br>");
        int i = 0;
        int index = -1;
        while ((index = result.indexOf("<br>", index + 1)) >= 0 && ++i <= linesCount) {
        }
        if (index < 0) {
            if (result.length() > MAX_SUMMARY_CHAR_COUNT) {
                return result.substring(0, MAX_SUMMARY_CHAR_COUNT - 1) + "...";
            }
            return result;
        }
        if (index > MAX_SUMMARY_CHAR_COUNT) {
            index = MAX_SUMMARY_CHAR_COUNT - 1;
        }
        result = result.substring(0, index) + "<br>...";
        return result;
    }
}

