/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.wcm.ext.component.activity;

import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import org.exoplatform.commons.embedder.ExoMedia;
import org.exoplatform.portal.application.PortalRequestContext;
import org.exoplatform.services.security.ConversationState;
import org.exoplatform.social.core.activity.model.ExoSocialActivity;
import org.exoplatform.social.core.activity.model.ExoSocialActivityImpl;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.core.manager.ActivityManager;
import org.exoplatform.social.core.manager.IdentityManager;
import org.exoplatform.social.core.space.model.Space;
import org.exoplatform.social.service.rest.LinkShare;
import org.exoplatform.social.webui.composer.UIActivityComposer;
import org.exoplatform.social.webui.composer.UIComposer;
import org.exoplatform.social.webui.profile.UIUserActivitiesDisplay;
import org.exoplatform.social.webui.space.UISpaceActivitiesDisplay;
import org.exoplatform.web.application.ApplicationMessage;
import org.exoplatform.webui.application.WebuiRequestContext;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIApplication;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.core.UIPortletApplication;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.event.EventListener;
import org.exoplatform.webui.form.UIFormStringInput;

@ComponentConfig(template="classpath:groovy/ecm/social-integration/plugin/link/UILinkActivityComposer.gtmpl", events={@EventConfig(listeners={AttachActionListener.class}), @EventConfig(listeners={ChangeLinkContentActionListener.class}), @EventConfig(listeners={RemoveLinkActionListener.class}), @EventConfig(listeners={UIActivityComposer.CloseActionListener.class}), @EventConfig(listeners={UIActivityComposer.SubmitContentActionListener.class}), @EventConfig(listeners={UIActivityComposer.ActivateActionListener.class})})
public class UILinkActivityComposer
extends UIActivityComposer {
    public static final String LINK_PARAM = "link";
    public static final String IMAGE_PARAM = "image";
    public static final String TITLE_PARAM = "title";
    public static final String DESCRIPTION_PARAM = "description";
    public static final String COMMENT_PARAM = "comment";
    public static final String HTML_PARAM = "html";
    private static final String MSG_ERROR_INVALID_LINK = "UILinkComposerPlugin.msg.error.Attach_Link";
    private LinkShare linkShare_;
    private boolean linkInfoDisplayed_ = false;
    private Map<String, String> templateParams;
    private boolean isDisplayed;
    private static final String HTML_ATTRIBUTE_TITLE = "title";

    public UILinkActivityComposer() {
        WebuiRequestContext requestContext = (WebuiRequestContext)WebuiRequestContext.getCurrentInstance();
        ResourceBundle resourceBundle = requestContext.getApplicationResourceBundle();
        this.setReadyForPostingActivity(false);
        UIFormStringInput inputLink = new UIFormStringInput("InputLink", "InputLink", null);
        inputLink.setHTMLAttribute("title", resourceBundle.getString("UILinkComposerPlugin.label.InputLink"));
        this.addChild((UIComponent)inputLink);
    }

    public boolean isDisplayed() {
        return this.isDisplayed;
    }

    public void setDisplayed(boolean isDisplayed) {
        this.isDisplayed = isDisplayed;
    }

    public void setLinkInfoDisplayed(boolean displayed) {
        this.linkInfoDisplayed_ = displayed;
    }

    public boolean isLinkInfoDisplayed() {
        return this.linkInfoDisplayed_;
    }

    public void setTemplateParams(Map<String, String> tempParams) {
        this.templateParams = tempParams;
    }

    public Map<String, String> getTemplateParams() {
        return this.templateParams;
    }

    public void clearLinkShare() {
        this.linkShare_ = null;
    }

    public LinkShare getLinkShare() {
        return this.linkShare_;
    }

    private void setLink(String url, WebuiRequestContext requestContext) throws Exception {
        try {
            this.linkShare_ = LinkShare.getInstance((String)url);
        }
        catch (Exception e) {
            this.clearLinkShare();
            this.resetToDefault();
            this.displayErrorMessage(requestContext, MSG_ERROR_INVALID_LINK);
            return;
        }
        if (this.linkShare_ == null) {
            this.resetToDefault();
            this.displayErrorMessage(requestContext, MSG_ERROR_INVALID_LINK);
            return;
        }
        this.templateParams = new LinkedHashMap<String, String>();
        this.templateParams.put(LINK_PARAM, this.linkShare_.getLink());
        ExoMedia mediaObject = this.linkShare_.getMediaObject();
        String image = "";
        List images = this.linkShare_.getImages();
        if (images != null && images.size() > 0) {
            image = (String)images.get(0);
        }
        this.templateParams.put(IMAGE_PARAM, image);
        this.templateParams.put("title", mediaObject != null ? mediaObject.getTitle() : this.linkShare_.getTitle());
        this.templateParams.put(DESCRIPTION_PARAM, mediaObject != null ? mediaObject.getDescription() : this.linkShare_.getDescription());
        this.templateParams.put(HTML_PARAM, mediaObject != null ? mediaObject.getHtml() : null);
        this.setLinkInfoDisplayed(true);
    }

    private void resetToDefault() {
        this.setReadyForPostingActivity(false);
        this.setDisplayed(false);
        this.getActivityComposerManager().setDefaultActivityComposer();
    }

    private void displayErrorMessage(WebuiRequestContext requestContext, String errorMessage) {
        UIApplication uiApp = requestContext.getUIApplication();
        uiApp.addMessage(new ApplicationMessage(errorMessage, null, 1));
        ((PortalRequestContext)requestContext.getParentAppRequestContext()).ignoreAJAXUpdateOnPortlets(true);
    }

    protected void onActivate(Event<UIActivityComposer> arg0) {
    }

    protected void onClose(Event<UIActivityComposer> arg0) {
        this.setReadyForPostingActivity(false);
    }

    protected void onSubmit(Event<UIActivityComposer> arg0) {
    }

    public void onPostActivity(UIComposer.PostContext postContext, UIComponent source, WebuiRequestContext requestContext, String postedMessage) throws Exception {
    }

    protected ExoSocialActivity onPostActivity(UIComposer.PostContext postContext, String postedMessage) throws Exception {
        Map<String, String> templateParams = this.getTemplateParams();
        if (templateParams == null) {
            return null;
        }
        if (templateParams.size() == 0) {
            ((UIPortletApplication)this.getAncestorOfType(UIPortletApplication.class)).addMessage(new ApplicationMessage("UIComposer.msg.error.Empty_Message", null, 1));
            return null;
        }
        ActivityManager activityManager = (ActivityManager)this.getApplicationComponent(ActivityManager.class);
        IdentityManager identityManager = (IdentityManager)this.getApplicationComponent(IdentityManager.class);
        String remoteUser = ConversationState.getCurrent().getIdentity().getUserId();
        Identity userIdentity = identityManager.getOrCreateIdentity("organization", remoteUser, true);
        templateParams.put(COMMENT_PARAM, postedMessage);
        templateParams.put("registeredKeysForProcessor", COMMENT_PARAM);
        if (templateParams.get(IMAGE_PARAM) == null) {
            templateParams.put(IMAGE_PARAM, "");
        }
        this.setTemplateParams(templateParams);
        String title = "${title}";
        ExoSocialActivityImpl activity = new ExoSocialActivityImpl(userIdentity.getId(), "LINK_ACTIVITY", title, null);
        activity.setTemplateParams(templateParams);
        activity.setExternalId("LINK_ACTIVITY");
        activity.setUrl(templateParams.get(LINK_PARAM).toString());
        if (postContext == UIComposer.PostContext.SPACE) {
            UISpaceActivitiesDisplay uiDisplaySpaceActivities = (UISpaceActivitiesDisplay)this.getActivityDisplay();
            Space space = uiDisplaySpaceActivities.getSpace();
            Identity spaceIdentity = identityManager.getOrCreateIdentity("space", space.getPrettyName(), false);
            activityManager.saveActivityNoReturn(spaceIdentity, (ExoSocialActivity)activity);
        } else if (postContext == UIComposer.PostContext.USER) {
            UIUserActivitiesDisplay uiUserActivitiesDisplay = (UIUserActivitiesDisplay)this.getActivityDisplay();
            String ownerName = uiUserActivitiesDisplay.getOwnerName();
            Identity ownerIdentity = identityManager.getOrCreateIdentity("organization", ownerName, false);
            activityManager.saveActivityNoReturn(ownerIdentity, (ExoSocialActivity)activity);
            if (uiUserActivitiesDisplay.getSelectedDisplayMode() == UIUserActivitiesDisplay.DisplayMode.CONNECTIONS || uiUserActivitiesDisplay.getSelectedDisplayMode() == UIUserActivitiesDisplay.DisplayMode.MY_SPACE) {
                uiUserActivitiesDisplay.setSelectedDisplayMode(UIUserActivitiesDisplay.DisplayMode.MY_ACTIVITIES);
            }
        }
        this.setTemplateParams(null);
        this.clearLinkShare();
        return activityManager.getActivity(activity.getId());
    }

    public static class RemoveLinkActionListener
    extends EventListener<UILinkActivityComposer> {
        public void execute(Event<UILinkActivityComposer> event) throws Exception {
            UILinkActivityComposer uiComposerLinkExtension = (UILinkActivityComposer)((Object)event.getSource());
            uiComposerLinkExtension.clearLinkShare();
            uiComposerLinkExtension.setLinkInfoDisplayed(false);
            uiComposerLinkExtension.setDisplayed(true);
            uiComposerLinkExtension.setReadyForPostingActivity(false);
            event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiComposerLinkExtension);
        }
    }

    public static class ChangeLinkContentActionListener
    extends EventListener<UILinkActivityComposer> {
        public void execute(Event<UILinkActivityComposer> event) throws Exception {
            WebuiRequestContext requestContext = event.getRequestContext();
            UILinkActivityComposer uiComposerLinkExtension = (UILinkActivityComposer)((Object)event.getSource());
            LinkedHashMap<String, String> tempParams = new LinkedHashMap<String, String>();
            tempParams.put(UILinkActivityComposer.LINK_PARAM, requestContext.getRequestParameter(UILinkActivityComposer.LINK_PARAM));
            tempParams.put(UILinkActivityComposer.IMAGE_PARAM, requestContext.getRequestParameter(UILinkActivityComposer.IMAGE_PARAM));
            tempParams.put("title", requestContext.getRequestParameter("title"));
            tempParams.put(UILinkActivityComposer.DESCRIPTION_PARAM, requestContext.getRequestParameter(UILinkActivityComposer.DESCRIPTION_PARAM));
            uiComposerLinkExtension.setTemplateParams(tempParams);
            uiComposerLinkExtension.setLinkInfoDisplayed(true);
            requestContext.addUIComponentToUpdateByAjax((UIComponent)uiComposerLinkExtension);
            UIComponent uiParent = uiComposerLinkExtension.getParent();
            if (uiParent != null) {
                uiParent.broadcast(event, event.getExecutionPhase());
            }
        }
    }

    public static class AttachActionListener
    extends EventListener<UILinkActivityComposer> {
        public void execute(Event<UILinkActivityComposer> event) throws Exception {
            WebuiRequestContext requestContext = event.getRequestContext();
            UILinkActivityComposer uiComposerLinkExtension = (UILinkActivityComposer)((Object)event.getSource());
            String url = requestContext.getRequestParameter("objectId").trim();
            uiComposerLinkExtension.setLink(url, requestContext);
            if (uiComposerLinkExtension.linkShare_ != null) {
                uiComposerLinkExtension.getActivityComposerManager().setCurrentActivityComposer((UIActivityComposer)uiComposerLinkExtension);
                requestContext.addUIComponentToUpdateByAjax((UIComponent)uiComposerLinkExtension);
                ((UILinkActivityComposer)((Object)event.getSource())).setReadyForPostingActivity(true);
            } else {
                uiComposerLinkExtension.getActivityComposerManager().setDefaultActivityComposer();
                requestContext.addUIComponentToUpdateByAjax((UIComponent)uiComposerLinkExtension);
            }
        }
    }
}

