/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.wcm.notification.plugin;

import java.util.Map;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import org.apache.commons.io.FileUtils;
import org.exoplatform.commons.api.notification.NotificationContext;
import org.exoplatform.commons.api.notification.model.ArgumentLiteral;
import org.exoplatform.commons.api.notification.model.NotificationInfo;
import org.exoplatform.commons.api.notification.plugin.AbstractNotificationChildPlugin;
import org.exoplatform.commons.api.notification.service.template.TemplateContext;
import org.exoplatform.commons.notification.NotificationUtils;
import org.exoplatform.commons.notification.template.TemplateUtils;
import org.exoplatform.commons.utils.CommonsUtils;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.core.ManageableRepository;
import org.exoplatform.services.jcr.ext.common.SessionProvider;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.wcm.core.NodeLocation;
import org.exoplatform.services.wcm.utils.WCMCoreUtils;
import org.exoplatform.social.core.activity.model.ExoSocialActivity;
import org.exoplatform.social.core.manager.ActivityManager;
import org.exoplatform.wcm.ext.component.activity.listener.Utils;
import org.exoplatform.webui.cssfile.CssClassManager;
import org.exoplatform.webui.cssfile.CssClassUtils;

public class FileActivityChildPlugin
extends AbstractNotificationChildPlugin {
    private static final Log LOG = ExoLogger.getLogger(FileActivityChildPlugin.class);
    public static final ArgumentLiteral<String> ACTIVITY_ID = new ArgumentLiteral(String.class, "activityId");
    public static final String PRIVATE_FOLDER_PATH = "/Private/";
    public static final String ACTIVITY_URL = "view_full_activity";
    public static final String ID = "files:spaces";
    public static final String MESSAGE = "MESSAGE";
    public static final String REPOSITORY = "REPOSITORY";
    public static final String WORKSPACE = "WORKSPACE";
    public static final String DOCLINK = "DOCLINK";
    public static final String NODE_UUID = "id";
    public static final String AUTHOR = "author";
    public static final String MIME_TYPE = "mimeType";
    public static final String DOCUMENT_TITLE = "docTitle";
    public static final String CONTENT_NAME = "contentName";
    public static final String DOCUMENT_SUMMARY = "docSummary";
    public static final String EXO_RESOURCES_URI = "/eXoSkin/skin/images/themes/default/Icons/TypeIcons/EmailNotificationIcons/";
    public static final String DOCNAME = "DOCNAME";
    public static final String ICON_FILE_EXTENSION = ".png";
    public static final String CONTENT_LINK = "contenLink";
    private String[] mimeType;
    private String[] nodeUUID;
    private Node[] contentNode;
    private NodeLocation[] nodeLocation;
    private String[] documentTitle;
    private ExoSocialActivity activity;
    private String baseURI;
    private String[] docName;
    private String[] contentLink;
    private int filesCount;

    public FileActivityChildPlugin(InitParams initParams) {
        super(initParams);
    }

    public String makeContent(NotificationContext ctx) {
        try {
            ActivityManager activityM = (ActivityManager)CommonsUtils.getService(ActivityManager.class);
            NotificationInfo notification = ctx.getNotificationInfo();
            String language = this.getLanguage(notification);
            TemplateContext templateContext = new TemplateContext(ID, language);
            String activityId = notification.getValueOwnerParameter(ACTIVITY_ID.getKey());
            this.activity = activityM.getActivity(activityId);
            if (this.activity.isComment()) {
                this.activity = activityM.getParentActivity(this.activity);
            }
            Map templateParams = this.activity.getTemplateParams();
            this.getAndSetFileInfo(templateParams);
            String message = templateParams.get(MESSAGE) != null ? NotificationUtils.processLinkTitle((String)((String)templateParams.get(MESSAGE))) : "";
            templateContext.put((Object)"ACTIVITY_TITLE", (Object)message);
            boolean[] isVideo = new boolean[this.filesCount];
            String[] thumbnailURL = new String[this.filesCount];
            String[] summaries = new String[this.filesCount];
            String[] sizes = new String[this.filesCount];
            int[] versions = new int[this.filesCount];
            for (int i = 0; i < this.filesCount; ++i) {
                isVideo[i] = this.mimeType[i].startsWith("video");
                thumbnailURL[i] = this.getDefaultThumbnail(i);
                Node currentNode = this.getContentNode(i);
                summaries[i] = Utils.getSummary(currentNode);
                sizes[i] = this.getSize(currentNode);
                versions[i] = this.getVersion(currentNode);
                if (this.contentLink == null || this.contentLink.length <= i) continue;
                this.contentLink[i] = CommonsUtils.getCurrentDomain() + this.contentLink[i];
            }
            templateContext.put((Object)"ACTIVITY_URL", (Object)this.contentLink);
            templateContext.put((Object)"DOCUMENT_TITLE", (Object)this.documentTitle);
            templateContext.put((Object)"SUMMARY", (Object)summaries);
            templateContext.put((Object)"SIZE", (Object)sizes);
            templateContext.put((Object)"VERSION", (Object)versions);
            templateContext.put((Object)"IS_VIDEO", (Object)isVideo);
            templateContext.put((Object)"DEFAULT_THUMBNAIL_URL", (Object)thumbnailURL);
            templateContext.put((Object)"THUMBNAIL_URL", null);
            templateContext.put((Object)"COUNT", (Object)this.filesCount);
            String content = TemplateUtils.processGroovy((TemplateContext)templateContext);
            return content;
        }
        catch (Exception e) {
            LOG.error((Object)"Failed at makeContent().", (Throwable)e);
            return this.activity != null ? this.activity.getTitle() : "";
        }
    }

    public String getId() {
        return ID;
    }

    public boolean isValid(NotificationContext ctx) {
        return false;
    }

    private void getAndSetFileInfo(Map<String, String> templateParams) {
        this.nodeUUID = this.getParameterValues(templateParams, NODE_UUID);
        this.filesCount = this.nodeUUID.length;
        this.mimeType = this.getParameterValues(templateParams, MIME_TYPE);
        this.docName = this.getParameterValues(templateParams, DOCNAME);
        this.contentLink = this.getParameterValues(templateParams, CONTENT_LINK);
        this.contentNode = new Node[this.filesCount];
        this.nodeLocation = new NodeLocation[this.filesCount];
        String[] documentTitle = this.getParameterValues(templateParams, DOCUMENT_TITLE);
        this.documentTitle = documentTitle != null ? documentTitle : this.getParameterValues(templateParams, CONTENT_NAME);
        RepositoryService repositoryService = (RepositoryService)WCMCoreUtils.getService(RepositoryService.class);
        ManageableRepository manageRepo = null;
        try {
            manageRepo = repositoryService.getCurrentRepository();
            SessionProvider sessionProvider = CommonsUtils.getSystemSessionProvider();
            for (String ws : manageRepo.getWorkspaceNames()) {
                for (int i = 0; i < this.filesCount; ++i) {
                    try {
                        this.contentNode[i] = sessionProvider.getSession(ws, manageRepo).getNodeByUUID(this.nodeUUID[i]);
                        this.nodeLocation[i] = NodeLocation.getNodeLocationByNode((Node)this.contentNode[i]);
                        continue;
                    }
                    catch (RepositoryException e) {
                        // empty catch block
                    }
                }
            }
        }
        catch (RepositoryException re) {
            LOG.error((Object)"Can not get the repository. ", (Throwable)re);
        }
        this.baseURI = CommonsUtils.getCurrentDomain();
    }

    private String getDefaultThumbnail(int i) {
        String cssClass = CssClassUtils.getCSSClassByFileNameAndFileType((String)(this.docName == null ? (this.documentTitle == null ? null : this.documentTitle[i]) : this.docName[i]), this.mimeType == null ? null : this.mimeType[i], (CssClassManager.ICON_SIZE)CssClassManager.ICON_SIZE.ICON_64);
        if (cssClass.indexOf("FileDefault") > 0) {
            return this.baseURI + EXO_RESOURCES_URI + "uiIcon64x64Templatent_file.png";
        }
        return this.baseURI + EXO_RESOURCES_URI + cssClass.split(" ")[0] + ICON_FILE_EXTENSION;
    }

    private Node getContentNode(int i) {
        return NodeLocation.getNodeByLocation((NodeLocation)this.nodeLocation[i]);
    }

    private String getSize(Node node) {
        double size = this.getFileSize(node);
        try {
            if (node.hasNode("jcr:content")) {
                return FileUtils.byteCountToDisplaySize((long)((long)size));
            }
        }
        catch (Exception e) {
            return "";
        }
        return "";
    }

    private double getFileSize(Node node) {
        double fileSize = 0.0;
        try {
            Node contentNode;
            if (node.hasNode("jcr:content") && (contentNode = node.getNode("jcr:content")).hasProperty("jcr:data")) {
                fileSize = contentNode.getProperty("jcr:data").getLength();
            }
        }
        catch (Exception ex) {
            fileSize = 0.0;
        }
        return fileSize;
    }

    private int getVersion(Node node) {
        String currentVersion = null;
        try {
            currentVersion = node.getBaseVersion().getName();
            if (currentVersion.contains("jcr:rootVersion")) {
                currentVersion = "0";
            }
        }
        catch (Exception e) {
            currentVersion = "0";
        }
        return Integer.parseInt(currentVersion);
    }

    private String[] getParameterValues(Map<String, String> activityParams, String paramName) {
        String[] values = null;
        String value = activityParams.get(paramName);
        if (value != null) {
            values = value.split("\\|@\\|");
        }
        if (LOG.isDebugEnabled() && this.filesCount != 0 && (values == null || values.length != this.filesCount)) {
            LOG.debug("Parameter '{}' hasn't same length as other activity parmameters", new Object[]{paramName});
        }
        return values;
    }
}

