/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.wcm.ext.component.activity;

import java.util.HashMap;
import java.util.List;
import javax.jcr.Node;
import org.exoplatform.commons.utils.CommonsUtils;
import org.exoplatform.services.cms.documents.DocumentService;
import org.exoplatform.social.plugin.doc.UIDocViewer;
import org.exoplatform.social.webui.activity.BaseUIActivity;
import org.exoplatform.wcm.ext.component.activity.UILinkActivity;
import org.exoplatform.wcm.ext.component.activity.UIPreviewCommentArea;
import org.exoplatform.webui.application.WebuiRequestContext;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.core.UIContainer;
import org.exoplatform.webui.core.UIPopupContainer;
import org.exoplatform.webui.core.UIPopupWindow;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.event.EventListener;
import org.exoplatform.webui.ext.UIExtension;
import org.exoplatform.webui.ext.UIExtensionManager;

@ComponentConfig(template="classpath:groovy/ecm/social-integration/UIDocumentPreview.gtmpl", events={@EventConfig(listeners={CloseActionListener.class})})
public class UIDocumentPreview
extends UIContainer {
    private DocumentService documentService = (DocumentService)CommonsUtils.getService(DocumentService.class);
    private BaseUIActivity baseUIActivity;

    public UIDocumentPreview() throws Exception {
        this.addChild(UIDocViewer.class, null, "UIDocViewer");
        this.addChild(UIPreviewCommentArea.class, null, "UIPreviewCommentArea");
    }

    public void setContentInfo(String docPath, String repository, String workspace, Node docNode) {
        UIDocViewer uiDocViewer = (UIDocViewer)this.getChild(UIDocViewer.class);
        uiDocViewer.docPath = docPath;
        uiDocViewer.repository = repository;
        uiDocViewer.workspace = workspace;
        uiDocViewer.setOriginalNode(docNode);
        uiDocViewer.setNode(docNode);
    }

    public Node getOriginalNode() throws Exception {
        UIDocViewer uiDocViewer = (UIDocViewer)this.findFirstComponentOfType(UIDocViewer.class);
        return uiDocViewer.getOriginalNode();
    }

    public String getLinkInDocumentsApp() throws Exception {
        return this.documentService.getLinkInDocumentsApp(this.getOriginalNode().getPath());
    }

    private boolean isWebContent() throws Exception {
        UIDocViewer uiDocViewer = (UIDocViewer)this.findFirstComponentOfType(UIDocViewer.class);
        Node previewNode = uiDocViewer.getNode();
        if (previewNode != null) {
            return previewNode.isNodeType("exo:webContent");
        }
        return false;
    }

    private boolean isMediaFile(Node data) throws Exception {
        if (data.isNodeType("nt:file")) {
            UIExtensionManager manager = (UIExtensionManager)this.getApplicationComponent(UIExtensionManager.class);
            List extensions = manager.getUIExtensions("org.exoplatform.ecm.dms.FileViewer");
            HashMap<String, String> context = new HashMap<String, String>();
            context.put("mimeType", data.getNode("jcr:content").getProperty("jcr:mimeType").getString());
            for (UIExtension extension : extensions) {
                if (!manager.accept("org.exoplatform.ecm.dms.FileViewer", extension.getName(), context) || "Text".equals(extension.getName()) || "PDF".equals(extension.getName())) continue;
                return true;
            }
        }
        return false;
    }

    public BaseUIActivity getBaseUIActivity() {
        return this.baseUIActivity;
    }

    public void setBaseUIActivity(BaseUIActivity baseUIActivity) {
        this.baseUIActivity = baseUIActivity;
    }

    public String getEmbedHtml() {
        BaseUIActivity baseUIActivity = this.getBaseUIActivity();
        if (baseUIActivity instanceof UILinkActivity) {
            String embedHtml = ((UILinkActivity)baseUIActivity).getEmbedHtml();
            if (embedHtml != null) {
                embedHtml = embedHtml.replaceFirst("width=\\\"[0-9]*\\\"", "width=\"100%\"").replaceFirst("height=\\\"[0-9]*\\\"", "height=\"100%\"");
            }
            return embedHtml;
        }
        return null;
    }

    public static class CloseActionListener
    extends EventListener<UIDocumentPreview> {
        public void execute(Event<UIDocumentPreview> event) throws Exception {
            UIDocumentPreview uiDocumentPreview = (UIDocumentPreview)((Object)event.getSource());
            UIPopupWindow uiPopupWindow = (UIPopupWindow)uiDocumentPreview.getAncestorOfType(UIPopupWindow.class);
            if (!uiPopupWindow.isShow()) {
                return;
            }
            uiPopupWindow.setShow(false);
            uiPopupWindow.setUIComponent(null);
            UIPopupContainer popupContainer = (UIPopupContainer)uiPopupWindow.getAncestorOfType(UIPopupContainer.class);
            WebuiRequestContext requestContext = event.getRequestContext();
            if (uiDocumentPreview.getBaseUIActivity() != null && requestContext.getUIApplication().findComponentById(uiDocumentPreview.getBaseUIActivity().getId()) != null) {
                requestContext.addUIComponentToUpdateByAjax((UIComponent)uiDocumentPreview.getBaseUIActivity());
            }
            requestContext.addUIComponentToUpdateByAjax((UIComponent)popupContainer);
        }
    }
}

