/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.wcm.ext.component.activity;

import javax.jcr.Node;
import javax.jcr.RepositoryException;
import org.apache.commons.lang.StringUtils;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.core.ManageableRepository;
import org.exoplatform.services.jcr.ext.common.SessionProvider;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.wcm.utils.WCMCoreUtils;
import org.exoplatform.social.core.activity.model.ExoSocialActivity;
import org.exoplatform.social.webui.activity.BaseUIActivity;
import org.exoplatform.social.webui.activity.BaseUIActivityBuilder;
import org.exoplatform.wcm.ext.component.activity.FileUIActivity;

public class FileUIActivityBuilder
extends BaseUIActivityBuilder {
    private static final Log LOG = ExoLogger.getLogger(FileUIActivityBuilder.class);

    protected void extendUIActivity(BaseUIActivity uiActivity, ExoSocialActivity activity) {
        FileUIActivity fileActivity = (FileUIActivity)uiActivity;
        if (activity.getTemplateParams() != null) {
            fileActivity.setUIActivityData(activity.getTemplateParams());
        }
        if (activity.getTemplateParams() != null && StringUtils.isNotBlank((String)((String)activity.getTemplateParams().get("MESSAGE")))) {
            fileActivity.setMessage(activity.getTitle());
        } else {
            fileActivity.setMessage(null);
        }
        if (fileActivity.getFilesCount() > 0) {
            RepositoryService repositoryService = (RepositoryService)WCMCoreUtils.getService(RepositoryService.class);
            ManageableRepository manageRepo = null;
            Node contentNode = null;
            try {
                manageRepo = repositoryService.getCurrentRepository();
                SessionProvider sessionProvider = WCMCoreUtils.getUserSessionProvider();
                for (String ws : manageRepo.getWorkspaceNames()) {
                    try {
                        for (int i = 0; i < fileActivity.getFilesCount(); ++i) {
                            if (StringUtils.isEmpty((String)fileActivity.getNodeUUID(i))) {
                                String contentLink = fileActivity.getContentLink(i);
                                String _ws = contentLink.split("/")[0];
                                String _repo = contentLink.split("/")[1];
                                String nodePath = contentLink.replace(_ws + "/" + _repo, "");
                                contentNode = (Node)sessionProvider.getSession(ws, manageRepo).getItem(nodePath);
                                fileActivity.setContentNode(contentNode, i);
                            } else {
                                contentNode = sessionProvider.getSession(ws, manageRepo).getNodeByUUID(fileActivity.getNodeUUID(i));
                            }
                            fileActivity.setContentNode(contentNode, i);
                        }
                    }
                    catch (RepositoryException e) {
                        // empty catch block
                    }
                }
            }
            catch (RepositoryException re) {
                LOG.error((Object)"Can not get the repository. ", (Throwable)re);
            }
        }
    }
}

