/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.wcm.ext.component.identity.provider;

import javax.jcr.RepositoryException;
import org.exoplatform.services.cms.documents.DocumentService;
import org.exoplatform.services.cms.documents.model.Document;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.wcm.utils.WCMCoreUtils;
import org.exoplatform.social.core.identity.IdentityProvider;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.core.identity.model.Profile;

public class DocumentIdentityProvider
extends IdentityProvider<Document> {
    private static final Log LOG = ExoLogger.getLogger(DocumentIdentityProvider.class);
    public static final String NAME = "document";
    private DocumentService docService = (DocumentService)WCMCoreUtils.getService(DocumentService.class);

    public Identity createIdentity(Document doc) {
        Identity identity = new Identity(NAME, doc.getId());
        return identity;
    }

    public Document findByRemoteId(String id) {
        try {
            return this.docService.findDocById(id);
        }
        catch (RepositoryException e) {
            LOG.error((Object)"RepositoryException: ", (Throwable)e);
            return null;
        }
    }

    public String getName() {
        return NAME;
    }

    public void populateProfile(Profile profile, Document doc) {
        profile.setProperty("firstName", (Object)doc.getName());
        profile.setProperty("username", (Object)doc.getName());
        profile.setProperty("Url", (Object)doc.getPath());
    }
}

